/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_StarDSP.c  Display switching module 
 Processes display output from taStarDSP.c
*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDDS.h"
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taIntEeprom.h"
#include "taZ_DDS.h"
#include "taGraphicsDriverEA320.h"
#include "taEATFTcommands.h"
#include "taKS0108Driver.h"


void zdspMsg(char* msg, uint8_t how)
{
	if(zc)   // charlcd
	{ 	
		cdSetPos(2,20);
		cdDisplayString(pmdSpaces(20));
		cdSetPos(2,20);
		cdDisplayString(msg);  // DDS 39 option
		_delay_ms(3000);
	}
	if (zg)   // graphics
	{
	}
	if (zt)   // tft
	{
		etcFont(11);
		etcTextColour(3, 0);
		etcString(240, 224, 'C', msg);
		_delay_ms(3000);
	}
}



void zdspLoadingBar(uint8_t bars)
{
	if ( (bars == 0) || (bars > 16) ) {return;}
	if (zc)   // charlcd
	{ 	
		uint8_t p = bars / 2;
		uint8_t m = bars % 2;
		p = (p + m) - 1;
		cdSetPos(2, 32 + p);
		cdPutByte(1, 1 + m);	// ascii 1 is full bar char
							// ascii 2 is left half bar char 
	}
	if (zs) ksdFillRect(61,56,61 + 4*bars,61);
	//if (zt) etcFillRect(225, 194, (225 + (8 * bars)), 204);  //wz 204
	
	if (zt) etcColourRect(225, 194, (225 + (8 * bars)), 204, 2);  //wz 204
	if (zg)   // graphics    
	{
		Brush.Color = 1;
		gedFillRect(162, 155, (162 + (5 * bars)), 159);  //wz 159
	}
}
