/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_DDScommands.c  Display switching module 
 Processes display output from taDDScommands.c

*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDDS.h"
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taIntEeprom.h"
#include "taDDScommands.h"
#include "taKeys.h"
#include "taZ_StarControl.h"
#include "taZ_DDScommands.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsEA320.h"
#include "taCAT.h"
#include "taEATFT.h"
#include "taEATFTmenus.h"
#include "taEATFTcommands.h"
#include "taKS0108Driver.h"
#include "taKS0108.h"
#include "taKS0108Menus.h"
#include "taRTC.h"


#define fup 1
#define fdown 0

#define FreqInfoX 3
#define FreqInfoY 44

#define MessageX = 115
#define MessageY = 100

#define Arial20 11
#define Arial18 12
#define Arial16 13
#define ArialBold18 9
#define ArialBold16 10


void zcmDisplaySigGenModeIndicator() __attribute__((section(".highmem")));
void zcmDisplaySigGenModeIndicator()
{
	if (SigGenMode == 0) {
		if (zc) {   // charlcd
			strcpy(StrB, pmdSpaces(6));
			cdSetPos(2,20);
			cdDisplayString(StrB);
		}
		if (zg)   // graphics
		{
			gedSwitchLayer(LayerTR);
			Brush.Color = 0;
			gedFillRect(1,40,103,67);
			Brush.Color = 1;
		}
	} else {
		if (zc) {   // charlcd
			strcpy(StrB, PMS(s_Sgen_));
			cdSetPos(2,20);
			cdDisplayString(StrB);
		}
		if (zg)   // graphics
		{
		  zcmWriteSigGen();
		}
	}
	if (zt) etShowSigGenMode();
}


void zcmWriteSigGen() __attribute__((section(".highmem")));
void zcmWriteSigGen()
{
	Brush.Color = 1;
	gedSwitchLayer(LayerTR);
	geClearParamBox();
	gedF8WriteString(PMS(s_Signal_generator),FreqInfoX,FreqInfoY);
  gedF8WriteString(PMS(s____mode_),FreqInfoX,FreqInfoY+12);
}


void zcmUpDownkHz(uint8_t fud) __attribute__((section(".highmem")));
void zcmUpDownkHz(uint8_t fud)
{
	uint16_t k;
	if (fud == fup) strcpy(StrA, PMS(s_Move_kHz_up));
	else strcpy(StrA, PMS(s_Move_kHz_down));
	zcmConfirmDDScommand();
	do {k = kyGetKeyChar();} while(k == 'X');
	if ((k < '0') || (k > '9')) return;
	while (k == kyGetKeyChar());  // wait until key released
	if (zc)
	{
		if (k == '0') {cdSetPos(2, 18); cdPutByte(1, '1');}
		cdSetPos(2, 19);
		cdPutByte(1, k);
	}
	if ((zg) || (zt))
	{
		if (k == '0') {StrA[0] = '1'; StrA[1] = k; StrA[2]=0;}
		else {StrA[0] = k; StrA[1]=0;}
	}
	if (zg)
	{
		gedF16WriteString(StrA, gedNextCharX, MsgY3);
	}		
	if (zt)
	{
		if (fud == fup) emeInfoString(140, 15, 'L', StrA);
		else emeInfoString(159, 15, 'L', StrA);
	}		
	_delay_ms(1000);
	k -= 0x030;
	if (k == 0) k = 10;
	if (fud == fup) Freq += 1000*k;
	else Freq -= 1000*k;
	ddsFreqChange();
}
	

void	zcmDisplayVfoStackTuning() __attribute__((section(".highmem")));
void	zcmDisplayVfoStackTuning()
{
	if (zc)   // charlcd
	{ 	
		cdSetPos(1,20);
	  cdDisplayString(pmdSpaces(20));  // clear normal VFO info
	  cdSetPos(1,20);
		cdDisplayString(PMS(s_VFOstack));
		zscShowStickyVolatile('V',1);   // 1 is dummay as this only for charlcd
	}
	if (zg)   // graphics
	{
	}
}


void zcmDisplayGuarding() __attribute__((section(".highmem")));
void zcmDisplayGuarding()
{
	if (zc)
	{ 
	 	cdSetPos(2,20);
		cdDisplayString(PMS(s_Guard));
	}
	if (zs)
	{
		 ksWriteFreqInfoHeader(PMS(s_Guard));
		 ksWriteFreqInfoData(PMS(s_T_20s));
	}
	if (zt) etShowGuarding();
	if (zg)   // graphics
	{
		
		gedSwitchLayer(LayerTR);
		geClearParamBox();
		gedF8WriteString(PMS(s_Guard_channel_check),FreqInfoX,FreqInfoY);
		gedF8WriteString(PMS(s_every_20_seconds_),FreqInfoX,FreqInfoY+12);
	}
}


void zcmDDScommandInput(char kc) __attribute__((section(".highmem")));
void zcmDDScommandInput(char kc)
{
	uint16_t DDScode = 0;
	uint16_t Bx = 0;
	uint8_t i;
	uint8_t kt;  // tens
	uint8_t si = 0; // String  StrA index
	uint8_t k = kc;
	uint8_t Knine = 0;
	
 	if ((k < '1') || (k > '9')) return;
	if (k == '9') Knine = 1;   /// first key is 9
	strcpy(StrA, PMS(s_DDS_command__));
	strcpy(StrC,StrA);
	StrB[si] = k;
	StrB[si+1] = 0;
	zscDeleteMsgFrame(0);
	if (zc)
	{
		cdSetPos(2, 0);
		cdDisplayString(pmdSpaces(20));
		cdSetPos(2, 0);
		cdDisplayString(StrA);
		cdSetPos(2, 13);
		cdDisplayString(StrB);
	}
	if(zs)
	{
		ksmMsgBox();
		strcpy(StrC,StrA);
		strcat(StrC,StrB);
		ksmMsgLine(StrC,2);
	}
	if ((zg) && (DDSparams.dpDSPDDSKeysDisplay == 2)) zscClearDSPKeys(1);
	if (((zg) || (zt)) && ((DDSparams.dpDSPDDSKeysDisplay == 1) || (DDSparams.dpDSPDDSKeysDisplay == 3))) zscDrawDDSKeysFrame(1);
	if (zt)
	{
		emeInfoFrame();
		etcFont(Arial18);
		etcTextColour(3, 1);
		emeInfoString(10, 15, 'L', StrA);
		emeInfoString(130, 15, 'L', StrB);
		if ((DDSparams.dpDSPDDSKeysDisplay == 1) || (DDSparams.dpDSPDDSKeysDisplay == 3)) {
			char *StrDDS9 = &StrC[2];
			char *StrDDS = &StrC[6];
			etcFont(Arial12);
			StrC[1] = 0;
			StrC[5] = 0;
			switch (k) {
				case '1':
					for (i = 0; i < DDS_1_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_1[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '2':
					for (i = 0; i < DDS_2_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_2[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '3':
					for (i = 0; i < DDS_3_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_3[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '4':
					for (i = 0; i < DDS_4_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_4[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '5':
					for (i = 0; i < DDS_5_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_5[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '6':
					for (i = 0; i < DDS_6_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_6[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '7':
					for (i = 0; i < DDS_7_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_7[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '8':
					for (i = 0; i < DDS_8_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_8[i]);
						StrC[0] = pmStrBuf[0];
						memcpy(StrDDS9, &pmStrBuf[1], 3);
						strcpy(StrDDS, &pmStrBuf[4]);
						etcTextColour(3, 1);
						emeMenuString(2, 2+(i*13), 'L', StrC);
						etcTextColour(7, 1);
						emeMenuString(8, 2+(i*13), 'L', StrDDS9);
						etcTextColour(10, 1);
						emeMenuString(22, 2+(i*13), 'L', StrDDS);
					}
					break;
				case '9':
					for (i = 0; i < DDS_9_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_9[i]);
						strcpy(StrDDS, pmStrBuf);
						etcTextColour(10, 1);
						emeMenuString(2, 2+(i*13), 'L', StrDDS);
					}
					break;
			}
			// "* = saved to EEPROM  [9] = save"
			// "0123456789012345678901234567890"
			strcpy(StrDDS, PMS(s_DDS_info_));
			StrC[0] = StrDDS[0];
			memcpy(StrDDS9, &StrDDS[21], 3);
			StrDDS[19] = 0;
			etcTextColour(3, 1);
			emeMenuString(2, 145, 'L', StrC);
			etcTextColour(10, 1);
			emeMenuString(8, 145, 'L', &StrDDS[1]);
			etcTextColour(7, 1);
			emeMenuString(113, 145, 'L', StrDDS9);
			etcTextColour(10, 1);
			emeMenuString(127, 145, 'L', &StrDDS[24]);
		}
	}
	if (zg)
	{
		//geDeleteMsgFrame();
		if ((DDSparams.dpDSPDDSKeysDisplay == 0) || (DDSparams.dpDSPDDSKeysDisplay == 2) || (Transmit == 1)) {
			geDrawMsgFrame();
			gedF16WriteString(StrA, MsgX+6, MsgY1);
			Bx = gedNextCharX;
			gedF16WriteString(StrB, Bx, MsgY1);
		} else {
//			geClearParamBox();
			gedF8WriteString(StrA, 3, 42);
			gedF16WriteString(StrB, 3, 51);
			gedSwitchLayer(LayerRx);				
			Bx = RxTxMsgX + 2 + gedF8StringWidth("*[9]");
			StrC[4] = 0;
			switch (k) {
				case '1':
					for (i = 0; i < DDS_1_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_1[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '2':
					for (i = 0; i < DDS_2_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_2[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '3':
					for (i = 0; i < DDS_3_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_3[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '4':
					for (i = 0; i < DDS_4_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_4[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '5':
					for (i = 0; i < DDS_5_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_5[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '6':
					for (i = 0; i < DDS_6_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_6[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '7':
					for (i = 0; i < DDS_7_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_7[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '8':
					for (i = 0; i < DDS_8_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_8[i]);
						memcpy(StrC, pmStrBuf, 4);
						gedF8WriteString(StrC, RxTxMsgX+2, RxMsgY+2+(i*9));
						gedF8WriteString(&pmStrBuf[4], Bx, RxMsgY+2+(i*9));
					}
					break;
				case '9':
					for (i = 0; i < DDS_9_Cnt; i++) {
						strcpy_P(pmStrBuf,(PGM_P)&s_DDS_9[i]);
						gedF8WriteString(pmStrBuf, RxTxMsgX+2, RxMsgY+2+(i*9));
					}
					break;
			}
			gedF8WriteString(PMS(s_DDS_info_), RxTxMsgX+2, RxMsgY+101);
			gedSwitchLayer(LayerTR);				
		}
	}
	kt = k;  // tens
 	while (k == kyGetKeyChar());  // wait until key released
	if (Knine > 0)
	{
		do
		{
			k = kyGetKeyChar();
			usbCheckPC();
			ctDoCat();
			scCheckFlags();
		} while ( (k != 'E') && (k != '#') && ( (k < '1') || (k > '9') ) ); // wait for another ('E' = esc)
		if ( (k == 'E') || (k == '#') )
		{
			zscRestoreLeftDisplay();
			if (zt)
			{
				emeDeleteInfo();
			}
			if(zs) ksmRestoreMenuArea(0);
			if (zg)
			{
				zscDeleteMsgFrame(1);
				if ((DDSparams.dpDSPDDSKeysDisplay == 1) || (DDSparams.dpDSPDDSKeysDisplay == 3)) {
//					geClearParamBox();
				}
			}
			if ((zt) || (zg))
			{
				zscClearDSPKeys(0);
		   		if (DisplaySwitch == 2)
		   		{
		   			if (zt) dspStartDSPdisplayEATFT();
		   			else geStartDSPdisplay();
		   		}
				else
				{
					zscShowDSPKeys();
				}
			}
			return;
		}
		si += 1;
		StrB[si] = k;
		StrB[si+1] = 0;
	 	if (zc)
		{
			cdSetPos(2, 13);
			cdDisplayString(StrB);
		}
		if(zs)
		{
			strcpy(StrC,StrA);
			strcat(StrC,StrB);
			ksmMsgLine(StrC,2);
		}
		if (zt) {etcFont(Arial18); etcTextColour(3, 1); emeInfoString(130, 15, 'L', StrB);}
		if (zg)
		{
			if ((DDSparams.dpDSPDDSKeysDisplay == 0) || (DDSparams.dpDSPDDSKeysDisplay == 2) || (Transmit == 1)) {
				gedF16WriteString(StrB, Bx, MsgY1);
			} else {
				gedF16WriteString(StrB, 3, 51);
			}
		}
		kt = k;  // tens
	}
	while (k == kyGetKeyChar());  // wait until key released
	do
	{
		k = kyGetKeyChar();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
	} while ( (k != 'E') && (k != '#') && (k != '*') && ( (k < '0') || (k > '9') ) ); // wait for another	
	if ( ((k >= '0') && (k <= '9')) || ((k == '*') && (Knine == 0)) ) 
	{
	    if (k == '*') DDScode = (kt-0x30)*10 + 100;   //  so '4*' gives 140  '6*' gives 160
		else DDScode = (kt-0x30)*10 + (k-0x30) + Knine*900;
	 	si += 1;
		StrB[si] = k;
		StrB[si+1] = 0;
		if (zc)
		{
			cdSetPos(2, 13);
			cdDisplayString(StrB);
		}
		if(zs)
		{
			strcpy(StrC,StrA);
			strcat(StrC,StrB);
			ksmMsgLine(StrC,2);
		}
		if (zt)
		{
			etcFont(Arial18);
			etcTextColour(3, 1);
			emeInfoString(130, 15, 'L', StrB);
			if (DDScode == 88)
			{
				// emeClearInfo();
				strcpy(StrA, PMS(s_Enter_frequency));
				emeInfoString(10, 38, 'L', StrA);
				strcpy(StrA, PMS(s_Leading_zero_if_under_10MHz));				
				etcFont(Arial14);
				emeInfoString(10, 61, 'L', StrA);
			}
		}
		if (zg)
		{
			if ((DDSparams.dpDSPDDSKeysDisplay == 0) || (DDSparams.dpDSPDDSKeysDisplay == 2) || (Transmit == 1)) {
				gedF16WriteString(StrB, Bx, MsgY1);
			} else {
				gedF16WriteString(StrB, 3, 51);
				zscClearMsgFrame();
			}
			if (DDScode == 88)
			{
				geClearRxMsgFrame();  // IJSxxx
				gedF16WriteString(PMS(s_Enter_frequency), MsgX+6, MsgY2);
				gedF8WriteString(PMS(s_Leading_zero_if_under_10MHz), MsgX+6, MsgY3);				
			}
		}
		_delay_ms(800);
//		geClearParamBox(); 
		cmDoDDScommand(DDScode);		
	}
	zscRestoreLeftDisplay();
	if (zt)
	{
		emeDeleteInfo();
	}
	if(zs) ksmRestoreMenuArea(0);
	if (zg)
	{
		zscDeleteMsgFrame(1);
	}
	if ((zt) || (zg))
	{
		zscClearDSPKeys(0);
   		if (DisplaySwitch == 2)
   		{
   			if (zt) dspStartDSPdisplayEATFT();
   			else geStartDSPdisplay();
   		}
		else
		{
			zscShowDSPKeys();
			if(zt) emeDrawDateTime();
		}
	}
}


void zcmConfirmDDScommand() __attribute__((section(".highmem")));
void zcmConfirmDDScommand()
{
	if (DisplayingMenu == 1) return;
	if (zc)
	{ 	
		cdSetPos(2,0);
		cdDisplayString(pmdSpaces(20));
		cdSetPos(2,0);
		cdDisplayString(StrA);
	}
	if (zs)
	{
		ksmMsgBox();
		ksmMsgLine(StrA,2);
	}
	if (zt)
	{
		emeInfoFrame();
		etcFont(Arial18);
		etcTextColour(3,1);
		emeInfoString(10,15,'L',StrA);
	}
	if (zg)
	{
		if ((DDSparams.dpDSPDDSKeysDisplay == 1) || (DDSparams.dpDSPDDSKeysDisplay == 3)) zscClearDSPKeys(1);
		zscDrawMsgFrame();
		gedF16WriteString(StrA,MsgX+6, MsgY3);
	} 
}


void zcmShowSplitMode() __attribute__((section(".highmem")));
void zcmShowSplitMode()
{
	if ((zc)||(zs))   // charlcd  or 128x64
	{ 	
		if(XRIT()==0)
		{strcpy(StrA,pmdSpaces(6));}
		else
		{
		  if(XIT==1)
		  {strcpy(StrA,PMS(s_XIT));}
		  else
		  {strcpy(StrA,PMS(s_RIT));};
			if(Split==1)
			{strcat(StrA,PMS(s_s));}
			else
			{strcat(StrA,pmdSpaces(2));}
 		}
	}
	if(zc)
	{
		cdSetPos(2,20);
		cdDisplayString(StrA);
	}
	if(zs)
	{
		ksdF8WriteString(StrA,38,16,0);		
	}	

	if (zt) etShowRITXIT();

	if (zg)   // graphics
	{
		if (XRIT() == 0) zscClearRITXITBox();
		else
		{
	  	if (XIT == 1) strcpy(StrA,PMS(s_XIT__split_)); 
			else strcpy(StrA,PMS(s_RIT__split_));
			if (Split == 1) strcat(StrA,PMS(s_on__));
			else strcat(StrA,PMS(s_off_));
			gedF16WriteString(StrA,FreqInfoX+6,FreqInfoY);
		}
	}
}								


void zcmUSBoffsetCal() __attribute__((section(".highmem")));
void zcmUSBoffsetCal()
{
	uint16_t Bx = 0;
	char k;
	uint8_t fSave = 0;
	int32_t OldFreq = 0;
	TuningMode = 'X';
	Mode = 1;   // UB
	scChangeMode();
	SigGenMode=1;
	ddsSetFreq();
	if (zc)   // charlcd
	{	
		cdClearLeft();
		cdSetPos(1,0);
		cdDisplayString(PMS(s_Set_USB_offset));
	}
	if(zs)
	{
		ksmMsgBox();
		ksmMsgLine(PMS(s_Set_USB_offset),1);
		ksmMsgLine(PMS(s_DDS_931_to_save_),3);
	}
	if (zt)
	{
		etcFont(Arial16);
		emeDeleteInfo();
		emeInfoFrame();
		strcpy(StrA,PMS(s_Set_USB_offset));
		etcTextColour(10,1);
		emeInfoString(5,4,'L',StrA);
		strcpy(StrA,PMS(s_Uses_sig__gen__mode));
		strcat(StrA,PMS(s_newline));
		strcat(StrA,PMS(s_DDS_931_to_save_));
		etcTextColour(4,1);
		emeInfoString(12,50,'L',StrA);
	}
	if (zg)
	{
		geClearRxMsgFrame(); // IJSxxx
		gedF16WriteString(PMS(s_Set_USB_offset),MsgX+6,MsgY2);
		gedF8WriteString(PMS(s_Uses_signal_generator_mode),MsgX+4,MsgY3+24);
		gedF8WriteString(PMS(s_as_Picastar_manual_),MsgX+4,MsgY3+33);
		gedF8WriteString(PMS(s_DDS_931_to_save_),MsgX+4,MsgY+MsgHeight-11);
	}
	uint8_t refresh = 1;
	int encval = 0;
 	OldFreq = Freq;
	Freq = USBoffset;
	do
	{
	 	if (refresh == 1)
		{
			ltoa(Freq,StrA,10);
			if (zc)
			{
				cdSetPos(2,1);
				cdDisplayString(gbTrailingSpaces(StrA,12));
			}
			if(zs) ksmMsgLine(StrA,2);
			if (zt)
			{
				etcFont(Arial18);
				etcTextColour(12,1);
				emeClearInfoRect(20,25,80,49);
				emeInfoString(20,25,'L',StrA);
			}	
			if (zg)
			{
				gedF16WriteString(gbTrailingSpaces(StrA,12), MsgX+6,MsgY3);
			}
			refresh = 0;
			ddsSetFreq(); 
		}				
		encval += enGetEncoder4delta();  // clears encoder4 count
		if (WakeupDisplay) scWakeupDisplay();
		if(abs(encval)>0)
		{
			Freq += encval;   
			if(Freq>600000000){fDDSclock=600000000;};
			if(Freq<1000000){fDDSclock=1000000;};
		  encval = 0;
		  refresh = 1;	  
	 	} 
    k = kyGetKeyCharLong(); 
 	}
	while((k!='E')&&(k!='#')&&(k!=(0x80+'9')));  // 89 is a long press of key 9
	if(k==(0x80+'9'))
	{
		strcpy(StrA,PMS(s_DDS_command__9));
		if (zc)
		{
			cdSetPos(2,0);
			cdDisplayString(pmdSpaces(20));
			cdSetPos(2,0);
			cdDisplayString(StrA);
		}
		if(zs) ksmMsgLine(StrA,3);
		if (zt)
		{
			etcFont(Arial16);
			emeClearInfoRect(3,44,200,65);
			etcTextColour(10,1);
			emeInfoString(12,48,'L',StrA);
		}
		if (zg)
		{
			Brush.Color = 0;
			gedFillRect(MsgX+1,MsgY3+18,MsgX+140,MsgY3+46);
			gedF16WriteString(StrA,MsgX+10,MsgY3+18);
			Bx = gedNextCharX;
		}
		do{k = kyGetKeyChar();}while(k=='9');
		_delay_ms(10);
		do{k = kyGetKeyChar();}while(k=='X');    
		if(k=='3')
		{
			strcpy(StrB,StrA);
			strcpy(StrA,PMS(s_3));
			strcat(StrB,StrA);
			if (zc)
			{
				cdSetPos(2,14);
				cdPutByte(1,'3');
			}
			if(zs) ksmMsgLine(StrB,3);
			if (zt)
			{
				emeInfoString(117,48,'L',StrA);
			}
			if (zg)
			{
				gedF16WriteString(StrA,Bx,MsgY3+18);
				Bx = gedNextCharX;
			}
			do{k=kyGetKeyChar();}while(k=='X');
			if(k=='1')
			{
				strcpy(StrA,PMS(s_1));
		    strcat(StrB,StrA);
				if (zc)
				{
					cdSetPos(2,15);
		 			cdPutByte(1,'1');
				}
				if(zs) ksmMsgLine(StrB,3);
				if (zt)
				{
					emeInfoString(126,48,'L',StrA);
				}
				if (zg)
				{
					gedF16WriteString(StrA,Bx,MsgY3+18);
				}
			  _delay_ms(1000);
			  fSave = 1;
			}
		}
	}
	zscRestoreLeftDisplay(); 
	if (fSave == 1)
	{	
 		USBoffset = Freq;
		ddsUpdateUSBoffset(1);   //   1  =  save it
	}
	Freq = OldFreq;	
	SigGenMode=0;
	ddsSetFreq();
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void zcmLSBoffsetCal() __attribute__((section(".highmem")));
void zcmLSBoffsetCal()
{
	uint16_t Bx = 0;
	char k;
	uint8_t fSave = 0;
	int32_t OldFreq = 0;
	TuningMode = 'X';
	Mode = 0;   // LSB   - corrected 25.1.2010
	scChangeMode();
	SigGenMode=1;
	ddsSetFreq();
	if (zc)   // charlcd
	{	
		cdClearLeft();
		cdSetPos(1,0);
		cdDisplayString(PMS(s_Set_LSB_offset));
	}
	if(zs)
	{
		ksmMsgBox();
		ksmMsgLine(PMS(s_Set_LSB_offset),1);
		ksmMsgLine(PMS(s_DDS_937_to_save_),3);
	}
	if (zt)
	{
		etcFont(Arial16);
		emeDeleteInfo();
		emeInfoFrame();
		strcpy(StrA,PMS(s_Set_LSB_offset));
		etcTextColour(10,1);
		emeInfoString(5,4,'L',StrA);
		strcpy(StrA,PMS(s_Uses_sig__gen__mode));
		strcat(StrA,PMS(s_newline));
		strcat(StrA,PMS(s_DDS_937_to_save_));
		etcTextColour(4,1);
		emeInfoString(12,50,'L',StrA);
	}
	if (zg)
	{
		geClearRxMsgFrame();  // IJSxxx
		gedF16WriteString(PMS(s_Set_LSB_offset),MsgX+6,MsgY2);
		gedF8WriteString(PMS(s_Uses_signal_generator_mode),MsgX+4,MsgY3+24);
		gedF8WriteString(PMS(s_as_Picastar_manual_),MsgX+4,MsgY3+33);
		gedF8WriteString(PMS(s_DDS_937_to_save_),MsgX+4,MsgY+MsgHeight-11);
	}
	uint8_t refresh = 1;
	int encval = 0;
 	OldFreq = Freq;
	Freq = LSBoffset;
	do
	{
	 	if (refresh == 1)
		{
			ltoa(Freq,StrA,10);
			if (zc)
			{
				cdSetPos(2,1);
				cdDisplayString(gbTrailingSpaces(StrA,12));
			}
			if(zs) ksmMsgLine(StrA,2);
			if (zt)
			{
				etcFont(Arial18);
				etcTextColour(12,1);
				emeClearInfoRect(20,25,80,49);
				emeInfoString(20,25,'L',StrA);
			}	
			if (zg)
			{
				gedF16WriteString(gbTrailingSpaces(StrA,12), MsgX+6,MsgY3);
			}
			refresh = 0;
			ddsSetFreq(); 
		}				
		encval += enGetEncoder4delta();  // clears encoder4 count
		if (WakeupDisplay) scWakeupDisplay();
		if(abs(encval)>0)
		{
			Freq += encval;   
			if(Freq>600000000){fDDSclock=600000000;};
			if(Freq<1000000){fDDSclock=1000000;};
			encval = 0;
			refresh = 1;	  
	 	} 
    	k = kyGetKeyCharLong(); 
 	} while((k!='E')&&(k!='#')&&(k!=(0x80+'9')));  // 89 is a long press of key 9
	if (k == (0x80+'9'))
	{
		strcpy(StrA,PMS(s_DDS_command__9));
		if (zc)
		{
			cdSetPos(2,0);
	  		cdDisplayString(pmdSpaces(20));
			cdSetPos(2,0);
			cdDisplayString(StrA);
		}
		if(zs) ksmMsgLine(StrA,3);
		if (zt)
		{
			etcFont(Arial16);
			emeClearInfoRect(3,44,200,65);
			etcTextColour(10,1);
			emeInfoString(12,48,'L',StrA);
		}
		if (zg)
		{
			Brush.Color = 0;
			gedFillRect(MsgX+1,MsgY3+18,MsgX+140,MsgY3+46);
			gedF16WriteString(StrA,MsgX+10,MsgY3+18);
			Bx = gedNextCharX;
		}
		do{k = kyGetKeyChar();}while(k=='9');
		_delay_ms(10);
		do{k = kyGetKeyChar();}while(k=='X');    
		if(k=='3')
		{
			strcpy(StrB,StrA);
			strcpy(StrA,PMS(s_3));
			strcat(StrB,StrA);
			if (zc)
			{
				cdSetPos(2,14);
				cdPutByte(1,'3');
			}
			if(zs) ksmMsgLine(StrB,3);
			if (zt)
			{
				emeInfoString(117,48,'L',StrA);
			}
			if (zg)
			{
				gedF16WriteString(StrA,Bx,MsgY3+18);
				Bx = gedNextCharX;
			}
			do{k=kyGetKeyChar();}while(k=='X');
			if(k=='7')
			{
				strcpy(StrA,PMS(s_7));
				strcat(StrB,StrA);
				if (zc)
				{
					cdSetPos(2,15);
		 			cdPutByte(1,'7');
				}
				if(zs) ksmMsgLine(StrB,3);
				if (zt)
				{
					emeInfoString(126,48,'L',StrA);
				}
				if (zg)
				{
					gedF16WriteString(StrA,Bx,MsgY3+18);
				}
			  _delay_ms(1000);
			  fSave = 1;
			}
		}
	}
	zscRestoreLeftDisplay(); 
	if(fSave==1)
	{	
 		LSBoffset = Freq;
		ddsUpdateLSBoffset(1);   //   1  =  save it
	}
	Freq = OldFreq;	
	SigGenMode=0;
	ddsSetFreq();
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void zcmDDSclockCal() __attribute__((section(".highmem")));
void zcmDDSclockCal()
{
	uint16_t Bx = 0;
	char k;
	uint8_t fSave = 0;
	int32_t fPrevious = 0;
	TuningMode = 'X';
	Mode = 1;   // UB
	scChangeMode();
	SigGenMode=1;
	ddsSetFreq();
	if (zc)   // charlcd
	{	
		cdSetPos(2,20);
		strcpy(StrB, PMS(s_ClkCal));
		cdDisplayString(StrB);
		cdClearLeft();
		cdSetPos(1,0);
		cdDisplayString(PMS(s_DDS_clock_freq_));
	}
	if(zs)
	{
		ksmMsgBox();
		ksmMsgLine(PMS(s_DDS_clock_freq_),1);
		ksmMsgLine(PMS(s_DDS_933_to_save_),3);
	}
	if (zt)
	{
		etcFont(Arial16);
		emeDeleteInfo();
		emeInfoFrame();
		strcpy(StrA,PMS(s_DDS_clock_frequency));
		etcTextColour(10,1);
		emeInfoString(5,4,'L',StrA);
		strcpy(StrA,PMS(s_Uses_sig__gen__mode));
		strcat(StrA,PMS(s_newline));
		strcat(StrA,PMS(s_DDS_933_to_save_));
		etcTextColour(4,1);
		emeInfoString(12,50,'L',StrA);
	}
	if (zg)
	{
		geClearRxMsgFrame();  // IJSxxx
		gedF16WriteString(PMS(s_DDS_clock_frequency),MsgX+6,MsgY2);
		gedF8WriteString(PMS(s_Uses_signal_generator_mode),MsgX+4,MsgY3+24);
		gedF8WriteString(PMS(s_as_Picastar_manual_),MsgX+4,MsgY3+33);
		gedF8WriteString(PMS(s_DDS_933_to_save_),MsgX+4,MsgY+MsgHeight-11);
	}
	uint8_t refresh = 1;
	int encval = 0;
	fPrevious = fDDSclock;
	do
	{
	 	if (refresh == 1)
		{
			ltoa(fDDSclock,StrA,10);
			if (zc)
			{
				cdSetPos(2,1);
				cdDisplayString(gbTrailingSpaces(StrA,12));
			}
			if(zs) ksmMsgLine(StrA,2);
			if (zt)
			{
				etcFont(Arial18);
				etcTextColour(12,1);
				emeClearInfoRect(20,25,80,49);
				emeInfoString(20,25,'L',StrA);
			}	
			if (zg)
			{
				gedF16WriteString(gbTrailingSpaces(StrA,12), MsgX+6,MsgY3);
			}
			refresh = 0;
			ddsUpdateDDSclock(0); 
		}				
		encval += enGetEncoder4delta();  // clears encoder4 count
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) > 0)
		{
			fDDSclock += encval;   
			if(fDDSclock>600000000){fDDSclock=600000000;};
			if(Freq<1000000){fDDSclock=1000000;};
			encval = 0;
			refresh = 1;	  
	 	}
		k = kyGetKeyCharLong(); 
 	} while((k!='E')&&(k!='#')&&(k!=(0x80+'9')));  // 89 is a long press of key 9
	if (k == (0x80+'9'))
	{
		strcpy(StrA,PMS(s_DDS_command__9));
		if (zc)
		{
			cdSetPos(2,0);
	  	cdDisplayString(pmdSpaces(20));
			cdSetPos(2,0);
			cdDisplayString(StrA);
		}
		if(zs) ksmMsgLine(StrA,3);
		if (zt)
		{
			etcFont(Arial16);
			emeClearInfoRect(3,44,200,65);
			etcTextColour(10,1);
			emeInfoString(12,48,'L',StrA);
		}
		if (zg)
		{
			Brush.Color = 0;
			gedFillRect(MsgX+1,MsgY3+18,MsgX+140,MsgY3+46);
			gedF16WriteString(StrA,MsgX+10,MsgY3+18);
			Bx = gedNextCharX;
		}
		do{k = kyGetKeyChar();}while(k=='9');
		_delay_ms(10);
		do{k = kyGetKeyChar();}while(k=='X');    
		if (k == '3')
		{
			strcpy(StrB,StrA);
			strcpy(StrA,PMS(s_3));
			strcat(StrB,StrA);
			if (zc)
			{
				cdSetPos(2,14);
				cdPutByte(1,'3');
			}
			if(zs) ksmMsgLine(StrB,3);
			if (zt)
			{
				emeInfoString(117,48,'L',StrA);
			}
			if (zg)
			{
				gedF16WriteString(StrA,Bx,MsgY3+18);
				Bx = gedNextCharX;
			}
			do{k=kyGetKeyChar();}while(k=='X');
			if (k == '3')
			{
				strcpy(StrA,PMS(s_3));
				strcat(StrB,StrA);
				if (zc)
				{
					cdSetPos(2,15);
		 			cdPutByte(1,'3');
				}
				if(zs) ksmMsgLine(StrB,3);
				if (zt)
				{
					emeInfoString(126,48,'L',StrA);
				}
				if (zg)
				{
					gedF16WriteString(StrA,Bx,MsgY3+18);
				}
			  _delay_ms(1000);
			  fSave = 1;
			}
		}
	}
	zscRestoreLeftDisplay(); 
	if (fSave == 1) ddsUpdateDDSclock(1);
	else fDDSclock = fPrevious;
	zscRestoreLeftDisplay();
	SigGenMode=0;
	ddsSetFreq();
	TuningMode = 'N';  // Encoder 4 can tune trx again
}
