/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taStarControl.c  Central picastar control module

*/


#include "taGlobal.h"
#include "TrxAVR.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "taEncoder.h"
#include "taFT245R.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taADC.h"
#include "taDebug.h"
#include "taUsart.h"
#include "taStarDSP.h"
#include "taProgmem.h"
#include "taStarControl.h"
#include "taSmeter.h"
#include "taMenus.h"
#include "taSWR.h"
#include "taStarDSP.h"
#include "taIntEeprom.h"
#include "taButtons.h"
#include "taDDScommands.h"
#include "taZ_DDScommands.h"
#include "taEA320TouchPanel.h"
#include "taZ_DDS.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taGraphicsControl.h"
#include "taGraphicsDriverEA320.h"
#include "taSlots.h"
#include "taCAT.h"
#include "taEATFT.h"
#include "taEATFTcommands.h"
#include "taEATFTmenus.h"
#include "taKS0108Driver.h"
#include "taKS0108.h"
#include "taEEPROM.h"		// for EEMEM definitions
#include "taKS0108Menus.h"
#include "taI2C.h"
#include "taRTC.h"


#define pgreen 1
#define pyellow 2
#define pred 3

#define DDS23Port PORTA
#define DDS23Bit 0

#define DDS43Port PORTA
#define DDS43Bit 1

#define IP3Port PORTE
#define IP3bit 2

#define AttenPort PORTJ
#define AttenBit 7

#define TxLedPort PORTH
#define TxLedBit 4

#define AttenLedPort PORTH
#define AttenLedBit 5

#define IP3LedPort PORTH
#define IP3LedBit 6

#define SlowSWRport PORTB
#define SlowSWRbit 5

#define PAdisablePort PORTB
#define PAdisableBit 6

#define TRpin PINB
#define TRbit 4				// DSP T/R line (low = transmit)

#define BandPort PORTK

#define portMOX PORTL  // IjS 12.5.2010
#define MOX 3


#define Timer3Max 15625;	// = (1 second) * (16MHz clock) / (1024 prescaler)
#define Timer4Max 250;		// = (1 mS) * (16MHz clock) / (64 prescaler)

#define Timer3Prescale 0x05; //  =   divide by 1024
#define Timer4Prescale 0x03; //  =   divide by 64

#define DisplayBlankDelay	1000	//  1000 x 1mS = 1000mS = 1 second
#define TuningDelay			1500	//  1500 x 1mS = 1500mS = 1.5 seconds
#define SweepDelay			25		//  25   x 1mS = 25mS   = 40 / second
#define SwrDelay			100		//  100  x 1mS = 100mS  = 10 / second
#define SmPwmDelay			250		//  250  x 1mS = 250mS  =  4 / second
#define SmLcdDelay			100		//  100  x 1mS = 100mS  = 10 / second
#define PotsDelay			100		//  100  x 1mS = 100mS  = 10 / second
#define BufDelay			100		//  100  x 1mS = 100mS  = 10 / second
#define ShiftKeyDelay		500		//  500  x 1mS = 500mS  =  2 / second
#define SwitchBlankDelay	100		//  100  x 1mS = 100mS  = 10 / second
#define RtcDelay 250            // 250 x 1ms = 250ms = 4 / second

#define LayerTR 1   // all layer graphic , all text uses graphics
#define LayerRx 2
#define LayerTx 3

#define StackStep 40   // no of tuning increments per slot



#define Switch72Bit 4		// switch 72 attenuator
#define Switch23Bit 3		// switch 23 future
#define Switch79Bit 2		// switch 79 spare
#define Switch43Bit 1		// switch 43 CW roofer



/*		Moved to taEEPROM.h
/////////////////////////////////////////////////////////////
//// on-chip EEPROM data///////////


uint8_t EEMEM EE_EncodersPotsParams[12] = {

			22,   // enc 1  CW QRO on/off
			11,   // enc 2  Denoise
			61,   // enc 3  Narrow SSB filter width / CW filter depth
			62,   // enc 4  Wide SSB filter width / CW filter width
			81,   // enc 5  Tx drive
			91,   // enc 6  Speech Compression / CW spot level
			82,   // enc 7  CW drive decrement
			51,   // enc 8  Manual notch
            21,   // pot A  AF gain
            22,   // pot B  CW QRO on/off
            99,   // spare
			99};  // spare

uint8_t EEMEM EE_RxButtonAssignments[32] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint8_t EEMEM EE_TxButtonAssignments[32] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

uint8_t EEMEM EE_DDSparamBlock[12] = {
			2, 		// dp44CWmode     DDS44 CW LSB default 
			0,     // Software flywheel off
			0,     // Autodim off
			0,     // Param reset mode (if 0 load backup params at startup)
			160,   // Bright display setting
			80,    // Dimmed display setting
			30,    // Autodim seconds
			0,     // Menu encoder reverse direction
			1,     // DDS and DSP key function display option
			0,		// Menu timeout (0 = no timeout, 5 - 60 seconds)
			0,		// spares ..
			0};
*/

// Table of scan delays in seconds
static const uint8_t pmdScanDelayList[10] PROGMEM = {1,2,3,5,10,15,20,30,40,60};  // seconds

// sweep rates  0 to 12  =  500Hz/sec to 5Mhz/sec
// wobbulator  uses 1-12 =   1kHz/sec to 5Mhz/sec
// rate tuning uses 0-7  =  500Hz/sec to 100kHz/sec 

static const uint32_t pmdSweepStepList[13] PROGMEM = {
			10,		//  0	400Hz/sec
			20,		//  1	800Hz/sec
			50,		//  2	2kHz/sec
			100,	//  3	4kHz/sec
			250,	//  4	10kHz/sec
			500,	//  5	20kHz/sec
			1250,	//  6	50kHz/sec
			2500,	//  7	100kHz/sec
			5000,	//  8	200kHz/sec 
			12500,	//  9	500kHz/sec      
			25000,	// 10	1000kHz/sec
			50000,	// 11	2000kHz/sec
			125000	// 12	5000kHz/sec
};

static uint16_t SweepTimer;
static uint16_t SwrTimer;
static uint16_t SmLcdTimer;
static uint16_t SmPwmTimer;
static uint16_t PotsTimer;
static uint16_t BufTimer;
static uint8_t KeyPadDone;
static uint8_t HashTrapped;
static uint8_t TenMins;
static uint16_t ShiftKeyTimer;
static uint8_t SwitchBlankTimer;
static uint8_t OneSecondTimerFlag;	// set by INT 3 but cant do the tasks in the ISR
static uint8_t OneSecondTimerFlagA;	// set by INT 3 but cant do the tasks in the ISR
struct MiscParams_type MiscParams;

uint8_t WobMode;
uint8_t Mode;
uint8_t PreviousMode;
uint8_t RFatten;
uint8_t DDS43;
uint8_t DDS23;
uint8_t GuardChannel;
uint8_t MainChannel;
uint8_t Guarding;
uint8_t ClearSlotno;
uint8_t SWdenoise;
uint8_t SWnoiseblank;
uint8_t SWautonotch;
uint8_t SWmanualnotch;
uint8_t SWfilter;
uint8_t CW_SWfilter;
uint8_t SSB_SWfilter;
uint8_t SWvox;
uint8_t SWspeechcomp;
uint8_t SWqro;
uint8_t SWqsk;
uint8_t SWspot;
uint8_t SWmonitor52;
uint8_t BufFlag;
uint8_t ShiftKeyFlag;
uint8_t ShiftTimer;
uint8_t ShowSwitchValueTimer;
uint8_t ShowSwitchValueFlag;
uint16_t RawKeycode;
uint8_t zgDSPDisplay;
uint8_t ztDSPDisplay;
uint8_t WakeupDisplay;
uint8_t Sleeping;
uint8_t Dimm;
uint8_t DisplayOff;
uint8_t AutoDimmed;
uint16_t AutoDimTimer;
uint8_t MenuTimer;
uint8_t MenuFlag;
uint8_t ScanDelayIndex;
uint8_t ScanDelay;
uint16_t ScanTimer;
uint16_t GuardTimer;
char StickyVolatile;
uint32_t fA;
uint32_t fB;
uint8_t SweepStepIndex;
uint32_t SweepStep;
uint8_t XIT;
uint8_t RIT;
uint8_t ABdiff;
uint8_t DisplaySwitch;
uint8_t DisplayBlankFlag;
uint16_t DisplayBlankTimer;
uint8_t DisplayingMenu;
uint8_t ParamSetting;
uint8_t DDS79;
uint8_t WideBand;
uint8_t Transmit;
uint8_t PreviousTransmitF;
uint8_t PreviousTransmitD;
uint8_t LastEncoderSetting;
uint16_t MoxTimer;
uint8_t RtcTimer;
char ScanMode;
uint8_t SwitchFlgs;	
uint8_t roatu;
uint8_t roatd;

void scDoXITkeys();
void scDoEncoder7();
void scShowMemStackSlotNo();
void scAlternateTuningModes();
void scDoScanStep();
void scToggleDisplay();
void scDisplayBottomBox();
void scDisplayBottomButtons();
void etdDoDisplayKeyEATFT();
void scSlotDisplay();
void scDoOneSecondDimTimer();
void scDoOneSecondTimer();
void scMeterLoopCode();


// *************** MAIN LOOP CODE *************************
void scTestLoopCode()
{
	if (OneSecondTimerFlagA) scDoOneSecondTimer();
	scCheckFlags();
	scDoXITkeys();
	scDoKeyPad();
	scDoEncoder7(); 
	ddsCheckRITshift();  
	scReadTR();
	icRxTx();
	scAlternateTuningModes(); // no action here on normal tuning as ISR changes Freq
	ddsCheckFreq(); 
	scSlotDisplay();			  
	scTrChangeDisplays();
	enDoEncodersPots();
	scMeterLoopCode();  // does DSP monitor as well
	usbCheckPC();
	rtcDoRTC();
	ctDoCat();
//	_delay_us(500);

}  	 
 

// **************** START UP CODE *******************

void scStarInit()
{
	roatu = 1;
 	roatd = 1;
	ksMsgShowing = 0;
	ksFreqInfoShowing = 0;
	ShiftKeyFlag = 0;
	ShiftKeyTimer = 0;
	SwitchBlankTimer = 0;
	ShowSwitchValueFlag = 0;
	ShowSwitchValueTimer = 0;
	etShowSWR = 1;
	scTx(0);  // external PTT off  IJS 12.5.2010
	Transmit = 0;
	MenuExit = 0;
	DiagMode = 'X';
	DDS79 = 0;
	WideBand = 0;
	DisplayBlankFlag = 0;
	DisplayBlankTimer = 0;
	DisplaySwitch = 0;   // dont show DSP initially
	XIT = 0;
	RIT = 0;
	Split = 0;
	TxXITtune = 0;
	KeyPadDone = 0;
	MenuFlag = 0;
	MoxTimer = 0;
	MenuTimer = 0;
	BufTimer = 0;
	ShiftTimer = 0;
	RtcTimer = 0;
	BufFlag = 0;
	PotsTimer = 0;
	SweepDir = 0;
	SweepTimer = 0;
	SweepStep = 10;  // Hz  
	Sleeping = 0;
	ClearSlotno = 1;   // will force display of current stack and no slot
	Dimm = 0;
	DisplayOff = 0;
	OneSecondTimerFlag = 0;
	OneSecondTimerFlagA = 0;
	AutoDimmed = 0;
	zgDSPDisplay = 0;
	ztDSPDisplay = 0;
	GuardChannel = 0;
	RFatten = 0;
	DDS43 = 0;
	DDS23 = 0;
	TenMins = 0;
	Mode = 0;
	ParamColour = pgreen;
	dspSetParamAddress();
	dspSetLed(ParamColour);
	if (zg) geSetMsgFrameDimensions(0);  // 0 = receive
	scSetSWRdamping(1);
	SwrTimer = 0;
	SmLcdTimer = 0;
	SmPwmTimer = 0;
	scPaBias(1);   // enable PA
	SwitchFlgs = 0;

 	// PWM output OC0B  - Smeter and Power meter
 	TCCR0A = 0x21;    // compare output fast PWM bottom
 	TCCR0B = 0x02;    // CLKio / 8
 	
 	// PWM output OC5C  - Display LED current control
 	TCCR5A = 0x09;    // compare output fast PWM bottom
 	TCCR5B = 0x02;    // CLKio / 64
 	
 	scSetDisplayLEDPWM(255);
}


////////////////////////////////////////////////////////////

void scMeterLoopCode()
{
	swDoSWR();
	smDoSmeters();
	dspDoDspDisplay();
}


void scCheckFlags()
{
	if (WakeupDisplay) scWakeupDisplay();
	if (DisplayBlankFlag == 2) {
		scSetDisplayLevel();
		DisplayBlankFlag = 0;
	}
	if (ShowSwitchValueFlag == 13) {
		char kv = (char)(RawKeycode & 0x000f) + 0x30;
		zscShowSwitchCommon(kv);
		ShowSwitchValueTimer = 1;
		ShowSwitchValueFlag = 1;
	}
	if (OneSecondTimerFlag) scDoOneSecondDimTimer();
}


void scSlotDisplay()
{
	if(ClearSlotno==1)
	{
		MemSlotNo = 255;         // if we were on a slot freq then slotno will be showing
		zscShowMemStackSlotNo(); // and should be cncelled as soon as we tune off the slot
		ClearSlotno = 0;
	}
}

////////////////////////////////////////////////////////////////////////
// PC request CTL sub decode   eg: $$$CTL_T = MOX transmit  $$$CTL_R  = MOX receieve   etc
void scUsbRequest(char cmd)
{
  switch(cmd)
	{
	  case 'T': scTx(1); break;    // send current set,switches etc to PC monitoring
		case 'R': scTx(0); break;
  }
}

////////////////////////////////////////////////////////////////////

void scTx(uint8_t tr)
{
	if(tr==1)
	{portMOX |= (1 << MOX); MoxTimer = DDSparams.dpMoxTimeout;}
	else 
	{portMOX &= ~(1 << MOX);};
}


// In 'N'  (normal) mode, Tuning encoder ISR set Freq and DDS
// ddsCheckFreq() does the rest
// - so no action here in 'N' mode 
// re flywheel: sweeping controlled by SweepDir (Only way to stop it is SweepDir=0)

void scAlternateTuningModes()
{
	if ((TuningMode == 'R') && (KillRateTuning == 1)) {
		KillRateTuning = 0;
		RateTuningIndex = 0;
		SweepDir = 0;
		Encoder4count = 0;
		zscShowRateTuningRate();
		return;
	}
	if (Encoder4count > 0) TuningDir = 'U'; else TuningDir = 'D';
	if ((TuningMode == 'N') || (TuningMode == 'X')) {
		if (DDSparams.dpSoftwareFlywheel == 0) {
			SweepDir=0;
		} else {
			if (MiscParams.FlywheelVal == 0) SweepStep = 1000;  // Flywheeling default at 40kHz/sec as classic Picastar
			else SweepStep = (uint16_t)MiscParams.FlywheelVal * 10;
			if (Flywheeling) SweepDir = LatestTuningDir;   // = 'U' or 'D'
			else SweepDir = 0; // stop flywheel on reversal
		}
		Encoder4count=0;	// no longer used in normal tuning
							// used in slot tuning and parameter setting where needs to be zeroed
							// before entering param setting
		return;
	}
	if (abs(Encoder4count) < StackStep) return;
	NeedShowFreq = 1; // to cause ddsCheckFreq() to call ddsShowFreq();
	Encoder4count = 0;  // only one slot at a time
	switch (TuningMode) {
		case 'V':    /// VFO stack
			if (TuningDir == 'U') {  // volatile stack
				if (StickyVolatile == 'S') {  //entering volatile stack from sticky
					VfoSlotNo = VolatileSP;
					zscShowStickyVolatile('V', VfoSlotNo+1);
					StickyVolatile = 'V';
				} else {
					if (VfoSlotNo == 0) VfoSlotNo = VolatileCount - 1; // 23 max count but numbered from zero
					else VfoSlotNo--;   // Vfo volatile slots 0- 22
						zscShowStickyVolatile('V', VfoSlotNo+1);
				}
				ddsLoadVolatileVfoSlot(VFO, VfoSlotNo);
				ddsApplyVfo(VFO);
				UpdateDDS = 1;
			} else {
				if (StickyVolatile == 'V') {  // entering sticky stack from volatile
					VfoSlotNo = ddsReadOldestStickyVfoSlotNo() - 1;
					if (VfoSlotNo > 7) {
						VfoSlotNo = 7;
						ddsWriteOldestStickyVfoSlotNo(VfoSlotNo);							
					}
					if (VfoSlotNo == 0) VfoSlotNo = 7;
					zscShowStickyVolatile('S', VfoSlotNo);
					StickyVolatile = 'S';
				} else {	
					if (VfoSlotNo == 1) VfoSlotNo = 7;
					else VfoSlotNo--;   // Vfo sticky slots 1 - 7  (0 is poweron)
				}
				zscShowStickyVolatile('S', VfoSlotNo);
				ddsLoadStickyVfoSlot(VFO, VfoSlotNo);
				ddsApplyVfo(VFO);
				UpdateDDS = 1;
			}
			break;
		case 'M':  // memory stack
			if (TuningDir == 'U') {
				MemSlotNo++;
				if (MemSlotNo > 5) MemSlotNo = 0;
			} else {
				if (MemSlotNo == 0) MemSlotNo = 5;
				else MemSlotNo--;
			}
			ddsLoadMemSlot(VFO, MemStackNo, MemSlotNo);
			zscShowMemStackSlotNo();
			ddsApplyVfo(VFO);
			UpdateDDS = 1;
			break;
 		case 'S':   /// scan sets tuning rate - look up from delay table
			switch (ScanMode) {
				case 'M':     // scan current stack
				case 'V':     // scan VFO ABAB
					if (TuningDir == 'U') { 
						if (ScanDelayIndex < 9) ScanDelayIndex++;
					} else {
						if (ScanDelayIndex > 0) ScanDelayIndex--;
					}
					ScanDelay = pgm_read_byte(&pmdScanDelayList[ScanDelayIndex]);
					zscShowScanDelay();
					break;
				case 'W':
					if (TuningDir == 'U') { 
						if (SweepStepIndex < 12) SweepStepIndex++;   // 1 to 12
					} else {
						if (SweepStepIndex > 1) SweepStepIndex--;  // 1 to 12
					}
					SweepStep = pgm_read_dword(&pmdSweepStepList[SweepStepIndex]);	
					zscShowWobbulatorRate();									
					break;
			}
			break;
		case 'R': 
			if (TuningDir == 'U') {
				if ((RateTuningIndex < 7) && (RateTuningIndex >= 0)) RateTuningIndex++;
			} else { // never reverses - only killed 
				if ((RateTuningIndex > -7) && (RateTuningIndex <= 0)) RateTuningIndex--;
			}
			if (RateTuningIndex == 0) {
				SweepDir = 0;
			} else {
				KillRateTuning = 0;
				SweepStep = pgm_read_dword(&pmdSweepStepList[abs(RateTuningIndex) - 1]);  
				// RateTuningIndex = 0 = no tuning, +1 = up at rate zero, -3 = down at rate
				if (RateTuningIndex > 0) SweepDir = 'U'; else SweepDir = 'D';
			}
			zscShowRateTuningRate();
			break;
	}
}


void scSetDDS23(uint8_t n)

{
	if (n == 1) {
		DDS23Port |= (1 << DDS23Bit);
		SwitchFlgs |= (1 << Switch23Bit);  	
	}
	
	else {
		DDS23Port &= ~(1 << DDS23Bit);
		SwitchFlgs &= ~(1 << Switch23Bit);  
	}
	dspSendCommand(118, SwitchFlgs); 	
}


void scSetDDS43(uint8_t n)
{
	
	if (n == 1) {
		DDS43Port |= (1 << DDS43Bit);
		SwitchFlgs |= (1 << Switch43Bit);  	
	}
	else {
		DDS43Port &= ~(1 << DDS43Bit);
		SwitchFlgs &= ~(1 << Switch43Bit);  
	}
	dspSendCommand(118, SwitchFlgs); 	
}

void scSetDDS79(uint8_t n)
{
	if (n == 1) {
		SwitchFlgs |= (1 << Switch79Bit);  	
	}
	
	else {
		SwitchFlgs &= ~(1 << Switch79Bit);  
	}

	dspSendCommand(118, SwitchFlgs); 	

}


void scSetMeterPWM(uint8_t n)
{
	OCR0B = n;
}


void scSetDisplayLEDPWM(uint8_t n)
{
	OCR5CH = 0;
	OCR5CL = n;  //must write high then low  // 8bit PWM
	if (zt) {
		uint16_t v = n;
		if (n == 0) {
			if (DisplayOff == 0) {
				DisplayOff = 1;
				etcLEDonoff(0);
			}
		} else {
			if (DisplayOff == 1) {
				DisplayOff = 0;
				etcLEDonoff(1);
			}
		}
		etcLEDBrightness((uint8_t)(((v+2)*100)/255)); //  colour TFT brightness
	}
}

void scPaBias(uint8_t n)
{
	if((n==1)&&(WideBand==0))
	{    
	  PAdisablePort |= (1 << PAdisableBit); //  high = enable PA
  }
	else
	{
	  PAdisablePort &= ~(1 << PAdisableBit); // low = disable PA
  }
}		  




void scStarStart()
{
	DisplayingMenu = 0;
	ParamSetting = 0;
	ddsLoadPowerOnSlot(2); //  2 means VfoA and VfoB
	VFO = 0;  //default to VFO A
	PreviousVFO = 255;		
	PreviousBand = 255;  // force band setting
	PreviousMode = 255;  // force mode setting - also sets offsets
	scSetDisplayLevel();
	zscShowStartUpscreen();
	dspLoad();
	DisplayBlankFlag = 1;
	scSetDisplayLEDPWM(0);
	etFilterInit();
	gcGraphicsDisplayStart();
	if (zc) {
		cdClear();
		cdHome();   
	}
	if (zs) ksdClearScreen();
	if (zt) etStartUp(); //   buttons and other colour graphics intialisation
	ddsApplyVfo(VFO);  // sets Freq
	ddsCheckFreq();
	zscShowMode();
	zscDisplayIP3NF();
	zscShowSwitches(1);
	zscShowFilter();
	zddsShowBothVfoFreqs();
	zscDisplayParamColour(ParamColour);
	if (zt) {
		etMemBox();
		etStackSlot(MemStackNo, 255);  // 255 means stack only displayed
	}
	UpdateDDS = 1;
	if(ParamsNotRestoredMsg == 1) {   // added IJS 13.5.2010  - message now in message box
 	 	strcpy(StrA, PMS(s_No_param_restore));
 		zcmConfirmDDScommand();
	}

}

/////////////////////////////////////////////////////////////
// EEMEM loading/saving

void scEEwriteEncodersPotsParams()
{
	ie_eeprom_write_block(EncodersPotsParams, ee.EE_EncodersPotsParams, 10);
}


void scEEreadEncodersPotsParams()
{
	uint8_t i, chng = 0;

	ie_eeprom_read_block(EncodersPotsParams, ee.EE_EncodersPotsParams, 10);
	for (i = 0; i < 10; i++) {
		if ((EncodersPotsParams[i] < 11) || (EncodersPotsParams[i] > 99)) {
			EncodersPotsParams[i] = 99; chng = 1;
		}
	}
	if (chng) scEEwriteEncodersPotsParams();
}


void scEEwriteRxButtonAssignments()
{
	ie_eeprom_write_block(RxButtonAssignments, ee.EE_RxButtonAssignments, noofButtons);
}


void scEEreadRxButtonAssignments()
{
	uint8_t i, chng = 0;

	ie_eeprom_read_block(RxButtonAssignments, ee.EE_RxButtonAssignments, noofButtons);
	for (i = 0; i < noofButtons; i++) {if (RxButtonAssignments[i] >= buGetNoofTasks()) {RxButtonAssignments[i] = 0; chng = 1;}}
	if (chng) scEEwriteRxButtonAssignments();
}


void scEEwriteTxButtonAssignments()
{
	ie_eeprom_write_block(TxButtonAssignments, ee.EE_TxButtonAssignments, noofButtons);
}


void scEEreadTxButtonAssignments()
{
	uint8_t i, chng = 0;

	ie_eeprom_read_block(TxButtonAssignments, ee.EE_TxButtonAssignments, noofButtons);
	for (i = 0; i < noofButtons; i++) {if (TxButtonAssignments[i] >= buGetNoofTasks()) {TxButtonAssignments[i] = 0; chng = 1;}}
	if (chng) scEEwriteTxButtonAssignments();
}


void scEEwriteRxTouchpadAssignments()
{
	ie_eeprom_write_block(RxTouchpadAssignments, ee.EE_RxTouchpadAssignments, noofTPButtons);
}


void scEEreadRxTouchpadAssignments()
{
	uint8_t i, chng = 0;

	ie_eeprom_read_block(RxTouchpadAssignments, ee.EE_RxTouchpadAssignments, noofTPButtons);
	for (i = 0; i < noofTPButtons; i++) {if (RxTouchpadAssignments[i] >= buGetNoofTasks()) {RxTouchpadAssignments[i] = 0; chng = 1;}}
	if (chng) scEEwriteRxTouchpadAssignments();
}


void scEEwriteTxTouchpadAssignments()
{
	ie_eeprom_write_block(TxTouchpadAssignments, ee.EE_TxTouchpadAssignments, noofTPButtons);
}


void scEEreadTxTouchpadAssignments()
{
	uint8_t i, chng = 0;

	ie_eeprom_read_block(TxTouchpadAssignments, ee.EE_TxTouchpadAssignments, noofTPButtons);
	for (i = 0; i < noofTPButtons; i++) {if (TxTouchpadAssignments[i] >= buGetNoofTasks()) {TxTouchpadAssignments[i] = 0; chng = 1;}}
	if (chng) scEEwriteTxTouchpadAssignments();
}


void scEEwriteDDSparams()
{
	uint8_t block[12];
	memcpy(&block[0], &DDSparams, 12);
	ie_eeprom_write_block(&block[0], ee.EE_DDSparamBlock, 12);
}


void scEEreadDDSparams()
{
	uint8_t block[12], chng = 0;

	ie_eeprom_read_block(&block[0], ee.EE_DDSparamBlock, 12);
	memcpy(&DDSparams, &block[0], 12);
	if (DDSparams.dp44CWmode > 3) {DDSparams.dp44CWmode = 2; chng = 1;}
	if (DDSparams.dpSoftwareFlywheel > 1) {DDSparams.dpSoftwareFlywheel = 0; chng = 1;}
	if (DDSparams.dpAutoDim > 1) {DDSparams.dpAutoDim = 0; chng = 1;}
	if (DDSparams.dpParamResetMode > 1) {DDSparams.dpParamResetMode = 0; chng = 1;}
//	if (DDSparams.dpDisplayBright == 0xff) {DDSparams.dpDisplayBright = 160; chng = 1;}
//	if (DDSparams.dpDisplayDimmed == 0xff) {DDSparams.dpDisplayDimmed = 80; chng = 1;}
//	if (DDSparams.dpAutoDimSeconds == 0xff) {DDSparams.dpAutoDimSeconds = 30; chng = 1;}
	if (DDSparams.dpDisplayKeyValue > 2) {DDSparams.dpDisplayKeyValue = 0; chng = 1;}
	if (DDSparams.dpDSPDDSKeysDisplay > 3) {DDSparams.dpDSPDDSKeysDisplay = 1; chng = 1;}
	if (DDSparams.dpMenuTimeout > 60) {DDSparams.dpMenuTimeout = 0; chng = 1;}
	if (DDSparams.dpMenuTimeout < 5) {DDSparams.dpMenuTimeout = 5; chng = 1;}
	if (DDSparams.dpMoxTimeout > 600) {DDSparams.dpMoxTimeout = 600; chng = 1;}
	if (DDSparams.dpMoxTimeout < 5) {DDSparams.dpMoxTimeout = 5; chng = 1;}
	if (chng) scEEwriteDDSparams();
}


void scEEwriteMiscParams()
{
	uint8_t block[8];

	memcpy(&block[0], &MiscParams, 8);
	ie_eeprom_write_block(&block[0], ee.EE_TuningParamBlock, 8);
}


void scEEreadMiscParams()
{
	uint8_t block[8], chng = 0;

	ie_eeprom_read_block(&block[0], ee.EE_TuningParamBlock, 8);
	memcpy(&MiscParams, &block[0], 8);
	if (MiscParams.TuningThreshold2 > 9) {MiscParams.TuningThreshold2 = 0; chng = 1;}
	if ((MiscParams.TuningThreshold1 <= (MiscParams.TuningThreshold2 + 1)) || (MiscParams.TuningThreshold1 > 20)) {
		MiscParams.TuningThreshold1 = (MiscParams.TuningThreshold2 * 2) + 2; chng = 1;
	}
	if (MiscParams.XParamShow > 1) {MiscParams.XParamShow = 0; chng = 1;}
	if (MiscParams.s5 > 0) {MiscParams.s5 = 0; chng = 1;}
	if (MiscParams.s6 > 0) {MiscParams.s6 = 0; chng = 1;}
	if (MiscParams.s7 > 0) {MiscParams.s7 = 0; chng = 1;}
	if (MiscParams.s8 > 0) {MiscParams.s8 = 0; chng = 1;}
	if (chng) scEEwriteMiscParams();
}


////////////////////////////////////////////////////////////////////
//// TIMERS //////////////////////////


void scTimersInit()
{
  uint16_t Tmax;
	
	// TIMER 3
	Tmax = Timer3Max;
	OCR3AH = Tmax / 0xFF;
	OCR3AL = Tmax % 0xFF;
	TCCR3A = 0;
	TCCR3B = 0x08 + Timer3Prescale;  // mode 4   clock bits 101  = /1024
	TIMSK3  = 0x02;  // OCIE3A bit set (timer 3, output compare A match int enable) 

	// TIMER 4
	Tmax = Timer4Max;
	OCR4AH = Tmax / 0xFF;
	OCR4AL = Tmax % 0xFF;
	TCCR4A = 0;
	TCCR4B = 0x08 + Timer4Prescale;  // mode 4   clock bits 011  = /64
	TIMSK4  = 0x02;  // OCIE4A bit set (timer 4, output compare A match int enable) 

  // TIMER 5


 }


ISR(TIMER3_COMPA_vect)   // interrupt on TXE line    1 second
{
	// Band last slot update if freq change in last 600 seconds = 10 mins
	if (TuningMode != 'S') {  // dont do this if scanning
		TenMins++;
		if (TenMins >= 600) {
			TenMins = 0;
			if (FreqChangeFlag == 1) {
				FreqChangeFlag = 0;
				ddsSaveBandSlot(VFO, 'L', Band);
			}
		}
	}

	if ( (DDSparams.dpAutoDim == 1) &&
		(AutoDimmed == 0) && 
		(Sleeping == 0) && 
		(Dimm == 0) &&
		(AutoDimTimer <= DDSparams.dpAutoDimSeconds) ) {
		  AutoDimTimer++;
	}
	
	if ((MenuFlag == 1) && (MenuTimer < DDSparams.dpMenuTimeout)) {
		MenuTimer++;
		if (MenuTimer >= DDSparams.dpMenuTimeout) {
			MenuFlag = 2;
			MenuTimer = 0;
		}
	}

	if (ShiftTimer > 0) ShiftTimer--;
	if (DisplayEncTimer > 0) DisplayEncTimer--;
	if (ShowSwitchValueTimer > 0) ShowSwitchValueTimer--;

	OneSecondTimerFlag = 1;
	OneSecondTimerFlagA = 1;

	return;
}


ISR(TIMER4_COMPA_vect)   // interrupt on TXE line    1mS
{
	if (TuningTimer < TuningDelay) TuningTimer++; // 1.5sec = XIT diff display persistence time
////////// Sweep stepper ///////////////////
	if (SweepDir != 0) {    // 0 = no sweep,  1 = down, 2 = up
		SweepTimer++;
		if (SweepTimer >= SweepDelay) {
			SweepTimer = 0;
			if (SweepDir == 'D') {
				Freq -= SweepStep;
				if ((ScanMode == 'W') && (Freq <= fB)) Freq = fA;
				if (Freq < 10000) Freq = 99999990;
			} else {
				Freq += SweepStep;
				if ((ScanMode == 'W') && (Freq >= fB)) Freq = fA;
				if (Freq > 99999990) Freq = 10000;
			}
			ddsSetFreq();
			NeedShowFreq = 1;
		}
	}
  //////////   SWR calc  //////////
	SwrTimer++;
	if (SwrTimer >= SwrDelay) {
		SwrTimer = 0;
		SWRflag = 1;
	}
  /////////////////////////
	SmLcdTimer++;
	if (SmLcdTimer >= SmLcdDelay) {
		SmLcdTimer = 0;
		SmLcdFlag = 1;
	}
////////////////////////////////
	SmPwmTimer++;
	if (SmPwmTimer >= SmPwmDelay) {
		SmPwmTimer = 0;
		SmPwmFlag = 1;
	}
////////////////////////////////
	PotsTimer++;
	if (PotsTimer >= PotsDelay) {
		PotsTimer = 0;
		PotsFlag = 1;
	}
////////////////////////////////
	if (DisplayBlankFlag == 1) {
		DisplayBlankTimer++;
		if (DisplayBlankTimer >= DisplayBlankDelay) {
			DisplayBlankTimer = 0;
			DisplayBlankFlag = 2;
		}
	}
////////////////////////////////
	if (BufFlag == 0) {
		BufTimer++;
		if (BufTimer >= BufDelay) {
			BufTimer = 0;
			BufFlag = 1;
		}
	}
////////////////////////////////
	if (ShiftKeyFlag == 0) {
		ShiftKeyTimer++;
		if (ShiftKeyTimer >= ShiftKeyDelay) {
			ShiftKeyTimer = 0;
			ShiftKeyFlag = 1;
		}
	}
/////////////////////////////////
	if (ShowSwitchValueFlag == 12) {
		SwitchBlankTimer++;
		if (SwitchBlankTimer >= SwitchBlankDelay) {
			SwitchBlankTimer = 0;
			ShowSwitchValueFlag = 13;
		}
	}
/////////////////////////////////
	RtcTimer++;
	if (RtcTimer >= RtcDelay) {
		RtcTimer = 0;
		if ((MenuTimer==0)&&(DisplayEnc==255)) RtcFlag = 1;
	}
  /////////////////////////

	return;
}


void scSetDisplayLevel()
{ 
	if ( (Dimm == 1) || (DDSparams.dpAutoDimSeconds == 0) )
	{
		cmDisplayDim();
	}
	else
	{
		cmDisplayBright();
	}
}


void scWakeupDisplay()
{
	if (WakeupDisplay != 2) {
		Flywheeling = 0;
		SweepDir = 0;
		KillRateTuning = 1;
	}
	WakeupDisplay = 0;
	AutoDimTimer = 0;
	if ( (AutoDimmed == 1) || (Sleeping == 1) )
	{
		Sleeping = 0;
		AutoDimmed = 0;
		scSetDisplayLevel();
	}
}


void scDoOneSecondDimTimer()
{ 
	OneSecondTimerFlag = 0;

	if (ShowSwitchValueTimer == 0) {
		switch (ShowSwitchValueFlag) {
			case 0:
			case 1:
				zscClearSwitchValue();
				break;
			case 11:
				zscBlankSwitchValue();
				ShowSwitchValueTimer = 1;
				ShowSwitchValueFlag = 12;
				break;
		}
	}

	if (ShiftTimer) zscShowShiftState(); else zscClearShiftState();

	if ( (DDSparams.dpAutoDim == 1) && (Dimm == 0) )
	{
		if ( (AutoDimmed == 0) && (Sleeping == 0) )
		{
			if (AutoDimTimer > DDSparams.dpAutoDimSeconds)
			{
				AutoDimmed = 1;
				cmDisplayDim();
			}
		}
	}
}


void scDoOneSecondTimer()   // this code intially in Timer 3 ISR  - corrupted display!1!
{
	OneSecondTimerFlagA = 0;

	if (MoxTimer > 0 ) {
	  MoxTimer--;
	  if (MoxTimer == 0) scTx(0);
	}

	if (TuningMode == 'S') {   // scanning
		switch (ScanMode) {
			case 'M':
			case 'V':
				ScanTimer++;
				if (ScanTimer >= ScanDelay) {
					ScanTimer = 0;
					scDoScanStep();
				}
		}
	}

	if ( (TuningMode == 'N') && (Guarding == 1) ) {
		if (VFO == GuardChannel) {
			GuardTimer++;
			if (GuardTimer >= 2) {
				GuardTimer = 0;
				VFO = MainChannel;
				BlockEncoderTuning = 0;
				ddsApplyVfo(VFO);
				zddsShowBothVfoFreqs();
			}
		} else {
			GuardTimer++;
			if (GuardTimer >= 20) {
				GuardTimer = 0;
				VFO = GuardChannel;
				BlockEncoderTuning = '1';  // block tuning
				ddsApplyVfo(VFO);
				zddsShowBothVfoFreqs();
			}
		}
	}
}




void scDoScanStep()
{
	switch (ScanMode) {
		case 'V': cmVfoAB(); break;
		case 'M':
			MemSlotNo++;
			if (MemSlotNo > 5) MemSlotNo = 0;
			ddsLoadMemSlot(VFO, MemStackNo, MemSlotNo); // load next slot
			ddsApplyVfo(VFO);
			ddsSetFreq();  // do this here  ... not in ddsCheckFreq();
			zddsShowFreq();
			zscShowMemStackSlotNo();
			UpdateDDS = 0;
			Band = ddsFreqToBand(Freq);
			if (Band != PreviousBand) {
				scSetBand(); // simply switch BPF and inform DSP
				PreviousBand = Band;
			}
			break;
	}
}


void scSetSWRdamping(uint8_t d)
{ 
	if (d == 1) SlowSWRport |= (1 << SlowSWRbit);
	else SlowSWRport &= ~(1 << SlowSWRbit);
}



void scReadTR()
{
	if ((TRpin & (1 << TRbit)) == 0) Transmit = 1;
	else Transmit = 0;
}


void scTrChangeDisplays()
{
	if (Transmit == 0) Mismatch = 0;
	if (Transmit != PreviousTransmitD) {
		if (Transmit) TxLedPort |= (1 << TxLedBit);
		else TxLedPort &= ~(1 << TxLedBit);
		PreviousTransmitD = Transmit;
		DisplayEncTimer = 0;
		if (zt) {
			DisplayEnc = 255;
			if (DisplaySwitch == 2)
			{
				if (Transmit == 1) etDeleteDSPmonRx(); 
				else etSmeterBarWidth = 0; // bars are otherwise incremental
			}
			etTouchpadCaptions();    // colour TFT only (S1D13700 changes pane) 
		}
		if (DisplaySwitch != 2) zscDeleteMsgFrame(1);
		if (zg) geSetMsgFrameDimensions(Transmit);
		zscGraphicsTR();
		if (Transmit == 0) {
			if (zs) {
				ksClearSwrMeter();
				ksSmeterInit();
			}
			if (zt) {
				etClearSWRmeter();
				etSmeterInit();
			}
			if ((zg) || (zt)) {
				zscShowDSPKeys();
			}
			zscRestoreLeftDisplay();
		} else {
			cdClearLeft();
			if ((zg) || (zt)) {
				zscShowDSPKeys();
			}
			if (zs) {
				ksClearSmeter();
				ksSwrInit();
			}
			if (zt) {
				etClearSmeter();
				etSwrDrawFramework();
			}
			BlockEncoderTuning = 0; // Stop all this funny tuning
			Guarding = 0;           //    ""
		  	SweepDir = 0;
			if (TuningMode == 'S') {
				HowToShowFreq = 'V';
				TuningMode = 'N';
				zddsShowBothVfoFreqs();   
				zscClearTuneBox();
				if (XRIT() == 0) {
					zscClearScanInfoDisplay();
					zscClearRITXITBox();
				}
				buRedrawLabel(39, 0);
			}
			zscClearScanInfoDisplay();
			zscShowMemStackSlotNo();
			zscDisplayIP3NF();
			zscDisplayParamColour(ParamColour);
		}
		if (zt) {
			if (DisplaySwitch == 2) dspStartDSPdisplayEATFT(); else emeDrawDateTime();
		}
	}
}


void scSetAtten(uint8_t n)
{
	if (n == 1) {
		AttenPort |= (1 << AttenBit);
		AttenLedPort |= (1 << AttenLedBit);
		SwitchFlgs |= (1 << Switch72Bit); 
	} else {
		AttenPort &= ~(1 << AttenBit);
		AttenLedPort &= ~(1 << AttenLedBit);
		SwitchFlgs &= ~(1 << Switch72Bit); 
	}
	dspSendCommand(118, SwitchFlgs);
}


void scSetIP3(uint8_t n)
{
	if (n == 1) {
		IP3Port |= (1 << IP3bit);
		IP3LedPort |= (1 << IP3LedBit);
		dspSendCommand(117, 1);   // notify DSP of best IP3 mode
	} else {
		IP3Port &= ~(1 << IP3bit);
		IP3LedPort &= ~(1 << IP3LedBit);
		dspSendCommand(117, 0);  // notify DSP of best NF mode
	}
}



void scSetBand()
{	
	BandPort = pmGetBandPort(Band);	
	dspSendCommand(106, pmGetDSPband(Band));   // set DSP band  
	icSetBPF();
}


void scDoEncoder7()
{
	if (enGetEncoder7delta() != 0) {
		SweepDir = 0;
		Guarding = 0;
		TuningMode = 'N';
		HowToShowFreq = 'V';
		zddsShowBothVfoFreqs();	// restore normal A/B frequency display
		if((SigGenMode==0) || !zg) zscClearTuneBox();
		if (XRIT() == 0) {
			zscClearScanInfoDisplay();
			if((SigGenMode==0) || !zg) zscClearRITXITBox();
		}
		buRedrawLabel(39, 0);
		scWakeupDisplay();
		if (zt) emeParamSettings();
		else if (zs) ksmParamSettings();
		else meParamSettings();
	}
}


void scChangeMode()  // call this also when changing high/low injection
{
	uint8_t bl;

	ddsSetFreq();  // calls ddsSetOffset() which sets DspMode
	bl = dspSendBulkLoad(1);
	dspSendCommand(2, DspMode);
	if (Mode < 2) SWfilter = SSB_SWfilter;
	else SWfilter = CW_SWfilter;
	dspLoadParams();
	dspLoadTxDrive();
	if (bl) dspSendBulkLoad(0);
	enSetEncodersMaxMin();   
	zscShowMode();
	buRedrawLabel(19, 0);
	buRedrawLabel(21, 0);
	buRedrawLabel(22, 0);
	buRedrawLabel(23, 0);
	etShowQRPQRO(dspGetParamValue(22));  // only acts on CW   IJS Star6A9
}


void scDoXITkeys()
{
	char k;

	KeyPadDone = 0;
	if ((ABdiff == 1) && (TxXITtune==0)) {  // hold down '0' to show VFO difference
		if (kyReadChar() == '0') {KeyPadDone = 1; return;}
		else if (kyReadChar() == '0') {KeyPadDone = 1; return;}
		else if (kyReadChar() == '0') {KeyPadDone = 1; return;}
		BlockEncoderTuning = 0;
		ABdiff = 0;
		zddsShowBothVfoFreqs();		
	}
	if (XIT == 1) {      // hold down '#' for XIT TX tune 
	  	uint8_t PriorTxXITtune = TxXITtune;	
		k = kyReadChar();
		if ((k == '#') || (HashTrapped)) {
			if (PriorTxXITtune == 1) {
				if (TxFreq != PriorTxFreq) {	
					ddsSetFreq();  // IJS 11.10.2009
					zddsDisplayABdiff(0);  // VFO B  prevent flutter
				}
				PriorTxFreq = TxFreq;
				KeyPadDone = 1;
				return;
			}  // keep tuning Tx
			_delay_ms(400);
			if (kyReadChar() == '#') {   // long or sustained press
				PriorTxFreq = 0;
				Split = 1;
				TxXITtune = 1;
				zcmShowSplitMode();
				zddsShowABdifference();
				KeyPadDone = 1;
				return;
			} else {   // short press or cancelled long press
				TxXITtune = 0;
				if (Split == 0) Split = 1; else Split = 0;
				zcmShowSplitMode();
				zddsShowBothVfoFreqs();
			}
			KeyPadDone = 1;
			return;
		} else {
			if (PriorTxXITtune == 1) {
				zddsShowBothVfoFreqs();
				TxXITtune = 0;
				ddsSetFreq();   // IJS 11.10.2009
				KeyPadDone = 1;
				return;
			}
		}
	}
	TxXITtune = 0;
	KeyPadDone = 0;
}


// param setting and menu loop keypad routine
// performs long key press action to toggle DSP switches
char scDoMenuKeyPad()
{
	char k = kyGetKeyCharLong();
	if ((k >= 0xB1) && (k <= 0xB9)) {
		k -= 0x80;
		switch(k) {
			case '1': scDenoise(); break;
		 	case '2': scColourshiftup(); break;    //scMute();
		 	case '3': scNoiseBlank(); break;
		 	case '4': scAutoNotch();  break;
			case '5': scColourshiftdwn(); break;   //scManualNotch();
			case '6': scWideNarrow();  break;
			case '7': scVoxQsk();  break; 
			case '9': scComp(); break;
		}
		while (k == kyGetKeyChar()) {
			_delay_ms(10);
		}
		return 'X';
	}
	return k;
}


uint8_t XRIT()
{
  return (XIT | RIT);
}


// Main loop keypad routine
void scDoKeyPad()
{
	char kc, k;
	
	HashTrapped = 0;
	if (KeyPadDone == 1) return;
	k = tpGetTouchChar();
	if (k == 'X') {
		k = kyGetKeyCharLong();
		kc = k & 0x7F; 
		if (kc == 'X') return;
	} else kc = k;
	if ( (kc == '#') && (XIT == 1) ) {
		HashTrapped = 1;
		return;
	}
	BlockEncoderTuning = 0; //  scDoXITKey should do this but may occur in between the two routines
	// key press so stop scanning and return to normal tuning
	if ((ScanMode == 'W') && (TuningMode == 'S')) WobMode = 1; else WobMode = 0;
	SweepDir = 0;
	Guarding = 0;
	TuningMode = 'N';
	HowToShowFreq = 'V';
	zddsShowBothVfoFreqs();	// restore normal A/B frequency display
	zscClearTuneBox(); // no action on zg
	if ( (XRIT()==0) && (SigGenMode==0) ) {
		zscClearScanInfoDisplay();   // acts in char mode only
	  if((!zg) || (RTCpos<3))	zscClearRITXITBox();
	}
	if (WobMode) buRedrawLabel(39, 0);
////////////  IJS STAR6a9 - to restore from DDS28/soft mute button on any key press
	if(Muted==1)
	{
		Muted=0;
		dspSendCommand(167,0); //star4
	}
//////////
	if (k > 0x80) cmDoDDSkeys(kc);
	else {
		switch (kc) {
		 	case '1': scDenoise(); break;
		 	case '2': scColourshiftup(); break; //scMute(); 
		 	case '3': scNoiseBlank(); break;
		 	case '4': scAutoNotch();  break;
			case '5': scColourshiftdwn();  break; //scManualNotch()
			case '6': scWideNarrow();  break;
			case '7': scVoxQsk();  break; 
			case '8':
				if (zt) emeParamSettings(); 
				else if (zs) ksmParamSettings();
				else meParamSettings();
				break;
			case '9': scComp(); break;
			case '*': cmVfoAB(); break;
			case '#': cmRIT();  break;
			case 'E': cmEsc();  break;
			case '0': cmCopyVfo(); break;   // also cancels RIT or XIT
			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
			case 6:
			case 7:
			case 8:
			case 9:
			case 10:
			case 11:
			case 12:
			case 13:
			case 14:
			case 15:
			case 'a':
			case 'b':
			case 'c':
		 	case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z': buDoButtonTask(kc); break;
			case 'M': 
				if (DisplaySwitch == 2) HaltDSPdisplay = 1;
				if (zt) emeDoMenus();
				else if (zs) ksmDoMenus();
				else meDoMenus();  // does zc and zg
				HaltDSPdisplay = 0;
				break;
			case 'S':

				if (DisplaySwitch == 2) HaltDSPdisplay=1;
		 		if (zt) emeSlotMenu();
				else if (zs) ksmSlotMenu();
				else stSlotMenu();  // does zc and zg
				HaltDSPdisplay = 0;
				break;
			case 'D': scToggleDisplay(); break;
		}
	}
}


void scToggleDisplay()
{
	DisplaySwitch += 1;
	if (DisplaySwitch > 2) DisplaySwitch = 0;
	if ((zt) && (DisplaySwitch == 1)) DisplaySwitch = 2;
	if (zt)
	{
		if (DisplaySwitch == 2) etShowSWR=0; else etShowSWR=1;
		if (Transmit == 1)
		{
			etClearSWRmeter();     //  clear the swr part as well
			etSwrDrawFramework();
		}	
		scDoDisplayKeyEATFT();
		if (DisplaySwitch == 0) emeDrawDateTime();
	}
	if (zg)
	{ 
	  geDoDisplayKey();
		if(RTCpos <3 ) geDrawDateTime();
  }
	if (DisplaySwitch == 0) zscShowDSPKeys();
}

void scDoMemSlotSave()
{
	ddsSaveMemSlot(VFO,MemStackNo, MemSlotNo);
	zscMemSlotSavedMessage();
}


void scDoDisplayKeyEATFT()
{
	switch(DisplaySwitch)
	{
		case 0: 
		{
			if(Transmit==0){etDeleteDSPmonRx();}else{etDeleteDSPmonTx();};
			break;
		}
		case 1:
		case 2: dspStartDSPdisplayEATFT(); break; 
	}
}


void scSwitchToMemStacks()
{
	MemSlotNo = 0;   // 61
	ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);	
	ddsApplyVfo(VFO);
	UpdateDDS = 1;
	Encoder4count = 0;		
	zscDisplayMemStack();	
	zscShowMemStackSlotNo();
}


void scPushToVolatileStack()
{
	VolatileSP += 1;                       // move to next slot
	if(VolatileSP > 22){VolatileSP = 0;}   //circular stack - see DDS manual
	if(VolatileCount < 23){VolatileCount += 1;};  // once stack is full we overwrite so count remains at 23
	ddsSaveVolatileVfoSlot(VFO,VolatileSP);
}


void scBandChanged()
{
	MemSlotNo = 255;
	if (Band != PreviousBand)
	{
		ddsSaveBandSlot(VFO, 'L', PreviousBand);
  	FreqChangeFlag = 0;  // prevent 30sec timer saving wrong band freq 
  	ddsLoadBandSlot(VFO, 'L', Band); 
		ddsApplyVfo(VFO);
		UpdateDDS = 1;
	 	zscShowFilter();
		ClearSlotno = 1;
	}
}


void scWobbulator()
{
	if(XRIT() | SigGenMode) return;
	fA = ddsGetVfoFreq(0);
	fB = ddsGetVfoFreq(1);
	Freq = fA;
	if (fB >= fA) {
		SweepDir = 'U';   // up
	} else {
		SweepDir = 'D';   // down
	}
	zscShowWobbActive();
	SweepStepIndex = 1;
	SweepStep = pgm_read_dword(&pmdSweepStepList[SweepStepIndex]);
	HowToShowFreq  = 'S'; // single display - scanning between VFOs
	ScanMode = 'W';
	TuningMode = 'S';
	zscShowWobbulatorMode();
	zscShowWobbulatorRate();
}	   


//////////////////////////////////////////////

// following two routine remains in scStarControl.c 
// because need access to  pmdScanDelayList

void scScanMemStack()
{
	if(XRIT() | SigGenMode) return;
	ScanDelayIndex = 0;
	ScanDelay = pgm_read_byte(&pmdScanDelayList[ScanDelayIndex]);
	ScanTimer = 0;
	ScanMode = 'M';    // memory stack
	TuningMode = 'S';  //  scanning
	HowToShowFreq = 'S'; // stack
	MemSlotNo = 0;
	scSwitchToMemStacks();
	ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo); // load fisrt slot
	ddsApplyVfo(VFO);
	UpdateDDS = 1;
	zscShowMemStackScan();
	zscShowScanDelay();
}


void scABscan()
{
	if(XRIT() | SigGenMode) return;
	HowToShowFreq = 'V';  // stack  - display freq not called
	ScanDelayIndex = 0;
	ScanDelay = pgm_read_byte(&pmdScanDelayList[ScanDelayIndex]);
	ScanTimer = 0;
	ScanMode = 'V';    // vfo A B
	TuningMode = 'S';  //  scanning
	zscShowABscan();
	zscShowScanDelay();
}

///////////////////////////////////////////////////////////

void scDenoise()
{ 
	if(SWdenoise==1){SWdenoise=0;}else{SWdenoise=1;};
	dspSendCommand(1,SWdenoise);   
	zscShowSwitches(1);
	if(rx2 == 1) {dspStartDSPdisplayEATFT();}

}


void scNoiseBlank()
{
	if(SWnoiseblank==1){SWnoiseblank=0;}else{SWnoiseblank=1;};
	dspSendCommand(3,SWnoiseblank);   
	zscShowSwitches();
}


void scAutoNotch()
{ 
		if (SWautonotch == 1) SWautonotch = 0; else SWautonotch = 1;
		dspSendCommand(4, SWautonotch);  // No mode condition in STAR4 used in both
		//QRO has also been removed; on request of John G3GIH
		zscShowSwitches();
	if(rx2 == 1) {dspStartDSPdisplayEATFT();} //2nd monitor mode rx2 a seperate macro has
	//been  setup in TFTa to allow for more DSP monitor information to be displayed from SNR
	//GW2HFR
}


void scWideNarrow()
{ 
	if (SWfilter == 1) SWfilter = 0; else SWfilter = 1;
	if (Mode < 2) SSB_SWfilter = SWfilter;
//	else CW_SWfilter = SWfilter;   // IJS Star6a9
	scSetWideNarrow();
}


void scSetWideNarrow()
{
	uint8_t bl;

	bl = dspSendBulkLoad(1);
	dspSendCommand(6, SWfilter);
	if (Mode < 2) dspSetSSBfilterCentre(63-SWfilter);
	if (bl) dspSendBulkLoad(0);
	ddsSaveFilterToLast();
	zscShowSwitches();
	zscShowFilter();
}


void scManualNotch()
{ 
	if(SWmanualnotch==1){SWmanualnotch=0;}else{SWmanualnotch=1;}
	dspSendCommand(5,SWmanualnotch);  
	zscShowSwitches();
}


void scVoxQsk()
{
	if (Mode < 2) {
		if (SWvox == 1) SWvox = 0; else SWvox = 1;
		dspSendCommand(7, SWvox);
	} else {
		if (SWqsk == 1) SWqsk = 0; else SWqsk = 1;
		dspSendCommand(7, SWqsk);
	}
	zscShowSwitches();
}



void scComp()
{
	if (Mode < 2) {
		if (SWspeechcomp == 1) SWspeechcomp = 0; else SWspeechcomp = 1;
		dspSendCommand(9, SWspeechcomp);
	} else {
		if (SWspot == 1) SWspot = 0; else SWspot = 1;
		dspSendCommand(9, SWspot);
	}
	zscShowSwitches();
}


void scModeStep()
{	 
	Mode += 1;
	if(Mode > 3){Mode=0;}
	scChangeMode();
	ddsSaveModeToLast();
	zscShowSwitches();
	zscShowFilter();
}


void scMute()
{
	if(Muted==1)
	{
		Muted=0;
  		dspSendCommand(167,0); //star4
	}
	else
	{
		Muted=1;
  		dspSendCommand(167,1); //star4
	}										
}

/////// STAR-4 Colour switching code GW2HFR /////////////
void scColourshiftup() {
  cmParamStep();
    _delay_ms(400);
      emeDeleteInfo(); 
  	_delay_ms(25);
  emeDrawDateTime();
  if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
		//	else zscShowDSPKeys();
					   }


void scColourshiftdwn() {

	switch (ParamColour) {
		case pgreen: cmSetRedParams(); break;
		case pred: cmSetYellowParams(); break;
		default: cmSetGreenParams();
	}
	_delay_ms(400);
      emeDeleteInfo(); 
  	_delay_ms(25);
  emeDrawDateTime();
  if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
		//	else zscShowDSPKeys();
                        }
