/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taSmeter.c   S-meter module

*/

#include "taGlobal.h"
#include "taCharLCD.h"
#include "taConfig.h"
#include "taStarDSP.h"
#include "taStarControl.h"
#include "taSmeter.h"
#include "taDDS.h"
#include "taProgmem.h"
#include "taEncoder.h"
#include "taZ_Smeter.h"

uint8_t SmPwmFlag;
uint8_t SmLcdFlag;
uint8_t SmeterDigPrev;
uint8_t SmeterPwmPrev;


void smDoSmeters()
{
	if (Transmit == 1) return;
	if (SmLcdFlag == 1) {
		SmLcdFlag = 0;
		zsmSmeterShowBars();
	}
	if (SmPwmFlag == 1) {
		SmPwmFlag = 0;
		smSmeterPwm();
	}
}


// in char-LCD this is called initially and also to restore display
// after parameter setting, transmit etc
// - may not be needed on three plane graphics
void smStartSmeter()
{
	SmeterDigPrev = 0;
	SmeterPwmPrev = 0;
	dspSendCommand(52, SWmonitor52);  
	zsmSmeterInitialise();
}


void smSmeterPwm()
{
	if ((HardwareSettings.hsHardwareOptionsA & 0x01) == 0) return;
	if (SmeterdB == SmeterPwmPrev) return;
	uint16_t n = SmeterdB;
	n = (n * 256) / 90;
	if (n > 255) n = 255;
	if (n < SmeterPwmPrev) n = (SmeterPwmPrev * 19) / 20;  
	SmeterPwmPrev = n;
	scSetMeterPWM(n);
}


//  S meter bars display is all in taZ_Smeter.c -  zsmSmeterShowBars()
