/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taSlots.c  Stacks and slots scrolling display


*/

#include "taGlobal.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taProgmem.h"
#include "taStarControl.h"
#include "taEncoder.h"
#include "taMenus.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taUsart.h"
#include "taADC.h"
#include "taButtons.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taEA320TouchPanel.h"
#include "taScroll.h"
#include "taGraphicsDriverEA320.h"
#include "taFont8.h"
#include "taFT245R.h"
#include "taCAT.h"
#include "taRTC.h"


void stGotoSlot(uint8_t slotkind, uint8_t m);
char* stSlotInfo();
char* stSlotMenuString(uint8_t i);
char* stMemSlotMenuString(uint8_t Index);
char* stVfoSlotMenuString(uint8_t i);
char* stBandSlotMenuString(uint8_t i);
char stSlotListMenu(uint8_t slotkind);
void stGoToSlot(uint8_t slotkind, uint8_t m);


char* stSlotMenuString(uint8_t Index)
{
	strcpy_P(pmStrBuf,(PGM_P)&pmdSlotMenuList[Index]);
	return &pmStrBuf[0];
} 


void stSlotMenu()
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t noofslots = 3;

	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			/////  Graphics menu initialise ///////////
			if (zg)
			{
				zscDeleteMsgFrame(0);  // clears a hole in DSP display mode
				zscDrawMsgFrame();
				X1scroll = MsgX + 2;
				Y1scroll = MsgY + 30;
				XXscroll = MsgWidth - 2;
				YYscroll = MsgHeight - 31;
				pGetItemString = stSlotMenuString;
				ScrollItemCount = noofslots;
				srInitScrollMenu();
				gedF8WriteString(PMS(s_Stacks_and_slots_display),MsgX+6,MsgY+5);
				gedF8WriteString(PMS(s_Press_Menu_to_select_stack_type),MsgX+6,MsgY+78);
				gedF8WriteString(PMS(s__then_Menu_to_go_to_slot),MsgX+6,MsgY+87);
				gedF8WriteString(PMS(s___No_VFO_slot_access_here_),MsgX+6,MsgY+96);
			}
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			if (zg)
			{
				srDrawList(m);
			}
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			m += encCount7;
			if(m<0){m=(m%noofslots)?(m%noofslots)+noofslots:0;}
			if(m>=noofslots){m=m%noofslots;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = kyGetKeyChar();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'S')   /// S is stacks key
		{
//			if(zc)
//			{
//				cdClearLeft();
//				cdSetPos(1,0);
//			}
			zscClearMsgFrame();
			kc = stSlotListMenu(m);  //  0 = mem,  1 = vfo,   2 = band
			zscRestoreLeftDisplay();
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	zscClearTuneBox();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2)
	{
		if (zg)
		{
			geStartDSPdisplay();
		}
	}
	else
	{
		zscDeleteMsgFrame(1);
		zscShowDSPKeys();
	}
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
}


char* stSlotInfo()
{
	uint8_t e,i;
	ltoa(RamSlot.stFreq,StrB,10);
	if(strlen(StrB)<8){e=0;}else{e=1;}
	for(i=0;i<=2;i++)
	{
	  StrB[9-i] = StrB[6-i+e];
	}
	StrB[6] = '.';
	for(i=3;i<=5;i++)
	{
	  StrB[8-i] = StrB[6-i+e];
	}
	StrB[2] = '.';
	if(e==0)
	{
		StrB[1]= StrB[0];
		StrB[0] = ' ';
	};
	StrB[10]=' ';
	StrB[11]=0;
	if(e==0)
	{
		for(i=0;i<=11;i++){StrB[12-i]=StrB[11-i];};
		StrB[0]=' ';
	}
	strcat(StrB,pmModeName(RamSlot.stMode));
	strcat(StrB," ");
	if(RamSlot.stIP3==1){strcat(StrB,"I ");}else{strcat(StrB,"N ");};
	switch(RamSlot.stParamColour)
	{
		case 1: strcat(StrB,"G "); break;
		case 2: strcat(StrB,"Y "); break;
		case 3: strcat(StrB,"R "); break;
	}
	if(RamSlot.stFilterNarrow==1)
	{
		if(RamSlot.stMode < 2){strcat(StrB,"N");} else {strcat(StrB,"D");};
	}
	else
	{
		if(RamSlot.stMode < 2){strcat(StrB,"W");} else {strcat(StrB,"C");};
	};
	
	return StrB;
}



char* stMemSlotMenuString(uint8_t i)
{
	uint8_t stack;
	uint8_t slot;
	if(i<24)
	{
		stack = i/6;
		slot =  i%6;
		ddsLoadMemSlotToRamSlot(stack,slot);		
		stack += 7;
		if(stack==10){stack=0;};
		strcpy(StrA,PMS(s_6x_6x__));
		StrA[1] = 0x30+stack;
		StrA[4] = 0x31+slot;
		strcat(StrA,stSlotInfo());
	}	
	return StrA;			  
}



char* stVfoSlotMenuString(uint8_t i)
{
	uint8_t n = i;
	if(n==0)
	{
		ddsLoadStickyVfoSlotToRamSlot(0);
		strcpy(StrA,PMS(s_Poweron__));
		strcat(StrA,stSlotInfo());
	}
	if((n>=1)&&(n<=7))
	{
		ddsLoadStickyVfoSlotToRamSlot(n);
		strcpy(StrA,PMS(s_Sticky____));
		StrA[7] = 0x30+n;
		strcat(StrA,stSlotInfo());
	}
	if((i>=8)&&(i<=30))
	{
		n -=8;
		if(n<VolatileCount)
		{
			ddsLoadVolatileVfoSlotToRamSlot(n);
		}
		n += 1;  //  slots 0-22 shown as 1-23
		strcpy(StrA,PMS(s_Volat_____));
		StrA[6] = 0x30 + n/10;
		StrA[7] = 0x30 + n%10;
		if(n<VolatileCount)
		{
			strcat(StrA,stSlotInfo());		
		}
		else
		{
			strcat(StrA,PMS(s_Slot_not_defined));
		}
	}
	return StrA;
}



char* stBandSlotMenuString(uint8_t i)
{
	uint8_t band, t;
	char LSC = 'X';
	band = i%10;
	t = i/10;
	switch(t)
	{
	  case 0: LSC = 'L'; strcpy(StrB,PMS(s__Last_)); break;
		case 1: LSC = 'S'; strcpy(StrB,PMS(s__SSB__)); break;
		case 2: LSC = 'C'; strcpy(StrB,PMS(s__CW___)); break;
	}
	ddsLoadBandSlotToRamSlot(LSC,band);
	strcpy(StrA,pmBandName(band));
	strcat(StrA,StrB);
	if(band==2)
	{strcat(StrA,PMS(s_10_hyphens));}
	else
	{strcat(StrA,stSlotInfo());};		
	return StrA;
}



void stGotoSlot(uint8_t slotkind, uint8_t m)
{
	switch(slotkind)
	{
		case 0:
		{
			MemStackNo = m/6;
			MemSlotNo =  m%6;
			ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);	
			ddsApplyVfo(VFO);
			UpdateDDS = 1;
			Encoder4count = 0;		
			zscShowMemStackSlotNo();
			break;
		}
		case 1:
		{
			// no volatile access here
			break;
		}
		case 2:
		{
			uint8_t b = m%10;   // band
			uint8_t t = m/10;
			char LSC = 'L';  // dummy value
			switch(t)
			{
	  		case 0: LSC = 'L'; break;
				case 1: LSC = 'S'; break;
				case 2: LSC = 'C'; break;
			}
			ddsLoadBandSlot(VFO,LSC,b); 
			ddsApplyVfo(VFO);
		  UpdateDDS = 1;
//			ddsSaveBandSlot(VFO,'L',Band);
			break;
		}
	}
}



char stSlotListMenu(uint8_t slotkind)
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t refresh = 1;
	uint8_t restart = 1;

	do
	{
		scReadTR();
		if((Transmit!=PreviousTransmitD) || (MenuFlag == 2))
		{
			zscClearTuneBox();
			Encoder4count = 0;
			return 'E';   //  exit all menus on TR switched
		}
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			if (zg)
			{
				zscDrawMsgFrame();
				X1scroll = MsgX + 2;
				Y1scroll = MsgY + 4;
				XXscroll = MsgWidth - 2;
				YYscroll = MsgHeight - 3;
				switch(slotkind)
				{
					case 0: pGetItemString = stMemSlotMenuString; ScrollItemCount = 24; break;
					case 1: pGetItemString = stVfoSlotMenuString; ScrollItemCount = 31; break;
					case 2: pGetItemString = stBandSlotMenuString; ScrollItemCount = 30; break;
				}
				srInitScrollMenu();
			}
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
//			if (zc)
//			{
//				cdSetPos(2,0);
//				cdDisplayString(pmdSpaces(20));
//				cdSetPos(2,0);
//				cdDisplayString(stSlotMenuString(1)); // xxxxxxxxxxxxxxx
//			}
			if (zg)
			{
				srDrawList(m);
			}
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			m += encCount7;
			if(m<0){m=(m%ScrollItemCount)?(m%ScrollItemCount)+ScrollItemCount:0;}
			if(m>=ScrollItemCount){m=m%ScrollItemCount;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'S')   /// S is stacks key
		{
			if(m!=1)  // no VFO slot access
			{
				stGotoSlot(slotkind,m);
				return 'E';  // cause exit from  parent menu
			}
			kc = 'X';
		}
	} while((kc!='E')&&(kc!='#'));  // 'E' is ESC key
	zscDeleteMsgFrame(1);
	Encoder4count = 0;
	return 'X';
}
