/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taScroll.c       Scrolling menu code module

*/


//  void (*ptask)();   //ptask defined here as a pointer to some function
//	ptask = (void*)pgm_read_word(&pmdTaskPointerList[taskno]);  //assign ptask to function from list 
//  ptask();  //call ptask   


#include "taGlobal.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taStarControl.h"
#include "taEncoder.h"
#include "taMenus.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taUsart.h"
#include "taADC.h"
#include "taButtons.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taEA320TouchPanel.h"
#include "taScroll.h"
#include "taGraphicsDriverEA320.h"
#include "taFont8.h"


#define ScrollSpacing 10

//	pGetItemString = pmParamNameNL;

//	strcpy(StrD,pGetItemString(22));


void srInitScroll()
{

}


void srDrawList(int Index)
{
	uint8_t y;
	char u[40];
	Brush.Color = 0;
	int pos,i;
	for(pos=0;pos<VisibleCount;pos++)
	{  
		y = Y1scroll+pos*ScrollSpacing;
		gedFillRect(X1scroll,y-1,X1scroll+XXscroll-1,y+8);
		
		i = pos + Index - HighlightedPos;
		if(i<0){i+=ScrollItemCount;};
		if(i>=ScrollItemCount){i-=ScrollItemCount;}
		if(pos==HighlightedPos)
		{
			InvertPixels=0xFF;
			strcpy(u," ");
			strcat(u,pGetItemString(i));
			gedF8WriteString(u,X1scroll,y);
			InvertPixels = 0;
		}
		else
		{
			gedF8WriteString(pGetItemString(i),X1scroll+SpaceWidth,y);
  	}
	}
}


// this is used when the highlighted item has been edited
void srDrawHighlightedItem(int Index)
{
	uint8_t y;
	char u[40];
	Brush.Color = 0;		
	y = Y1scroll+HighlightedPos*ScrollSpacing;
	gedFillRect(X1scroll+1,y-1,X1scroll+XXscroll-1,y+8);
	InvertPixels=0xFF;
	strcpy(u," ");
	strcat(u,pGetItemString(Index));
	gedF8WriteString(u,X1scroll,y);
	InvertPixels = 0;
}


void srInitScrollMenu()
{
	VisibleCount = YYscroll/ScrollSpacing;
	if(VisibleCount>ScrollItemCount){VisibleCount=ScrollItemCount;};
  HighlightedPos = VisibleCount/2 - 1;
	SpaceWidth = pgm_read_byte(&lentbl_S[0]);   // ascii 32 width
	Brush.Color = 0;
	gedFillRect(X1scroll+1,Y1scroll+1,X1scroll+XXscroll-2,Y1scroll+YYscroll-2);
}
