/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taKeysUser.c  User defined key pad decode module program file


*/

#include "taGlobal.h"
#include "taKeysUser.h"
#include "taStarControl.h"

char kuDecode1(uint16_t k);
char kuDecode2(uint16_t k);

// Select required user decode function here
char kyUserDefined(uint16_t k)
{
	return (kuDecode1(k));
//	return (kuDecode2(k));
}

///////////////////////////////////////////////////////////////////////////
//
//	User defined TrxAVR_Picastar keypad
//
//	4 x 4 Hex Keypad with optional 9 - Customised
//
//	[j] - square brackets = shift char
//
//	button				|	code returned by kuDecode1(k)
//						|
//	11	21	31	41		|	1[a]	2[b]	3[c]	A(Menu)[d]
//						|
//	12	22	32	42		|	4[e]	5[f]	6[g]	B(Esc)[h]
//						|
//	13	23	33	43		|	7[i]	8[j]	9[k]	C(Display)[l]
//						|
//	14	24	34	44		|	*[m]	0[n]	#[o]	D(Shift)
//						|

char kuDecode1(uint16_t k)
{
	char ch = 'X';
	
	if ( ((k & 0x00FF) == 0x0044) && ((k & 0xFF00) != 0x0000 ) )
		k = ((k & 0x00FF) << 8) | ((k & 0xFF00) >> 8);

	switch (k)
	{ 

		case 0x0044:  ch = '!'; break;	// Shift Key is "invisible"

		case 0x0011:  ch = '1'; break;
		case 0x0021:  ch = '2'; break;
		case 0x0031:  ch = '3'; break;
		case 0x0041:  ch = 'M'; break;
		case 0x0051:  ch = 'u'; break;	// 51 = u
		case 0x0012:  ch = '4'; break;
		case 0x0022:  ch = '5'; break;
		case 0x0032:  ch = '6'; break;
		case 0x0042:  ch = 'E'; break;
		case 0x0052:  ch = 't'; break;	// 52 = t
		case 0x0013:  ch = '7'; break;
		case 0x0023:  ch = '8'; break;
		case 0x0033:  ch = '9'; break;
		case 0x0043:  ch = 'D'; break;
		case 0x0053:  ch = 's'; break;	// 53 = s
		case 0x0014:  ch = '*'; break;
		case 0x0024:  ch = '0'; break;
		case 0x0034:  ch = '#'; break;
		case 0x0054:  ch = 'S'; break;	// 54 = S(tacks)
		case 0x0015:  ch = 'z'; break;	// 15 = z
		case 0x0025:  ch = 'y'; break;	// 25 = y
		case 0x0035:  ch = 'x'; break;	// 35 = x
		case 0x0045:  ch = 'w'; break;	// 45 = w
		case 0x0055:  ch = 'v'; break;	// 55 = v

		case 0x4411:  ch = 'a'; break;	// Shift and 1
		case 0x4421:  ch = 'b'; break;	// 2
		case 0x4431:  ch = 'c'; break;	// 3
		case 0x4441:  ch = 'd'; break;	// A
		case 0x4412:  ch = 'e'; break;	// 4
		case 0x4422:  ch = 'f'; break;	// 5
		case 0x4432:  ch = 'g'; break;	// 6
		case 0x4442:  ch = 'h'; break;	// B
		case 0x4413:  ch = 'i'; break;	// 7
		case 0x4423:  ch = 'j'; break;	// 8
		case 0x4433:  ch = 'k'; break;	// 9
		case 0x4443:  ch = 'l'; break;	// C
		case 0x4414:  ch = 'm'; break;	// *
		case 0x4424:  ch = 'n'; break;	// 0
		case 0x4434:  ch = 'o'; break;	// #

	}
	
	if (ch != 'X') {
		if (ch == '!') {
			if (ShiftKeyFlag) ShiftTimer = 5;
			ch = 'X';
		} else {
			ShiftTimer = 0;
			ShiftKeyFlag = 0;
		}
	}

	return ch;
}


///////////////////////////////////////////////////////////////////////////
//
//	User defined TrxAVR_Picastar keypad
//
//	4 x 4 Hex Keypad with extra 2 columns of 6 switches - Customised
//
//	[j] - square brackets = shift char
//  Shift # is the Stacks function
//
//	button						|	code returned by kuDecode2(k)
//								|
//	11	21	31	41	51	61		|	1[a]	2[b]	3[c]	A(Menu)[d]		o[a]	u[g]
//								|
//	12	22	32	42	52	62		|	4[e]	5[f]	6[g]	B(Esc)[h]		p[b]	v[h]
//								|
//	13	23	33	43	53	63		|	7[i]	8[j]	9[k]	C(Display)[l]	q[c]	w[i]
//								|
//	14	24	34	44	54	64		|	*[m]	0[n]	#[S]	D(Shift)		r[d]	x[j]
//								|
//					55	65		|											s[e]	y[k]
//								|
//					56	66		|											t[f]	z[l]
//								|

char kuDecode2(uint16_t k)
{
	char ch = 'X';
	
	if ( ((k & 0x00FF) == 0x0044) && ((k & 0xFF00) != 0x0000 ) )
		k = ((k & 0x00FF) << 8) | ((k & 0xFF00) >> 8);

	switch (k)
	{ 

		case 0x0044:  ch = '!'; break;	// Shift Key is "invisible"

		case 0x0011:  ch = '1'; break;
		case 0x0021:  ch = '2'; break;
		case 0x0031:  ch = '3'; break;
		case 0x0041:  ch = 'M'; break;
		case 0x0051:  ch = 'o'; break;	// 51 = o
		case 0x0061:  ch = 'u'; break;	// 61 = u
		case 0x0012:  ch = '4'; break;
		case 0x0022:  ch = '5'; break;
		case 0x0032:  ch = '6'; break;
		case 0x0042:  ch = 'E'; break;
		case 0x0052:  ch = 'p'; break;	// 52 = p
		case 0x0062:  ch = 'v'; break;	// 62 = v
		case 0x0013:  ch = '7'; break;
		case 0x0023:  ch = '8'; break;
		case 0x0033:  ch = '9'; break;
		case 0x0043:  ch = 'D'; break;
		case 0x0053:  ch = 'q'; break;	// 53 = q
		case 0x0063:  ch = 'w'; break;	// 63 = w
		case 0x0014:  ch = '*'; break;
		case 0x0024:  ch = '0'; break;
		case 0x0034:  ch = '#'; break;
		case 0x0054:  ch = 'r'; break;	// 54 = r
		case 0x0064:  ch = 'x'; break;	// 64 = x
		case 0x0055:  ch = 's'; break;	// 54 = s
		case 0x0065:  ch = 'y'; break;	// 64 = y
		case 0x0056:  ch = 't'; break;	// 54 = t
		case 0x0066:  ch = 'z'; break;	// 64 = z
		
		// These matrix combinations are currently unused
		case 0x0015:  ch = 'a'; break;	// 15 = a
		case 0x0025:  ch = 'b'; break;	// 25 = b
		case 0x0035:  ch = 'c'; break;	// 35 = c
		case 0x0045:  ch = 'd'; break;	// 45 = d
		case 0x0016:  ch = 'e'; break;	// 16 = e
		case 0x0026:  ch = 'f'; break;	// 26 = f
		case 0x0036:  ch = 'g'; break;	// 36 = g
		case 0x0046:  ch = 'h'; break;	// 46 = h

		// Shifted key combinations
		case 0x4411:  ch = 'a'; break;	// Shift and 1
		case 0x4421:  ch = 'b'; break;	// 2
		case 0x4431:  ch = 'c'; break;	// 3
		case 0x4441:  ch = 'd'; break;	// A
		case 0x4451:  ch = 'a'; break;	// S51
		case 0x4461:  ch = 'g'; break;	// S61
		case 0x4412:  ch = 'e'; break;	// 4
		case 0x4422:  ch = 'f'; break;	// 5
		case 0x4432:  ch = 'g'; break;	// 6
		case 0x4442:  ch = 'h'; break;	// B
		case 0x4452:  ch = 'b'; break;	// S52
		case 0x4462:  ch = 'h'; break;	// S62
		case 0x4413:  ch = 'i'; break;	// 7
		case 0x4423:  ch = 'j'; break;	// 8
		case 0x4433:  ch = 'k'; break;	// 9
		case 0x4443:  ch = 'l'; break;	// C
		case 0x4453:  ch = 'c'; break;	// S53
		case 0x4463:  ch = 'i'; break;	// S63
		case 0x4414:  ch = 'm'; break;	// *
		case 0x4424:  ch = 'n'; break;	// 0
		case 0x4434:  ch = 'S'; break;	// # => Stacks function
		case 0x4454:  ch = 'd'; break;	// S54
		case 0x4464:  ch = 'j'; break;	// S64
		case 0x4455:  ch = 'e'; break;	// S55
		case 0x4465:  ch = 'k'; break;	// S65
		case 0x4456:  ch = 'f'; break;	// S56
		case 0x4466:  ch = 'l'; break;	// S66

	}
	
	if (ch != 'X') {
		if (ch == '!') {
			if (ShiftKeyFlag) ShiftTimer = 5;
			ch = 'X';
		} else {
			ShiftTimer = 0;
			ShiftKeyFlag = 0;
		}
	}

	return ch;
}
