/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taGraphicsEA320.c    program file
 
Graphics display routines   320x240   
Epson S1D13700 driver chip
 
*/
#include "taGlobal.h"
#include "taFont16.h"
#include "taFont8.h"
#include "taFontFreqA.h"
#include "taButtons.h"
#include "taGraphicsEA320.h"
#include "taGraphicsDriverEA320.h"
#include "taStarDSP.h"
#include "taGraphicsControl.h"
#include "taZ_StarControl.h"
#include "taStarControl.h"
#include "taSmeter.h"
#include "taSWR.h"
#include "taDDS.h"
#include "taRTC.h"
#include "taEncoder.h"
#include "taZ_DDScommands.h"


#define MsgRTCX 114
#define MsgRTCY 182


uint16_t MsgX;
uint16_t MsgWidth;
uint8_t MsgY;
uint8_t MsgHeight;
uint8_t MsgY1;
uint8_t MsgY2;
uint8_t MsgY3;
uint8_t BarsY;

uint8_t geLabelOffset(char* s);
uint8_t geAllowDisplayRTC();
void geDisplayBottomBox();
void geDisplayBottomButtons();
void geDspGraphicsInit();
void geRxDSPtext();
void geTxDSPtext();



///////////////////   RTC   /////////////////////////

void geDrawTime() __attribute__((section(".highmem")));
void geDrawTime()
{
  if (!geAllowDisplayRTC()) return;
	gedSwitchLayer(LayerTR);
	switch(RTCpos)
	{
	  case 1:
		{
			if(DisplaySwitch) return;
			Brush.Color = 1;
			gedF8WriteString(StrTimeU, 37, 220);
			gedF8WriteString(StrTimeL, 37, 230);
			break;
		}
	  case 2:
		{
			if(DisplaySwitch) return;
			Brush.Color = 1;
			gedF8WriteString(StrTimeU, MsgRTCX+37, MsgRTCY+3);
			gedF8WriteString(StrTimeL, MsgRTCX+37, MsgRTCY+13);
			break;
		}
	  case 3:
		{
			if(XRIT()==0)
			{
				Brush.Color = 1;
				ged5x3WriteString(StrTimeU, 23, 46);
				ged5x3WriteString(StrTimeL, 23, 56);
			}
			break;
		}
  }
}



void geClearParamBox() __attribute__((section(".highmem")));
void geClearParamBox()
{
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		Brush.Color = 0;
		gedFillRect(1,40,103,67);
		Brush.Color = 1;
	}
}



void geClearParamBoxLower() __attribute__((section(".highmem")));
void geClearParamBoxLower()
{
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		Brush.Color = 0;
		gedFillRect(1,56,103,67);
		Brush.Color = 1;
	}
}




uint8_t geAllowDisplayRTC() __attribute__((section(".highmem")));
uint8_t geAllowDisplayRTC()
{
	if (RtcActive==0) return 0; 
	if (RTCpos<3) return 1;
	if (NoClockDraw || Guarding || (TuningMode=='V') 
	|| (TuningMode=='R') || (TuningMode=='S')
	|| (TuningMode=='M') || SigGenMode) return 0;
	return 1;
}

void geDrawDateTime() __attribute__((section(".highmem")));
void geDrawDateTime()
{
  if (!geAllowDisplayRTC()) return;
	rtcPrepareTime();
	gedSwitchLayer(LayerTR);
	switch(RTCpos)
	{
  	case 1:
		{
			if(DisplaySwitch) return;
			Brush.Color = 0;
			gedFillRect(1,217,162,238);
			Brush.Color = 1;
  		gedHorizLine(0,162,217,1);
  	  gedVertLine(217,239,162,1);
			gedF8WriteString(PMS(se_UTC____), 6, 220);
			gedF8WriteString(PMS(se_Local__), 6, 230);
			gedF8WriteString(StrDateU, 88, 220);
			gedF8WriteString(StrDateL, 88, 230);
			gedF8WriteString(StrTimeU, 37, 220);
			gedF8WriteString(StrTimeL, 37, 230);
			break;
		}
  	case 2:
		{
			if(DisplaySwitch) return;
			Brush.Color = 0;
			gedFillRect(MsgRTCX,MsgRTCY,MsgRTCX+160,MsgRTCY+23);
			Brush.Color = 1;
  		gedRect(MsgRTCX,MsgRTCY,MsgRTCX+160,MsgRTCY+23,1);
			gedF8WriteString(PMS(se_UTC____), MsgRTCX+4, MsgRTCY+3);
			gedF8WriteString(PMS(se_Local__), MsgRTCX+4, MsgRTCY+13);
			gedF8WriteString(StrDateU, MsgRTCX+88, MsgRTCY+3);
			gedF8WriteString(StrDateL, MsgRTCX+88, MsgRTCY+13);
			gedF8WriteString(StrTimeU, MsgRTCX+37, MsgRTCY+3);
			gedF8WriteString(StrTimeL, MsgRTCX+37, MsgRTCY+13);
			break;
		}
  	case 3:
		{
			if(XRIT()==0)
			{
				geClearParamBox();
				Brush.Color = 1;
				ged5x3WriteString("UTC:", 6, 46);
				ged5x3WriteString("Loc:", 6, 56);
				ged5x3WriteString(StrDateU, 56, 46);
				ged5x3WriteString(StrDateL, 56, 56);
				ged5x3WriteString(StrTimeU, 23, 46);
				ged5x3WriteString(StrTimeL, 23, 56);
			}
			break;
		}	
	}
}

/////////////////////////////////////////////////////////////

void geSetMsgFrameDimensions(uint8_t transmit) __attribute__((section(".highmem")));
void geSetMsgFrameDimensions(uint8_t transmit)
{
  	MsgX = RxTxMsgX;
	MsgWidth = RxTxMsgWidth;
	if (transmit == 1)
	{
		MsgY = TxMsgY;
		MsgHeight = TxMsgHeight;
		MsgY1 = TxMsgY1;
		MsgY2 = TxMsgY2;
		MsgY3 = TxMsgY3;
	}
	else
	{
		MsgY = RxMsgY;
		MsgHeight = RxMsgHeight;
		MsgY1 = RxMsgY1;
		MsgY2 = RxMsgY2;
		MsgY3 = RxMsgY3;
	}
}

//////////////////////////////////

void geCheckBox(uint16_t X,uint8_t Y,uint8_t chkd) __attribute__((section(".highmem")));
void geCheckBox(uint16_t X,uint8_t Y,uint8_t chkd)
{
	if(chkd==0)
	{
		Brush.Color = 0;
		gedFillRect(X,Y,X+6,Y+6);
		Brush.Color = 1;
		gedHorizLine(X,X+6,Y,1);
		gedHorizLine(X,X+6,Y+6,1);
  	gedVertLine(Y,Y+6,X,1);
		gedVertLine(Y,Y+6,X+6,1);
	}
	else 
	{
		Brush.Color = 1;
		gedFillRect(X,Y,X+6,Y+6);
	}
}

///////////////////////////////////////////////

void geClearWin() __attribute__((section(".highmem")));
void geClearWin()
{
	uint8_t i;
	
	zgDSPDisplay = 0;
	Brush.Color = 0;
	if (!HaveTP && !HaveRB && !HaveBB) i = 0; else i = 1;
	gedSwitchLayer(LayerRx);
	gedFillRect(WinX,WinY,WinX+WinWidth-i, WinY+WinHeight-1);
	gedSwitchLayer(LayerTx);
	gedFillRect(WinX,WinY,WinX+WinWidth-i, WinY+WinHeight-1);
	gedSwitchLayer(LayerTR);
	gedFillRect(WinX,WinY,WinX+WinWidth-i, WinY+WinHeight-1);
	Brush.Color = 1;
}


///////////////////////////////////////////////////////


void geDrawMsgFrame() __attribute__((section(".highmem")));
void geDrawMsgFrame()
{
	gedSwitchLayer(LayerTR);      // switch to layer 1
	Brush.Color = 1;
	gedHorizLine(MsgX, MsgX+MsgWidth, MsgY, 1);    // top border
	gedHorizLine(MsgX, MsgX+MsgWidth, MsgY+MsgHeight, 1);  // bottom border
	gedVertLine(MsgY, MsgY+MsgHeight, MsgX, 1);     // left border
	gedVertLine(MsgY, MsgY+MsgHeight, MsgX+MsgWidth, 1);   // right border
}


void geClearRxMsgFrame() __attribute__((section(".highmem")));
void geClearRxMsgFrame()
{
	zgDSPDisplay = 0;
	Brush.Color = 0;
	gedSwitchLayer(LayerRx);
	gedFillRect(MsgX+1, MsgY+1, MsgX+MsgWidth-1, MsgY+MsgHeight-1);
	Brush.Color = 1;
}
	


void geClearMsgFrame() __attribute__((section(".highmem")));
void geClearMsgFrame()
{
	Brush.Color = 0;
	if (DisplaySwitch == 2)
	{
		zgDSPDisplay = 0;
		gedSwitchLayer(LayerRx);
		gedFillRect(MsgX+1, MsgY+1, MsgX+MsgWidth-1, MsgY+MsgHeight-1);
		gedSwitchLayer(LayerTx);
		gedFillRect(MsgX+1, MsgY+1, MsgX+MsgWidth-1, MsgY+MsgHeight-1);
	}
	gedSwitchLayer(LayerTR);
	gedFillRect(MsgX+1, MsgY+1, MsgX+MsgWidth-1, MsgY+MsgHeight-1);
	Brush.Color = 1;
}



void geDeleteMsgFrame() __attribute__((section(".highmem")));
void geDeleteMsgFrame()
{
	NoClockDraw = 0;
	Brush.Color = 0;
	if (DisplaySwitch == 2)
	{
		zgDSPDisplay = 0;
		gedSwitchLayer(LayerRx);
		gedFillRect(MsgX, MsgY, MsgX+MsgWidth, MsgY+MsgHeight);
		gedSwitchLayer(LayerTx);
		gedFillRect(MsgX, MsgY, MsgX+MsgWidth, MsgY+MsgHeight);
	}
	gedSwitchLayer(LayerTR);
	gedFillRect(MsgX, MsgY, MsgX+MsgWidth, MsgY+MsgHeight);
	Brush.Color = 1;
}


void geShowState(char c) __attribute__((section(".highmem")));
void geShowState(char c)
{
	if (DisplaySwitch == 2) return;
	gedSwitchLayer(LayerTR);
	Brush.Color = 0;
	gedFillRect(geStateX, geStateY, geStateX+15, geStateY+17);
	Brush.Color = 1;
	gedHorizLine(geStateX, geStateX+15, geStateY, 1);
	gedHorizLine(geStateX, geStateX+15, geStateY+17, 1);
	gedVertLine(geStateY, geStateY+17, geStateX, 1);
	gedVertLine(geStateY, geStateY+17, geStateX+15, 1);
	StrA[0] = c;
	StrA[1] = 0;
	gedF16WriteString(StrA, geStateX+4, geStateY+1);
}


void geBlankState() __attribute__((section(".highmem")));
void geBlankState()
{
	if (DisplaySwitch == 2) return;
	gedSwitchLayer(LayerTR);
	Brush.Color = 0;
	gedFillRect(geStateX+1, geStateY+1, geStateX+14, geStateY+16);
	Brush.Color = 1;
}


void geClearState() __attribute__((section(".highmem")));
void geClearState()
{
	if (DisplaySwitch == 2) return;
	gedSwitchLayer(LayerTR);
	Brush.Color = 0;
	gedFillRect(geStateX, geStateY, geStateX+15, geStateY+17);
	Brush.Color = 1;
}


void geDrawFrames() __attribute__((section(".highmem")));
void geDrawFrames()
{
	uint8_t i;
	
	Brush.Color = 1;
	gedSwitchLayer(1);				// switch to layer 1
	
	gedHorizLine(0, 319, 0, 1);		// top border
	gedHorizLine(0, 319, 239, 1);	// bottom border
	gedVertLine(1, 238, 319, 1);	// right border
	gedVertLine(0, 239, 0, 1);		// left border

	gedHorizLine(0, 280, 39, 1);	// under VFO A
	gedVertLine(0, 39, 34, 1);		// left of VFO A 
	gedHorizLine(0, 280, 68, 1);	// under VFO B 
	gedVertLine(39, 68, 104, 1);	// left of VFO B
	
	//  button frames on right
	if (HaveTP || HaveRB) {
		gedVertLine(0, 239, 280, 1);	// Left of right side buttons
		for (i = 1; i < 8; i++) {gedHorizLine(280, 319, 30*i, 1);}
	}
	
	//  NO button frames on right
	if (!HaveTP && !HaveRB) {
		if (!HaveBB) {
			gedVertLine(0, 68, 280, 1);		// Right of VFO's
		} else {
			gedVertLine(0, 239, 280, 1);	// Right side of used display
		}
	}
}


void geDrawButtonFramesLtoR() __attribute__((section(".highmem")));
void geDrawButtonFramesLtoR()
{
	Brush.Color = 1;
	uint8_t i;
	if (HaveTP || HaveBB) {
		gedHorizLine(0, 280, 210, 1);
		for (i = 1; i < 7; i++) {gedVertLine(210, 239, 40*i, 1);}
	}
}  


void geClearButtonFramesLtoR() __attribute__((section(".highmem")));
void geClearButtonFramesLtoR()
{
	Brush.Color = 0;
	gedFillRect(1, 211, 279, 238);
}




// if task == 0 do them all
void geButtonLabelsZtoSRx(uint8_t task, uint8_t highlight) __attribute__((section(".highmem")));
void geButtonLabelsZtoSRx(uint8_t task, uint8_t highlight)
{
	uint8_t b, s,t;

	if (!HaveTP && !HaveRB) return;
	gedSwitchLayer(LayerRx);
	for (b = 0; b < 8; b++)  // z to s
	{
		if (HaveTP) t = RxTouchpadAssignments[b];
		else t = RxButtonAssignments[25 - b];
		if((task==0)||(task==t))
		{
			Brush.Color = 0;
			gedFillRect(281, b*30+1, 318, b*30+29);
			Brush.Color = 1;
			if(highlight)		gedRect(281, b*30+1, 318, b*30+29,1);
			s = buGetTaskLabel(t, StrA, StrB);
			if (s == 0) {
				if (HaveTP) {
					strcpy(StrA, "TP");
					itoa(b+1, StrB, 10);
				} else {
					strcpy(StrA, "button");
					StrB[0] = 25 - b + 0x41;
					StrB[1] = 0;
				}
			}
			gedF8WriteString(StrA, 280 + geLabelOffset(StrA), 30*b + 5);
			gedF8WriteString(StrB, 280 + geLabelOffset(StrB), 30*b + 16);
		}
	}
	gedSwitchLayer(LayerTR);
}




// if task == 0 do them all
void geButtonLabelsZtoSTx(uint8_t task, uint8_t highlight) __attribute__((section(".highmem")));
void geButtonLabelsZtoSTx(uint8_t task, uint8_t highlight)
{
	uint8_t b, s, t;
	if (!HaveTP && !HaveRB) return;
	gedSwitchLayer(LayerTx);
	for (b = 0; b < 8; b++)  // z to s
	{
		if (HaveTP) t = TxTouchpadAssignments[b];
		else t = TxButtonAssignments[25 - b];
		if((task==0)||(task==t))
		{		
			Brush.Color = 0;
			gedFillRect(281, b*30+1, 318, b*30+29);
			Brush.Color = 1;
			if(highlight) gedRect(281, b*30+1, 318, b*30+29,1);
			s = buGetTaskLabel(t, StrA, StrB);
			if (s == 0) {
				if (HaveTP) {
					strcpy(StrA, "TP");
					itoa(b+1, StrB, 10);
				} else {
					strcpy(StrA, "button");
					StrB[0] = 25 - b + 0x41;
					StrB[1] = 0;
				}
			}
			gedF8WriteString(StrA, 280 + geLabelOffset(StrA), 30*b + 5);
			gedF8WriteString(StrB, 280 + geLabelOffset(StrB), 30*b + 16);
		}
	}
	gedSwitchLayer(LayerTR);
}


// if task == 0 do them all
void geButtonLabelsLtoRRx(uint8_t task, uint8_t highlight) __attribute__((section(".highmem")));
void geButtonLabelsLtoRRx(uint8_t task, uint8_t highlight)
{
	uint8_t b, s,t;
	
	if (!HaveTP && !HaveBB) return;
	gedSwitchLayer(LayerRx);
	for (b = 0; b < 7; b++)  // r to l
	{
		if (HaveTP) t = RxTouchpadAssignments[b+8];
		else t = RxButtonAssignments[b+11];
		if((task==0)||(task==t))
		{
			Brush.Color = 0;
			gedFillRect(b*40+1, 211, b*40+39, 238);
			Brush.Color = 1;
			if(highlight) gedRect(b*40+1, 211, b*40+39, 238,1);

			s = buGetTaskLabel(t, StrA, StrB);
			if (s == 0) {
				if (HaveTP) {
					strcpy(StrA, "TP");
					itoa(b+9, StrB, 10);
				} else {
					strcpy(StrA, "button");
				StrB[0] = b + 11 + 0x41;
					StrB[1] = 0;
				}
			}
			gedF8WriteString(StrA, 40*b + geLabelOffset(StrA), 215);
			gedF8WriteString(StrB, 40*b + geLabelOffset(StrB), 226);
		}
	}
	gedSwitchLayer(LayerTR);
}


// if task == 0 do them all
void geButtonLabelsLtoRTx(uint8_t task, uint8_t highlight) __attribute__((section(".highmem")));
void geButtonLabelsLtoRTx(uint8_t task, uint8_t highlight)
{
	uint8_t b, s,t;
	
	if (!HaveTP && !HaveBB) return;
	gedSwitchLayer(LayerTx);
	for (b = 0; b < 7; b++)  // r to l
	{
		if (HaveTP) t = TxTouchpadAssignments[b+8];
		else t = TxButtonAssignments[b+11];
		if((task==0)||(task==t))
		{
			Brush.Color = 0;
			gedFillRect(b*40+1, 211, b*40+39, 238);
			Brush.Color = 1;
			if(highlight)	gedRect(b*40+1, 211, b*40+39, 238,1);
 
			s = buGetTaskLabel(t, StrA, StrB);
			if (s == 0) {
				if (HaveTP) {
					strcpy(StrA, "TP");
					itoa(b+9, StrB, 10);
				} else {
					strcpy(StrA, "button");
				StrB[0] = b + 11 + 0x41;
					StrB[1] = 0;
				}
			}
			gedF8WriteString(StrA, 40*b + geLabelOffset(StrA), 215);
			gedF8WriteString(StrB, 40*b + geLabelOffset(StrB), 226);
		}
	}
	gedSwitchLayer(LayerTR);
}


uint8_t geLabelOffset(char* s) __attribute__((section(".highmem")));
uint8_t geLabelOffset(char* s)
{
	uint8_t i;
	uint8_t w = 0;
	uint8_t a = strlen(s);
	
	if (a == 0) return 0;
	for (i = 0; i < a; i++)
	{
		w += 1 + pgm_read_byte(&lentbl_S[s[i]-32]);
	}
	w -= 1;   // w is now string width in pixels
	return (39-w)/2;  // offset to centre is 39 pixel width button
}


void geFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw) __attribute__((section(".highmem")));
void geFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw)
{
  gedSwitchLayer(2);
	uint8_t w = (widthparam+3)/6;
	uint8_t c  = (centreparam+6)/12;
	if(c > 19){c=19;};
	if(w>40){w=40;};
	uint8_t sk = (40-w)/2;
	uint16_t X = FilterTopX;
	uint16_t Y = FilterTopY;
  Brush.Color=0;
	gedFillRect(X,Y+18,X+41,Y+53);
	Brush.Color=1;
	if(Mode==1)
	{
	  gedVertLine(Y+50,Y+53,X+20-c,1);
	}
	else
	{
		gedVertLine(Y+50,Y+53,X+21+c,1);
	};
	gedHorizLine(X,X+sk,Y+48,1);
  gedHorizLine(X+40-sk,X+40,Y+48,1);
	gedHorizLine(X+sk,X+40-sk,Y+18,1);
	gedVertLine(Y+18,Y+48,X+sk,1);
	gedVertLine(Y+18,Y+48,X+40-sk,1);
  if(sw==1)
	{strcpy(StrB,PMS(s_Narrow));}
	else
	{strcpy(StrB,PMS(s_Wide));}; 
	Brush.Color=0;
	gedFillRect(X,Y,X+41,Y+7);
	gedF8CentreWriteString(StrB,X,Y,40);
	gedFillRect(X,Y+9,X+41,Y+16);
	gedF8CentreWriteString(swid,X,Y+9,40);
  gedSwitchLayer(1);


}




void geFilterCW(char* swid, uint8_t widthparam, 
									uint8_t centreparam, uint8_t depthparam, uint8_t sw) __attribute__((section(".highmem")));
void geFilterCW(char * swid, uint8_t widthparam, 
                  uint8_t centreparam, uint8_t depthparam, uint8_t sw)
{
	gedSwitchLayer(2);
	uint8_t w = (widthparam+3)/6;
	uint8_t c  = (centreparam+6)/12;
	if(c > 19){c=19;};
	if(w<2){w=2;};
	uint8_t d;
	if(sw==1){d=depthparam*3;}else{d=0;}; 
	uint8_t sk = (40-w)/2;
	uint16_t X = FilterTopX;
	uint16_t Y = FilterTopY;
  Brush.Color=0;
	gedFillRect(X,Y+18,X+40,Y+53);
	Brush.Color=1;
	if(Mode==3)
	{
	  gedVertLine(Y+50,Y+53,X+20-c,1);
	}
	else
	{
		gedVertLine(Y+50,Y+53,X+21+c,1);
	};
	gedHorizLine(X,X+sk,Y+48,1);   // L skirt
  gedHorizLine(X+40-sk,X+40,Y+48,1);   // R skirt
  gedHorizLine(X+sk,X+19,Y+48-30+d,1);	// L shoulder
  gedHorizLine(X+21,X+40-sk,Y+48-30+d,1);	//R shoulder
	gedHorizLine(X+19,X+21,Y+18,1);      // top

	gedVertLine(Y+18,Y+48-30+d,X+19,1);
	gedVertLine(Y+18,Y+48-30+d,X+21,1);

	gedVertLine(Y+48-30+d,Y+48,X+sk,1);
	gedVertLine(Y+48-30+d,Y+48,X+40-sk,1);

  if(sw==1)
	{strcpy(StrB,PMS(s_6162));}
	else
	{strcpy(StrB,PMS(s_Context));}; 
	Brush.Color=0;
	gedFillRect(X,Y,X+41,Y+7);
	gedF8CentreWriteString(StrB,X,Y,40);
	gedFillRect(X,Y+9,X+41,Y+16);
	gedF8CentreWriteString(swid,X,Y+9,40);
	gedSwitchLayer(1);
}


///////////////////////////////////////////////////////
/////////Display Toggle////////////////




void geDisplayBottomBox() __attribute__((section(".highmem")));
void geDisplayBottomBox()
{
	gedSwitchLayer(LayerRx);
	geClearButtonFramesLtoR();
	gedSwitchLayer(LayerTx);
	geClearButtonFramesLtoR();
	gedSwitchLayer(LayerTR);
	geClearButtonFramesLtoR();
}


void geDisplayBottomButtons() __attribute__((section(".highmem")));
void geDisplayBottomButtons()
{
	gedSwitchLayer(LayerTR);
	geDrawButtonFramesLtoR();
	gedSwitchLayer(LayerRx);
	geClearButtonFramesLtoR();
	geButtonLabelsLtoRRx(0,0);
	gedSwitchLayer(LayerTx);
	geClearButtonFramesLtoR();
	geButtonLabelsLtoRTx(0,0);
	gedSwitchLayer(LayerTR);
}


void geDoDisplayKey() __attribute__((section(".highmem")));
void geDoDisplayKey()
{
	switch(DisplaySwitch)
	{
		case 0: 
		{
			geClearWin();
			gedSwitchLayer(LayerRx);
			if(Transmit==0){smStartSmeter();};
			gedSwitchLayer(LayerTR);
			zscShowSwitches();
			zscShowFilter();
			zscDisplayIP3NF();
			zscShowMode();
			zscDisplayParamColour(ParamColour);
			if (HaveTP || HaveBB)
			{geDisplayBottomButtons();}
			else
			{geDisplayBottomBox();}
			break;
		}
		case 1:
		{
			geDisplayBottomBox();
			gedSwitchLayer(LayerTR);
			break;
		}		  
		case 2: geStartDSPdisplay(); break; 
	}
	gedSwitchLayer(LayerTx);
	swInitSWR();
	gedSwitchLayer(LayerTR);
}



void geStartDSPdisplay() __attribute__((section(".highmem")));
void geStartDSPdisplay()
{
	geClearWin();
	geDspGraphicsInit();
	zscShowSwitches();  // redraw with RF atten which no longer fits
	gedSwitchLayer(LayerRx);
	if(Transmit==0){smStartSmeter();};
	gedSwitchLayer(LayerTx);
	if(Transmit==1){swInitSWR();};
	gedSwitchLayer(LayerTR);
	HaltDSPdisplay = 0;
}


/////////////////////////////////////////////////////////////
//////////////   DSP display //////////////////////////////

void geRxDSPtext() __attribute__((section(".highmem")));
void geRxDSPtext()
{
	uint8_t i;
	for(i=0;i<=7;i++)
	{
		gedF8WriteString(PMS(pmdRxBarList[i]),WinX+2,2+BarsY+11*i);
	}
}


void geTxDSPtext() __attribute__((section(".highmem")));
void geTxDSPtext()
{
	uint8_t i;
	for(i=0;i<=7;i++)
	{
		gedF8WriteString(PMS(pmdTxBarList[i]),WinX+2,2+BarsY+11*i);
	}
}


void geTrDSPtext() __attribute__((section(".highmem")));
void geTrDSPtext()
{
	gedF8WriteString(PMS(s_Test_point),WinX+2,BarsY-10);
	gedF8WriteString(PMS(s_dB),WinX+69,BarsY-10);
	gedF8WriteString(PMS(s_Min),243,BarsY-10);
	gedF8WriteString(PMS(s_Max),263,BarsY-10);
	StrA[1] = '0';
	StrA[2] = 0;
	uint8_t i;
	for(i=1;i<=4;i++)
	{
		StrA[0] = 2*i + 0x30;
		gedF8WriteString(StrA,WinX+79+32*i,BarsY-10);
	}
	StrA[0] = '0';
	StrA[1] = 0;
	gedF8WriteString(StrA,WinX+86,BarsY-10);
}



void geDspGraphicsInit() __attribute__((section(".highmem")));
void geDspGraphicsInit()
{	
	uint8_t i, j, Yi, Xj;
	BarsY = WinY + WinHeight - 8*11;
	dspInitGraphicsEA320();
	Brush.Color=1;
	gedSwitchLayer(LayerTR);
	for(i=0;i<=7;i++)
	{
		Yi = BarsY+11*i;
		gedHorizLine(WinX,WinX+WinWidth-1,Yi,1);
		for(j=1;j<=9;j++)
		{
		  Xj = 84 + j*16;
			gedVertLine(Yi,Yi+1,Xj,1);
			gedVertLine(Yi+10,Yi+11,Xj,1);
		}				 
	}
	gedHorizLine(WinX,WinX+WinWidth-1,BarsY-13,1);
	gedVertLine(WinY, WinY+WinHeight-1, WinX+WinWidth, 1);
	gedVertLine(BarsY-13,WinY+WinHeight-1,66,1);
	gedVertLine(BarsY-13,WinY+WinHeight-1,84,1);
	gedVertLine(BarsY-13,WinY+WinHeight-1,260,1);
	gedVertLine(BarsY-13,WinY+WinHeight-1,240,1);

	gedVertLine(69,BarsY-14,68,1);
	
	geTrDSPtext();

	gedSwitchLayer(LayerRx);
	gedHorizLine(72,261,113,1);  // gain bar
	for(i=0;i<=12;i++)
	{
	  gedVertLine(113-2,113,72+15*i,1);
	}
	geRxDSPtext();
	
	gedSwitchLayer(LayerTx);
	geTxDSPtext();

	gedSwitchLayer(LayerTR);


}
