/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taGlobal.c    program file
 
Globally available variables and functions 
 
(String handling buffers take up alot of RAM 
   - define one set for everone to use
	 - CARE in interrupt service routines
	  ... and routine called by interrupt service routinea
		....ok if interrupts disabled!!! )

*/

#include "taGlobal.h"
#include "taMsg.h"
#include "taProgmem.h"
#include <util/delay.h>

uint8_t TftaI2Caddress;
struct HardwareSettingsType HardwareSettings;
uint8_t timer3test;
uint8_t timer4test;
char DiagMode;
uint8_t zc;            // zc == 1 - means write to char lcd
uint8_t zs;            // zs == 1 - means write to 128x64 graphics display
uint8_t zg;            // zg == 1 - means write to 320x240 graphics display
uint8_t zt;            // zt == 1 - means write to colour TFT display on I2C bus
uint8_t TwentyByFour;  // 0 = 40x2    1 = 20x4    For char LCD
uint8_t EA320_6800;    // 0 = 8080    1 = 6800    For 320x240 display
uint8_t DualDisplay;   // 0 = no multiple display    1 = multiple display
uint8_t HaveTP;        // 1 = 320x240 touch panel installed
uint8_t HaveRB;        // 1 = 320x240 8 right side buttons installed
uint8_t HaveBB;        // 1 = 320x240 7 bottom buttons installed
uint8_t DoMeterCode;   // 1 = display supports scMeterLoopCode()
uint8_t ksCSLOW;       // 1 = CS active low for 128x64 display
uint8_t ymax;          // rows 5 to 7
uint8_t xmax;          // columns 1 to 8
uint16_t CounterA;  
uint16_t CounterB;
char StrA[90];
char StrB[80]; 
char StrC[80]; 
char StrD[32];
uint8_t I2Cbuf[258];
uint32_t MonitorA;
uint32_t MonitorB;
uint32_t MonitorC;
uint32_t MonitorH;
uint8_t TestIndex;
char ButtonRT;
uint8_t VisibleCount;
int HighlightedPos;
uint8_t SpaceWidth;
uint16_t X1scroll, Y1scroll, XXscroll, YYscroll;
uint8_t ScrollItemCount;
uint8_t PrevSwCW;
uint8_t PrevSwSSB;
uint8_t PrevMode;
uint8_t MenuExit;


// pad string with trailing spaces
char* gbTrailingSpaces(char* s, uint8_t width)
{
	uint8_t spcs = width - strlen(s);
	if (spcs > 0) strcat(s, pmdSpaces(spcs));
	return s;
}


char* gbLeadingSpaces(char* s, uint8_t width)
{
	char u[20];
	char* p = u; 
	uint8_t spcs = width - strlen(s);
	if (spcs > 0) {
		strcpy(p,pmdSpaces(spcs));
		s = strcat(p,s);
	}
  return s;
}
