//  TrxAVR taFont8.c

//  IJS  - change BYTE to uint8_t


#include "taGlobal.h"
#include "taFont8.h"


static const uint8_t chr20[3] PROGMEM = { 0x00, 0x00, 0x00 };
static const uint8_t chr21[3] PROGMEM = { 0x00, 0x5F, 0x00 };
static const uint8_t chr22[3] PROGMEM = { 0x07, 0x00, 0x07 };
static const uint8_t chr23[5] PROGMEM = { 0x14, 0x7F, 0x14, 0x7F, 0x14 };
static const uint8_t chr24[5] PROGMEM = { 0x26, 0x49, 0x7F, 0x49, 0x32 };
static const uint8_t chr25[5] PROGMEM = { 0x63, 0x13, 0x08, 0x64, 0x63 };
static const uint8_t chr26[5] PROGMEM = { 0x36, 0x49, 0x00, 0x22, 0x50 };
static const uint8_t chr27[3] PROGMEM = { 0x04, 0x03, 0x00 };
static const uint8_t chr28[3] PROGMEM = { 0x1C, 0x22, 0x41 };
static const uint8_t chr29[3] PROGMEM = { 0x41, 0x22, 0x1C };
static const uint8_t chr2A[5] PROGMEM = { 0x14, 0x2A, 0x1C, 0x2A, 0x14 };
static const uint8_t chr2B[5] PROGMEM = { 0x08, 0x08, 0x3E, 0x08, 0x08 };
static const uint8_t chr2C[2] PROGMEM = { 0x80, 0x60 };
static const uint8_t chr2D[5] PROGMEM = { 0x08, 0x08, 0x08, 0x08, 0x08 };
static const uint8_t chr2E[1] PROGMEM = { 0x40 };
static const uint8_t chr2F[5] PROGMEM = { 0x60, 0x10, 0x08, 0x04, 0x03 };
static const uint8_t chr30[5] PROGMEM = { 0x3E, 0x51, 0x49, 0x45, 0x3E };
static const uint8_t chr31[5] PROGMEM = { 0x00, 0x42, 0x7F, 0x40, 0x00 };
static const uint8_t chr32[5] PROGMEM = { 0x62, 0x51, 0x49, 0x49, 0x46 };
static const uint8_t chr33[5] PROGMEM = { 0x22, 0x41, 0x49, 0x49, 0x36 };
static const uint8_t chr34[5] PROGMEM = { 0x18, 0x14, 0x12, 0x7F, 0x10 };
static const uint8_t chr35[5] PROGMEM = { 0x27, 0x49, 0x49, 0x49, 0x31 };
static const uint8_t chr36[5] PROGMEM = { 0x3C, 0x4A, 0x49, 0x49, 0x30 };
static const uint8_t chr37[5] PROGMEM = { 0x01, 0x71, 0x09, 0x05, 0x03 };
static const uint8_t chr38[5] PROGMEM = { 0x36, 0x49, 0x49, 0x49, 0x36 };
static const uint8_t chr39[5] PROGMEM = { 0x06, 0x49, 0x49, 0x29, 0x1E };
static const uint8_t chr3A[1] PROGMEM = { 0x14 };
static const uint8_t chr3B[2] PROGMEM = { 0x80, 0x68 };
static const uint8_t chr3C[4] PROGMEM = { 0x08, 0x14, 0x22, 0x41 };
static const uint8_t chr3D[4] PROGMEM = { 0x14, 0x14, 0x14, 0x14 };
static const uint8_t chr3E[4] PROGMEM = { 0x41, 0x22, 0x14, 0x08 };
static const uint8_t chr3F[5] PROGMEM = { 0x02, 0x01, 0x51, 0x09, 0x06 };
static const uint8_t chr40[5] PROGMEM = { 0x3E, 0x41, 0x5D, 0x00, 0x4E };
static const uint8_t chr41[5] PROGMEM = { 0x7C, 0x12, 0x11, 0x12, 0x7C };
static const uint8_t chr42[5] PROGMEM = { 0x7F, 0x49, 0x49, 0x49, 0x36 };
static const uint8_t chr43[5] PROGMEM = { 0x3E, 0x41, 0x41, 0x41, 0x22 };
static const uint8_t chr44[5] PROGMEM = { 0x7F, 0x41, 0x41, 0x22, 0x1C };
static const uint8_t chr45[5] PROGMEM = { 0x7F, 0x49, 0x49, 0x49, 0x41 };
static const uint8_t chr46[5] PROGMEM = { 0x7F, 0x09, 0x09, 0x09, 0x01 };
static const uint8_t chr47[5] PROGMEM = { 0x3E, 0x41, 0x49, 0x29, 0x72 };
static const uint8_t chr48[5] PROGMEM = { 0x7F, 0x08, 0x08, 0x08, 0x7F };
static const uint8_t chr49[3] PROGMEM = { 0x41, 0x7F, 0x41 };
static const uint8_t chr4A[5] PROGMEM = { 0x20, 0x40, 0x41, 0x3F, 0x01 };
static const uint8_t chr4B[5] PROGMEM = { 0x7F, 0x08, 0x14, 0x22, 0x41 };
static const uint8_t chr4C[4] PROGMEM = { 0x7F, 0x40, 0x40, 0x40 };
static const uint8_t chr4D[5] PROGMEM = { 0x7F, 0x02, 0x0C, 0x02, 0x7F };
static const uint8_t chr4E[5] PROGMEM = { 0x7F, 0x06, 0x08, 0x30, 0x7F };
static const uint8_t chr4F[5] PROGMEM = { 0x3E, 0x41, 0x41, 0x41, 0x3E };
static const uint8_t chr50[5] PROGMEM = { 0x7F, 0x09, 0x09, 0x09, 0x06 };
static const uint8_t chr51[5] PROGMEM = { 0x3E, 0x41, 0x51, 0x21, 0x5E };
static const uint8_t chr52[5] PROGMEM = { 0x7F, 0x09, 0x19, 0x29, 0x46 };
static const uint8_t chr53[5] PROGMEM = { 0x26, 0x49, 0x49, 0x49, 0x32 };
static const uint8_t chr54[5] PROGMEM = { 0x01, 0x01, 0x7F, 0x01, 0x01 };
static const uint8_t chr55[5] PROGMEM = { 0x3F, 0x40, 0x40, 0x40, 0x3F };
static const uint8_t chr56[5] PROGMEM = { 0x0F, 0x30, 0x40, 0x30, 0x0F };
static const uint8_t chr57[7] PROGMEM = { 0x0F, 0x30, 0x40, 0x38, 0x40, 0x30, 0x0F };
static const uint8_t chr58[5] PROGMEM = { 0x63, 0x14, 0x08, 0x14, 0x63 };
static const uint8_t chr59[5] PROGMEM = { 0x07, 0x08, 0x70, 0x08, 0x07 };
static const uint8_t chr5A[5] PROGMEM = { 0x61, 0x51, 0x49, 0x45, 0x43 };
static const uint8_t chr5B[3] PROGMEM = { 0x7F, 0x41, 0x41 };
static const uint8_t chr5C[5] PROGMEM = { 0x03, 0x04, 0x08, 0x10, 0x60 };
static const uint8_t chr5D[3] PROGMEM = { 0x41, 0x41, 0x7F };
static const uint8_t chr5E[5] PROGMEM = { 0x08, 0x04, 0x02, 0x04, 0x08 };
static const uint8_t chr5F[5] PROGMEM = { 0x40, 0x40, 0x40, 0x40, 0x40 };
static const uint8_t chr60[3] PROGMEM = { 0x03, 0x04, 0x00 };
static const uint8_t chr61[4] PROGMEM = { 0x20, 0x54, 0x54, 0x78 };
static const uint8_t chr62[5] PROGMEM = { 0x7F, 0x28, 0x44, 0x44, 0x38 };
static const uint8_t chr63[4] PROGMEM = { 0x38, 0x44, 0x44, 0x28 };
static const uint8_t chr64[5] PROGMEM = { 0x38, 0x44, 0x44, 0x28, 0x7F };
static const uint8_t chr65[4] PROGMEM = { 0x38, 0x54, 0x54, 0x48 };
static const uint8_t chr66[4] PROGMEM = { 0x08, 0x7E, 0x09, 0x02 };
static const uint8_t chr67[4] PROGMEM = { 0x98, 0xA4, 0xA4, 0x58 };
static const uint8_t chr68[5] PROGMEM = { 0x7F, 0x08, 0x04, 0x04, 0x78 };
static const uint8_t chr69[2] PROGMEM = { 0x3D, 0x40 };
static const uint8_t chr6A[3] PROGMEM = { 0x80, 0x84, 0x7D };
static const uint8_t chr6B[4] PROGMEM = { 0x7F, 0x10, 0x28, 0x44 };
static const uint8_t chr6C[3] PROGMEM = { 0x01, 0x7F, 0x00 };
static const uint8_t chr6D[6] PROGMEM = { 0x7C, 0x08, 0x04, 0x78, 0x04, 0x78 };
static const uint8_t chr6E[5] PROGMEM = { 0x7C, 0x08, 0x04, 0x04, 0x78 };
static const uint8_t chr6F[4] PROGMEM = { 0x38, 0x44, 0x44, 0x38 };
static const uint8_t chr70[5] PROGMEM = { 0xFC, 0x18, 0x24, 0x24, 0x18 };
static const uint8_t chr71[5] PROGMEM = { 0x18, 0x24, 0x24, 0x18, 0xFC };
static const uint8_t chr72[5] PROGMEM = { 0x7C, 0x08, 0x04, 0x04, 0x08 };
static const uint8_t chr73[4] PROGMEM = { 0x48, 0x54, 0x54, 0x24 };
static const uint8_t chr74[3] PROGMEM = { 0x04, 0x3E, 0x44 };
static const uint8_t chr75[5] PROGMEM = { 0x3C, 0x40, 0x40, 0x20, 0x7C };
static const uint8_t chr76[5] PROGMEM = { 0x1C, 0x20, 0x40, 0x20, 0x1C };
static const uint8_t chr77[5] PROGMEM = { 0x3C, 0x40, 0x30, 0x40, 0x3C };
static const uint8_t chr78[5] PROGMEM = { 0x44, 0x28, 0x10, 0x28, 0x44 };
static const uint8_t chr79[4] PROGMEM = { 0x1C, 0xA0, 0xA0, 0x7C };
static const uint8_t chr7A[4] PROGMEM = { 0x64, 0x54, 0x54, 0x4C };
static const uint8_t chr7B[3] PROGMEM = { 0x08, 0x36, 0x41 };
static const uint8_t chr7C[3] PROGMEM = { 0x00, 0x7F, 0x00 };
static const uint8_t chr7D[3] PROGMEM = { 0x41, 0x36, 0x08 };
static const uint8_t chr7E[2] PROGMEM = { 0x00, 0x00 };
static const uint8_t chr7F[1] PROGMEM = { 0x00 };           //  IJS  - modify to array
static const uint8_t chr80[7] PROGMEM = { 0x1C, 0x22, 0x41, 0x4F, 0x41, 0x22, 0x1C };
static const uint8_t chr81[7] PROGMEM = { 0x1C, 0x22, 0x41, 0x49, 0x45, 0x22, 0x1C };
static const uint8_t chr82[7] PROGMEM = { 0x1C, 0x22, 0x41, 0x49, 0x49, 0x2A, 0x1C };
static const uint8_t chr83[7] PROGMEM = { 0x1C, 0x22, 0x41, 0x49, 0x51, 0x22, 0x1C };
static const uint8_t chr84[7] PROGMEM = { 0x1C, 0x22, 0x41, 0x79, 0x41, 0x22, 0x1C };
static const uint8_t chr85[7] PROGMEM = { 0x1C, 0x22, 0x51, 0x49, 0x41, 0x22, 0x1C };
static const uint8_t chr86[7] PROGMEM = { 0x1C, 0x2A, 0x49, 0x49, 0x41, 0x22, 0x1C };
static const uint8_t chr87[7] PROGMEM = { 0x1C, 0x22, 0x45, 0x49, 0x41, 0x22, 0x1C };
// bold numerics etc for VFO B
static const uint8_t chr88[5] PROGMEM = { 0x7E, 0xFF, 0x81, 0xFF, 0x7E };      // 0
static const uint8_t chr89[5] PROGMEM = { 0x0C, 0x06, 0xFF, 0xFF, 0x00 };      // 1
static const uint8_t chr8A[5] PROGMEM = { 0xC2, 0xE3, 0xB1, 0x9F, 0x8E };      // 2
static const uint8_t chr8B[5] PROGMEM = { 0x42, 0xC3, 0x89, 0xFF, 0x76 };      // 3
static const uint8_t chr8C[5] PROGMEM = { 0x30, 0x2C, 0x22, 0xFF, 0xFF };      // 4
static const uint8_t chr8D[5] PROGMEM = { 0x5C, 0xCF, 0x8B, 0xF9, 0x71 };      // 5
static const uint8_t chr8E[5] PROGMEM = { 0x7E, 0xFF, 0x89, 0xFB, 0x72 };      // 6
static const uint8_t chr8F[5] PROGMEM = { 0x01, 0xF1, 0xFD, 0x0F, 0x03 };      // 7
static const uint8_t chr90[5] PROGMEM = { 0x76, 0xFF, 0x89, 0xFF, 0x76 };      // 8
static const uint8_t chr91[5] PROGMEM = { 0x4E, 0xDF, 0x91, 0xFF, 0x7E };      // 9
static const uint8_t chr92[5] PROGMEM = { 0x10, 0x10, 0x7C, 0x10, 0x10 };      // +  
static const uint8_t chr93[5] PROGMEM = { 0x10, 0x10, 0x10, 0x10, 0x00 };      // - 
static const uint8_t chr94[5] PROGMEM = { 0xC0, 0xC0, 0x00, 0x00, 0x00 };      // .
static const uint8_t chr95[7] PROGMEM = { 0xE0, 0xFC, 0x3F, 0x23, 0x3F, 0xFC, 0xE0 };  // A
static const uint8_t chr96[6] PROGMEM = { 0xFF, 0xFF, 0x89, 0x89, 0xFF, 0x76 };        // B
static const uint8_t chr97[7] PROGMEM = { 0xFF, 0xFF, 0x11, 0x31, 0x7F, 0xCE, 0x80 };  // R
static const uint8_t chr98[6] PROGMEM = { 0x03, 0x03, 0xFF, 0xFF, 0x03, 0x03 };        // T
static const uint8_t chr99[7] PROGMEM = { 0x3C, 0x7E, 0xC3, 0x81, 0x91, 0xF3, 0x38 };  // G
static const uint8_t chr9A[5] PROGMEM = { 0x00, 0x00, 0x00, 0x00, 0x00 };              // digit space
// 5x3 numerics
static const uint8_t chrA0[3] PROGMEM = { 0x1F, 0x11, 0x1F }; // 0
static const uint8_t chrA1[2] PROGMEM = { 0x00, 0x1F };       // 1
static const uint8_t chrA2[3] PROGMEM = { 0x19, 0x15, 0x17 }; // 2
static const uint8_t chrA3[3] PROGMEM = { 0x11, 0x15, 0x0E }; // 3
static const uint8_t chrA4[3] PROGMEM = { 0x0F, 0x08, 0x1C }; // 4
static const uint8_t chrA5[3] PROGMEM = { 0x17, 0x15, 0x09 }; // 5
static const uint8_t chrA6[3] PROGMEM = { 0x1F, 0x15, 0x1D }; // 6
static const uint8_t chrA7[3] PROGMEM = { 0x11, 0x09, 0x07 }; // 7
static const uint8_t chrA8[3] PROGMEM = { 0x1F, 0x15, 0x1F }; // 8
static const uint8_t chrA9[3] PROGMEM = { 0x17, 0x15, 0x0F }; // 9
static const uint8_t chrAA[3] PROGMEM = { 0x1F, 0x08, 0x14 }; // k
static const uint8_t chrAB[1] PROGMEM = { 0x10 };             // .
static const uint8_t chrAC[1] PROGMEM = { 0x14 };             // :
static const uint8_t chrAD[1] PROGMEM = { 0x00};       // SPACE


static const uint8_t chrC1[3] PROGMEM = { 0x1E, 0x09, 0x1E };              // A
static const uint8_t chrC2[3] PROGMEM = { 0x1F, 0x15, 0x0A };              // B
static const uint8_t chrC3[3] PROGMEM = { 0x0E, 0x11, 0x0A };              // C
static const uint8_t chrC4[3] PROGMEM = { 0x1F, 0x11, 0x0E };              // D
static const uint8_t chrC5[3] PROGMEM = { 0x1F, 0x15, 0x15 };              // E
static const uint8_t chrC6[3] PROGMEM = { 0x1F, 0x05, 0x05 };              // F
static const uint8_t chrC7[4] PROGMEM = { 0x0E, 0x11, 0x15, 0x1D};               // G
static const uint8_t chrC8[3] PROGMEM = { 0x1F, 0x04, 0x1F };              // H
static const uint8_t chrC9[3] PROGMEM = { 0x11, 0x1F, 0x11 };              // I
static const uint8_t chrCA[3] PROGMEM = { 0x08, 0x10, 0x0F };              // J
static const uint8_t chrCB[3] PROGMEM = { 0x1F, 0x04, 0x1B };              // K
static const uint8_t chrCC[3] PROGMEM = { 0x1F, 0x10, 0x10 };              // L
static const uint8_t chrCD[5] PROGMEM = { 0x1F, 0x02, 0x04, 0x02, 0x1F };  // M
static const uint8_t chrCE[4] PROGMEM = { 0x1F, 0x06, 0x0C, 0x1F };        // N
static const uint8_t chrCF[3] PROGMEM = { 0x0E, 0x11, 0x0E };              // O
static const uint8_t chrD0[3] PROGMEM = { 0x1F, 0x05, 0x02 };              // P
static const uint8_t chrD1[3] PROGMEM = { 0x0E, 0x11, 0x1E };              // Q
static const uint8_t chrD2[3] PROGMEM = { 0x1F, 0x05, 0x1A };              // R
static const uint8_t chrD3[3] PROGMEM = { 0x12, 0x15, 0x09 };              // S
static const uint8_t chrD4[3] PROGMEM = { 0x01, 0x1F, 0x01 };              // T
static const uint8_t chrD5[3] PROGMEM = { 0x1F, 0x10, 0x1F };              // U
static const uint8_t chrD6[3] PROGMEM = { 0x07, 0x18, 0x07 };              // V
static const uint8_t chrD7[5] PROGMEM = { 0x0F, 0x10, 0x0C, 0x10, 0x0F };  // W
static const uint8_t chrD8[3] PROGMEM = { 0x1B, 0x04, 0x1B };              // X
static const uint8_t chrD9[3] PROGMEM = { 0x03, 0x1C, 0x03 };              // Y
static const uint8_t chrDA[3] PROGMEM = { 0x19, 0x15, 0x13 };              // Z





const uint8_t lentbl_S[163] PROGMEM = {
	3, 3, 3, 5, 5, 5, 5, 3, 3, 
	3, 5, 5, 2, 5, 1, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 1, 
	2, 4, 4, 4, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 3, 5, 5, 4, 
	5, 5, 5, 5, 5, 5, 5, 5, 5, 
	5, 7, 5, 5, 5, 3, 5, 3, 5, 
	5, 3, 4, 5, 4, 5, 4, 4, 4, 
	5, 2, 3, 4, 3, 6, 5, 4, 5, 
	5, 5, 4, 3, 5, 5, 5, 5, 4, 
	4, 3, 3, 3, 2, 0, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 2,
	7, 6, 7, 6, 7, 5, 3, 2, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 1,
	1, 1, 3, 3, 3, 3, 3, 3, 4, 
	3, 3, 3, 3, 3, 5, 4, 3, 3,
	3, 3, 3, 3, 3, 3, 5, 3, 3, 
	3
};

const uint8_t *  const chrtbl_S[163] PROGMEM = {
	chr20, chr21, chr22, chr23, chr24, chr25, chr26,   // 0
	chr27, chr28, chr29, chr2A, chr2B, chr2C, chr2D,   // 7
	chr2E, chr2F, chr30, chr31, chr32, chr33, chr34,   // 14
	chr35, chr36, chr37, chr38, chr39, chr3A, chr3B,   // 21
	chr3C, chr3D, chr3E, chr3F, chr40, chr41, chr42,   // 28
	chr43, chr44, chr45, chr46, chr47, chr48, chr49,   // 35
	chr4A, chr4B, chr4C, chr4D, chr4E, chr4F, chr50,   // 42 
	chr51, chr52, chr53, chr54, chr55, chr56, chr57,   // 49
	chr58, chr59, chr5A, chr5B, chr5C, chr5D, chr5E,   // 56
	chr5F, chr60, chr61, chr62, chr63, chr64, chr65,   // 63
	chr66, chr67, chr68, chr69, chr6A, chr6B, chr6C,   // 70
	chr6D, chr6E, chr6F, chr70, chr71, chr72, chr73,   // 77
	chr74, chr75, chr76, chr77, chr78, chr79, chr7A,   // 84 
	chr7B, chr7C, chr7D, chr7E, chr7F, chr80, chr81,   // 91
	chr82, chr83, chr84, chr85, chr86, chr87, chr88,   // 98
	chr89, chr8A, chr8B, chr8C, chr8D, chr8E, chr8F,   // 105
	chr90, chr91, chr92, chr93, chr94, chr95, chr96,   // 112
	chr97, chr98, chr99, chr9A, chrA0, chrA1, chrA2,   // 119
	chrA3, chrA4, chrA5, chrA6, chrA7, chrA8, chrA9,   // 126
	chrAA, chrAB, chrAC, chrAD, chrC1, chrC2, chrC3,   // 133
	chrC4, chrC5, chrC6, chrC7, chrC8, chrC9, chrCA,   // 140
	chrCB, chrCC, chrCD, chrCE, chrCF, chrD0, chrD1,   // 147
	chrD2, chrD3, chrD4, chrD5, chrD6, chrD7, chrD8,   // 154
	chrD9, chrDA                                       // 161
};
							

char f8Map5x3(char ch);


// the write routine subtracts 32 from the ascii value - so must pre-add 32 here							
char f8Map5x3(char ch)
{
  if(ch == 'k') return 165; 
	if((ch >= 0x30) && (ch <= 0x39)) return(ch + 107);  // numerics (chrA0 - chrA9) = (123 - 132)  
	if((ch >= 0x61) && (ch <= 0x7A)) return(ch + 72);  // lower case to upper case (chrC1 - chrDA) = (137 - 162)
	if((ch >= 0x41) && (ch <= 0x5A)) return(ch + 104);  // upper case to upper case (chrC1 - chrDA) = (137 - 162)
  switch(ch)
	{
		case '.': ch = 166; break;
		case ':': ch = 167; break;
		case ' ': ch = 168;  break;
	}
  return ch;
}
												 
