/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFTdriver.c    program file

 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display driver module

*/

#include "taGlobal.h"
#include "taTWI.h"
#include "taEATFTdriver.h"
#include "taStarControl.h"
#include "taProgmem.h"

#define DC1 0x11
#define DC2 0x12
#define ACK 6

#define ETMAXTRIES 50

uint8_t SbufReady;
static uint8_t RbufFree;

uint8_t etdGetBufferInfo();
uint8_t etdRequestCommand(char comchar);
void etdWordsToBuf(uint16_t* ram, uint8_t n);
void etdBufToWords(uint16_t* ram, uint8_t n);


uint8_t etdSendPackage(char* cs)
{
	char ch;
	uint8_t t, i, nc, chk;

	t = 0;	// try number
	chk = DC1;
	nc = strlen(cs);
	I2Cbuf[0] = DC1;
	I2Cbuf[1] = nc;
	chk += nc;

	for (i = 0; i < nc; i++) {
		I2Cbuf[i+2] = cs[i];
		chk += cs[i];
	}
	I2Cbuf[nc+2] = chk; // modulo 256 checksum;
	do {
		etdBlockWrite(nc+3);
		ch = 0;
		etdReadByte(&ch);
	} while ( (ch != ACK) && (t++ < ETMAXTRIES) );
	if (ch == ACK) return 1; else return 0;
}


uint8_t etdSendPackageNC(uint8_t* pbuf, uint8_t nc)
{
	char ch;
	uint8_t t, i, chk;

	t = 0;	// try number
	chk = DC1;
	I2Cbuf[0] = DC1;
	I2Cbuf[1] = nc;
	chk += nc;
	for (i = 0; i < nc; i++) {
		I2Cbuf[i+2] = pbuf[i];
		chk += pbuf[i];
	}
	I2Cbuf[nc+2] = chk ;	// modulo 256 checksum;
	do {
		etdBlockWrite(nc+3);
		ch = 0;
		etdReadByte(&ch);
	} while ( (ch != ACK) && (t++ < ETMAXTRIES) );
	if (ch == ACK) return 1; else return 0;
}


uint8_t etdReceivePackage(char* cs)
{
	char ch;
	uint8_t t, i, nc, bcc, chk;

	t = 0;	// try number
	if (etdRequestCommand('S') == 0) return 0;
	do {
		if (t != 0) {
			if (etdRequestCommand('R') == 0) return 0;
		}
		if (etdReadByte(&ch) == 0) return 0;
		if (ch != DC1) return 0;
		if (etdReadByte((char*)&nc) == 0) return 0;
		if (etdBlockRead(nc) == 0) return 0;
		if (etdReadByte((char*)&bcc) == 0) return 0;
		chk = DC1 + nc;
		for (i = 0; i < nc; i++) {
			cs[i] = I2Cbuf[i];
			chk += cs[i];
		}
		cs[nc] = 0;
	} while ( (bcc != chk) && (t++ < ETMAXTRIES) );
	if (bcc == chk) return 1; else return 0;
}


uint8_t etdGetBufferInfo()  // unused
{
	uint8_t t, chk;

	t = 0;	// try number
	if (etdRequestCommand('I') == 0) return 0;
	do {
		if (t != 0)
		{
			if (etdRequestCommand('R') == 0) return 0;
		}
		etdBlockRead(5);
		if (I2Cbuf[0] != DC2) return 0;
		if (I2Cbuf[1] != 2) return 0;
		SbufReady = I2Cbuf[2];
		RbufFree = I2Cbuf[3];
		chk = DC2 + 2 + SbufReady + RbufFree;
	} while ( (I2Cbuf[4] != chk) && (t++ < ETMAXTRIES) );
	if (I2Cbuf[4] == chk) return 1; else return 0;
}


uint8_t etdRequestCommand(char comchar)
{
	char ch;
	uint8_t t, chk;
	
	t = 0;	// try number
	I2Cbuf[0] = DC2;
	I2Cbuf[1] = 1;
	I2Cbuf[2] = comchar;
	chk = DC2 + 1 + comchar;
	I2Cbuf[3] = chk;
	do {
		etdBlockWrite(4);
		ch = 0;
		etdReadByte(&ch);
	} while ( (ch != ACK) && (t++ < ETMAXTRIES) );
	if (ch == ACK) return 1; else return 0;
}


void etdWordsToBuf(uint16_t* ram, uint8_t n)
{
	uint8_t i;
	
	for (i = 0; i < 2*n; i++) {I2Cbuf[i] = *((uint8_t*)ram + i);}
}


void etdBufToWords(uint16_t* ram, uint8_t n)
{
	uint8_t i;
	
	for (i = 0; i < 2*n; i++) {*((uint8_t*)ram + i) = I2Cbuf[i];}
}
