/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFTcontrol.c    program file
 
 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display
 
 TrxAVR control of display
   
*/


#include "taGlobal.h"
#include "taEATFTdriver.h"
#include "taStarControl.h"
#include "taEATFTcommands.h"
#include "taButtons.h"
#include "taDDS.h"
#include "taZ_SWR.h"
#include "taEATFT.h"
#include "taStarDSP.h"
#include "taFT245R.h"
#include "taEA320TouchPanel.h"

//#define clActiveVFO 7
//#define clInactiveVFO 10
#define clActiveVFO 8
#define clInactiveVFO 7
#define clFreqDifference 4

// Smeter
#define etSmeterBarX 220
#define etSmeterBarTop 77
#define etSmeterBarBottom 87
#define S9 328 //etSmeterBarX + 9*12

// SWR meter
#define etSWRmeterBarX 262  // labelling of bars to left of this
#define etSWRmeterY 77
#define etSWRmeterD 10   // d in macro   = division width in pixels
#define etSWRspacing 35  // verical scpaign of the three bars
#define etSWRheight 10  // bar height

#define RITX 235
#define RITY 41
#define ModeX 181
#define ModeY 45
#define ParamColourX 181
#define ParamColourY 68
#define StateX 200 //188
#define StateY 68 //90
#define FilterX 56  //131
#define FilterY 42
#define StackX 106
#define StackY 45
#define TuneX 106
#define TuneY 68
#define QrpX 181
#define QrpY 90

/////////  MACRO CALL ROUTINES //////////////////
// define macro numbers

#define MnDrawButtons 				1
#define MnSmeterFramework   	2
#define MnClearSmeter 				3
#define MnSWRmeterFramework 	4
#define MnCopySWRbar					5
#define MnClearSWRmeter     	6
#define MnDSPmonRx 						7
#define MnDSPmonRx2                  12
#define MnDSPmonTx						8
#define MnDeleteDSPmonRx 			10
#define MnDeleteDSPmonTx			11


// TFT Touchpad circular buffer
uint8_t TFT_TP[TFT_TP_BUFFER_SIZE];
volatile uint8_t TFT_TP_Head;
volatile uint8_t TFT_TP_Tail;

// TFT Encoders8 circular buffer
uint8_t TFT_ENC8[TFT_ENC8_BUFFER_SIZE];
volatile uint8_t TFT_ENC8_Head;
volatile uint8_t TFT_ENC8_Tail;

static const uint8_t pmdSwitchInfo[8][6] PROGMEM = {
		{0,0,0,0,0,0},
		{58,0,1,11,8,2},
		{90,0,1,11,8,2},
		{122,0,1,11,8,2},
	// -------------------
		{0,0,0,0,0,0},//{154,0,1,11,8,2},
		{58,20,1,11,8,2},
		{90,20,1,11,8,2},
		{122,20,1,11,8,2},
};
	
static const uint8_t* const pmdSwitchVarSSB[8] PROGMEM = {
			0,
			&SWautonotch, //&SWdenoise,
			&SWnoiseblank,
			&SWdenoise,  //&SWautonotch,
			&SWmanualnotch,
			&SWvox,
			&SWspeechcomp,
			&RFatten,
};

static const uint8_t* const pmdSwitchVarCW[8] PROGMEM = {
			0,
			&SWautonotch, //manual and auto are switched together in STAR4
			&SWnoiseblank,
			&SWdenoise,
			&SWqro,	
			&SWqsk,
			&SWspot,
			&RFatten,
};

uint16_t MenuW;
uint8_t etShowSWR;
uint8_t etSmeterBarWidth;

static uint8_t etFwdBarWidth;
static uint8_t etRefBarWidth;
static uint8_t etSwrBarWidth;
static uint8_t PrevNdigA;
static uint8_t PrevNdigB;
static uint8_t HighlightedTPs[2][12];  //  [ Transmit, Touchpad no ]


void etDebug(char *str) __attribute__((section(".highmem")));
void etDebug(char *str)
{
	etcFont(Arial16);
	etcTextColour(8,0);
	etcDeleteRect(80,150,400,200);
	etcString(80,150,'L',str);
}


// Return the number of bytes of data in the touch pad buffer
uint8_t etTFT_TPBufferDataAvailable() __attribute__((section(".highmem")));
uint8_t etTFT_TPBufferDataAvailable()
{
	// There is data in the buffer unless Head and Tail are equal
	if (TFT_TP_Tail > TFT_TP_Head) return ((uint8_t)TFT_TP_BUFFER_MASK - TFT_TP_Tail + TFT_TP_Head + (uint8_t)1);
	else return (TFT_TP_Head - TFT_TP_Tail);
}


// Return the number of free bytes in the touch pad buffer
uint8_t etTFT_TPBufferSpace() __attribute__((section(".highmem")));
uint8_t etTFT_TPBufferSpace()
{
	if (TFT_TP_Tail > TFT_TP_Head) return (TFT_TP_Tail - TFT_TP_Head - (uint8_t)1);
	else return ((uint8_t)TFT_TP_BUFFER_MASK - TFT_TP_Head + TFT_TP_Tail);
}


// Return the number of bytes of data in the encoders8 buffer
uint8_t etTFT_ENC8BufferDataAvailable() __attribute__((section(".highmem")));
uint8_t etTFT_ENC8BufferDataAvailable()
{
	// There is data in the buffer unless Head and Tail are equal
	if (TFT_ENC8_Tail > TFT_ENC8_Head) return ((uint8_t)TFT_ENC8_BUFFER_MASK - TFT_ENC8_Tail + TFT_ENC8_Head + (uint8_t)1);
	else return (TFT_ENC8_Head - TFT_ENC8_Tail);
}


// Return the number of free bytes in the encoders8 buffer
uint8_t etTFT_ENC8BufferSpace() __attribute__((section(".highmem")));
uint8_t etTFT_ENC8BufferSpace()
{
	if (TFT_ENC8_Tail > TFT_ENC8_Head) return (TFT_ENC8_Tail - TFT_ENC8_Head - (uint8_t)1);
	else return ((uint8_t)TFT_ENC8_BUFFER_MASK - TFT_ENC8_Head + TFT_ENC8_Tail);
}


uint8_t etReadBuf() __attribute__((section(".highmem")));
uint8_t etReadBuf()
{
	uint8_t cnt, b, rc, cSREG;
	char buf[256];	
	
	if (!zt) return 0;
	if (BufFlag == 0) return 0;
	BufFlag = 0;
	if (etdReceivePackage(buf) == 0) return 0;

	cnt = strlen(buf);
	if (cnt < 3) return 0;
	rc = 0;
	for (b = 0; b < cnt-2;) {
		switch (buf[b]) {
			case '#':
				switch (buf[b+1]) {
					case 'Z':
						cSREG = SREG;
						cli();
						if (etTFT_TPBufferSpace()) {
							TFT_TP[TFT_TP_Head] = buf[b+2] - 0x30;
							TFT_TP_Head = (TFT_TP_Head + 1) & TFT_TP_BUFFER_MASK;
						}
						SREG = cSREG;
						rc = 1;
						b += 3;
						break;
					case 'E':
						cSREG = SREG;
						cli();
						if (etTFT_ENC8BufferSpace() >= 3) {
							TFT_ENC8[TFT_ENC8_Head] = buf[b+2] - 0x30;
							TFT_ENC8_Head = (TFT_ENC8_Head + 1) & TFT_ENC8_BUFFER_MASK;
							TFT_ENC8[TFT_ENC8_Head] = ((buf[b+3] == '+') ? 1 : 0);
							TFT_ENC8_Head = (TFT_ENC8_Head + 1) & TFT_ENC8_BUFFER_MASK;
							TFT_ENC8[TFT_ENC8_Head] = 10 * (buf[b+4] - 0x30) + buf[b+5] - 0x30;
							TFT_ENC8_Head = (TFT_ENC8_Head + 1) & TFT_ENC8_BUFFER_MASK;
						}
						SREG = cSREG;
						rc = 1;
						b += 6;
						break;
					default:
						b++;
						break;
				}
				break;
			case 0x1B:
				switch (buf[b+1]) {
					case 'H':
						if (buf[b+3] == 1) {
							cSREG = SREG;
							cli();
							if (etTFT_TPBufferSpace()) {
								TFT_TP[TFT_TP_Head] = 0;
								TFT_TP_Head = (TFT_TP_Head + 1) & TFT_TP_BUFFER_MASK;
							}
							SREG = cSREG;
							rc = 1;
						}
						b += 8;
						break;
					default: {
						b++;
						break;
					}
				}
				break;
			default:
				b++;
				break;
		}
	}
	
	return rc;
}


char etReadTouch() __attribute__((section(".highmem")));
char etReadTouch()
{
	char ret;
	uint8_t cSREG;

	if (!zt) return 'X';
	
	etReadBuf();
	cSREG = SREG;
	cli();
	if (etTFT_TPBufferDataAvailable()) {
		ret = TFT_TP[TFT_TP_Tail];
		TFT_TP_Tail = (TFT_TP_Tail + 1) & TFT_TP_BUFFER_MASK;
		SREG = cSREG;
		if (ret) {
			return ret;
		} else {
			return 'E';
		}
	} else {
		SREG = cSREG;
		return 'X';
	}
}


void etInitTouchPanel() __attribute__((section(".highmem")));
void etInitTouchPanel()
{
	uint8_t b;
	uint16_t x, y;
	for (b = 0; b < 12; b++) {
		HighlightedTPs[0][b] = 0;
		HighlightedTPs[1][b] = 0;
		if (b > 5) x = 429; else x = 0;
		y = 46 * (b % 6);
		etcTouchKey(x, y, x+50, y+41, b+1, 0, "");
	}
	etcFreeTouch(55, 0, 424, 271);  // Define remaining area as a touch pad to return 'E' (Esc)  
}


void etDrawTouchpad() __attribute__((section(".highmem")));
void etDrawTouchpad()
{
	uint8_t b, c;
	uint16_t x, y;
	uint8_t task;

	for (b = 0; b < 12; b++) {
		if (b > 5) x = 429; else x = 0;
		y = 46 * (b % 6);
		if (HighlightedTPs[Transmit][b]) c = 9;
		else {
			if (Transmit) task = TxTouchpadAssignments[b]; else task = RxTouchpadAssignments[b];
			if (task == 32) {
				if (ParamColour == pgreen) c = buGetButtonColour(12);
				else if (ParamColour == pyellow) c = buGetButtonColour(13);
				else c = buGetButtonColour(14);
			} else c = buGetButtonColour(task);
		}
		etcColourRect(x, y, x+50, y+41, c);
	}
}


void etRThighlight(uint8_t task, uint8_t Highlighted) __attribute__((section(".highmem")));
void etRThighlight(uint8_t task, uint8_t Highlighted)
{
	uint8_t b, t;
	for (b = 0; b < 12; b++) {
		//  look for the task in both Tx and Rx touchpads
		t = RxTouchpadAssignments[b];
		if (t == task) HighlightedTPs[0][b] = Highlighted;  
		t = TxTouchpadAssignments[b];
		if (t == task) HighlightedTPs[1][b] = Highlighted;  
	}
}



void etRedrawTouchpadCaption(uint8_t task, uint8_t Highlighted) __attribute__((section(".highmem")));
void etRedrawTouchpadCaption(uint8_t task, uint8_t Highlighted)
{
	uint8_t b, colour, capcolour, s, t;
	uint16_t x, y;

	if (task >= 12 && task <= 14) task = 32;
	for (b = 0; b < 12; b++) {
		if (Transmit) t = TxTouchpadAssignments[b]; else t = RxTouchpadAssignments[b];
		if (t == task) {
			if (b > 5) x = 429; else x = 0;
			y = 46 * (b % 6);
			if (Highlighted) {
				capcolour = 7; // yellow caption
				colour = 9;  // gray button
			} else { 
				colour = buGetButtonColour(task);	
				capcolour = buGetCaptionColour(task);
			}
			if (task == 32) {
				if (ParamColour == pgreen) {colour = buGetButtonColour(12); capcolour = buGetCaptionColour(12);}
				else if (ParamColour == pyellow) {colour = buGetButtonColour(13); capcolour = buGetCaptionColour(13);}
				else {colour = buGetButtonColour(14); capcolour = buGetCaptionColour(14);}
			}
			s = buGetTaskLabel(task, StrA, StrB);
			etcColourRect(x, y, x+50, y+41, colour);
			etcFont(Arial16);
			if (b > 5) x = 454; else x = 24;
			y = 3 + (46 * (b % 6));
			if (s == 0) {
				strcpy(StrA, "TP");
				itoa(b+1, StrB, 10);
			}
			strcat(StrA, "|");
			strcat(StrA, StrB);
			etcTextColour(capcolour, 0);
			etcString(x, y, 'C', StrA);
		}
	}
}



void etTouchpadCaptions() __attribute__((section(".highmem")));
void etTouchpadCaptions()
{
	uint8_t b, c, s;
	uint16_t x, y;
	uint8_t task;

	etDrawTouchpad();
	etcFont(Arial16);
	for (b = 0; b < 12; b++)
	{
		if (b > 5) x = 454; else x = 24;
		y = 3 + (46 * (b % 6));
		if (Transmit) task = TxTouchpadAssignments[b]; else task = RxTouchpadAssignments[b];
		s = buGetTaskLabel(task, StrA, StrB);
		if (task == 32) {
			if (ParamColour == pgreen) c = buGetCaptionColour(12);
			else if (ParamColour == pyellow) c = buGetCaptionColour(13);
			else c = buGetCaptionColour(14);
		} else c = buGetCaptionColour(task);
		if (HighlightedTPs[Transmit][b]) c = 7;
		if (s == 0) {
			strcpy(StrA, "TP");
			itoa(b+1, StrB, 10);
		}
		strcat(StrA, "|");
		strcat(StrA, StrB);
		etcTextColour(c, 0);
		etcString(x, y, 'C', StrA);
	}
}


/////////////  MACROS /////////////////////////////////////

void etSmeterFramework() __attribute__((section(".highmem")));
void etSmeterFramework()
{
	etcMacro(MnSmeterFramework);  // Macro 2
}


void etClearSmeter() __attribute__((section(".highmem")));
void etClearSmeter()
{
  etcMacro(MnClearSmeter);    // Macro 3
}


void etSWRmeterFramework() __attribute__((section(".highmem")));
void etSWRmeterFramework()
{
  etcMacro(MnSWRmeterFramework);  // Macro 4
}


void etCopySWRbar() __attribute__((section(".highmem")));
void etCopySWRbar()
{
  etcMacro(MnCopySWRbar);  // Macro 5
}


void etClearSWRmeter() __attribute__((section(".highmem")));
void etClearSWRmeter()
{
  etcMacro(MnClearSWRmeter);    // Macro 5
}


void etDSPmonRx() __attribute__((section(".highmem")));
void etDSPmonRx()
{
	etcMacro(MnDSPmonRx);     // macro 7
	ztDSPDisplay = 0;
}             

void etDSPmonRx2() __attribute__((section(".highmem")));
void etDSPmonRx2()  //hfr
{
	etcMacro(MnDSPmonRx2);     // macro 12
	ztDSPDisplay = 0;
}             


void etDSPmonTx() __attribute__((section(".highmem")));
void etDSPmonTx()
{
	etcMacro(MnDSPmonTx);     // macro 8
	ztDSPDisplay = 0;
}


void etDeleteDSPmonRx() __attribute__((section(".highmem")));
void etDeleteDSPmonRx()
{
	etcMacro(MnDeleteDSPmonRx);     // macro 10
	ztDSPDisplay = 0;
}


void etDeleteDSPmonTx() __attribute__((section(".highmem")));
void etDeleteDSPmonTx()
{
	etcMacro(MnDeleteDSPmonTx);     // macro 11
	ztDSPDisplay = 0;
}

//
//////////////////////////////////////

void etShowSwitches() __attribute__((section(".highmem")));
void etShowSwitches()
{
	uint8_t swon, sw, x, y, b, r, t;

	etcFont(Arial16);
	for (sw = 1; sw <= 7; sw++) {
		x = pgm_read_byte(&pmdSwitchInfo[sw][0]);
		y = pgm_read_byte(&pmdSwitchInfo[sw][1]);
		if(sw == 3) {r = 31;}
		else {r = 0;}
    	if (Mode < 2) {
			swon = *(uint8_t*)pgm_read_word(&pmdSwitchVarSSB[sw]);
    		strcpy_P(StrA,(PGM_P)&pmdSwitchLogo[sw][0]);
    	} else {
			swon = *(uint8_t*)pgm_read_word(&pmdSwitchVarCW[sw]);
    		strcpy_P(StrA,(PGM_P)&pmdSwitchLogo[sw][1]);
    	}
		if (swon) {
			b = pgm_read_byte(&pmdSwitchInfo[sw][5]);
			t = pgm_read_byte(&pmdSwitchInfo[sw][4]);
		} else {
			b = pgm_read_byte(&pmdSwitchInfo[sw][3]);
			t = pgm_read_byte(&pmdSwitchInfo[sw][2]);
		}
		etcColourRect(x-1, y, (r+x)+27, y+16, b); //hfr
		etcTextColour(t, 0);// 0 blk
		etcString((r/2)+x+12, y, 'C', StrA);
	

	}
}


void etShowIP3() __attribute__((section(".highmem")));
void etShowIP3()
{
	uint8_t x = 152;
	uint8_t y = 20;
	etcFont(Arial16);
	etcColourRect(x+1,y+1,x+26,y+15,1);
	etcLineColour(8,1);
	etcRect(x,y,x+27,y+16);
	if(IP3){strcpy(StrA,"IP3");}else{strcpy(StrA,"NF");};
	etcTextColour(5,0);
	etcString(x+12,y,'C',StrA);  
}

//////////////////////////////////////

void etSwrInit() __attribute__((section(".highmem")));
void etSwrInit()
{

}

// char* zswPowerLabel(char fr, uint8_t n);


void	etSwrDrawFramework() __attribute__((section(".highmem")));
void	etSwrDrawFramework()
{
	uint8_t i;
	uint16_t y = etSWRmeterY + 13; // see flash macro bar height h = 1, so h + 3
	uint16_t x;
	etFwdBarWidth = 0;
	etRefBarWidth = 0;
	etSwrBarWidth = 0;
	etSWRmeterFramework();  // this also sets text font and colour
	if(etShowSWR){etCopySWRbar();}; 
  x = etSWRmeterBarX-40;
	etcString(x,etSWRmeterY-2,'L',"Fwd.");
	etcString(x,etSWRmeterY-2+etSWRspacing,'L',"Refl.");
	if(etShowSWR){etcString(x,etSWRmeterY-2+2*etSWRspacing,'L',"SWR");};
	for(i=0;i<4;i++)
	{ 
		x = etSWRmeterBarX + etSWRmeterD*5*i;
		etcString(x,y,'C',zswPowerLabel('F',i));
		etcString(x,y+etSWRspacing,'C',zswPowerLabel('R',i));
		if(etShowSWR)
		{
			itoa(i+1,StrA,10);
			etcString(x,y+2*etSWRspacing,'C',StrA);
		}
	}
}


void etSWRmeterBarSet(uint16_t w, char bar) __attribute__((section(".highmem")));
void etSWRmeterBarSet(uint16_t w, char bar)
{
  uint16_t y = etSWRmeterY;
	uint16_t pw = 0;
	uint8_t BarColour = 3;
	uint8_t Overrange = 0;
	if(w>160)
	{
		w=160; 
		Overrange=1;
	}
	switch(bar)
	{
		case 'F': {
								y = etSWRmeterY;
								pw = etFwdBarWidth;
								etFwdBarWidth = w;
								break;
							}
		case 'R': {
								y = etSWRmeterY+etSWRspacing;
								pw = etRefBarWidth;
								etRefBarWidth = w;
								break;
							}
		case 'S': {
								y = etSWRmeterY+2*etSWRspacing;
								pw = etSwrBarWidth;
								etSwrBarWidth = w;
								break;
							}
	}
	if(w!=pw)
	{
	  uint16_t a,b,x;
		if((w>pw)||(Overrange==1))
		{
			BarColour=3;
			a = etSWRmeterBarX+pw;
			b = etSWRmeterBarX+w;
			etcDisplayColour(BarColour,0);
			etcFillRect(a+1,y,b,y+etSWRheight);
			etcDisplayColour(1,0);
			for(x=a;x<=b;x++)
			{
				
				if(((x+38)%(etSWRmeterD*5))==0)
				{etcFillRect(x-1,y,x+1,y+etSWRheight);}
				else
				{
					if(((x-2)%etSWRmeterD)==0){etcFillRect(x,y,x,y+etSWRheight);}
				}
			}
    }
		else
		{
		  a = etSWRmeterBarX+w+1;
			b = etSWRmeterBarX+pw; 
			etcDisplayColour(9,0);
			etcFillRect(a,y,b,y+etSWRheight);
			etcDisplayColour(1,0);
			for(x=a;x<=b;x++)
			{
				if(((x+38)%(etSWRmeterD*5))==0)
				{etcFillRect(x-1,y,x+1,y+etSWRheight);}
				else
				{
					if(((x-2)%etSWRmeterD)==0){etcFillRect(x,y,x,y+etSWRheight);}
				}
			}
    }
  }

}


/////////////////////////////////////

void etSmeterInit() __attribute__((section(".highmem")));
void etSmeterInit()
{
  etSmeterBarWidth = 0;
	etSmeterFramework();
}



void etSmeterBarSet(uint8_t w) __attribute__((section(".highmem")));
void etSmeterBarSet(uint8_t w)
{ 
	uint16_t x;
	uint8_t pw = etSmeterBarWidth;
	etSmeterBarWidth = w; 
	if(w!=pw)
	{
	  uint16_t a;
		uint16_t b;
		if(w>pw)
		{
			a = etSmeterBarX+pw;
			b = etSmeterBarX+w;
			if((b<=S9)|(a>=S9))
			{
			  if(b<=S9){etcDisplayColour(4,0);}else{etcDisplayColour(12,0);}; // green else red // 4 green JK smeter
			  etcFillRect(a+1,etSmeterBarTop,b,etSmeterBarBottom);
			}
			else
			{
				etcDisplayColour(4,0);
			  etcFillRect(a+1,etSmeterBarTop,S9-1,etSmeterBarBottom);			  	
				etcDisplayColour(12,0);
				etcFillRect(S9+1,etSmeterBarTop,b,etSmeterBarBottom);
			}					
			etcDisplayColour(1,0);
			for(x=a;x<=b;x++)
			{
				if(((x+8)%12)==0){etcFillRect(x,etSmeterBarTop,x,etSmeterBarBottom);}
			}
    }
		else
		{
		  a = etSmeterBarX+w+1;
			b = etSmeterBarX+pw; 
			etcDisplayColour(9,0);
			etcFillRect(a,etSmeterBarTop,b,etSmeterBarBottom);
			etcDisplayColour(1,0);
			for(x=a;x<=b;x++)
			{
				if(((x+8)%12)==0){etcFillRect(x,etSmeterBarTop,x,etSmeterBarBottom);}
			}
    }
  }
}



void etStartUp() __attribute__((section(".highmem")));
void etStartUp()
{
	etcDeleteDisplay();
	etcTouchInit(); 
	etInitTouchPanel();
	etTouchpadCaptions();
}
 

void etClearFrequencyDisplay(uint8_t Vfo) __attribute__((section(".highmem")));
void etClearFrequencyDisplay(uint8_t Vfo)
{
	if (Vfo == 0) etcDeleteRect(195, 0, 428, 43);
	else etcDeleteRect(267, 44, 428, 68);
}


void etDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void etDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo)
{
	int32_t dfa;
	int pa, pb, nb;
	uint16_t x, y;

	y = 40 * Vfo;  // VfoB lower
	x = 421 - (2 * Vfo);
	etClearFrequencyDisplay(Vfo);	
	etcTextColour(clFreqDifference, 1);
	if (Vfo == 0) etcFont(OldSansBlack42); else etcFont(OldSansBlack28);
	if (df == 0) strcpy(StrA, "0");
	else {
		if (df > 0) StrA[0] = '+'; else StrA[0] = '-'; 
		dfa = labs(df);
		ltoa(dfa, StrB, 10);
		nb = strlen(StrB);
		pa = 1;           // StrA pointer
		for (pb = 0; pb < nb; pb++) {
			if (((nb - pb) % 3) == 0) StrA[pa++] = '.';
			StrA[pa++] = StrB[pb];
		}
		StrA[pa] = 0;
	}
	etcString(x, y, 'R' ,StrA);
	PrevNdigA = 0;
	PrevNdigB = 0;
}


void etDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t LeadingZero) __attribute__((section(".highmem")));
void etDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t LeadingZero)
{
	uint16_t x, y;
  
	y = 40 * Vfo;  // VfoB lower
	x = 421 - (2 * Vfo);
	if (Vfo == 0) etcFont(OldSansBlack42); else etcFont(OldSansBlack28);
	etcTextColour(clActiveVFO, 1);
	StrA[0] = 0; // null string
	if ((LeadingZero == 1) && (f > 0)) strcat(StrA, "0");
	ltoa(f, StrB, 10);
	strcat(StrA, StrB);
	etcString(x, y, 'R', StrA);
}


void etDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void etDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo)
{
	uint16_t x, y;
	uint8_t ndig;

	y = 40 * Vfo;  // VfoB lower
	x = 421 - (2 * Vfo);
	if (Vfo == 0) etcFont(OldSansBlack42); else etcFont(OldSansBlack28);
	if (ActiveVfo == Vfo) etcTextColour(clActiveVFO, 1); else etcTextColour(clInactiveVFO, 1);
	ltoa(f, StrB, 10);
	ndig = strlen(StrB);

	if (ndig <= 5) {
		StrA[0] = StrB[0];
		StrA[1] = StrB[1];
		StrA[2] = '.';
		StrA[3] = StrB[2];
		StrA[4] = StrB[3];
		StrA[5] = StrB[4];
		StrA[6] = 0;
	} else if (ndig == 6) {
		StrA[0] = StrB[0];
		StrA[1] = StrB[1];
		StrA[2] = StrB[2];
		StrA[3] = '.';
		StrA[4] = StrB[3];
		StrA[5] = StrB[4];
		StrA[6] = StrB[5];
		StrA[7] = 0;
	} else if (ndig == 7) {
		StrA[0] = StrB[0];
		StrA[1] = '.';
		StrA[2] = StrB[1];
		StrA[3] = StrB[2];
		StrA[4] = StrB[3];
		StrA[5] = '.';
		StrA[6] = StrB[4];
		StrA[7] = StrB[5];
		StrA[8] = StrB[6];
		StrA[9] = 0;
	} else {
		StrA[0] = StrB[0];
		StrA[1] = StrB[1];
		StrA[2] = '.';
		StrA[3] = StrB[2];
		StrA[4] = StrB[3];
		StrA[5] = StrB[4];
		StrA[6] = '.';
		StrA[7] = StrB[5];
		StrA[8] = StrB[6];
		StrA[9] = StrB[7];
		StrA[10] = 0;
	}

	if (Vfo == 0) {
		if (ndig != PrevNdigA) etcColourRect(216, 6, 295, 34, 1);
		PrevNdigA = ndig;
	} else {
		if (ndig != PrevNdigB) etcColourRect(284, 44, 336, 62, 1);
		PrevNdigB = ndig;
	}
	etcString(x, y, 'R', StrA);	
}


void etWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void etWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo)
{
	uint16_t x, y;

	y = 10 + (34 * Vfo);  // VfoB lower
	if (Vfo == 0) x = 201; else x = 271;
	if (Vfo == ActiveVfo) etcTextColour(clActiveVFO, 1); else etcTextColour(clInactiveVFO, 1);
	if (Vfo == 0) etcFont(OldSansBlack28); else etcFont(OldSansBlack22);
	strcpy(StrA, pmdSpaces(3));
	StrA[1] = tag;
	etcString(x, y, 'C', StrA);
}


void etShowRITXIT() __attribute__((section(".highmem")));
void etShowRITXIT()
{	
	etClearRITXIT();
	if ((XIT != 0) || (RIT != 0)) {
		if (XIT == 1)  strcpy(StrA, PMS(s_XIT));
		else strcpy(StrA, PMS(s_RIT));
		if (Split == 1) strcat(StrA, PMS(s__split));
		etcFont(Arial16);
		etcTextColour(3, 1);
		etcString(RITX, RITY, 'L', StrA);
	}
}


void etClearRITXIT() __attribute__((section(".highmem")));
void etClearRITXIT()
{
	etcColourRect(RITX,RITY,RITX+28,RITY+31,1);
}


void etShowMode() __attribute__((section(".highmem")));
void etShowMode()
{
	etcColourRect(ModeX,ModeY,ModeX+37,ModeY+17,1);
	etcLineColour(8,1);
	etcRect(ModeX,ModeY,ModeX+37,ModeY+17);
	etcFont(GenevaBold16);
	etcTextColour(10,1);
	strcpy(StrA,pmModeName(Mode));
	etcString(ModeX+18,ModeY+1,'C',StrA);
}


void etShowQRPQRO(uint8_t val) __attribute__((section(".highmem")));
void etShowQRPQRO(uint8_t val)
{
	etcColourRect(QrpX,QrpY,QrpX+29,QrpY+15,1);
	etcLineColour(8,1);
	etcRect(QrpX,QrpY,QrpX+29,QrpY+15);
	etcFont(Geneva14);
	etcTextColour(6,1);
	if(val==0){strcpy(StrA,"QRP");}else{strcpy(StrA,"QRO");}
	etcString(QrpX+14   ,QrpY+1,'C',StrA);
}



void etShowParamColour(uint8_t pc) __attribute__((section(".highmem")));
void etShowParamColour(uint8_t pc)
{
	uint8_t c = 1;
	uint8_t ch = 'X';
	switch(pc)
	{
		case 1: c=4; ch = 'G'; break;
		case 2: c=7; ch = 'Y'; break;
		case 3: c=3; ch = 'R'; break;
	}
	etcColourRect(ParamColourX,ParamColourY,ParamColourX+18,ParamColourY+17,1);
	etcLineColour(c,1);
	etcRect(ParamColourX,ParamColourY,ParamColourX+17,ParamColourY+17);
	etcTextColour(c,0);
	etcFont(GenevaBold16);
	StrA[0] = ch;
	StrA[1] = 0;
	etcString(ParamColourX+4,ParamColourY+1,'L',StrA);
}


void etShowState(char pc) __attribute__((section(".highmem")));
void etShowState(char pc)
{
	etcColourRect(StateX+1, StateY+1, StateX+16, StateY+16, 1);
	etcLineColour(8, 1);
	etcRect(StateX, StateY, StateX+17, StateY+17);
	etcTextColour(5, 0);
	etcFont(GenevaBold16);
	StrA[0] = pc;
	StrA[1] = 0;
	etcString(StateX+4, StateY+1, 'L', StrA);
}


void etBlankState() __attribute__((section(".highmem")));
void etBlankState()
{
	etcColourRect(StateX+1, StateY+1, StateX+16, StateY+16, 1);
}


void etClearState() __attribute__((section(".highmem")));
void etClearState()
{
	etcDeleteRect(StateX, StateY, StateX+17, StateY+17);
}


///////////////////    FILTER GRAPHIC /////////////////

void etFilterInit() __attribute__((section(".highmem")));
void etFilterInit()
{
	PrevSwCW = 255;
	PrevSwSSB = 255;
	PrevMode = 255;
}


void etFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw) __attribute__((section(".highmem")));
void etFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw)
{
	uint16_t X, Y;
	uint8_t sk, w, c;
	
	w = (widthparam + 3) / 6;
	c  = (centreparam + 6) / 12;
	if (c > 19) c = 19;
	if (w > 40) w = 40;
	sk = (40 - w) / 2;
	X = FilterX;
	Y = FilterY;
	etcColourRect(X-3, Y+27, X+43, Y+64, 1);
	etcLineColour(10, 0);
	if (Mode == 1) etcLine(X+20-c, Y+60, X+20-c, Y+64);
	else etcLine(X+21+c, Y+60, X+21+c, Y+64);
	etcLineColour(14, 0);
	etcLine(X, Y+59, X+sk, Y+59);
	etcLine(X+40-sk, Y+59, X+40, Y+59);
	etcLine(X+sk, Y+29, X+40-sk, Y+29);
	etcLine(X+sk, Y+29, X+sk, Y+59);
	etcLine(X+40-sk, Y+29, X+40-sk, Y+59);
	if (sw == 1) strcpy(StrB, PMS(s_Narrow));
	else strcpy(StrB, PMS(s_Wide));
	etcFont(Geneva14);
	etcTextColour(7, 0);
	if ((sw != PrevSwSSB) || (Mode != PrevMode)) {   // more anti flicker
		etcColourRect(X-3, Y, X+43, Y+13, 1);
		etcString(X+20, Y, 'C', StrB);
		PrevSwSSB = sw;
		PrevMode = Mode;
	}
	etcColourRect(X-3, Y+13, X+43, Y+25, 1);
	etcString(X+20, Y+14, 'C', swid);
}


void etFilterCW(char * swid, uint8_t widthparam, 
           uint8_t centreparam, uint8_t depthparam, uint8_t sw) __attribute__((section(".highmem")));
void etFilterCW(char * swid, uint8_t widthparam, 
           uint8_t centreparam, uint8_t depthparam, uint8_t sw)
{
	uint16_t X, Y;
	uint8_t w, c, d, sk;

	w = (widthparam + 3) / 6;
	c  = (centreparam + 6) / 12;
	if (c > 19) c = 19;
	if (w > 40) w = 40;
	if (w < 2) w = 2;
	if (sw == 1) d = depthparam * 3; else d = 0;
	sk = (40 - w) / 2;
	X = FilterX;
	Y = FilterY;
	etcColourRect(X-3, Y+25, X+43, Y+64, 1);
	etcLineColour(10, 0);
	if (Mode == 3) etcLine(X+20-c, Y+61, X+20-c, Y+64);
	else etcLine(X+21+c, Y+61, X+21+c, Y+64);
	etcLineColour(14, 0);
	etcLine(X, Y+59, X+sk, Y+59);
	etcLine(X+40-sk, Y+59, X+40, Y+59);
	etcLine(X+sk, Y+59-30+d, X+19, Y+59-30+d);	// L shoulder
	etcLine(X+21, Y+59-30+d, X+40-sk, Y+59-30+d);	//R shoulder
	etcLine(X+19, Y+29, X+21, Y+29);      // top
	etcLine(X+19, Y+29, X+19, Y+59-30+d);
	etcLine(X+21, Y+29, X+21, Y+59-30+d);
	etcLine(X+sk, Y+59-30+d, X+sk, Y+59);
	etcLine(X+40-sk, Y+59-30+d, X+40-sk, Y+59);
	if (sw == 1) strcpy(StrB, PMS(s_6162));
	else strcpy(StrB, PMS(s_Context));
	etcFont(Geneva14);
	etcTextColour(7, 0);
	if ((sw != PrevSwCW) || (Mode != PrevMode)) {   // more anti flicker
		etcColourRect(X-3, Y, X+43, Y+13, 1);
		etcString(X+20, Y, 'C', StrB);
		PrevSwCW = sw;
		PrevMode = Mode;
	}
	etcColourRect(X-3, Y+14, X+43, Y+25, 1);
	etcString(X+20, Y+14, 'C', swid);
}


//////////////////////////////////////////////////////////////////

void etShowSigGenMode() __attribute__((section(".highmem")));
void etShowSigGenMode()
{
	if (SigGenMode == 0) {
		etDeleteTuneBox();
	} else {
		etTuneBox();
		strcpy(StrB,PMS(s_Signal1_generator));
		etTuneText(StrB);
	}
}




void etShowVfoStackMode() __attribute__((section(".highmem")));
void etShowVfoStackMode()
{
	etTuneBox();
	strcpy(StrA,PMS(s_VFO_stack));
	etTuneText(StrA);
}


void etShowWobbulatorMode() __attribute__((section(".highmem")));
void etShowWobbulatorMode()
{
	etTuneBox();
	strcpy(StrA,PMS(s_wobbulator));
	etTuneText(StrA);
}


void etShowRateTuningMode() __attribute__((section(".highmem")));
void etShowRateTuningMode()
{
	etTuneBox();
	strcpy(StrA,PMS(s_Rate_tune));
	etTuneText(StrA);
}

void etShowABscan() __attribute__((section(".highmem")));
void etShowABscan()
{
	etTuneBox();
	strcpy(StrA,PMS(s_AB_scan));
	etTuneText(StrA);
}


void etShowMemStackScan() __attribute__((section(".highmem")));
void etShowMemStackScan()
{
	etTuneBox();
	strcpy(StrA,PMS(s_Mem_scan));
	etTuneText(StrA);
}


void etShowGuarding() __attribute__((section(".highmem")));
void etShowGuarding()
{
	etTuneBox();
	strcpy(StrA,PMS(s_guard_chan_every_20s));
	etTuneText(StrA);
}

//////////////////////////////////////////////////////////////////



void etMemBox() __attribute__((section(".highmem")));
void etMemBox()
{
	etcColourRect(StackX+1,StackY+1,StackX+69,StackY+17,1);
  etcLineColour(8,1);
	etcRect(StackX,StackY,StackX+70,StackY+18);
}


void etStackSlot(uint8_t stack, uint8_t slot) __attribute__((section(".highmem")));
void etStackSlot(uint8_t stack, uint8_t slot)
{
	etcColourRect(StackX+1,StackY+1,StackX+69,StackY+17,1);
	etcFont(Arial16);
	etcTextColour(15,1);
	strcpy(StrA,PMS(s_mem1_));
	stack +=  67;
	if(stack>=70){stack=60;};
	if(slot!=255){slot += 61;};
 	ltoa(stack,StrB,10);
	strcat(StrA,StrB);
	strcat(StrA,":");
	if(slot!=255){ltoa(slot,StrB,10);}else{strcpy(StrB,"---");};
	strcat(StrA,StrB);
	etcString(StackX+3,StackY+2,'L',StrA);
}



void etShowSlickyVolatile(char sv, uint8_t slotno) __attribute__((section(".highmem")));
void etShowSlickyVolatile(char sv, uint8_t slotno)
{
	if(sv=='V')
	{strcpy(StrA,PMS(s_Volatile_));}
	else
	{strcpy(StrA,PMS(s_Sticky_));};
	ltoa(slotno,StrB,10);
	strcat(StrA,StrB);
	etClearTuneBoxLower();
	etTuneTextLower(StrA);
}

//////////////////////////////////////////////////////////////////////////////

void etTuneBox() __attribute__((section(".highmem")));
void etTuneBox()
{
	etDeleteTuneBox();
  etcLineColour(8,1);
	etcRect(TuneX,TuneY,TuneX+70,TuneY+39);
}


void etDeleteTuneBox() __attribute__((section(".highmem")));
void etDeleteTuneBox()
{
	etcColourRect(TuneX,TuneY,TuneX+70,TuneY+39,1);
}


void etClearTuneBoxLower() __attribute__((section(".highmem")));
void etClearTuneBoxLower()
{
	etcColourRect(TuneX+1,TuneY+18,TuneX+69,TuneY+38,1);
}


void etTuneText(char* ttx) __attribute__((section(".highmem")));
void etTuneText(char* ttx)  // two lines using | delimeter
{
	etcFont(Arial16);
	etcTextColour(15,1);	
	etcString(TuneX+3,TuneY+2,'L',ttx);
}



void etTuneTextLower(char* ttx) __attribute__((section(".highmem")));
void etTuneTextLower(char* ttx)
{
	etClearTuneBoxLower();
	etcFont(Arial16);
	etcTextColour(15,1);	
	etcString(TuneX+3,TuneY+20,'L',ttx);
}

///////////////////////////////////////////////////////////////////////////////


uint8_t etProgramFlash() __attribute__((section(".highmem")));
uint8_t etProgramFlash()
{
  uint32_t chksum = etDoProgramFlash();
  _delay_us(200);
	usbPutByte(chksum / 256);
	_delay_us(200);
	usbPutByte(chksum % 256);
  return 1;
}


uint16_t etDoProgramFlash() __attribute__((section(".highmem")));
uint16_t etDoProgramFlash()
{
	uint32_t bc;
	uint8_t done;
	uint16_t i;
  uint32_t p;
	uint32_t remaining;
	uint16_t bksz;
	uint32_t ByteCount;
  uint8_t buf[132];
	uint32_t RcvChecksum;
	if(usbReceiveBlock((uint8_t*)(&ByteCount),4,5000)==0){return 9999;};
	bc = 0;
  p = 0; 
	done = 0;
	RcvChecksum = 0;
	while(done == 0)
  {
		_delay_ms(5);
    remaining = ByteCount - p;
		if(remaining <= 128){done = 1;};
		if(remaining >= 128){bksz = 128;} else {bksz = remaining;};
		if(usbReceiveBlock((uint8_t*)(&buf[0]),bksz,5000)==0){return 5678;};		
    for(i=0;i<bksz;i++)
		{
      RcvChecksum = (RcvChecksum + buf[i]) % 0x10000;
		}
		bc += bksz;
    etdSendPackageNC(buf,bksz);
		p += bksz;
  }
  RcvChecksum = (RcvChecksum + bc) % 0x10000;
	return RcvChecksum;
}
