/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taEA320TouchPanel.c  Touch panel module program file
*/


#include "taGlobal.h"
#include "taKeys.h"
#include "taADC.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsControl.h"
#include "taZ_StarControl.h"
#include "taZ_DDS.h"
#include "taEA320TouchPanel.h"
#include "taIntEeprom.h"
#include "taDDS.h"
#include "taFT245R.h"
#include "taCAT.h"
#include "taEATFT.h"
#include "taStarControl.h"
#include "taEEPROM.h"		// for EEMEM definitions


#define Xadc 4     /// ADC channels
#define Yadc 5

#define TouchPIN PINF
#define TouchDDR DDRF
#define TouchPORT PORTF
#define TouchYH 7
#define TouchXH 6


/*		Moved to taEEPROM.h
struct TouchCal_type EEMEM EE_TouchCal;
*/

struct TouchCal_type TouchCal;

static uint16_t AdcTop;
static uint16_t AdcLeft;
static uint16_t AdcWidth;
static uint16_t AdcHeight;
static uint16_t AdcBottom;
static uint16_t AdcRight;
static uint32_t TPX;
static uint32_t TPY;
static uint16_t PixelsX;
static uint16_t PixelsY;

uint16_t tpReadX();
uint16_t tpReadY();
char tpReadChar();
char tpCharEA320();
uint8_t tpReadCalADC(uint16_t* pADCX, uint16_t* pADCY);
void tpDrawCross(uint16_t x, uint16_t y);
uint8_t tpDoCalibration();


// Quiescent state is with TouchYH and TouchXH low
// This switches on the PNP and switches off the NPN
// - So no panel current, but both panes pulled up to 5v
// so high value pull up only has to to maintain sensing panes at 5v
// doesn't have to move it to 5v - so small delay 


uint16_t tpReadY()
{
	TouchPORT |= (1 << TouchYH);
	_delay_us(200);              
	uint16_t adc = adReadADC(Xadc);
	TouchPORT &= ~(1 << TouchYH);
	return adc;
}


uint16_t tpReadX()
{
	TouchPORT |= (1 << TouchXH);
	_delay_us(200);
	uint16_t adc = adReadADC(Yadc);   //  Y1-Y2 have X voltage
	TouchPORT &= ~(1 << TouchXH);
	return adc;
}


void tpInitTouchPanel()
{
	PixelsX = 320;
	PixelsY = 240;
	TouchPORT &= ~((1 << TouchXH) | (1 << TouchYH)); // no panel current
	TouchDDR |= ((1 << TouchXH) | (1 << TouchYH));  // outputs  
	TouchDDR &= ~((1 << Xadc) | (1 << Yadc));  //  inputs (port bit = ADC number)
	TouchPORT &= ~((1 << Xadc) | (1 << Yadc));  // no internal pullups needed
	if (!HaveTP) return;
	tpEEreadTouchCal();
	if ((TouchCal.tcBottom < 50) || (TouchCal.tcRight < 50))
	{
		TouchCal.tcTop    = 168;  // default if rubbish loaded
 		TouchCal.tcBottom = 915;
		TouchCal.tcRight  = 840; 
		TouchCal.tcLeft   = 200;
	}
	AdcWidth = TouchCal.tcRight - TouchCal.tcLeft + 1;
	AdcHeight = TouchCal.tcBottom - TouchCal.tcTop + 1;
	AdcTop =   TouchCal.tcTop;
	AdcLeft = TouchCal.tcLeft;
	AdcBottom = TouchCal.tcBottom;
	AdcRight = TouchCal.tcRight;
}


char tpGetTouchChar()
{
	char ka;
	ka = etReadTouch();
	if (ka == 'X')
	{
		if (!HaveTP) return 'X';
		ka = tpReadChar();
		if (ka == 'X') return 'X';
		uint8_t count = 0;
		uint8_t k;
		do
		{
			count += 1;
			k = tpReadChar();
			if (k == 'X') return 'X';
			if (k != ka)
			{
				ka = k;
				count = 0;
			}
		} while (count < 12);
		do {;} while (ka == tpReadChar());
	}
	scWakeupDisplay();
	ShiftTimer = 0;
	return ka;
}


char tpReadChar()
{
	uint16_t adcx = tpReadX();
	if (adcx > AdcRight) return 'X';  // unless pressed wont get past here 	
	uint16_t adcy = tpReadY();
	if (adcy > AdcBottom) return 'X';
	TPX = ((uint32_t)PixelsX*(adcx - AdcLeft))/AdcWidth;
	if (TPX < 0) return 'X';
	TPY = ((uint32_t)PixelsY*(adcy - AdcTop))/AdcHeight;
	if (TPX < 0) return 'X';
	return tpCharEA320();
}		 


char tpCharEA320()
{	
	char ch = 'X';
	if ((TPY > PixelsY) || (TPX > PixelsX)) return 'X';
	uint16_t p = (TPX/40) + (TPY/30)*0x100;
	switch (p)
	{
		case 0x0007: ch = 1;  break;
		case 0x0107: ch = 2;  break;
		case 0x0207: ch = 3;  break;
		case 0x0307: ch = 4;  break;
		case 0x0407: ch = 5;  break;
		case 0x0507: ch = 6;  break;
		case 0x0607: ch = 7;  break;
		case 0x0707: ch = 8;  break;
		case 0x0700: ch = 9;  break;
		case 0x0701: ch = 10;  break;
		case 0x0702: ch = 11;  break;
		case 0x0703: ch = 12;  break;
		case 0x0704: ch = 13;  break;
		case 0x0705: ch = 14;  break;
		case 0x0706: ch = 15;  break;
		default:	 ch = 'E';  break;  // tap anywhere else = ESC
	}
	return ch;
}			


uint8_t tpReadCalADC(uint16_t* pADCX, uint16_t* pADCY)
{
	char ch;
	uint16_t xadc, yadc, xa, ya;
	do
	{
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		ch = kyGetKeyChar();
		xadc = tpReadX();
		yadc = tpReadY();
	} while (((xadc > 980) || (yadc > 980)) && (ch != 'E') && (ch != '#'));
	if ((ch == 'E') || (ch == '#')) return 0;
	uint8_t count = 0;
	do
	{
		xa = tpReadX();
		ya = tpReadY();
		if ((xa == xadc) && (ya == yadc))
		{
			count += 1;
		}
		else
		{
			count = 0;
			xadc = xa;
			yadc = ya;
		}
	} while (count < 6);
	*pADCX = xadc;
	*pADCY = yadc;
	xadc=0;
	while (xadc < 980)
	{
		xadc = tpReadX();
		ctDoCat();
		usbCheckPC();
		scCheckFlags();
	} // wait for end of press
	_delay_ms(200);
	return 1;
}


void tpDrawCross(uint16_t x, uint16_t y)
{
	uint16_t xt;
	gedHorizLine(x-15, x+15, y, 1);
	gedVertLine(y-15, y+15, x, 1);
	if (x > 160) xt = x-82; else xt = x+20;
	gedF16WriteString(PMS(s_Tap_cross), xt, y-9);
}


void tpCalibration()
{
	if (Transmit == 1) return;
	tpDoCalibration();
	gedCls(0);
	gcGraphicsDisplayRestore();
	zscShowMode();
	zscShowSwitches();
	zscShowFilter();
	zddsShowBothVfoFreqs();  //@@@@@@@@@
	gedShowLayer(2,1);
}

		 
uint8_t tpDoCalibration()
{
	if (!HaveTP) return 0;
	uint8_t r;
	uint16_t a,d;
	uint16_t X_040_030, X_280_030, X_040_210, X_280_210, X_160_120;
	uint16_t Y_040_030, Y_280_030, Y_040_210, Y_280_210, Y_160_120;
	gedShowLayer(2,0);
	gedShowLayer(3,0);
	gedShowLayer(1,1);
	gedSwitchLayer(1);
	gedCls(0);
	gedF16WriteString(PMS(s_Touch_panel_calibration),60,80);
	gedF16WriteString(PMS(s_Tap_screen_to_begin_),70,120);
	gedF8WriteString(PMS(s__Key_ESC_or___to_exit_),76,140);
	gedF8WriteString(PMS(s_use_stylus_A),50,180);
	gedF8WriteString(PMS(s_use_stylus_B),50,190);
	r = tpReadCalADC(&X_040_030,&Y_040_030);  // dummy read to start
	if (r==0){return 0;};
	gedCls(0);
	tpDrawCross(40,30);
	if (tpReadCalADC(&X_040_030, &Y_040_030)==0){return 0;};
	gedCls(0);
	tpDrawCross(280,30);
	if (tpReadCalADC(&X_280_030, &Y_280_030)==0){return 0;};
	gedCls(0);
	tpDrawCross(40,210);
	if (tpReadCalADC(&X_040_210, &Y_040_210)==0){return 0;};
	gedCls(0);
	tpDrawCross(280,210);
	if (tpReadCalADC(&X_280_210, &Y_280_210)==0){return 0;};
	gedCls(0);
	tpDrawCross(160,120);
	if (tpReadCalADC(&X_160_120, &Y_160_120)==0){return 0;};
	gedCls(0);

	d = ((X_280_030 + X_280_210) - (X_040_030 + X_040_210))/6;  // 2 * 40 pixel's ADC average
	a = (X_040_030 + X_040_210);   // 2 * left cal x
	TouchCal.tcLeft = (a-d)/2;
	a = (X_280_030 + X_280_210);   // 2 * right cal x  average
	TouchCal.tcRight = (a+d)/2;

	d = ((Y_040_210 + Y_280_210) - (Y_040_030 + Y_280_030))/6;  // 2 * 30 pixel's ADC average
	a = (Y_040_030 + Y_280_030);   // 2 * top cal y average
	TouchCal.tcTop = (a-d)/2;
	a = (Y_040_210 + Y_280_210);   // 2 * right cal y
	TouchCal.tcBottom = (a+d)/2;
	tpEEwriteTouchCal();
	tpInitTouchPanel();
	return 1;
}

  
void tpEEwriteTouchCal()
{
	ie_eeprom_write_block(&TouchCal, &ee.EE_TouchCal, 8);
}


void tpEEreadTouchCal()
{
	ie_eeprom_read_block(&TouchCal, &ee.EE_TouchCal, 8);
}
