/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taDiagnostic.c    program file
 
Diagnostic routines  - USB port control
*/

#include "taGlobal.h"
#include "taDDS.h"
#include "taFT245R.h"
#include "taStarControl.h"
#include "ta24LC512.h"
#include "taIntEeprom.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "taGraphicsDriverEA320.h"
#include "taButtons.h"
#include "taEncoder.h"
#include "taGraphicsControl.h"
#include "taEA320TouchPanel.h"
#include "TrxAVR.h"


void diaSetDiagMode(char m);


void diaUsbRequest(char cmd)
{
  uint8_t block[12];
	switch(cmd)
	{
	  case 'W': {
		            if(usbReceiveBlock((uint8_t*)(&block),11,500)==1)
								{ 
									diaSetDiagMode('W');
									PORTA = block[0];				
									PORTB = block[1];				
									PORTC = block[2];				
									if((block[3] & 0x01)==0x01){PORTD |= 0x01;}else{PORTD &= 0xFE;};
									if((block[3] & 0x02)==0x20){PORTD |= 0x02;}else{PORTD &= 0xFD;};
									if((block[3] & 0x80)==0x80){PORTD |= 0x80;}else{PORTD &= 0x7F;};				
									PORTE = block[4];				
									PORTF = block[5];				
									PORTG = block[6];				
									PORTH = block[7];								
									PORTJ = block[8];				
									PORTK = block[9];				
									PORTL = block[10];				
								}
								break;
							}
	  case 'R': {
								diaSetDiagMode('R');
								block[0] = PINA;				
								block[1] = PINB;				
							  block[2] = PINC;				
								block[3] = PIND & 0x83;
								block[4] = PINE;				
								block[5] = PINF;				
								block[6] = PING;				
							  block[7] = PINH;								
							  block[8] = PINJ;				
								block[9] = PINK;				
								block[10] = PINL;				

		            usbSendBlock((uint8_t*)(&block),11,500);
								break;
							}
  }
}



void diaSetDiagMode(char m)
{
  if(DiagMode==m){return;};
	DiagMode = m;
	TIMSK3  = 0x00;  // disable Timer 3 interrupt 
	TIMSK4  = 0x00;  // disable Timer 4 interrupt 
	EIMSK = 0;       // disable encoder interrupts
	UCSR3B &= ~(1 << 7);  // disable RXCIE3 (bit 7)  - Encoders8 interrupt
	UCSR2B &= ~(1 << 6);  // disable TXCIE2 (bit 6) - DSP Tx interrupt
	UCSR2B &= ~(1 << 7);  // disable RXCIE2 (bit 7) - DSP Rx interupt
	UCSR0B &= ~(1 << 6);  // disable TXCIE0 (bit 6) - CAT Tx interrupt
	UCSR0B &= ~(1 << 7);  // disable RXCIE0 (bit 7) - CAT Rx interrupt
	ADCSRA = 7;           //  Switch off ADC by cleaing bit 7
	switch(DiagMode)
	{
		case 'W':
		{
			DDRA = 0xFF;
			DDRB = 0xFF;
			DDRC = 0xFF;
			DDRD = 0xB3;   // 2-6 must be preserved for USB
			DDRE = 0xFF;
			DDRF = 0xFF;
			DDRG = 0x3F;  //has only 6 bits
			DDRH = 0xFF;
			DDRJ = 0xFF;
			DDRK = 0xFF;
			DDRL = 0xFF;
      break;
		}

		case 'R':
		{
			DDRA = 0x00;
			DDRB = 0x00;
			DDRC = 0x00;
			DDRD = 0x30;   // 2-6 must be preserved for USB
			DDRE = 0x00;
			DDRF = 0x00;
			DDRG = 0x00;  //has only 6 bits
			DDRH = 0x00;
			DDRJ = 0x00;
			DDRK = 0x00;
			DDRL = 0x00;
      break;
		}
	}
}	
