/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taDDScommands.c  Picastar (longkeypress) DDS commands module

*/


#include "taGlobal.h"
#include "TrxAVR.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "taEncoder.h"
#include "taFT245R.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taADC.h"
#include "taDebug.h"
#include "taUsart.h"
#include "taStarDSP.h"
#include "taStarControl.h"
#include "taSmeter.h"
#include "taMenus.h"
#include "taSWR.h"
#include "taStarDSP.h"
#include "taIntEeprom.h"
#include "taButtons.h"
#include "taDDScommands.h"
#include "taZ_DDS.h"
#include "taZ_DDScommands.h"
#include "taZ_StarControl.h"
#include "taEATFTcommands.h"
#include "taEATFT.h"
#include "taKS0108.h"
#include "taKS0108Menus.h"
#include "taGraphicsEA320.h"
#include "taRTC.h"
#include "taZ_StarControl.h"



#define fup 1
#define fdown 0

#define portDDS79  PORTG
#define bitDDS79 2


// DDS keys either two digits or 9 adn two more digits
void cmDoDDSkeys(char kc) __attribute__((section(".highmem")));
void cmDoDDSkeys(char kc)
{
  if(kc=='0'){cmABdiff(); return;};
	if(kc=='#'){cmXIT(); return;};
	zcmDDScommandInput(kc);   
}


void cmDoDDScommand(uint16_t code) __attribute__((section(".highmem")));
void cmDoDDScommand(uint16_t code)
{
	uint32_t f;
	uint8_t b;
	switch(code)
	{
      //on band change, ddsCheckFreq will change Freq and update and save slot
		case 16:  Band=0; scBandChanged(); break;  // 160
		case 80:  Band=1; scBandChanged(); break;  // 80
		case 40:  Band=3; scBandChanged(); break;  // 40
		case 30:  Band=4; scBandChanged(); break;  // 30
		case 20:  Band=5; scBandChanged(); break;  // 20
		case 17:  Band=6; scBandChanged(); break;  // 17
		case 15:  Band=7; scBandChanged(); break;  // 15
		case 12:  Band=8; scBandChanged(); break;  // 12
		case 10:  Band=9; scBandChanged(); break;  // 10

		// on ParamChange = need to update and save slot
	//	case 51:  cmSetGreenParams();  break;   HFR Star4
	//	case 52:  cmSetYellowParams(); break;
	//	case 53:  cmSetRedParams();    break;
		case 54:  cmDefaultParams();   break; 
			     	
		case 11:  cmSSB(); break; // switch to SSB
      
		case 13:  { // go to current band SSB default slot
					ddsLoadBandSlot(VFO,'S',Band); 
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					ddsSaveBandSlot(VFO,'L',Band);
					break;
		}
							  
		case 913: { // save active slot to current band SSB default slot 
					ddsSaveBandSlot(VFO,'S',Band);
					break;
		}

		case 19:  { // go to current band CW default slot
					ddsLoadBandSlot(VFO,'C',Band); 
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					ddsSaveBandSlot(VFO,'L',Band);
					break;
		}
							  
		case 919: { // save active slot to current band CW default slot 
					ddsSaveBandSlot(VFO,'C',Band);
					break;
		}
      
		case 22:  cmRateTuning();  break;
      
		case 23:  cmDDS23();  break; 

		case 26:  cmSoftFlywheel();  break;
			
		case 27:  cmVfoStackTune();  break;   // VFO stack tuning mode
      
		case 28:  scMute(); break;

		case 29:  cmDoDDS29();  break;
			
		case 31:  zcmUSBoffsetCal();  break;
			
		case 33:  zcmDDSclockCal();  break;          

		case 37:  zcmLSBoffsetCal();  break;
					  
		case 39:  {
					if(DDSparams.dpParamResetMode==0)
					{
						DDSparams.dpParamResetMode=1;
						strcpy(StrA,PMS(s_No_PowerOn_restore)); 
					}
					else
					{
						DDSparams.dpParamResetMode=0;
						strcpy(StrA,PMS(s_PowerOn_restore)); 
					} 
					scEEwriteDDSparams();						
					zcmConfirmDDScommand();
					_delay_ms(3000);									
					break;
		}
               
		case 41:  { // up by n kHz
					zcmUpDownkHz(fup);
					break;
		}
      
		case 43:  cmDDS43();  break; 
			
		case 44:  cmCW();  break;	// switch to CW
			
		case 47:  { // down by n kHz
					zcmUpDownkHz(fdown);
					break;
		}
      
		case 48:  cmIP3();  break; 
		  
		case 49:  {
					if(DDSparams.dp44CWmode!=3)
					{
						DDSparams.dp44CWmode=3;
					}
					else
					{
						DDSparams.dp44CWmode=2;}; 
						scEEwriteDDSparams();						
						strcpy(StrA,PMS(s_Default_CW_mode));
						strcat(StrA,pmModeName(DDSparams.dp44CWmode));
						zcmConfirmDDScommand();
						_delay_ms(3000);									
						break;
		}
			
		case 50:  {
					ddsLoadPowerOnSlot(VFO);  // to current VFO A ro B (not both)
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					strcpy(StrA,PMS(s_PowerOn_slot_t_VFO_N));
					if(VFO==0)
					{
						StrA[19]='A';
					}
					else
					{
						StrA[19]='B';
					}
					zcmConfirmDDScommand();
					_delay_ms(2000);									
					break;
		}
		
		case 55:  cmGuard();  break;

		case 56 : scScanMemStack();  break;  // 56   scan six slot of current stack
 			          
		case 58:  scWobbulator();  break; 

		case 59:  {
					dspRestoreAllBackupParams();
					strcpy(StrA,PMS(s_All_params_default));
					zcmConfirmDDScommand();
					dspLoadParams(); 
					_delay_ms(800);
					break;
		}											
			
		case 61:  {
					MemSlotNo = 0;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}
			
		case 62:  {
					MemSlotNo = 1;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}
			
		case 63:  {
					MemSlotNo = 2;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}
			
		case 64:  {
					MemSlotNo = 3;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}
			
		case 65:  {
					MemSlotNo = 4;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}
			
		case 66:  {
					MemSlotNo = 5;
					HowToShowFreq = 'V';  // vfo
					ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);
					ddsApplyVfo(VFO);
					UpdateDDS = 1;
					break;
		}

		case 67:  {
					TuningMode = 'M';
					HowToShowFreq = 'S';  // stack
					MemStackNo = 0;
					scSwitchToMemStacks();
					break;
		}
			
		case 68:  {
					TuningMode = 'M';
					HowToShowFreq = 'S';  // stack
					MemStackNo = 1;
					scSwitchToMemStacks();
					break;
		}

		case 69:  {
					TuningMode = 'M';
					HowToShowFreq = 'S';  // stack
					MemStackNo = 2;
					scSwitchToMemStacks();
					break;
		}

		case 60:  {
					TuningMode = 'M';
					HowToShowFreq = 'S';  // stack
					MemStackNo = 3;
					scSwitchToMemStacks();
					break;
		}

		case 71:  cmToggleDim(); break;

		case 72:  cmAtten();  break;

		case 73:  {
					cmDisplayOff();
					Sleeping = 1;
					//Switch of keypad LEDS hfr
					//PORTD = (PORTD && 0x7F); // removed again IJS Star6a9
					break;
		}

      	case 74:  cmToggleAutoDim(); break; 

		case 75:  cmWideBandRx(); break;

		case 76:  cmToggleDSPKeys(); break;
     	
		case 77:  cmSsbLsb();  break;
      
		case 78:  cmShowSwitchValue();  break;
      
		case 79:  cmDDS79();
		
         /////////swr  - extra to Picastar
		case 82:  swStepSwrMode();   break; // step Forward - Reflected - SWR
		case 84:  swSetSwrMode('F'); break; // Forward power display
		case 85:  swSetSwrMode('R'); break; // Reflecter power display
		case 86:  swSetSwrMode('S'); break; // SWR display

		case 81:  cmHighSideInjection();  break;			

		case 83:  {cmCopyVfo(); cmSigGenMode();  break;}

		case 87:  cmLowSideInjection();  break;
			
		case 88:  {
					f = zscKeyInFreq();
					if(f>0)
					{
						Freq = f;
						ddsFreqChange();
						if(Band!=PreviousBand)
						{
							scSetBand(); 
							PreviousBand=Band;
							_delay_ms(200);
						}
					}
					else
					{
						zddsShowBothVfoFreqs();
					}
					break;
		}
	//	case 89 {



	//	}
									
		case 140: {		// 4* Save current slot to volatile VFO stack		   
					scPushToVolatileStack();
					ltoa(VolatileCount,StrA,10);
					strcat(StrA," ");
					strcat(StrA,PMS(s_volatile_slot));
					if(VolatileCount > 1)
					{
						strcat(StrA,"s");
					}
					zcmConfirmDDScommand();
					_delay_ms(800);
					break;									
		}
      
		case 150: scABscan();  break;  // 5*   scan between vfos A and B
			
		case 160: {  // 6*  Save current slot to sticky VFO stack - overwrite oldest
		             //  Note: slots are 1- 7  (0 is power on)
					b = ddsReadOldestStickyVfoSlotNo();
					if ( (b < 1) || (b > 7) )  //  this will only happen first time the Eeprom used
					{
						b=1;
					}
					ddsSaveStickyVfoSlot(VFO,b);
					b+=1;
					if (b > 7)
					{
						b=1;
					}
					ddsWriteOldestStickyVfoSlotNo(b);
					strcpy(StrA,PMS(s_Saved_to_sticky_slot));
					zcmConfirmDDScommand();
					_delay_ms(800);
					break;									
		}

		case 950: {
					ddsSavePowerOnSlot(VFO);  // save current VFO A or B 
					strcpy(StrA,PMS(s_VFO_N_t_PowerOn_slot));
					if (VFO == 0)
					{
						StrA[4] = 'A';
					}
					else
					{
						StrA[4] = 'B';
					}
					zcmConfirmDDScommand();
					_delay_ms(800);									
					break;                  
		}
			
		case 961: {
					MemSlotNo = 0;
					scDoMemSlotSave();  // always used current MemStackNo
					break;
		}
			
		case 962: {
					MemSlotNo = 1;
					scDoMemSlotSave();
					break;
		}
			
		case 963: {
					MemSlotNo = 2;
					scDoMemSlotSave();
					break;
		}
			
		case 964: {
					MemSlotNo = 3;
					scDoMemSlotSave();
					break;
		}
			
		case 965: {
					MemSlotNo = 4;
					scDoMemSlotSave();
					break;
		}
			
		case 966: {
					MemSlotNo = 5;
					scDoMemSlotSave();
					break;
		}
		
		case 998: {
					cfInitDisplay();   // Repaint Display 
					break;
		}

		case 999: {
					cmReboot();
					break;
		}

	} // end switch
}	  

// DDS & DSP coomands removed from switch statement so can also be called by soft buttons


void cmParamStep() __attribute__((section(".highmem")));
void cmParamStep()
{
	switch (ParamColour) {
		case pgreen: cmSetYellowParams(); break;
		case pyellow: cmSetRedParams(); break;
		default: cmSetGreenParams();
	}
}


void cmSetGreenParams() __attribute__((section(".highmem")));
void cmSetGreenParams()
{
	ParamColour=pgreen; 
	ddsSaveParamColourToLast(); 
	dspSetParameterColour(); 
	strcpy(StrA,PMS(s_Green));
	strcat(StrA,PMS(s__params));
	zcmConfirmDDScommand();   
	_delay_ms(800);
	zscRestoreLeftDisplay();		
	zscShowFilter();
	if(zs) ksmRestoreMenuArea(0);
}



void cmSetYellowParams() __attribute__((section(".highmem")));
void cmSetYellowParams()
{
	ParamColour=pyellow;
	ddsSaveParamColourToLast();
	dspSetParameterColour();
	strcpy(StrA,PMS(s_Yellow));
	strcat(StrA,PMS(s__params));
	zcmConfirmDDScommand();   
	_delay_ms(800);
	zscRestoreLeftDisplay();		
	zscShowFilter();
	if(zs) ksmRestoreMenuArea(0);
}


void cmSetRedParams() __attribute__((section(".highmem")));
void cmSetRedParams()
{
	ParamColour=pred; 
	ddsSaveParamColourToLast();
	dspSetParameterColour();
	strcpy(StrA,PMS(s_Red));
	strcat(StrA,PMS(s__params));
	zcmConfirmDDScommand();  
	_delay_ms(800);
	zscRestoreLeftDisplay();		
	zscShowFilter();
	if(zs) ksmRestoreMenuArea(0);
}


void cmDefaultParams() __attribute__((section(".highmem")));
void cmDefaultParams()
{
	dspRestoreDefaultParams();
	ddsSaveParamColourToLast();
	strcpy(StrA,PMS(s_Default));
	strcat(StrA,PMS(s__params));
	zcmConfirmDDScommand();   
	_delay_ms(1000);
	zscRestoreLeftDisplay();		
	zscShowFilter();
}




void cmVfoAB() __attribute__((section(".highmem")));
void cmVfoAB()
{
  if(VFO==0){VFO=1;}else{VFO=0;};
  ddsApplyVfo(VFO); 
	UpdateDDS = 1;
	zddsShowBothVfoFreqs();
}


void cmSplit() __attribute__((section(".highmem")));
void cmSplit()
{
	if(Split==0){Split=1;}else{Split=0;};
  zddsShowBothVfoFreqs();   
}



void cmCopyVfo() __attribute__((section(".highmem")));
void cmCopyVfo()  // 0 key   -will also cancel XIT/RIT
{
  uint8_t ShowCopy = 0;
	zscRestoreLeftDisplay(); // acts on charlcd only
	zscClearTuneBox();  // acts on graphics only
	zscClearRITXITBox();
	if(XRIT()==0){ShowCopy=1;};
	Split = 0;
	XIT = 0;
	RIT = 0;
	ddsCopyVfo();
	ddsApplyVfo(VFO); 
	UpdateDDS = 1;
	zddsShowBothVfoFreqs();
  if(ShowCopy==1){zscShowVfoCopy();};
	if(zg && (RTCpos==3)) geDrawDateTime();
}


void cmToggleSwrMode() __attribute__((section(".highmem")));
void cmToggleSwrMode()
{
	swStepSwrMode();
}



void cmSSB() __attribute__((section(".highmem")));
void cmSSB()
{
	if (Band > 4) Mode = 1; else Mode = 0;
	scChangeMode();   // loads mode params using current paramcolour 
	ddsSaveModeToLast(); 
	zscShowFilter();
	zscShowSwitches();
}



void cmCW() __attribute__((section(".highmem")));
void cmCW()
{
	Mode = DDSparams.dp44CWmode; 
	scChangeMode(); 
	ddsSaveModeToLast(); 
	zscShowFilter();
	zscShowSwitches();
}


void cmToggleDSPKeys() __attribute__((section(".highmem")));
void cmToggleDSPKeys()
{
	DDSparams.dpDSPDDSKeysDisplay++;
	if (DDSparams.dpDSPDDSKeysDisplay > 3) DDSparams.dpDSPDDSKeysDisplay = 0;
	scEEwriteDDSparams();
	switch (DDSparams.dpDSPDDSKeysDisplay) {
		case 0: strcpy(StrA, PMS(s_DSPKeys_off)); zscClearDSPKeys(0); break;
		case 1: strcpy(StrA, PMS(s_DSPKeys_DDS_on)); zscClearDSPKeys(0); break;
		case 2: strcpy(StrA, PMS(s_DSPKeys_DSP_on));  zscClearDSPKeys(0); break;
		case 3: strcpy(StrA, PMS(s_DSPKeys_Both_on)); break;
	}
	zcmConfirmDDScommand();
	_delay_ms(800);								
	zscRestoreLeftDisplay();	
	xeLoadHardwareSettings();
	rtcInit(0); 
	rtcDoDateTime();	
}


void cmAtten() __attribute__((section(".highmem")));
void cmAtten()
{
  if(RFatten==1)
  {
		RFatten=0;
  	strcpy(StrA,PMS(s_RF_atten__off));
	}
	else
	{
	  RFatten=1;
  	strcpy(StrA,PMS(s_RF_atten__on));
	};
	zcmConfirmDDScommand(); 
	scSetAtten(RFatten);
	zscShowSwitches();
	_delay_ms(800);								
	zscRestoreLeftDisplay();	
	if(zs) ksmRestoreMenuArea(0);
}


void cmSsbLsb() __attribute__((section(".highmem")));
void cmSsbLsb()
{
	switch(Mode)
	{
	  case 0: Mode = 1; break;
		case 1: Mode = 0; break;
		case 2: Mode = 3; break;
		case 3: Mode = 2; break;
		default: return;
  }
//	if(Mode>=2){return;};
	if((Mode&0x01)==0)
	{strcpy(StrA,PMS(s_Toggle_to_LSB));}
	else
	{strcpy(StrA,PMS(s_Toggle_to_USB));};
	scChangeMode();   // loads mode params using current paramcolour 
	ddsSaveModeToLast(); 															
	_delay_ms(1200);
	zscRestoreLeftDisplay();		
	zscShowFilter();
	zscShowSwitches();
}


void cmIP3() __attribute__((section(".highmem")));
void cmIP3()
{
	if(IP3==1)
	{
		IP3=0;
  	strcpy(StrA,PMS(s_Best_NF_set));
	}
	else
	{
		IP3=1;
  	strcpy(StrA,PMS(s_Best_IP3_set));
	};
	scSetIP3(IP3);						
	ddsSaveIP3ToLast();
	zcmConfirmDDScommand();  
	_delay_ms(800);	
	zscRestoreLeftDisplay();
	zscDisplayIP3NF();
	if(zs) ksmRestoreMenuArea(0);
}


void cmShowSwitchValue() __attribute__((section(".highmem")));
void cmShowSwitchValue()
{
	if (DDSparams.dpDisplayKeyValue == 2) {
		DDSparams.dpDisplayKeyValue = 0;
		strcpy(StrA,PMS(s_SwitchCode_off));
	} else {
		if (DDSparams.dpDisplayKeyValue == 1) {
			DDSparams.dpDisplayKeyValue = 2;
			strcpy(StrA,PMS(s_RawSwitchCode_on));
		} else {
			DDSparams.dpDisplayKeyValue = 1;
			strcpy(StrA,PMS(s_SwitchCode_on));
		}
	}
	scEEwriteDDSparams();						
	zcmConfirmDDScommand();  
	_delay_ms(800);	
	zscRestoreLeftDisplay();
}


void cmDDS43() __attribute__((section(".highmem")));
void cmDDS43()
{
	if(DDS43==1)
  {
		DDS43=0;
  	strcpy(StrA,PMS(s_DDS43_switch_off));
	}
	else
	{
		DDS43=1;
  	strcpy(StrA,PMS(s_DDS43_switch_on));
	};
	scSetDDS43(DDS43);						
	zcmConfirmDDScommand();  
	_delay_ms(800);									
	zscRestoreLeftDisplay();											
}



void cmDDS23() __attribute__((section(".highmem")));
void cmDDS23()
{
	if(DDS23==1)
	{
    DDS23=0;
  	strcpy(StrA,PMS(s_DDS23_switch_off));
	}
  else
	{
		DDS23=1;
  	strcpy(StrA,PMS(s_DDS23_switch_on));
	};
	scSetDDS23(DDS23);						
	zcmConfirmDDScommand();   
	_delay_ms(800);
	zscRestoreLeftDisplay();											
}

void cmSoftFlywheel() __attribute__((section(".highmem")));
void cmSoftFlywheel()
{
  if(DDSparams.dpSoftwareFlywheel==1)
	{
		DDSparams.dpSoftwareFlywheel=0;
  	strcpy(StrA,PMS(s_Flywheel_off));
	}
	else
	{
		DDSparams.dpSoftwareFlywheel=1;
  	strcpy(StrA,PMS(s_Flywheel_on));
	};
	scEEwriteDDSparams();						
	zcmConfirmDDScommand(); 
	_delay_ms(800);									
	zscRestoreLeftDisplay();											
}


void cmBandUp() __attribute__((section(".highmem")));
void cmBandUp()
{
	Band++;
	if (Band == 2) Band = 3; // skip 60m HFR ONLY
	if (Band > 9) Band = 0;
	_delay_ms(300);
	scBandChanged();
}


void cmBandDown() __attribute__((section(".highmem")));
void cmBandDown()
{
	if (Band > 0) Band--; else Band = 9;
	if (Band == 2) Band = 1; // skip 60m  HFR ONLY
	_delay_ms(300); 
	scBandChanged();
}


void cmDisplayOff() __attribute__((section(".highmem")));
void cmDisplayOff()
{
	scSetDisplayLEDPWM(0); 
}


void cmDisplayBright() __attribute__((section(".highmem")));
void cmDisplayBright()
{
  scSetDisplayLEDPWM(DDSparams.dpDisplayBright);


PORTD = PORTD | (1 << 7); //Keypad LEDS 
}


void cmDisplayDim() __attribute__((section(".highmem")));
void cmDisplayDim()
{
  scSetDisplayLEDPWM(DDSparams.dpDisplayDimmed);
}


void cmTuneLock() __attribute__((section(".highmem")));
void cmTuneLock()
{
	if (LockTuning) {
		LockTuning = 0;
  		strcpy(StrA,PMS(s_Tune_lock_off));
	} else {
		LockTuning = 1;
  		strcpy(StrA,PMS(s_Tune_lock_on));
	}
	zcmConfirmDDScommand(); 
	_delay_ms(800);	
	zscRestoreLeftDisplay();											
}								


void cmToggleAutoDim() __attribute__((section(".highmem")));
void cmToggleAutoDim()
{
	if (DDSparams.dpAutoDim == 1)
	{
		DDSparams.dpAutoDim = 0;
  		strcpy(StrA,PMS(s_Auto_dim_off));
	}
	else
	{
		DDSparams.dpAutoDim = 1;
  		strcpy(StrA,PMS(s_Auto_dim_on));
	}
	scEEwriteDDSparams();
	zcmConfirmDDScommand(); 
	_delay_ms(800);	
	zscRestoreLeftDisplay();											
}								


void cmToggleDim() __attribute__((section(".highmem")));
void cmToggleDim()
{
	if (Dimm == 1)
	{
		Dimm = 0;
		AutoDimmed = 1;
		scWakeupDisplay();
  		strcpy(StrA,PMS(s_Dim_off));
	}
	else
	{
		Dimm = 1;
		cmDisplayDim();
  		strcpy(StrA,PMS(s_Dim_on));
	}
	zcmConfirmDDScommand(); 
	_delay_ms(800);	
	zscRestoreLeftDisplay();											
}								


void cmRateTuning() __attribute__((section(".highmem")));
void cmRateTuning()
{  
  if(zs) ksmClearDateTime();
	HowToShowFreq = 'V';
	TuningMode = 'R';
	SweepDir = 0;  // no intial sweeping
	RateTuningIndex = 0; 
  zscShowRateTuning();
	zscShowRateTuningRate();
}


void cmEsc() __attribute__((section(".highmem")));
void cmEsc()
{
	if (zs) {ksClearFreqInfo(); ksmDrawDateTime();};
	if (zt) etDeleteTuneBox();
	zddsShowBothVfoFreqs();
	if(!SigGenMode) zcmShowSplitMode();
	zscShowFilter();        // in case changed by encoder filter setting
	zscShowDSPKeys(); // in case prior scanning where no DSP key display
  if(zg && (RTCpos==3)) geDrawDateTime();
}


void cmRIT() __attribute__((section(".highmem")));
void cmRIT()    // # key
{
	if(SigGenMode) return;
	if(XRIT()==0)
	{
		if(RTCpos==3) geClearParamBox();  // EA320 only
		ddsCopyVfo();
		RITfreq = VfoSlot[0].stFreq;
		StartRITTxFreq = VfoSlot[0].stFreq;
		VFO = 0;
		Split=1;
		RIT = 1;
	}
	else
	{
		if(RIT==1)
		{
			uint8_t Vy;
			if(VFO==1){Vy=0;}else{Vy=1;};
			if(Split==0)
			{
				Freq = RITfreq;
				VfoSlot[VFO].stFreq = Freq;
				Split=1;
			}
			else
			{
				Split=0;
				RITfreq = Freq; 
				Freq = VfoSlot[Vy].stFreq;
				VfoSlot[VFO].stFreq= Freq;
				StartRITTxFreq = Freq;
			};
		}
  }
  ddsApplyVfo(VFO);
	UpdateDDS = 1;
	zddsShowBothVfoFreqs();   
	zcmShowSplitMode(); 
}

		
void cmCancelRITXIT() __attribute__((section(".highmem")));
void cmCancelRITXIT()
{
	if(SigGenMode) return;
	Split=0;
	XIT = 0;
	RIT = 0;
	ABdiff = 0;
	TxXITtune = 0;
  zddsShowBothVfoFreqs();
	zcmShowSplitMode(); 
	if(zg && (RTCpos==3)) geDrawDateTime();
}



void cmXIT() __attribute__((section(".highmem")));
void cmXIT()
{
	if(SigGenMode) return;
  if(RTCpos==3) geClearParamBox();  // EA320 only
  XIT = 1;
	RIT = 0;
  ddsCopyVfo();
	VFO=0;
	TxFreq=ddsGetVfoFreq(1);
	Split=1;
	zddsShowABdifference();               
  XIT = 1;
	TxXITtune = 1;
	ddsSetFreq();  // IJS 11.10.2009
	zcmShowSplitMode();
}


void cmABdiff() __attribute__((section(".highmem")));
void cmABdiff()   // holding 0 key
{
  BlockEncoderTuning = 1;
	ABdiff=1;
  zddsShowABdifference();
}



void cmReboot() __attribute__((section(".highmem")));
void cmReboot()
{
	cli();
	_delay_ms(200);
  	WDTCSR = ((1 << WDCE) | (1 <<WDE));  // watchdog on
	WDTCSR = (1 <<WDE);  
	sei();
	while (1) {};
}
  



void cmSigGenMode() __attribute__((section(".highmem")));
void cmSigGenMode()
{
	if (SigGenMode == 1) {
		SigGenMode = 0;
 	 	strcpy(StrA, PMS(s_Sig_gen_mode_off));
	} else {
		SigGenMode = 1;
 	 	strcpy(StrA, PMS(s_Sig_gen_mode_on));
	}
	ddsSetFreq();
	zcmDisplaySigGenModeIndicator();
	zcmConfirmDDScommand();
	_delay_ms(800);	
	zscRestoreLeftDisplay();											
}



void cmLowSideInjection() __attribute__((section(".highmem")));
void cmLowSideInjection()
{
  LowSideInjection = 1;
  scChangeMode();
	strcpy(StrA,PMS(s_Low_side_injection));
  zcmConfirmDDScommand();
	_delay_ms(800);
	zscRestoreLeftDisplay();		
}



void cmHighSideInjection() __attribute__((section(".highmem")));
void cmHighSideInjection()
{
  LowSideInjection = 0;
	scChangeMode();
	strcpy(StrA,PMS(s_High_side_injection));
  zcmConfirmDDScommand();
	_delay_ms(800);
	zscRestoreLeftDisplay();		
}


void cmGuard() __attribute__((section(".highmem")));
void cmGuard()
{
	if(XRIT() | SigGenMode) return;
	if(zs) ksmClearDateTime();
	Split = 0;
	Guarding = 1;  //  switch to other VFO for 2 sec every 20sec
	HowToShowFreq = 'V';
	MainChannel = VFO;
	if(MainChannel==1){GuardChannel=0;}else{GuardChannel=1;};
	zddsShowBothVfoFreqs();
  zcmDisplayGuarding();
}




void cmVfoStackTune() __attribute__((section(".highmem")));
void cmVfoStackTune()
{
	if(XRIT() | SigGenMode) return;
  if(zs) ksmClearDateTime();
	HowToShowFreq = 'S'; //stack
	TuningMode = 'V';  // VFO stack tuning mode
	zscShowVfoStackMode();
	zcmDisplayVfoStackTuning();
	scPushToVolatileStack();
	StickyVolatile='V';
  VfoSlotNo=VolatileSP;  // last to be added
  ddsApplyVfo(VFO);
  UpdateDDS = 1;
  Encoder4count = 0;
}


void cmWideBandRx() __attribute__((section(".highmem")));
void cmWideBandRx()
{
	if (DDS79 == 1) {
		DDS79 = 0;
		WideBand = 0;
		strcpy(StrA, PMS(s_PG2_and_wide_Rx_off));
	} else {
		if (WideBand == 1) {
			WideBand = 0;
			strcpy(StrA, PMS(s_PG2_and_wide_Rx_off));
		} else {
			WideBand = 1;
			strcpy(StrA, PMS(s_PG2_and_wide_Rx_on));
		}
	}
	cmDoDDS79WideBand();
	zcmConfirmDDScommand();
	_delay_ms(800);
	zscRestoreLeftDisplay();		
}


void cmDDS79() __attribute__((section(".highmem")));
void cmDDS79()
{
	if (WideBand == 1) {
		DDS79 = 0;
		WideBand = 0;
		strcpy(StrA, PMS(s_PG2_and_wide_Rx_off));
	} else {
		if (DDS79 == 1) {
			DDS79 = 0;
			strcpy(StrA, PMS(s_PortG_bit_2_off));
		} else {
			DDS79 = 1; 
			strcpy(StrA, PMS(s_PortG_bit_2_on));
		}
	}
	cmDoDDS79WideBand();
	zcmConfirmDDScommand();
	_delay_ms(800);
	zscRestoreLeftDisplay();		
}


void cmDoDDS79WideBand() __attribute__((section(".highmem")));
void cmDoDDS79WideBand()
{
	scSetBand();
	if (WideBand == 1) scPaBias(0); else scPaBias(1);
	if ((WideBand == 1) || (DDS79 == 1)) {
		portDDS79 |= (1 << bitDDS79);
	} else {
		portDDS79 &= ~(1 << bitDDS79);
	}

	scSetDDS79((WideBand == 1) || (DDS79 == 1));

}


void cmDoDDS29() __attribute__((section(".highmem")));
void cmDoDDS29()
{
rx2 =! rx2; // toggle 2ND monitor display //hfr
}
