/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taButtons.c  Soft defined buttons module program file


*/


#include "taGlobal.h"
#include "taEncoder.h"
#include "taStarDSP.h"
#include "taCharLCD.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taGlobal.h"
#include "taSWR.h"
#include "taDDS.h"
#include "taStarDSP.h"
#include "taMenus.h"
#include "taDebug.h"
#include "taButtons.h"
#include "taDDScommands.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taEATFTmenus.h"
#include "taEATFT.h"
#include "taEATFTcommands.h"
#include "taScroll.h"
#include "taUsart.h"
#include "taMenus.h"
#include "taKS0108Menus.h"
#include "taI2C.h"
#include "taGraphicsControl.h"


// noofButtons defined in taGlobal.h

uint8_t RxButtonAssignments[noofButtons];  //  Rx soft-labelled button tasks
uint8_t TxButtonAssignments[noofButtons];   // Tx soft-labelled button tasks

// noofTPButtons defined in taGlobal.h

uint8_t RxTouchpadAssignments[noofTPButtons];  //  Rx touch pad button tasks
uint8_t TxTouchpadAssignments[noofTPButtons];   // Tx touch pad button tasks

uint8_t ButtonMode;
static uint8_t LastButton;

void buNotAssigned();
void buCopyVfo();
void buVfoAB();
void buSplit();
void buRIT();
void buSSB();
void buCW();
void buModeStep();
void buSsbLsb();
void buAtten();
void buScanBank();
void buScanAB();
void buParamStep();
void buGreen();
void buYellow();
void buRed();
void buDefaultParams();
void buDenoise();
void buMute();
void buNoiseBlank();
void buAutoNotch();
void buManNotch();
void buWideNarrow();
void buVox();
void buComp();
void buForward();
void buReflected();
void buSWR();
void buIP3();
void buSoftFlywheel();
void buDDS23();
void buDDS43();
void buBandUp();
void buBandDown();
void buSWRtoggle();
void buXIT();
void buRIT();
void buSleep();
void buDim();
void buWobbulator();
void buRateTune();
void buSigGen();
void buGuardChannel();
void buMemStackScan();
void buVfoStackTune();
void buVfoABscan();
void buDDS79();
void buWideBandRx();
void buEncAssign();
void buMemStack67();
void buMemStack68();
void buMemStack69();
void buMemStack60();
void buMemStackTune67();
void buMemStackTune68();
void buMemStackTune69();
void buMemStackTune60();
void buMemSlot61();
void buMemSlot62();
void buMemSlot63();
void buMemSlot64();
void buMemSlot65();
void buMemSlot66();
void buMemStack67Tune();
void buMemStack68Tune();
void buMemStack69Tune();
void buMemStack60Tune();
void buDSPDDSKeys();
void buAutoDim();
void buI2C1();
void buI2C2();
void buI2C3();
void buI2C4();
void buI2C5();
void buI2C6();
void buI2C7();
void buI2C8();
void buPA3AKE_Roofer();
void buPA3AKE_AttenIncrease();
void buPA3AKE_AttenDecrease();
void buTuneLock();
void buCWQRO();
void buCWQRP();
void buCWQROQRP();

// Button information routines which return a string for the second line
// of the button.
//  pmdButtonHasMsgList must be or'ed with 0x02 or 0x08
char* OnOff(uint8_t n);
char* biAtten();						//  9 buAtten
char* biSoftFlywheel();					// 29 buSoftFlywheel
char* biDDS23();						// 30 buDDS23
char* biDDS43();						// 21 buDDS43
char* biDDS79();						// 46 buDDS79
char* biWideBandRx();					// 47 buDDS75
char* biWobbulator();					// 38 buWobbulator
char* biAutoDim();						// 64 buAutoDim
char* biPA3AKE_Roofer();  				// 73 buPA3AKE_Roofer
char* biPA3AKE_AttenIncrease();			// 74 buPA3AKE_AttenIncrease
char* biPA3AKE_AttenDecrease();			// 75 buPA3AKE_AttenDecrease
char* biTuneLock();						// 76 buTuneLock

char* biI2C1();
char* biI2C2();
char* biI2C3();
char* biI2C4();
char* biI2C5();
char* biI2C6();
char* biI2C7();
char* biI2C8();

void buParamsRedraw();
void buStackTune();
void buGotoSlot();

// nooftasks is defined in taGlobal.h
// pmdTaskNameList & pmdTaskLabelList defined in taMsg

// table of pointers to subroutines
const void* const pmdTaskPointerList[nooftasks] PROGMEM = {
	buNotAssigned,				//    0 buNotAssigned
	buCopyVfo,					//    1 buCopyVfo
	buVfoAB,					//    2 buVfoAB
	buSplit,					//    3 buSplit
	buRIT,						//    4 buRIT
	buSSB,						//    5 buSSB
	buCW,						//    6 buCW
	buModeStep,					//    7 buModeStep
	buSsbLsb,					//    8 buSsbLsb
	buAtten,					//    9 buAtten
	buScanBank,					//   10 buScanBank
	buScanAB,					//   11 buScanAB
	buGreen,					//   12 buGreen
	buYellow,					//   13 buYellow
	buRed,						//   14 buRed
	buDefaultParams,			//   15 buDefaultParams 
	buDenoise,					//   16 buDenoise
	buMute,						//   17 buMute
	buNoiseBlank,				//   18 buNoiseBlank
	buAutoNotch,				//   19 nbuAutoNotch
	buManNotch,					//   20 buManNotch
	buWideNarrow,				//   21 buWideNarrow
	buVox,						//   22 buVox
	buComp,						//   23 buComp
	buForward,					//   24 buForward
	buReflected,				//   25 buReflected
	buSWR,						//   26 buSWR
	buSWRtoggle,				//   27 buSWRtoggle
	buIP3,						//   28 buIP3
	buSoftFlywheel,				//   29 buSoftFlywheel
	buDDS23,					//   30 buDDS23
	buDDS43,					//   31 buDDS43
	buParamStep,				//   32 buParamStep
	buBandUp,					//   33 buBandUp
	buBandDown,					//   34 buBandDown
	buXIT,						//   35 buXIT
	buRIT,						//   36 buRIT
	buSleep,					//   37 buSleep
	buDim,						//   38 buDim
	buWobbulator,				//   39 buWobbulator
	buRateTune,					//   40 buRateTune
	buSigGen,					//   41 buSigGen
	buGuardChannel,				//   42 buGuardChannel
	buMemStackScan,				//   43 buMemStackScan
	buVfoStackTune,				//   44 buVfoStackTune
	buVfoABscan,				//   45 buVfoABscan
	buDDS79,					//   46 buDDS79
	buWideBandRx,				//   47 buWideBandRx
	buEncAssign,				//   48 buEncAssign
	buMemStack67,				//	 49 buMemStack67
	buMemStack68,				//	 50 buMemStack68
	buMemStack69,				//	 51 buMemStack69
	buMemStack60,				// 	 52 buMemStack60
	buMemSlot61,				//	 53 buMemSlot61
	buMemSlot62,				//	 54 buMemSlot62
	buMemSlot63,				// 	 55 buMemSlot63
	buMemSlot64,				//	 56 buMemSlot64
	buMemSlot65,				//	 57 buMemSlot65
	buMemSlot66,				//	 58 buMemSlot66
	buMemStack67Tune,			//	 59 buMemStack67Tune
	buMemStack68Tune,			//	 60 buMemStack68Tune
	buMemStack69Tune,			//	 61 buMemStack69Tune
	buMemStack60Tune,			// 	 62 buMemStack60Tune
	buDSPDDSKeys,				//   63 buDSPDDSKeys
	buAutoDim,					//   64 buAutoDim
	buI2C1,						//   65 I2C task 1
	buI2C2,						//   66 I2C task 2
	buI2C3,						//   67 I2C task 3
	buI2C4,						//   68 I2C task 4
	buI2C5,						//   69 I2C task 5
	buI2C6,						//   70 I2C task 6
	buI2C7,						//   71 I2C task 7
	buI2C8,						//   72 I2C task 8
	buPA3AKE_Roofer,			//   73 buPA3AKE_Roofer
	buPA3AKE_AttenIncrease,		//   74 buPA3AKE_AttenIncrease
	buPA3AKE_AttenDecrease,		//   75 buPA3AKE_AttenDecrease
	buTuneLock,					//   76 buTuneLock
	buCWQRO,						//	77 buCWQRO
	buCWQRP,						// 78 buCWQRP
	buCWQROQRP,					// 79 buCWQROQRP
};

// table of pointers to subroutines
// which return an information string for the second line of the button
const void* const pmdButtonInfoPointerList[nooftasks] PROGMEM = {
	0,							//    0 buNotAssigned
	0,							//    1 buCopyVfo
	0,							//    2 buVfoAB
	0,							//    3 buSplit
	0,							//    4 buRIT
	0,							//    5 buSSB
	0,							//    6 buCW
	0,							//    7 buModeStep
	0,							//    8 buSsbLsb
	biAtten,					//    9 buAtten
	0,							//   10 buScanBank
	0,							//   11 buScanAB
	0,							//   12 buGreen
	0,							//   13 buYellow
	0,							//   14 buRed
	0,							//   15 buDefaultParams 
	0,							//   16 buDenoise
	0,							//   17 buMute
	0,							//   18 buNoiseBlank
	0,							//   19 nbuAutoNotch
	0,							//   20 buManNotch
	0,							//   21 buWideNarrow
	0,							//   22 buVox
	0,							//   23 buComp
	0,							//   24 buForward
	0,							//   25 buReflected
	0,							//   26 buSWR
	0,        					//   27 buSWRtoggle
	0,							//   28 buIP3
	biSoftFlywheel,				//   29 buSoftFlywheel
	biDDS23,					//   30 buDDS23
	biDDS43,					//   31 buDDS43
	0,							//   32 buParamStep
	0,							//   33 buBandUp
	0,							//   34 buBandDown
	0,							//   35 buXIT
	0,							//   36 buRIT
	0,							//   37 buSleep
	0,							//   38 buDim
	biWobbulator,				//   39 buWobbulator
	0,							//   40 buRateTune
	0,							//   41 buSigGen
	0,							//   42 buGuardChannel
	0,							//   43 buMemStackScan
	0,							//   44 buVfoStackTune
	0,							//   45 buVfoABscan
	biDDS79,					//   46 buDDS79
	biWideBandRx,				//   47 buWideBandRx
	0,							//   48 buEncAssign
	0,							//	 49 buMemStack67
	0,							//	 50 buMemStack68
	0,							//	 51 buMemStack69
	0,							// 	 52 buMemStack60
	0,							//	 53 buMemSlot61
	0,							//	 54 buMemSlot62
	0,							// 	 55 buMemSlot63
	0,							//	 56 buMemSlot64
	0,							//	 57 buMemSlot65
	0,							//	 58 buMemSlot66
	0,							//	 59 buMemStack67Tune
	0,							//	 60 buMemStack68Tune
	0,							//	 61 buMemStack69Tune
	0,							// 	 62 buMemStack60Tune
	0,							//   63 buDSPDDSKeys
	biAutoDim,					//   64 buAutoDim
	biI2C1,						//   65 I2C task 1
	biI2C2,						//   66 I2C task 2
	biI2C3,						//   67 I2C task 3
	biI2C4,						//   68 I2C task 4
	biI2C5,						//   69 I2C task 5
	biI2C6,						//   70 I2C task 6
	biI2C7,						//   71 I2C task 7
	biI2C8,						//   72 I2C task 8
	biPA3AKE_Roofer,  			//   73 buPA3AKE_Roofer
	biPA3AKE_AttenIncrease,		//   74 buPA3AKE_AttenIncrease
	biPA3AKE_AttenDecrease,		//   75 buPA3AKE_AttenDecrease
	biTuneLock,					//   76 buTuneLock
	0,									//   77 buCWQRO
	0,									//   78 buCWQRP
	0,									//   79 buCWQROQRP
};

// table of button message indicators
//	0x01 - Message to be displayed
//	0x02 - Button info on 2nd line and redraw button after task
//	0x04 - Step task labelling
//	0x08 - Redraw button after task
//
const uint8_t pmdButtonHasMsgList[nooftasks] PROGMEM = {
		0,	//    0 buNotAssigned
		0,	//    1 buCopyVfo
		0,	//    2 buVfoAB
		0,	//    3 buSplit
		0,	//    4 buRIT
		0,	//    5 buSSB
		0,	//    6 buCW
		0,	//    7 buModeStep
		0,	//    8 buSsbLsb
		3,	//    9 buAtten
		0,	//   10 buScanBank
		0,	//   11 buScanAB
		9,	//   12 buGreen
		9,	//   13 buYellow
		9,	//   14 buRed
		1,	//   15 buDefaultParams 
		0,	//   16 buDenoise
		0,	//   17 buMute
		0,	//   18 buNoiseBlank
		0,	//   19 nbuAutoNotch
		0,	//   20 buManNotch
		0,	//   21 buWideNarrow
		0,	//   22 buVox
		0,	//   23 buComp
		0,	//   24 buForward
		0,	//   25 buReflected
		0,	//   26 buSWR
		0,	//   27 buSWRtoggle
		1,	//   28 buIP3
		3,	//   29 buSoftFlywheel
		3,	//   30 buDDS23
		3,	//   31 buDDS43
		9,	//   32 buParamStep
		0,	//   33 buBandUp
		0,	//   34 buBandDown
		0,	//   35 buXIT
		0,	//   36 buRIT
		1,	//   37 buSleep
		1,	//   38 buDim
		2,	//   39 buWobbulator
		0,	//   40 buRateTune
		1,	//   41 buSigGen
		0,	//   42 buGuardChannel
		0,	//   43 buMemStackScan
		0,	//   44 buVfoStackTune
		0,	//   45 buVfoABscan
		3,  //   46 buDDS79
		3,  //   47 buWideBandRx
		0,  //   48 buEncAssign
		0,	//	 49 buMemStack67
		0,	//	 50 buMemStack68
		0,	//	 51 buMemStack69
		0,	// 	 52 buMemStack60
		0,	//	 53 buMemSlot61
		0,	//	 54 buMemSlot62
		0,	// 	 55 buMemSlot63
		0,	//	 56 buMemSlot64
		0,	//	 57 buMemSlot65
		0,	//	 58 buMemSlot66
		0,	//	 59 buMemStack67Tune
		0,	//	 60 buMemStack68Tune
		0,	//	 61 buMemStack69Tune
		0,	// 	 62 buMemStack60Tune
		1,  //   63 buDSPDDSKeys
		3,	//   64 buAutoDim
		4,  //   65 buI2C1    - bit 2 = PCA9555 task 
		4,  //   66 buI2C2
		4,  //   67 buI2C3
		4,  //   68 buI2C4
		4,  //   69 buI2C5
		4,  //   70 buI2C6
		4,  //   71 buI2C7
		4,  //   72 buI2C8
		2,  //   73 buPA3AKE roofer
		2,  //   74 buPA3AKE_AttenIncrease
		2,  //   75 buPA3AKE_AttenDecrease
		3,  //   76 buTuneLock
		0,	//   77 buCWQRO
		0,	//	 78 buCWQRP
		0,	//	 79 buCWQROQRP
};

// table of button message pairs
const uint8_t pmdButtonPairsList[nooftasks] PROGMEM = {
		0,	//    0 buNotAssigned
		0,	//    1 buCopyVfo
		0,	//    2 buVfoAB
		0,	//    3 buSplit
		0,	//    4 buRIT
		0,	//    5 buSSB
		0,	//    6 buCW
		0,	//    7 buModeStep
		0,	//    8 buSsbLsb
		0,	//    9 buAtten
		0,	//   10 buScanBank
		0,	//   11 buScanAB
		0,	//   12 buGreen
		0,	//   13 buYellow
		0,	//   14 buRed
		0,	//   15 buDefaultParams 
		0,	//   16 buDenoise
		0,	//   17 buMute
		0,	//   18 buNoiseBlank
		0,	//   19 nbuAutoNotch
		0,	//   20 buManNotch
		0,	//   21 buWideNarrow
		0,	//   22 buVox
		0,	//   23 buComp
		0,	//   24 buForward
		0,	//   25 buReflected
		0,	//   26 buSWR
		0,	//   27 buSWRtoggle
		0,	//   28 buIP3
		0,	//   29 buSoftFlywheel
		0,	//   30 buDDS23
		0,	//   31 buDDS43
		0,	//   32 buParamStep
		0,	//   33 buBandUp
		0,	//   34 buBandDown
		0,	//   35 buXIT
		0,	//   36 buRIT
		0,	//   37 buSleep
		0,	//   38 buDim
		0,	//   39 buWobbulator
		0,	//   40 buRateTune
		0,	//   41 buSigGen
		0,	//   42 buGuardChannel
		0,	//   43 buMemStackScan
		0,	//   44 buVfoStackTune
		0,	//   45 buVfoABscan
		0,  //   46 buDDS79
		0,  //   47 buWideBandRx
		0,  //   48 buEncAssign
		0,	//	 49 buMemStack67
		0,	//	 50 buMemStack68
		0,	//	 51 buMemStack69
		0,	// 	 52 buMemStack60
		0,	//	 53 buMemSlot61
		0,	//	 54 buMemSlot62
		0,	// 	 55 buMemSlot63
		0,	//	 56 buMemSlot64
		0,	//	 57 buMemSlot65
		0,	//	 58 buMemSlot66
		0,	//	 59 buMemStack67Tune
		0,	//	 60 buMemStack68Tune
		0,	//	 61 buMemStack69Tune
		0,	// 	 62 buMemStack60Tune
		0,  //   63 buDSPDDSKeys
		0,	//   64 buAutoDim
		0,  //   65 buI2C1
		0,  //   66 buI2C2
		0,  //   67 buI2C3
		0,  //   68 buI2C4
		0,  //   69 buI2C5
		0,  //   70 buI2C6
		0,  //   71 buI2C7
		0,  //   72 buI2C8
		0,  //   73 buPA3AKE roofer
		75, //   74 buPA3AKE_AttenIncrease
		74, //   75 buPA3AKE_AttenDecrease
		0,  //   76 buTuneLock
		0,	//   77 buCWQRO
		0,	//	 78 buCWQRPQRP
		0,	//   79 buCWQROQRP
};

// table of button colours
const uint8_t pmdButtonColourList[nooftasks][2] PROGMEM = {
		{ 6,17},	//    0 buNotAssigned
		{ 6,17},	//    1 buCopyVfo
		{ 6,17},	//    2 buVfoAB
		{ 6,17},	//    3 buSplit
		{ 6,17},	//    4 buRIT
		{14,21},	//    5 buSSB
		{14,21},	//    6 buCW
		{14,21},	//    7 buModeStep
		{14,21},	//    8 buSsbLsb
		{ 6,17},	//    9 buAtten
		{ 6,17},	//   10 buScanBank
		{ 6,17},	//   11 buScanAB
		{ 8,18},	//   12 buGreen
		{ 8,19},	//   13 buYellow
		{ 8,20},	//   14 buRed
		{14,21},	//   15 buDefaultParams 
		{14,21},	//   16 buDenoise
		{14,21},	//   17 buMute
		{14,21},	//   18 buNoiseBlank
		{14,21},	//   19 nbuAutoNotch
		{14,21},	//   20 buManNotch
		{14,21},	//   21 buWideNarrow
		{14,21},	//   22 buVox
		{14,21},	//   23 buComp
		{ 6,17},	//   24 buForward
		{ 6,17},	//   25 buReflected
		{ 6,17},	//   26 buSWR
		{ 6,17},	//   27 buSWRtoggle
		{ 6,17},	//   28 buIP3
		{ 6,17},	//   29 buSoftFlywheel
		{ 6,17},	//   30 buDDS23
		{ 6,17},	//   31 buDDS43
		{ 8,18},	//   32 buParamStep
		{ 6,17},	//   33 buBandUp
		{ 6,17},	//   34 buBandDown
		{ 6,17},	//   35 buXIT
		{ 6,17},	//   36 buRIT
		{ 7,21},	//   37 buSleep
		{ 7,21},	//   38 buDim
		{ 6,17},	//   39 buWobbulator
		{ 6,17},	//   40 buRateTune
		{ 6,17},	//   41 buSigGen
		{ 6,17},	//   42 buGuardChannel
		{ 6,17},	//   43 buMemStackScan
		{ 6,17},	//   44 buVfoStackTune
		{ 6,17},	//   45 buVfoABscan
		{ 6,17},	//   46 buDDS79
		{ 6,17},	//   47 buWideBandRx
		{ 7,21},	//   48 buEncAssign
		{ 7,22},	//	 49 buMemStack67
		{ 7,22},	//	 50 buMemStack68
		{ 7,22},	//	 51 buMemStack69
		{ 7,22},	// 	 52 buMemStack60
		{ 7,22},	//	 53 buMemSlot61
		{ 7,22},	//	 54 buMemSlot62
		{ 7,22},	// 	 55 buMemSlot63
		{ 7,22},	//	 56 buMemSlot64
		{ 7,22},	//	 57 buMemSlot65
		{ 7,22},	//	 58 buMemSlot66
		{ 7,22},	//	 59 buMemStack67Tune
		{ 7,22},	//	 60 buMemStack68Tune
		{ 7,22},	//	 61 buMemStack69Tune
		{ 7,22},	// 	 62 buMemStack60Tune
		{ 7,21},	//   63 buDSPDDSKeys
		{ 7,21},	//   64 buAutoDim
		{ 7,21},	//   65 buI2C1
		{ 7,21},	//   66 buI2C2
		{ 7,21},	//   67 buI2C3
		{ 7,21},	//   68 buI2C4
		{ 7,21},	//   69 buI2C5
		{ 7,21},	//   70 buI2C6
		{ 7,21},	//   71 buI2C7
		{ 7,21},	//   72 buI2C8
		{ 7,21},	//   73 buPA3AKE_Roofer
		{ 7,21},	//   74 buPA3AKE_AttenIncrease
		{ 7,21},	//   75 buPA3AKE_AttenDecrease
		{ 7,21},	//   76 buTuneLock
		{14,21},	//   77 buCWQRO
		{14,21},	//   78 buCWQRP
		{14,21},	//   79 buCWQROQRP						
};

// table of Rx, TX allowed
const uint8_t pmdRxTxAllowed[nooftasks][2] PROGMEM = {
		{1,1},	//    0 buNotAssigned
		{1,1},	//    1 buCopyVfo
		{1,1},	//    2 buVfoAB
		{1,1},	//    3 buSplit
		{1,1},	//    4 buRIT
		{1,1},	//    5 buSSB
		{1,1},	//    6 buCW
		{1,1},	//    7 buModeStep
		{1,1},	//    8 buSsbLsb
		{1,1},	//    9 buAtten
		{1,1},	//   10 buScanBank
		{1,1},	//   11 buScanAB
		{1,1},	//   12 buGreen
		{1,1},	//   13 buYellow
		{1,1},	//   14 buRed
		{1,1},	//   15 buDefaultParams 
		{1,1},	//   16 buDenoise
		{1,1},	//   17 buMute
		{1,1},	//   18 buNoiseBlank
		{1,1},	//   19 nbuAutoNotch
		{1,1},	//   20 buManNotch
		{1,1},	//   21 buWideNarrow
		{1,1},	//   22 buVox
		{1,1},	//   23 buComp
		{1,1},	//   24 buForward
		{1,1},	//   25 buReflected
		{1,1},	//   26 buSWR
		{1,1},	//   27 buSWRtoggle
		{1,1},	//   28 buIP3
		{1,1},	//   29 buSoftFlywheel
		{1,1},	//   30 buDDS23
		{1,1},	//   31 buDDS43
		{1,1},	//   32 buParamStep
		{1,1},	//   33 buBandUp
		{1,1},	//   34 buBandDown
		{1,1},	//   35 buXIT
		{1,1},	//   36 buRIT
		{1,1},	//   37 buSleep
		{1,1},	//   38 buDim
		{1,0},	//   39 buWobbulator
		{1,1},	//   40 buRateTune
		{1,1},	//   41 buSigGen
		{1,1},	//   42 buGuardChannel
		{1,1},	//   43 buMemStackScan
		{1,1},	//   44 buVfoStackTune
		{1,1},	//   45 buVfoABscan
		{1,1},  //   46 buDDS79
		{1,0},  //   47 buWideBandRx
		{1,1},  //   48 buEncAssign
		{1,0},	//	 49 buMemStack67
		{1,0},	//	 50 buMemStack68
		{1,0},	//	 51 buMemStack69
		{1,0},	// 	 52 buMemStack60
		{1,0},	//	 53 buMemSlot61
		{1,0},	//	 54 buMemSlot62
		{1,0},	// 	 55 buMemSlot63
		{1,0},	//	 56 buMemSlot64
		{1,0},	//	 57 buMemSlot65
		{1,0},	//	 58 buMemSlot66
		{1,0},	//	 59 buMemStack67Tune
		{1,0},	//	 60 buMemStack68Tune
		{1,0},	//	 61 buMemStack69Tune
		{1,0}, 	// 	 62 buMemStack60Tune
		{1,1},  //   63 buDSPDDSKeys
		{1,1},	//   64 buAutoDim
		{1,1},  //   65 buI2C1
		{1,1},  //   66 buI2C2
		{1,1},  //   67 buI2C3
		{1,1},  //   68 buI2C4
		{1,1},  //   69 buI2C5
		{1,1},  //   70 buI2C6
		{1,1},  //   71 buI2C7
		{1,1},  //   72 buI2C8
		{1,0},  //   73 buPA3AKE_Roofer
		{1,0},  //   74 buPA3AKE_AttenIncrease
		{1,0},  //   75 buPA3AKE_AttenDecrease
		{1,1},  //   76 buTuneLock
		{1,1},	//   77 buCWQRO	
		{1,1},	//   78 buCWQRP
		{1,1},	//   79 buCWQROQRP
			
};


uint8_t buGetTaskLabel(uint8_t n, char* sa, char* sb)
{
	uint8_t Group;
	char* (*ptask)();   //ptask defined here as a pointer to some function
	uint8_t msgcode;

	msgcode = pgm_read_byte(&pmdButtonHasMsgList[n]);
	if ((n >= 65) && (n <= 72)) {
		icGetI2CGetButtonLabel(n-64, sa, sb);
		Group = icGetStepTaskGroup(n-64);
		if (Group > 0) {
			if (((0x04 & msgcode) == 0x04) && (UseStepTaskLabel[Group-1])) strcpy(sb,StepTaskLabel[Group-1]);  // bit 2 for stepped task labelling
		}
	} else {
//	if ((Mode < 2) || n < 19 || n == 20 || n > 23)
		if ((Mode < 2) ||  n < 22 || n > 23)     // modified IJS Star6a9
		{
			strcpy_P(sa, (PGM_P)&pmdTaskLabelList[n][0]);
			if ((0x02 & msgcode) == 0x02) {  //  button info on second line
				ptask = (void*)pgm_read_word(&pmdButtonInfoPointerList[n]);  //assign ptask to function from list 
				sb = ptask();
			} else strcpy_P(sb, (PGM_P)&pmdTaskLabelList[n][1]);
		}
		else
		{
			/*
			if (n == 19) {														// removed IJS Star6a9
				strcpy_P(sa, (PGM_P)&pmdTaskLabel19[0]);
				strcpy_P(sb, (PGM_P)&pmdTaskLabel19[1]);
			} else if (n == 21) {
				strcpy_P(sa, (PGM_P)&pmdTaskLabel21[0]);
				strcpy_P(sb, (PGM_P)&pmdTaskLabel21[1]);
			} else 
			*/
			if (n == 22) {
				strcpy_P(sa, (PGM_P)&pmdTaskLabel22[0]);
				strcpy_P(sb, (PGM_P)&pmdTaskLabel22[1]);
			} else if (n == 23) {
				strcpy_P(sa, (PGM_P)&pmdTaskLabel23[0]);
				strcpy_P(sb, (PGM_P)&pmdTaskLabel23[1]);
			}
		}
	}
	if (n != 0) return 1;	// Return 1 if task assigned
	else return 0;	// Return 0 if no task assigned
}


uint8_t  buGetCaptionColour(uint8_t taskno)
{
	return pgm_read_byte(&pmdButtonColourList[taskno][0]);
}


uint8_t  buGetButtonColour(uint8_t taskno)
{
	return pgm_read_byte(&pmdButtonColourList[taskno][1]);
}


uint8_t  buGetTaskAllowed(uint8_t taskno, uint8_t mode)
{
	if (taskno > (nooftasks - 1)) return 0;
	return pgm_read_byte(&pmdRxTxAllowed[taskno][mode]);
}


char* buTaskName(uint8_t n)
{
	if (n > (nooftasks - 1))
	{
		pmStrBuf[0] = 0; // empty string
	}
	else
	{
		if((n>=65)&&(n<=72))
		{
			strcpy(pmStrBuf,"T  ");
			pmStrBuf[1] = n-64 + 0x30;
			icGetI2CGetTaskLabel(n-64,StrB);
			strcat(pmStrBuf,StrB);
		}
		else
		{
			if (buGetTaskAllowed(n, ButtonMode))
			{
				strcpy_P(pmStrBuf, (PGM_P)&pmdTaskNameList[n]);
			}
			else
			{
				strcpy_P(pmStrBuf, (PGM_P)&pmdNotAllowed);
			}
		}
	}
	return &pmStrBuf[0];
}


uint8_t buGetNoofTasks()
{
  return nooftasks;
}


////////////////////////////////////////////////////////////////////

// parameter ch is keypad soft button character 'a' - 'z' or touchpad button 1 - 15
void buDoButtonTask(uint8_t ch)  
{
	void (*ptask)();   //ptask defined here as a pointer to some function
	uint8_t HasMsg;
	uint8_t taskno;   // the index of the button task liss - ie: 0 to 75+
	uint8_t button;
	uint8_t Paired;

	if (DisplayingMenu) return;
	LastButton = ch;
	if (ch >= 'a' ) {
		button = ch - 0x61;   //  'a' = 0,   'b' = 1  etc
		if (Transmit == 1) {
			taskno = TxButtonAssignments[button];
			if (taskno && zt) {
				for (uint8_t i = 0; i < noofTPButtons; i++) {
					if (TxTouchpadAssignments[i] == taskno) {
						etcInvertTouchKey(i + 1);
						etcTone(2);
					}
				}
			}
		} else {
			taskno = RxButtonAssignments[button];
			if (taskno && zt) {
				for (uint8_t i = 0; i < noofTPButtons; i++) {
					if (RxTouchpadAssignments[i] == taskno) {
						etcInvertTouchKey(i + 1);
						etcTone(2);
					}
				}
			}
		}
	} else {
		button = ch - 1;   //  1 = 0,   2 = 1  etc
		if (Transmit == 1) taskno = TxTouchpadAssignments[button];
		else taskno = RxTouchpadAssignments[button];
	}
	ptask = (void*)pgm_read_word(&pmdTaskPointerList[taskno]);  //assign ptask to function from list 
	HasMsg = pgm_read_byte(&pmdButtonHasMsgList[taskno]);
	if ((HasMsg & 0x01) == 0x01) {
		zscDeleteMsgFrame(0);
		if ((DDSparams.dpDSPDDSKeysDisplay == 2) || (DDSparams.dpDSPDDSKeysDisplay == 3)) zscClearDSPKeys(1);
		zscDrawMsgFrame();
	}
	ptask();  //call ptask  must do this before updating button labels 
	//////////   Info on the button ///////////
	if ( ((HasMsg & 0x02) == 0x02) || ((HasMsg & 0x08) == 0x08) ) {
		buRedrawLabel(taskno, 0);
		Paired = pgm_read_byte(&pmdButtonPairsList[taskno]);
		if(Paired) buRedrawLabel(Paired,0);
	}
	if ((HasMsg & 0x01) == 0x01) {
		_delay_ms(400);
		if (zt) {emeDeleteInfo(); emeDrawDateTime();}; 
		if (zs) 
		{
			ksmRestoreMenuArea(0);
			ksmDrawDateTime();
    }
		if (zg) zscDeleteMsgFrame(1);
		if ((zt) || (zg)) {
	   		if (DisplaySwitch == 2) {
	   			if (zt) dspStartDSPdisplayEATFT();
	   			else geStartDSPdisplay();
	   		} else {
				zscShowDSPKeys();
			}
		}
	}
}


void buRedrawLabel(uint8_t taskno, uint8_t Highlighted)
{
	if (zg) gcGraphicsRedrawLabels(taskno, Highlighted); // needs testing & reducing to single button redraw
	if (zt) {
		etcTouchKeyInvert(0);
		etRedrawTouchpadCaption(taskno, Highlighted);  // 0 = not highlighted
		etcTouchKeyInvert(1);
	}
}


void buParamsRedraw()
{
	if ((ParamSetting == 1) && (zt)) emeParamsRedrawExternal();
}


////////////////////////////////////////////////////////////////////

/////  button task routines

void buNotAssigned()
{
  // no code here =- no action
}


void buCopyVfo()
{
  cmCopyVfo();  
}


void buVfoAB()
{
  cmVfoAB();
	buParamsRedraw();
}


void buSplit()
{
  cmSplit();
}


void buSSB()
{
  cmSSB();
	buParamsRedraw();
}


void buCW()
{
  cmCW();
	buParamsRedraw();
}


void buModeStep()
{
  scModeStep();
	buParamsRedraw();
}


void buSsbLsb()
{
  cmSsbLsb();
}


void buAtten()
{
  cmAtten();
}


void buScanBank()
{
  scScanMemStack();
}


void buScanAB()
{
  scABscan();

}


void buParamStep()
{
  cmParamStep();
	buParamsRedraw();
}


void buGreen()
{
  cmSetGreenParams();
	buParamsRedraw();
}


void buYellow()
{
  cmSetYellowParams();
	buParamsRedraw();
}


void buRed()
{
  cmSetRedParams();
	buParamsRedraw();
}


void buDefaultParams()
{
  cmDefaultParams();
}


void buDenoise()
{
  scDenoise();
}


void buMute()
{
  scMute();
}


void buNoiseBlank()
{
  scNoiseBlank();
}


void buAutoNotch()
{
  scAutoNotch();
}


void buManNotch()
{
  scManualNotch();
}


void buWideNarrow()
{
  scWideNarrow();
}


void buVox()
{
  scVoxQsk();
}


void buComp()
{
  scComp();
}


void buForward()
{
  swSetSwrMode('F');
}


void buReflected()
{
  swSetSwrMode('R');
}


void buSWR()
{
  swSetSwrMode('S');
}


void buSWRtoggle()
{
	swStepSwrMode();
}


void buIP3()
{
  cmIP3();
	zscDisplayIP3NF();  // IJS 14.2.2011
}


void buSoftFlywheel()
{
  cmSoftFlywheel();
}


void buDDS23()
{
  cmDDS23();
}


void buDDS43()
{
  cmDDS43();
}


void buBandUp()
{
  cmBandUp();
	buParamsRedraw();
}


void buBandDown()
{
  cmBandDown();
	buParamsRedraw();
}

 
void buXIT()
{
  cmXIT();
	buParamsRedraw();
}


void buRIT()
{
  cmRIT();
	buParamsRedraw();
}


void buSleep()
{
  cmDisplayOff();
  Sleeping = 1;
}


void buDim()
{
	cmToggleDim();
	buParamsRedraw();
}


void buAutoDim()
{
	cmToggleAutoDim();
	buParamsRedraw();
}


void buTuneLock()
{
	cmTuneLock();
	buParamsRedraw();
}


void buDSPDDSKeys()
{
	cmToggleDSPKeys();
	buParamsRedraw();
}


void buWobbulator()
{
	if (WobMode == 0) scWobbulator();
}


void buRateTune()
{
  cmRateTuning();
}


void buSigGen()
{
  cmSigGenMode();
}


void buGuardChannel()
{
  cmGuard();
}


void buMemStackScan()
{
  scScanMemStack();
}


void buVfoStackTune()
{
  cmVfoStackTune();
}


void buVfoABscan()
{
  scABscan();
}


void buDDS79()
{
  cmDDS79();
}


void buWideBandRx()
{
  cmWideBandRx();
}


void buEncAssign()
{
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	
	if (DisplaySwitch == 2) {HaltDSPdisplay = 1;}
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	if (zt) {
		MenuW = MenuWstandard;
		emeClearMenu();
		emeEncoderAssign(LastButton);
		emeDeleteMenu();
	} else {
		if (zg) {
			zscDeleteMsgFrame(0);
			zscDrawMsgFrame();
			X1scroll = MsgX + 2;
			XXscroll = MsgWidth - 2;
			meEncoderAssign(LastButton);
			if((XRIT()==0) && (SigGenMode==0)) geClearParamBox();
		} else {
			if (zs) {
				ksmDeleteMenuBox(1);
				ksmDrawMenuFrame();
				ksmEncoderAssign(LastButton);
			} else meEncoderAssign(LastButton); // chr-lcd (zc) only
		}
	}
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) {
		if (zt) dspStartDSPdisplayEATFT();
		else if (zg) geStartDSPdisplay();
	} else {
		zscDeleteMsgFrame(1);
		zscShowDSPKeys();
		if(zt) emeDrawDateTime();
	}
	if (zs) ksmRestoreMenuArea(1);
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	HaltDSPdisplay = 0;
}




void buMemStack67()
{
	MemStackNo = 0;
	MemSlotNo = 255;
	zscShowMemStackSlotNo();
}


void buMemStack68()
{
	MemStackNo = 1;
	MemSlotNo = 255;
	zscShowMemStackSlotNo();
}


void buMemStack69()
{
	MemStackNo = 2;
	MemSlotNo = 255;
	zscShowMemStackSlotNo();
}


void buMemStack60()
{
	MemStackNo = 3;
	MemSlotNo = 255;
	zscShowMemStackSlotNo();
}


void buGotoSlot()
{
	ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);   
	ddsApplyVfo(VFO);
	UpdateDDS = 1;
	zscShowMemStackSlotNo();

}


void buMemSlot61()
{
	MemSlotNo = 0;
	buGotoSlot();
}


void buMemSlot62()
{
	MemSlotNo = 1;
	buGotoSlot();
}


void buMemSlot63()
{
	MemSlotNo = 2;
	buGotoSlot();
}


void buMemSlot64()
{
	MemSlotNo = 3;
	buGotoSlot();
}


void buMemSlot65()
{
	MemSlotNo = 4;
	buGotoSlot();
}


void buMemSlot66()
{
	MemSlotNo = 5;
	buGotoSlot();
}


void buStackTune()
{
	TuningMode = 'M';
	HowToShowFreq = 'S';  // stack
	scSwitchToMemStacks();
}



void buMemStack67Tune()
{
	MemStackNo = 0;
	buStackTune();
}


void buMemStack68Tune()
{
	MemStackNo = 1;
	buStackTune();
}


void buMemStack69Tune()
{
	MemStackNo = 2;
	buStackTune();
}


void buMemStack60Tune()
{
	MemStackNo = 3;
	buStackTune();
}

void buCWQRO()
{
	dspSetParam(22,1);
	etShowQRPQRO(1);
}


void buCWQRP()
{
	dspSetParam(22,0);	
	etShowQRPQRO(0);
}


void buCWQROQRP()
{
	uint8_t val = dspGetParamValue(22);
	if(val==0){val=1;}else{val=0;}
	dspSetParam(22,val);		
	etShowQRPQRO(val);
}



void buI2C1() { icPCA9555Task(1);};
void buI2C2() { icPCA9555Task(2);};
void buI2C3() { icPCA9555Task(3);};
void buI2C4() { icPCA9555Task(4);};
void buI2C5() { icPCA9555Task(5);};
void buI2C6() { icPCA9555Task(6);};
void buI2C7() { icPCA9555Task(7);};
void buI2C8() { icPCA9555Task(8);};

void buPA3AKE_Roofer() { icPA3AKE_ToggleRoofer();};
void buPA3AKE_AttenIncrease() { icPA3AKE_AttenSwitch('+');};
void buPA3AKE_AttenDecrease() { icPA3AKE_AttenSwitch('-');};

///////////////////////////////////////////
/////// Buttn info routines //////

char* OnOff(uint8_t n)
{
	if (n) strcpy(StrB, PMS(s_on)); else strcpy(StrB, PMS(s_off));
	return StrB;
}


char* biPA3AKE_Roofer()  //   73 buPA3AKE_Roofer
{
	return icRooferModeString();
}


char* biPA3AKE_AttenIncrease()		//   74 buPA3AKE_AttenIncrease   
{
	return icAttenLevelString();
}


char* biPA3AKE_AttenDecrease()		//   75 buPA3AKE_AttenDecrease   
{
	return icAttenLevelString();
}


char* biAtten()
{
	return OnOff(RFatten);
}


char* biSoftFlywheel()
{
	return OnOff(DDSparams.dpSoftwareFlywheel);
}


char* biDDS23()
{
	return OnOff(DDS23);
}


char* biDDS43()
{
	return OnOff(DDS43);
}


char* biDDS79()
{
	return OnOff(DDS79);
}


char* biWideBandRx()
{
	return OnOff(WideBand);
}


char* biWobbulator()
{
	return OnOff( (ScanMode == 'W') && (TuningMode == 'S') );
}


char* biAutoDim()
{
	return OnOff(DDSparams.dpAutoDim);
}


char* biTuneLock()
{
	return OnOff(LockTuning);
}


char* biI2C1()
{
	return StrB;
}


char* biI2C2()
{
	return StrB;
}


char* biI2C3()
{
	return StrB;
}


char* biI2C4()
{
	return StrB;
}


char* biI2C5()
{
	return StrB;
}


char* biI2C6()
{
	return StrB;
}


char* biI2C7()
{
	return StrB;
}


char* biI2C8()
{
	return StrB;
}
