/*
 *****    homebrew-radios.net   *****

 *****     Project TrxAVR       *****


 taStarDSP.h    header file
 
Support Picastar DSP/IF unit
*/

#ifndef _ta_STARDSP_H_
#define _ta_STARDSP_H_ 1


#define pgreen 1
#define pyellow 2
#define pred 3

extern uint8_t ParamVal;
extern uint8_t Muted;
extern uint8_t ParamColour;
extern uint8_t SmeterdB;
extern uint8_t DspMode;
extern uint8_t HaltDSPdisplay;
extern uint8_t ParamsNotRestoredMsg;
extern uint8_t rx2;

void ReadVFOs();
void WriteVOFs();
void dspSetDefaultXeepromData();
uint8_t dspSendCharTx2(char pc);
void dspSetLed(uint8_t colour);  
void dspUsbRequest(char cmd);
uint8_t dspLoadCode();
uint8_t dspSendBulkLoad(uint8_t request);
void dspLoadParams();
void dspLoadSwitches();
void dspLoad();
void dspLoadTxDrive();
void dspStoreTxDrive(uint8_t drv);
void dspInit();
void dspSendCommand(uint8_t p, uint8_t data);
void dspSetParam(uint8_t p, uint8_t v);
uint8_t dspGetParamValue(uint8_t starno);
uint8_t dspGetGreenParamValue(uint8_t starno);
void dspRestoreDefaultParams();
void dspRestoreParamToBackup(uint8_t starno);
void dspRestoreParamToBackupDontSend(uint8_t starno);  
void dspTidySwitches();
void dspSetSSBfilterCentre(uint16_t widthparam);
uint8_t dspGetMax(uint8_t starno);
uint8_t dspGetMin(uint8_t starno);
uint8_t dspGetMult(uint8_t starno);
void dspSetParameterColour();
void dspLoadParameterColour();
void dspSetParamAddress();
void dspRestoreAllBackupParams();
char* dspParamValString(uint8_t p, uint8_t LeadingSpaces);
uint8_t dspStarToUser(uint8_t starno);
uint8_t dspUserToStar(uint8_t userno);
void dspDoDspDisplay();
void dspInitGraphicsEA320();
void dspStartDSPdisplayEATFT();
void dspChangeParamValue(uint8_t starno, uint8_t value);
uint8_t dspGetParam254Value(uint8_t starno);

#endif	/* !_ta_STARDSP_H_ */
