/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taSWR.h    header file
 
Forward and reflected power, SWR  
*/

#ifndef _ta_SWR_H_
#define _ta_SWR_H_ 1


// Transfer calibration data structure .... either forward or reflected 
struct CalTransferStruct_type    //  72 bytes
{
  uint16_t ctsCalLevel[32];    // 32 power levels for ADC output = 32, 64 ... 992
  uint16_t ctsFsWatts;         // Forward analogue meter output full scale watts
  uint16_t ctsMismatchDeciWatts;
  uint16_t ctsMismatchSeconds;
  uint8_t  ctsFwdRef;
  uint8_t  ctsSpare;
};

extern uint8_t SWRflag;
extern char SWRmode;
extern uint32_t FwdCentiWatts;
extern uint32_t RefCentiWatts;
extern uint32_t SWRx100;
extern uint16_t Mismatch;
extern uint16_t FwdFsdDeciwatts;
extern uint16_t RefFsdDeciwatts;


void swDoSWR();
void swInitSWR();
void swCalcSWR();
void swZeroSWR();
void swDisplaySWR();
void swReadSWR();
void swProtectPA();
void swStepSwrMode();
void swUsbRequest(char cmd);
void swSetSwrMode(char mode);

#endif	/* !_ta_SWR_H_ */
