/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taKS0108.h    128x64 mono graphics control header file

*/

#ifndef _ta_KS0108_H_
#define _ta_KS0108_H_ 1


extern uint8_t ksMsgShowing;
extern uint8_t ksFreqInfoShowing;
extern char ksFreqInfoText[10];

void ksWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo);
void ksDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t LeadingZero);
void ksDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo);
void ksDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo);
void ksClearFrequencyDisplay(uint8_t Vfo);
void ksShowWobbulatorMode();
void ksShowVfoStackMode();
void ksShowABscan();
void ksShowRateTuningMode();
void ksShowMemStackScan();
void ksFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw);
void ksFilterCW(char * swid, uint8_t widthparam, uint8_t centreparam, uint8_t depthparam, uint8_t sw);
void ksClearRITXIT();
void ksClearFreqInfo();
void ksClearFreqInfoUpper();
void ksClearFreqInfoLower();
void ksWriteFreqInfoData(char* s);
void ksWriteFreqInfoHeader(char* s);
void ksSmeterInit();
void ksMeterBarSet(uint8_t w);
void ksClearSwrMeter();
void ksClearSmeter();
void ksSwrInit();
char* ksdParamMenuString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k

#endif	/* !_ta_KS0108_H_ */
