/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taGlobal.h    header file
 
Globally available variables and functions 

(String handling buffers take up a lot of RAM 
   - define one set for everyone to use
	 - CARE in interrupt service routines!!! )
*/

#ifndef _ta_GLOBAL_H_
#define _ta_GLOBAL_H_ 1


#define noofButtons 26		// no of buttons 0 ('a') - 25 ('z')
#define noofTPButtons 15	// no of buttons 0 (1) - 14 (15)

#define nooftasks 80

#define DDS_1_Cnt 8
#define DDS_2_Cnt 6
#define DDS_3_Cnt 5
#define DDS_4_Cnt 8
#define DDS_5_Cnt 10
#define DDS_6_Cnt 11
#define DDS_7_Cnt 9
#define DDS_8_Cnt 6
#define DDS_9_Cnt 9

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>
#include <stdint.h>
#include <inttypes.h>
#include <string.h>
#include <stdlib.h>
#include "taMsg.h"
#include "taProgmem.h"
#include "avr_compiler.h"
#include <util/delay.h>





struct HardwareSettingsType  // 32 bytes
{
	// display panel options - Set from Hobcat
	uint8_t hsDisplay;
//  0 - NT3881/HD44780 character display 40x2
//  1 - NT3881/HD44780 character display 20x4
//  2 - S1D13700 mono graphics panel 320x240  8080
//  3 - S1D13700 mono graphics panel 320x240  6800
//  4 - eDIPTFT43-ATP  TFT colour display (I2C bus)
//  5 - KS0108 mono graphics display panel 128x64


	// keypad options - set from Hobcat
	uint8_t hsKeypad;
// 0 - 16 key  4x4 hex key pad + optional 9 other buttons
// 1 - 18 button TrxAVR-Picastar keypad + optional 8 other buttons  
// 2 - 25 button keypad with on 320x240 S1D13700 motherboard
// 3 - 18 button keypad - no display nor stacks (but soft keys C,M & N)
// 4 - User defined keypad layout - refer to taKeys.c


	// Tuning encoder sense
	uint8_t hsTuningEncoder;
//  0 - quad/phase  &  G3XJP home brew - clock and direction
//  1 - quad/phase reversed

	// 320x240 Touch panel and button display options
	uint8_t hsTouchPanel;
//  0 - No touch panel & no button labels
//  1 - No touch panel & 8 button labels (right side)
//  2 - No touch panel & 15 button labels (right side and bottom)
//	3 - Touch panel installed (15 buttons)

	uint8_t hsDDSmultiplierA;  
	uint8_t hsDDSmultiplierB;         

	 // Hardware options - set from Hobcat
	uint8_t hsHardwareOptionsA;
//	bit 0 - PwmMeter
//	bit 1 - IP3 LED
//	bit 2 - Attenuator LED
//  bit 3 - NineBPFs


	// Four 1k blocks to avoid max write issues
	uint8_t hsInternalEepromStart;
	//  0 = 0x0000
	//  1 = 0x0400
	//  2 = 0x0800
	//  3 = 0x0C00

	uint8_t hsCallsign[11];
	uint8_t hsWelcomeText1[29];
	uint8_t hsWelcomeText2[29];

	// Multiple display options
	uint8_t hsDualDisplay;
//	0 - No multiple display
//	1 - Main display + char 40x2
//	2 - Main display + char 20x4
//	3 - Main display + EATFT colout
//	4 - Main display + char 40x2 + EATFT colour
//	5 - Main display + char 20x4 + EATFT colour

	// Menu encoder sense
	uint8_t hsMenuEncoder;
//	0 - standard direction
//	1 - reverse direction

	// Keypad matrix size (X x Y)
	uint8_t hsKeyMatrix;
//	0  - 5 x 5 (standard)
//	1  - 5 x 6
//	2  - 5 x 7
//	3  - 6 x 5
//	4  - 6 x 6
//	5  - 6 x 7
//	6  - 7 x 5
//	7  - 7 x 6
//	8  - 7 x 7
//	9  - 8 x 5
//	10 - 8 x 6
//	11 - 8 x 7

  uint8_t hsRtcStatus;
	// 0 - RTCkind[0]    |  0 = no RTC    1 = ISL1220   
	// 1 - RTCkind[1]    |  2 = DS1307    3 = PCF 8583 
	// 2 - RTCkind[2]    |
	// 3 - RTCkind[3]    |
  // 4  
  // 5
	// 6
	// 7

	
	uint8_t hsSpare[15];
};

extern uint8_t TftaI2Caddress;
extern struct HardwareSettingsType HardwareSettings;
extern uint8_t timer3test;
extern uint8_t timer4test;
extern char DiagMode;
extern uint8_t zc;            // zc == 1 - means write to char lcd
extern uint8_t zs;            // zs == 1 - means write to 128x64 graphics display
extern uint8_t zg;            // zg == 1 - means write to 320x240 graphics display
extern uint8_t zt;            // zt == 1 - means write to colour TFT display on I2C bus
extern uint8_t TwentyByFour;  // 0 = 40x2    1 = 20x4    For char LCD
extern uint8_t EA320_6800;    // 0 = 8080    1 = 6800    For 320x240 display
extern uint8_t DualDisplay;   // 0 = no multiple display    1 = multiple display
extern uint8_t HaveTP;        // 1 = 320x240 touch panel installed
extern uint8_t HaveRB;        // 1 = 320x240 8 right side buttons installed
extern uint8_t HaveBB;        // 1 = 320x240 7 bottom buttons installed
extern uint8_t DoMeterCode;   // 1 = display supports scMeterLoopCode()
extern uint8_t ksCSLOW;       // 1 = CS active low for 128x64 display
extern uint8_t ymax;          // rows 5 to 7
extern uint8_t xmax;          // columns 1 to 8
extern uint16_t CounterA;  
extern uint16_t CounterB;
extern char StrA[90];
extern char StrB[80]; 
extern char StrC[80]; 
extern char StrD[32];
extern uint8_t I2Cbuf[258];
extern uint32_t MonitorA;
extern uint32_t MonitorB;
extern uint32_t MonitorC;
extern uint32_t MonitorH;
extern uint8_t TestIndex;
extern char ButtonRT;
extern uint8_t VisibleCount;
extern int HighlightedPos;
extern uint8_t SpaceWidth;
extern uint16_t X1scroll, Y1scroll, XXscroll, YYscroll;
extern uint8_t ScrollItemCount;
extern uint8_t PrevSwCW;
extern uint8_t PrevSwSSB;
extern uint8_t PrevMode;
extern uint8_t MenuExit;

char* gbTrailingSpaces(char* s, uint8_t width);
char* gbLeadingSpaces(char* s, uint8_t width);

uint32_t dummy;

#endif	/* !_ta_GLOBAL_H_ */
