/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taEncoder.h  Rotary encoder module header file


*/

#ifndef _ta_ENCODER_H_
#define _ta_ENCODER_H_ 1

extern uint8_t DisplayEnc;
extern uint16_t TuningTimer; // stepping and XIT Tx tune persistence
extern int Encoder4count;  // global
extern int Encoder7count;  // global
extern char TuningMode;   //  'N' = normal  'V'= VFO stack  'R' = rate
extern uint8_t PotsFlag;
extern uint8_t Param81PotVal;
extern uint8_t Flywheeling;
extern char LatestTuningDir;  // used by flywheel
extern char TuningDir;
extern int RateTuningIndex;
extern uint8_t SweepDir;   // 0 = no sweep, 'D' = down, 'U' = up
extern uint8_t KillRateTuning;
extern uint8_t EncodersPotsParams[12];  // user nos
extern uint8_t EncodersPotsParamMax[12];   // param max values
extern uint8_t EncodersPotsParamMin[12];   // param max values
extern uint8_t BlockEncoderTuning;
extern uint8_t LockTuning;
extern uint8_t TxXITtune;
extern uint8_t DisplayEncTimer;


int enGetEncoder4delta();
int enGetEncoder7delta();
void enINTenable(unsigned char n, unsigned char tf);
void enEncodersInit();
uint8_t enDoEncodersPots();
void enSetEncodersMaxMin();

#endif	/* !_ta_ENCODER_H_ */
