/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taEEPROM.h    header file
 
Holds all the EEPROM data declarations for TrxAVR.
Do not change the order or else the physical allocations will affected.

*/

#ifndef _ta_EEPROM_H_
#define _ta_EEPROM_H_ 1

#include "taDDS.h"				// for Slot_type struct definition
#include "taEA320TouchPanel.h"	// for TouchCal_type struct definition

struct ee_type {
	// From taDDS.c
	uint32_t EE_fDDSclock;					// DDS clock in Hz
	uint32_t EE_USBoffset;					// USB Offset
	uint32_t EE_LSBoffset;					// LSB Offset
	struct Slot_type EE_BandStack[3][10];	// EEPROM Sticky slots x 30   (60m slots unused)
	struct Slot_type EE_MemStack[4][6];		// EEPROM Sticky slots x 24
	struct Slot_type EE_VfoStickyStack[8];	// EEPROM Sticky slots  0 = PowerOn,   1-7 = VFO slots 1-7

	// From taStarDSP.c
	uint8_t EE_CalCurve[42];

	// From taStarControl.c
	uint8_t EE_EncodersPotsParams[12];
	uint8_t EE_RxButtonAssignments[32];
	uint8_t EE_TxButtonAssignments[32];
	uint8_t EE_DDSparamBlock[12];

	// From taEA320TouchPanel.c
	struct TouchCal_type EE_TouchCal;

	// New allocations
	uint8_t EE_RxTouchpadAssignments[32];
	uint8_t EE_TxTouchpadAssignments[32];

	// I2C control
	uint8_t EE_I2C_ButtonOpcode[8];
	uint8_t EE_I2C_ButtonGroup[8];
	uint8_t EE_I2C_ButtonAddress[8];
	uint16_t EE_I2C_ButtonDataword[8];
	char EE_I2C_ButtonLabels[8][12];

	uint8_t EE_I2C_BpfKind;
	uint8_t EE_I2C_BpfAddress;
	uint8_t EE_PA3AKE_RooferAddress;
	uint8_t EE_PA3AKE_SquarerAddress;
	uint8_t EE_PA3AKE_MixerAddress;
	uint8_t EE_PA3AKE_MixerEnable;
	uint8_t EE_PA3AKE_RooferSwitchEnable;
	uint16_t EE_PA3AKE_MixerDAC;
	uint16_t EE_PA3AKE_SquarerDAC;
	uint8_t EE_EnablePCA9555;
	uint8_t EE_I2C_Spare[11];
	uint8_t EE_LocalTimeOffset;

	uint32_t EE_CWoffset;					// optional separate CWU/CWL offset in Hz
	uint8_t EE_CWoffsetEnable;

	uint8_t EE_TuningParamBlock[8];
};

extern struct ee_type EEMEM ee;

#endif	/* !_ta_EEPROM_H_ */








