unit UfrmParamFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, StdCtrls, FileCtrl, Mask, RzEdit, RzLabel;

type
  TfrmParamFile = class(TForm)
    RzBitBtn1: TRzBitBtn;
    RzBitBtn2: TRzBitBtn;
    Edit_ParamFileName: TEdit;
    RzLabel_StarFolder: TRzLabel;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    FileListBox_ParamFile: TFileListBox;
    procedure RzBitBtn2Click(Sender: TObject);
    procedure RzBitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure Initialise;
  end;

var
  frmParamFile: TfrmParamFile;

implementation

{$R *.dfm}

Uses UIniData;

procedure TfrmParamFile.Initialise;
var
  s: string;
begin
  ReadXJPIniData;
  RzLabel_StarFolder.Caption := 'Star folder = ' + g_RegIniData.IniStarFolder;
  FileListBox_ParamFile.Directory := g_RegIniData.IniStarFolder;
  try
    FileListBox_ParamFile.FileName := g_XJPIniData.IniParams;
  except
    FileListBox_ParamFile.FileName := '';
  end;
end;


procedure TfrmParamFile.RzBitBtn2Click(Sender: TObject);
begin
  ModalResult := mrAbort;
end;

procedure TfrmParamFile.RzBitBtn1Click(Sender: TObject);
begin
  g_XJPIniData.IniParams := ExtractFilename(FileListBox_Paramfile.FileName);
  WriteXJPIniData;
  ModalResult := mrOk;
end;

end.
