unit UfrmI2C;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxExEdtr, dxTL, dxDBCtrl, dxDBGrid, dxCntner, ExtCtrls, RzPanel,
  DB, dxmdaset, dxDBTLCl, dxGrClms, StdCtrls, RzLabel, RzButton, RzLstBox,
  RzCmboBx, RzRadChk, Mask, RzEdit, RzSpnEdt, D2XXUnit, syncobjs;

type
  Butask_type =
    record
        btOperation: byte;
        btGroup: byte;
        btAddress: byte;
        btData: byte;
        btLabel: string;
    end;



type
  TfrmI2C = class(TForm)
    dxMemData_Tasks: TdxMemData;
    DS_Tasks: TDataSource;
    RzPanel1: TRzPanel;
    dxDBGrid_Tasks: TdxDBGrid;
    TaskCol_Id: TdxDBGridColumn;
    TaskCol_Label: TdxDBGridColumn;
    TaskCol_Group: TdxDBGridColumn;
    TaskCol_Address: TdxDBGridPickColumn;
    TaskCol_Data: TdxDBGridColumn;
    TaskCol_Operation: TdxDBGridPickColumn;
    dxMemData_TasksGROUP: TSmallintField;
    TaskColumn_15: TdxDBGridCheckColumn;
    TaskColumn_14: TdxDBGridCheckColumn;
    TaskColumn_13: TdxDBGridCheckColumn;
    TaskColumn_12: TdxDBGridCheckColumn;
    TaskColumn_11: TdxDBGridCheckColumn;
    TaskColumn_10: TdxDBGridCheckColumn;
    TaskColumn_09: TdxDBGridCheckColumn;
    TaskColumn_08: TdxDBGridCheckColumn;
    TaskColumn_07: TdxDBGridCheckColumn;
    TaskColumn_06: TdxDBGridCheckColumn;
    TaskColumn_05: TdxDBGridCheckColumn;
    TaskColumn_04: TdxDBGridCheckColumn;
    TaskColumn_03: TdxDBGridCheckColumn;
    TaskColumn_02: TdxDBGridCheckColumn;
    TaskColumn_01: TdxDBGridCheckColumn;
    TaskColumn_00: TdxDBGridCheckColumn;
    dxMemData_TasksBIT14: TBooleanField;
    dxMemData_TasksBIT13: TBooleanField;
    dxMemData_TasksBIT12: TBooleanField;
    dxMemData_TasksBIT11: TBooleanField;
    dxMemData_TasksBIT10: TBooleanField;
    dxMemData_TasksBIT09: TBooleanField;
    dxMemData_TasksBIT08: TBooleanField;
    dxMemData_TasksBIT07: TBooleanField;
    dxMemData_TasksBIT06: TBooleanField;
    dxMemData_TasksBIT05: TBooleanField;
    dxMemData_TasksBIT04: TBooleanField;
    dxMemData_TasksBIT03: TBooleanField;
    dxMemData_TasksBIT02: TBooleanField;
    dxMemData_TasksBIT01: TBooleanField;
    dxMemData_TasksBIT00: TBooleanField;
    RzBitBtn_Help: TRzBitBtn;
    RzBitBtn_Accept: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    dxMemData_TasksBIT15: TBooleanField;
    dxMemData_TasksOP: TStringField;
    dxMemData_TasksADDR: TStringField;
    dxMemData_TasksID: TIntegerField;
    dxMemData_TasksLABEL: TStringField;
    RzPanel2: TRzPanel;
    RzLabel7: TRzLabel;
    RzCombo_BpfAddress: TRzComboBox;
    RzCombo_BpfType: TRzComboBox;
    RzLabel8: TRzLabel;
    RzLabel9: TRzLabel;
    RzPanel3: TRzPanel;
    RzLabel_RooferCombo: TRzLabel;
    RzLabel13: TRzLabel;
    RzCombo_Roofer: TRzComboBox;
    RzCombo_SquarerAddress: TRzComboBox;
    RzCombo_MixerAddress: TRzComboBox;
    RzLabel_SquarerCombo: TRzLabel;
    RzLabel_MixerCombo: TRzLabel;
    RzLabel10: TRzLabel;
    RzLabel14: TRzLabel;
    RzLabel16: TRzLabel;
    RzLabel17: TRzLabel;
    RzLabel18: TRzLabel;
    RzChBox_Roofer: TRzCheckBox;
    RzChBox_Mixer: TRzCheckBox;
    RzSpinEdit_SquarerDAC: TRzSpinEdit;
    RzSpinEdit_MixerDAC: TRzSpinEdit;
    RzLabel_SquarerDAC: TRzLabel;
    RzLabel_MixerDAC: TRzLabel;
    RzRB_1x: TRzRadioButton;
    RzRB_10x: TRzRadioButton;
    RzRB_50x: TRzRadioButton;
    RzLabel_Adjust: TRzLabel;
    RzLabel11: TRzLabel;
    RzLabel12: TRzLabel;
    RzLabel15: TRzLabel;
    RzLabel19: TRzLabel;
    RzLabel20: TRzLabel;
    RzLabel21: TRzLabel;
    RzLabel22: TRzLabel;
    RzLabel23: TRzLabel;
    RzLabel24: TRzLabel;
    RzLabel25: TRzLabel;
    RzLabel26: TRzLabel;
    RzLabel27: TRzLabel;
    RzLabel28: TRzLabel;
    RzLabel29: TRzLabel;
    RzChBox_EnablePCA9555: TRzCheckBox;
    procedure RzBitBtn_AcceptClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzChBox_RooferClick(Sender: TObject);
    procedure RzChBox_MixerClick(Sender: TObject);
    procedure RzRB_1xClick(Sender: TObject);
    procedure RzRB_10xClick(Sender: TObject);
    procedure RzRB_50xClick(Sender: TObject);
    procedure RzSpinEdit_MixerDACChange(Sender: TObject);
    procedure RzSpinEdit_SquarerDACChange(Sender: TObject);
    procedure dxMemData_TasksCalcFields(DataSet: TDataSet);
    procedure dxDBGrid_TasksCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure RzChBox_EnablePCA9555Click(Sender: TObject);
    procedure RzBitBtn_HelpClick(Sender: TObject);
  private
    IdFieldIndex: integer;
    LabelFieldIndex: integer;
    OpFieldIndex: integer;
    GroupFieldIndex: integer;
    AddressFieldIndex: integer;
    I2CDelayEvent: TEvent;
    SendDAC: char;
    Butask: array[1..8] of Butask_type;
    block: array[0..7] of byte;
    procedure SetFields;
    function LookupAddress(s: string; max: byte): byte;
    function LookupOpcode(s: string): byte;
    procedure EnableComponents;
  public
    procedure Initialise;
    function PA3AKE_SendDAC: boolean;
    function PA3AKE_ReadDACs: boolean;
  end;

var
  frmI2C: TfrmI2C;

implementation

{$R *.dfm}

uses UIniData, UfrmMain, UUsb;

procedure TfrmI2C.Initialise;
var
  i: byte;
begin
  with dxDBGrid_Tasks do begin
    IdFieldIndex := ColumnByFieldName('ID').index;
    LabelFieldIndex := ColumnByFieldName('LABEL').index;
    OpFieldIndex := ColumnByFieldName('OP').index;
    GroupFieldIndex := ColumnByFieldName('GROUP').index;
    AddressFieldIndex := ColumnByFieldName('ADDR').index;
  end;
  I2CDelayEvent := TEvent.Create(0, true, false, 'Hobcat I2C delay event');
  I2CDelayEvent.ResetEvent;
  LoadEememInifile;
  SetFields;
  with g_EememIniData do
  begin
    RzCombo_BpfType.ItemIndex := IniPCA9555BpfType;
    if not IniPCA9555BpfAddress in [0..7] then IniPCA9555BpfAddress := 0;
    RzCombo_BpfAddress.ItemIndex := IniPCA9555BpfAddress;
    if not IniPA3AKE_RooferAddress in [0..7] then IniPA3AKE_RooferAddress := 0;
    RzCombo_Roofer.ItemIndex := IniPA3AKE_RooferAddress;
    if not IniPA3AKE_SquarerAddress in [0..3] then IniPA3AKE_SquarerAddress := 0 ;
    RzCombo_SquarerAddress.ItemIndex := IniPA3AKE_SquarerAddress;
    if not IniPA3AKE_MixerAddress in [0..3] then IniPA3AKE_MixerAddress := 0 ;
    RzCombo_MixerAddress.ItemIndex := IniPA3AKE_MixerAddress;
    RzChBox_Mixer.Checked := (IniPA3AKE_MixerEnable > 0);
    RzChBox_Roofer.Checked := (IniPA3AKE_RooferSwitchEnable > 0);
    RzChBox_EnablePCA9555.Checked := (IniEnablePCA9555 = 1);
    RzRB_1x.Checked := true;
    RzSpinEdit_SquarerDAC.Increment := 1;
    RzSpinEdit_MixerDAC.Increment := 1;
    EnableComponents;
    frmMain.USBstate[AD5321r] := 'W';
  end;
end;


procedure TfrmI2C.EnableComponents;
begin
  if RzChBox_EnablePCA9555.Checked then
  begin
    dxDBGrid_Tasks.Enabled := true;
    dxDBGrid_Tasks.Font.Color := clWindowText;
    dxDBGrid_Tasks.HeaderFont.Color := clMaroon;
    dxDBGrid_Tasks.BandFont.Color := clBlue;
  end
  else begin
    dxDBGrid_Tasks.Enabled := false;
    dxDBGrid_Tasks.Font.Color := clSilver;
    dxDBGrid_Tasks.HeaderFont.Color := clSilver;
    dxDBGrid_Tasks.BandFont.Color := clSilver;
  end;
  if RzChBox_Mixer.Checked then
  begin
    RzCombo_SquarerAddress.Enabled := true;
    RzCombo_MixerAddress.Enabled := true;
    RzLabel_SquarerCombo.Enabled := true;
    RzLabel_MixerCombo.Enabled := true;
    RzLabel_MixerDAC.Enabled := true;
    RzLabel_SquarerDAC.Enabled := true;
    RzLabel_Adjust.Enabled := true;
    RzSpinEdit_MixerDAC.Enabled := true;
    RzSpinEdit_SquarerDAC.Enabled := true;
    RzRB_1x.Enabled := true;
    RzRB_10x.Enabled := true;
    RzRB_50x.Enabled := true;
  end
  else begin
    RzCombo_SquarerAddress.Enabled := false;
    RzCombo_MixerAddress.Enabled := false;
    RzLabel_SquarerCombo.Enabled := false;
    RzLabel_MixerCombo.Enabled := false;
    RzLabel_MixerDAC.Enabled := false;
    RzLabel_SquarerDAC.Enabled := false;
    RzLabel_Adjust.Enabled := false;
    RzSpinEdit_MixerDAC.Enabled := false;
    RzSpinEdit_SquarerDAC.Enabled := false;
    RzRB_1x.Enabled := false;
    RzRB_10x.Enabled := false;
    RzRB_50x.Enabled := false;
  end;
  if RzChBox_Roofer.Checked then
  begin
    RzCombo_Roofer.Enabled := true;
    RzLabel_RooferCombo.Enabled := true;
  end
  else begin
    RzCombo_Roofer.Enabled := false;
    RzLabel_RooferCombo.Enabled := false;
  end;
end;


procedure TfrmI2C.SetFields;
var
 i: byte;
 AddressIndex: byte;
begin
  dxMemData_Tasks.Close;
  dxMemData_Tasks.Open;
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i], dxMemData_Tasks do
    begin
      Append;
      FieldValues['ID'] := i;
      FieldValues['LABEL'] := IniPcaLabel;
      FieldValues['OP'] := TaskCol_Operation.Items[IniPcaOpCode];
      FieldValues['GROUP'] := IniPcaGroup;
      AddressIndex := IniPcaAddress;
      if not (AddressIndex in [0..7]) then AddressIndex := 0;
      FieldValues['ADDR'] := TaskCol_Address.Items[AddressIndex];
      FieldValues['BIT15'] := (IniPcaDataword AND $8000);
      FieldValues['BIT14'] := (IniPcaDataword AND $4000);
      FieldValues['BIT13'] := (IniPcaDataword AND $2000);
      FieldValues['BIT12'] := (IniPcaDataword AND $1000);
      FieldValues['BIT11'] := (IniPcaDataword AND $0800);
      FieldValues['BIT10'] := (IniPcaDataword AND $0400);
      FieldValues['BIT09'] := (IniPcaDataword AND $0200);
      FieldValues['BIT08'] := (IniPcaDataword AND $0100);
      FieldValues['BIT07'] := (IniPcaDataword AND $0080);
      FieldValues['BIT06'] := (IniPcaDataword AND $0040);
      FieldValues['BIT05'] := (IniPcaDataword AND $0020);
      FieldValues['BIT04'] := (IniPcaDataword AND $0010);
      FieldValues['BIT03'] := (IniPcaDataword AND $0008);
      FieldValues['BIT02'] := (IniPcaDataword AND $0004);
      FieldValues['BIT01'] := (IniPcaDataword AND $0002);
      FieldValues['BIT00'] := (IniPcaDataword AND $0001);
      Post;
    end;
  end;
end;



procedure TfrmI2C.RzBitBtn_AcceptClick(Sender: TObject);
var
  i,x: byte;
  s: string[100];
  b: boolean;
begin
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i], dxMemData_Tasks do
    begin
      locate('id',i,[]);
      if FieldValues['LABEL'] <> null
      then s := FieldByName('LABEL').AsString
      else s := '';
      IniPcaLabel := s;
      IniPcaGroup := FieldByName('GROUP').AsInteger;
      s := FieldByName('OP').AsString;
      IniPcaOpcode := LookupOpcode(s);
      s := FieldByName('ADDR').AsString;
      IniPcaAddress := LookupAddress(s,7);
      IniPcaDataword := 0;
      if FieldValues['BIT15'] then  IniPcaDataword := IniPcaDataword + $8000;
      if FieldValues['BIT14'] then IniPcaDataword := IniPcaDataword OR $4000;
      if FieldValues['BIT13'] then IniPcaDataword := IniPcaDataword OR $2000;
      if FieldValues['BIT12'] then IniPcaDataword := IniPcaDataword OR $1000;
      if FieldValues['BIT11'] then IniPcaDataword := IniPcaDataword OR $0800;
      if FieldValues['BIT10'] then IniPcaDataword := IniPcaDataword OR $0400;
      if FieldValues['BIT09'] then IniPcaDataword := IniPcaDataword OR $0200;
      if FieldValues['BIT08'] then IniPcaDataword := IniPcaDataword OR $0100;
      if FieldValues['BIT07'] then IniPcaDataword := IniPcaDataword OR $0080;
      if FieldValues['BIT06'] then IniPcaDataword := IniPcaDataword OR $0040;
      if FieldValues['BIT05'] then IniPcaDataword := IniPcaDataword OR $0020;
      if FieldValues['BIT04'] then IniPcaDataword := IniPcaDataword OR $0010;
      if FieldValues['BIT03'] then IniPcaDataword := IniPcaDataword OR $0008;
      if FieldValues['BIT02'] then IniPcaDataword := IniPcaDataword OR $0004;
      if FieldValues['BIT01'] then IniPcaDataword := IniPcaDataword OR $0002;
      if FieldValues['BIT00'] then IniPcaDataword := IniPcaDataword OR $0001;
    end;
  end;
  with g_EememIniData do
  begin
    IniPCA9555BpfType := RzCombo_BpfType.ItemIndex;
    IniPCA9555BpfAddress :=  RzCombo_BpfAddress.ItemIndex;
    if RzChBox_EnablePCA9555.Checked
    then IniEnablePCA9555 := 1
    else IniEnablePCA9555 := 0;
    IniPA3AKE_RooferAddress := RzCombo_Roofer.ItemIndex;
    IniPA3AKE_SquarerAddress :=  RzCombo_SquarerAddress.ItemIndex;
    IniPA3AKE_MixerAddress := RzCombo_MixerAddress.ItemIndex;
    if RzChBox_Mixer.Checked
    then IniPA3AKE_MixerEnable := 1
    else IniPA3AKE_MixerEnable := 0;
    if RzChBox_Roofer.Checked
    then IniPA3AKE_RooferSwitchEnable := 1
    else IniPA3AKE_RooferSwitchEnable := 0;
    IniPA3AKE_SquarerDAC := trunc(RzSpinEdit_SquarerDAC.Value);
    IniPA3AKE_MixerDAC := trunc(RzSpinEdit_MixerDAC.Value);
  end;
  SaveEememIniFile;
  Close;
end;



function TfrmI2C.LookupOpcode(s: string): byte;
var
  i: byte;
begin
  result := 0;
  for i := 1 to 14 do
  begin
    if TaskCol_Operation.Items[i] = s then
    begin
      result := i;
      break;
    end;
  end;
end;


function TfrmI2C.LookupAddress(s: string; max: byte): byte;
var
  i: byte;
begin
  result := 0;
  for i := 0 to max do
  begin
    if TaskCol_Address.Items[i] = s then
    begin
      result := i;
      break;
    end;
  end;
end;



procedure TfrmI2C.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmI2C.RzChBox_RooferClick(Sender: TObject);
begin
  EnableComponents;
end;

procedure TfrmI2C.RzChBox_MixerClick(Sender: TObject);
begin
  EnableComponents;
end;

procedure TfrmI2C.RzRB_1xClick(Sender: TObject);
begin
  RzSpinEdit_SquarerDAC.Increment := 1;
  RzSpinEdit_MixerDAC.Increment := 1;
end;

procedure TfrmI2C.RzRB_10xClick(Sender: TObject);
begin
  RzSpinEdit_SquarerDAC.Increment := 10;
  RzSpinEdit_MixerDAC.Increment := 10;
end;

procedure TfrmI2C.RzRB_50xClick(Sender: TObject);
begin
  RzSpinEdit_SquarerDAC.Increment := 50;
  RzSpinEdit_MixerDAC.Increment := 50;
end;

function TfrmI2C.PA3AKE_SendDAC: boolean;
var
  s: string;
  w: word;
begin
  result := false;
  Purge_USB_Device_In;
  s := '$$$L_I2C_' + SendDAC;  // 'M' for mixer DAC , 'S' for squarer DAC
  if SendDAC = 'M'
  then w := trunc(RzSpinEdit_MixerDAC.Value)
  else w := trunc(RzSpinEdit_SquarerDAC.Value);
  block[0] := w MOD $100;
  block[1] := w DIV $100;
  if not Usb.usSendString(s) then exit;
  if not Usb.usSendBlock(@block,2) then exit;
  result := true;
end;

function TfrmI2C.PA3AKE_ReadDACs;
begin
  result := false;
  Purge_USB_Device_In;
  if Usb.usSendString('$$$S_I2C_C') then
  begin
    I2CDelayEvent.ResetEvent;
    I2CDelayEvent.WaitFor(200);
    if Usb.usReceiveBlock(@block,4) then
    begin
      result := true;
      RzSpinEdit_MixerDAC.Value := block[0] + $100*block[1];
      RzSpinEdit_SquarerDAC.Value := block[2] + $100*block[3];
      exit;
    end;
  end;
  // read from Ini file if USB failure
  with g_EememINidata do
  begin
    RzSpinEdit_SquarerDAC.Value := IniPA3AKE_SquarerDAC;
    RzSpinEdit_MixerDAC.Value := IniPA3AKE_MixerDAC;
  end;
end;

procedure TfrmI2C.RzSpinEdit_MixerDACChange(Sender: TObject);
begin
  SendDAC := 'M';
  frmMain.USBstate[AD5321w] := 'W';
end;

procedure TfrmI2C.RzSpinEdit_SquarerDACChange(Sender: TObject);
begin
  SendDAC := 'S';
  frmMain.USBstate[AD5321w] := 'W';
end;

procedure TfrmI2C.dxMemData_TasksCalcFields(DataSet: TDataSet);
var
  Group: integer;
begin
  with DataSet do
  begin
    Group := FieldByName('Group').AsInteger;
    if Group > 4 then FieldValues['GROUP'] := 4;
  end;
end;

procedure TfrmI2C.dxDBGrid_TasksCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  Op: string;
  Opcode: integer;
begin
  if (AColumn = TaskCol_Group) then
  begin
    Op := ANode.Values[OpFieldIndex];
    Opcode := LookupOpcode(Op);
    if Anode.Values[GroupFieldIndex] = 0 then AFont.Color := clSilver;
    if not (Opcode in [1,7,8,9,11,12]) then
    begin
      AFont.Color := clSilver;
      AText := 'X';
    end;
  end
end;

procedure TfrmI2C.RzChBox_EnablePCA9555Click(Sender: TObject);
begin
  EnableComponents;
end;

procedure TfrmI2C.RzBitBtn_HelpClick(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/I2C/I2C.htm');
end;

end.
