unit UfrmHardware;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RzCmboBx, RzButton, Syncobjs, RzLabel, Mask, RzEdit,
  RzSpnEdt, RzRadChk, ExtCtrls, RzPanel, D2XXUnit, UGlobals;

type



  TfrmHardware = class(TForm)
    RzBitBtn1: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_Save: TRzBitBtn;
    RzCombo_Keypad: TRzComboBox;
    RzCombo_Display: TRzComboBox;
    RzCombo_TouchPanel: TRzComboBox;
    RzLabel1: TRzLabel;
    RzLabel_TpSelect: TRzLabel;
    RzLabel3: TRzLabel;
    RzCombo_TuningEncoder: TRzComboBox;
    RzLabel4: TRzLabel;
    RzCheckBox_PwmMeter: TRzCheckBox;
    RzLabel7: TRzLabel;
    RzLabel8: TRzLabel;
    RzCombo_Eeprom: TRzComboBox;
    RzLabel9: TRzLabel;
    RzLabel10: TRzLabel;
    RzLabel11: TRzLabel;
    RzLabel12: TRzLabel;
    RzLabel13: TRzLabel;
    RzLabel14: TRzLabel;
    RzLabel5: TRzLabel;
    RzGroupBox1: TRzGroupBox;
    RzLabel15: TRzLabel;
    RzSpinEdit_multiplier: TRzSpinEdit;
    RzChkBx_multiplier: TRzCheckBox;
    RzLabel_MultWarn: TRzLabel;
    RzGroupBox2: TRzGroupBox;
    RzEdit_WelcomeText1: TRzEdit;
    RzEdit_Callsign: TRzEdit;
    RzLabel16: TRzLabel;
    RzLabel17: TRzLabel;
    RzEdit_WelcomeText2: TRzEdit;
    RzLabel18: TRzLabel;
    RzLabel19: TRzLabel;
    RzCombo_MultipleDisplay: TRzComboBox;
    RzLabel_MultipleDisplay: TRzLabel;
    RzCombo_MenuEncoder: TRzComboBox;
    RzLabel2: TRzLabel;
    RzCheckBox_NineBPFs: TRzCheckBox;
    RzLabel20: TRzLabel;
    RzCombo_KeyMatrix: TRzComboBox;
    RzLabel21: TRzLabel;
    RzLabel22: TRzLabel;
    RzLabel23: TRzLabel;
    RzLabel24: TRzLabel;
    RzLabel25: TRzLabel;
    RzLabel26: TRzLabel;
    RzLabel27: TRzLabel;
    RzCombo_RTC: TRzComboBox;
    RzLabel28: TRzLabel;
    procedure FormShow(Sender: TObject);
    procedure RzBitBtn_SaveClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzChkBx_multiplierClick(Sender: TObject);
    procedure RzCombo_DisplayChange(Sender: TObject);
    procedure RzCombo_MultipleDisplayChange(Sender: TObject);
    procedure RzBitBtn1Click(Sender: TObject);
  private
    HwDelayEvent: TEvent;
    block: array[0..99] of byte;
    stext: array[0..60] of char;
    HardwareSettings: THardwareSettings;
    function DoReadHardware: boolean;
    function DoWriteHardware: boolean;
    procedure EnableTouchPanelSelect;
    procedure MultiplierMessage;
  public
    procedure Initialise;
    procedure ReadHardware;
    procedure WriteHardware;
  end;

var
  frmHardware: TfrmHardware;

implementation

{$R *.dfm}
uses UfrmMain, UUsb;


procedure TfrmHardware.Initialise;
begin
  HwDelayEvent := TEvent.Create(0, true, false, 'Hobcat Hardware delay event');
  HwDelayEvent.ResetEvent;
  HwDelayEvent.WaitFor(200);
  frmMain.USBstate[hwread] := 'W';
end;




procedure TfrmHardware.EnableTouchPanelSelect;
begin
  if (RzCombo_Display.ItemIndex in [2,3])
  then begin
    RzCombo_TouchPanel.Visible := true;
    RzLabel_TpSelect.Visible := true;
  end
  else begin
    RzCombo_TouchPanel.Visible := false;
    RzLabel_TpSelect.Visible := false;
  end;
end;


procedure TfrmHardware.ReadHardware;
var
  s: string;
  b: byte;
begin
  if not DoReadHardware then
  begin
    s := 'Failed to read Hardware Settings from TrxAVR 24LC512 EEPROM';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  with HardwareSettings do
  begin
    RzCombo_Keypad.ItemIndex := hsKeypad;
    RzCombo_KeyMatrix.ItemIndex := hsKeyMatrix;
    RzCombo_MultipleDisplay.ItemIndex := hsMultipleDisplay;
    if (hsMultipleDisplay < 0) OR (hsMultipleDisplay >4) then hsMultipleDisplay := 0;
    RzCombo_Display.ItemIndex := hsDisplay;
    EnableTouchPanelSelect;
    RzCombo_TouchPanel.ItemIndex := hsTouchPanel;
    RzCombo_TuningEncoder.ItemIndex := hsTuningEncoder;
    RzCombo_MenuEncoder.ItemIndex := hsMenuEncoder;
    RzCombo_Eeprom.ItemIndex := hsInternalEepromStart;
    b := hsHardwareOptionsA;
    if (b AND $01) <> 0
    then RzCheckBox_PwmMeter.checked := true
    else RzCheckBox_PwmMeter.checked := false;
    if (b AND $08) <> 0
    then RzCheckBox_NineBPFs.checked := true
    else RzCheckBox_NineBPFs.checked := false;
    RzCombo_RTC.ItemIndex := hsRtcStatus AND $0F;
    if hsDDSmultiplierA XOR hsDDSmultiplierB <> $FF then
    begin
      hsDDSmultiplierA := 0;
      hsDDSmultiplierB := $FF;
    end;
    if (hsDDSmultiplierA < 4) OR (hsDDSmultiplierA > 20) then
    begin
      RzChkBx_multiplier.checked := false;
      RzSpinEdit_multiplier.Value := 4;
      hsDDSmultiplierA := 0;
      hsDDSmultiplierB := $FF;
    end
    else begin
      RzChkBx_multiplier.checked := true;
      RzSpinEdit_multiplier.Value := hsDDSmultiplierA;
    end;
    RzSpinEdit_Multiplier.Enabled := RzChkBx_multiplier.checked;
    move(hsCallsign,stext,11);
    s := stext;
    RzEdit_Callsign.Text := s;
    move(hsWelcomeText1,stext,29);
    s := stext;
    RzEdit_WelcomeText1.Text := s;
    move(hsWelcomeText2,stext,29);
    s := stext;
    RzEdit_WelcomeText2.Text := s;
  end;
  MultiplierMessage; 
end;





procedure TfrmHardware.WriteHardware;
var
  s: string;
  b,i,nc: byte;
begin
  with HardwareSettings do
  begin
    hsKeypad := RzCombo_Keypad.ItemIndex;
    hsKeyMatrix := RzCombo_KeyMatrix.ItemIndex;
    hsDisplay := RzCombo_Display.ItemIndex;
    hsMultipleDisplay := RzCombo_MultipleDisplay.ItemIndex;
    hsTouchPanel := RzCombo_TouchPanel.ItemIndex;
    hsTuningEncoder := RzCombo_TuningEncoder.ItemIndex;
    hsMenuEncoder := RzCombo_MenuEncoder.ItemIndex;
    hsInternalEepromStart := RzCombo_Eeprom.ItemIndex;
    if RzChkBx_multiplier.checked
    then hsDDSmultiplierA := trunc(RzSpinEdit_multiplier.Value)
    else hsDDSmultiplierA := 0;
    hsDDSmultiplierB := hsDDSmultiplierA XOR $FF; // prevernt accidental multiplier
    b := 0;
    if RzCheckBox_PwmMeter.checked then b := b + $01;
    if RzCheckBox_NineBPFs.checked then b := b + $08;
    hsRtcStatus := hsRtcStatus AND $F0;
    b := RzCombo_RTC.ItemIndex AND $0F;
    hsRtcStatus := hsRtcStatus OR b;
    hsHardwareOptionsA := b;
    s := RzEdit_Callsign.text;
    nc := length(s);
    if nc > 10 then nc := 10;
    if nc > 0 then
    begin
      for i := 0 to nc-1 do hsCallsign[i] := ord(s[i+1]);
    end;
    hsCallsign[nc] := 0;
    s := RzEdit_WelcomeText1.text;
    nc := length(s);
    if nc > 28 then nc := 28;
    if nc > 0 then
    begin
      for i := 0 to nc-1 do hsWelcomeText1[i] := ord(s[i+1]);
    end;
    hsWelcomeText1[nc] := 0;
    s := RzEdit_WelcomeText2.text;
    nc := length(s);
    if nc > 28 then nc := 28;
    if nc > 0 then
    begin
      for i := 0 to nc-1 do hsWelcomeText2[i] := ord(s[i+1]);
    end;
    hsWelcomeText2[nc] := 0;
  end;
  if DoWriteHardware then
  begin
    s := 'Hardware settings written to TrxAVR 24LC512 EEPROM'
           + #13#10 + ' Please check on TrxAVR';
    MessageDlg(s,mtInformation,[mbOk],0);
  end
  else begin
    s := 'Writing Hardware Setting to TrxAVR 24LC512 EEPROM failed';
    MessageDlg(s,mtWarning,[mbOk],0);
  end;
end;


function TfrmHardware.DoReadHardware: boolean;
begin
  result := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_R')
  then exit
  else begin
    HwDelayEvent.ResetEvent;
    HwDelayEvent.WaitFor(200);
    if not Usb.usReceiveBlock(@block,96) then exit;
    move(block,HardwareSettings,96);
  end;
  Result := true;
end;


function TfrmHardware.DoWriteHardware: boolean;
begin
  result := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_W') then exit;
  move(HardwareSettings,block,96);
  if not Usb.usSendBlock(@block,96) then exit;     //  sent byte count
  result := true;
end;

procedure TfrmHardware.MultiplierMessage;
begin
  if rzChkBx_Multiplier.Checked
  then RzLabel_MultWarn.Font.Color := clRed
  else RzLabel_MultWarn.Font.Color := clMaroon;
end;


procedure TfrmHardware.FormShow(Sender: TObject);
begin
  frmMain.USBstate[hwread] := 'W';
end;

procedure TfrmHardware.RzBitBtn_SaveClick(Sender: TObject);
begin
  frmMain.USBstate[hwwrite] := 'W';
end;

procedure TfrmHardware.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmHardware.RzChkBx_multiplierClick(Sender: TObject);
begin
  RzSpinEdit_Multiplier.Enabled := RzChkBx_multiplier.checked;
  MultiplierMessage;
end;

procedure TfrmHardware.RzCombo_DisplayChange(Sender: TObject);
begin
  EnableTouchPanelSelect;
end;

procedure TfrmHardware.RzCombo_MultipleDisplayChange(Sender: TObject);
begin
  EnableTouchPanelSelect;
end;






procedure TfrmHardware.RzBitBtn1Click(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/TP_setup_4_USB_data.htm');
end;

end.
