unit UfrmDatabase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxExEdtr, dxTL, dxDBCtrl, DB, DBTables, MyAccess, MyClasses, MyCall, DBAccess, MemDS, dxCntner, dxDBTL,
  RzButton, dxDBGrid, dxDBTLCl, dxGrClms, ExtCtrls, RzPanel, StdCtrls,
  RzLabel, dxPSGlbl, dxPSUtl, dxPrnPg, dxBkgnd, dxWrap, dxPSEngn, dxPrnDev,
  dxPSCompsProvider, dxPSFillPatterns, dxPSEdgePatterns, dxPSCore,
  dxPSdxTLLnk, dxPSdxDBCtrlLnk, dxPSdxDBGrLnk, dxPgsDlg;

type
  PInteger_type = ^Integer;


  type
  TfrmDatabase = class(TForm)
    Query_hbusers: TMyQuery;
    RzBitBtn1: TRzBitBtn;
    Query_hbusersid: TIntegerField;
    Query_hbusersusername: TStringField;
    Query_hbusersname: TStringField;
    Query_hbuserscallsign: TStringField;
    Query_hbusersid_1: TIntegerField;
    Query_hbusersusername_1: TStringField;
    Query_hbusersstarno: TIntegerField;
    Query_hbuserstitle: TStringField;
    Query_hbusersstartdate: TDateField;
    Query_hbusersqsodate: TDateField;
    Query_hbusersdescription: TMemoField;
    Query_hbusersstarpcbs: TSmallintField;
    Query_hbuserscontroller: TSmallintField;
    Query_hbusersdisplay: TSmallintField;
    Query_hbusersencoder: TSmallintField;
    Query_hbusersencoders8: TSmallintField;
    Query_hbuserstouchpanel: TStringField;
    Query_hbusersbpf: TSmallintField;
    Query_hbusersmixer: TStringField;
    Query_hbusersroofer: TStringField;
    Query_hbuserscomments: TMemoField;
    Query_hbusersproject: TStringField;
    dxDBGrid_projects: TdxDBGrid;
    Pcol_id: TdxDBGridColumn;
    Pcol_username: TdxDBGridColumn;
    Pcol_name: TdxDBGridColumn;
    Pcol_callsign: TdxDBGridColumn;
    Pcol_title: TdxDBGridColumn;
    Pcol_controller: TdxDBGridColumn;
    Pcol_starpcbs: TdxDBGridColumn;
    Pcol_encoder: TdxDBGridColumn;
    Pcol_display: TdxDBGridColumn;
    Pcol_touchpanel: TdxDBGridColumn;
    Pcol_encoders8: TdxDBGridColumn;
    Pcol_bpf: TdxDBGridColumn;
    Pcol_description: TdxDBGridMemoColumn;
    RzPanel1: TRzPanel;
    Pcol_mixer: TdxDBGridColumn;
    Pcol_roofer: TdxDBGridColumn;
    Pcol_qsodate: TdxDBGridDateColumn;
    Pcol_startdate: TdxDBGridDateColumn;
    Pcol_URL: TdxDBGridColumn;
    Query_hbusersurl: TStringField;
    RzURLLabel2: TRzURLLabel;
    RzPanel2: TRzPanel;
    RzLabel1: TRzLabel;
    RzBitBtn_printSelected: TRzBitBtn;
    RzBitBtn_clode: TRzBitBtn;
    RzBitBtn_Up: TRzBitBtn;
    RzBitBtn_down: TRzBitBtn;
    dxPageSetupDialog1: TdxPageSetupDialog;
    dxComponentPrinter1: TdxComponentPrinter;
    dxComponentPrinter1Link1: TdxDBGridReportLink;
    Query_DbRtf: TMyQuery;
    Query_Comments: TMyQuery;
    Query_hbuserstext: TStringField;
    Query_DbRtfid: TIntegerField;
    Query_DbRtfusername: TStringField;
    Query_DbRtfstarno: TIntegerField;
    Query_DbRtftitle: TStringField;
    Query_DbRtfstartdate: TDateField;
    Query_DbRtfqsodate: TDateField;
    Query_DbRtfdescription: TMemoField;
    Query_DbRtfstarpcbs: TSmallintField;
    Query_DbRtfcontroller: TSmallintField;
    Query_DbRtfdisplay: TSmallintField;
    Query_DbRtfencoder: TSmallintField;
    Query_DbRtfencoders8: TSmallintField;
    Query_DbRtftouchpanel: TStringField;
    Query_DbRtfbpf: TSmallintField;
    Query_DbRtfmixer: TStringField;
    Query_DbRtfroofer: TStringField;
    Query_DbRtfurl: TStringField;
    Query_DbRtfid_1: TIntegerField;
    Query_DbRtfusername_1: TStringField;
    Query_DbRtfname: TStringField;
    Query_DbRtfcallsign: TStringField;
    Query_DbRtftext: TStringField;
    Query_DbRtfcomments: TMemoField;
    Pcol_comments: TdxDBGridMemoColumn;
    Query_Commentsid: TIntegerField;
    Query_Commentscomments: TMemoField;
    Database_hbradios: TMyConnection;
    MyDataSource_hbusers: TMyDataSource;
    procedure dxDBGrid_projectsCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxDBGrid_projectsGetPreviewText(Sender: TObject;
      Node: TdxTreeListNode; var Text: String);
    procedure dxDBGrid_projectsChangeNodeEx(Sender: TObject);
    procedure dxDBGrid_projectsCustomDrawPreviewCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      ASelected: Boolean; var AText: String; var AColor,
      ATextColor: TColor; AFont: TFont; var ADone: Boolean);
    procedure RzBitBtn_clodeClick(Sender: TObject);
    procedure RzBitBtn_printSelectedClick(Sender: TObject);
    procedure RzBitBtn_UpClick(Sender: TObject);
    procedure RzBitBtn_downClick(Sender: TObject);
    procedure dxDBGrid_projectsReloadGroupList(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    IdFieldIndex: integer;
    UsernameFieldIndex: integer;
    NameFieldIndex: integer;
    CallsignFieldIndex: integer;
    TitleFieldIndex: integer;
    StartdateFieldIndex: integer;
    QsodateFieldIndex: integer;
    ControllerFieldIndex: integer;
    StarpcbsFieldIndex: integer;
    EncoderFieldIndex: integer;
    DisplayFieldIndex: integer;
    TouchpanelFieldIndex: integer;
    Encoders8FieldIndex: integer;
    BpfFieldIndex: integer;
    DescriptionFieldIndex: integer;
    CommentsFieldIndex: integer;
    UrlFieldIndex: integer;
    ClSelected: TColor;
    PrevId: integer;
    Comments: string;
    ComList: TStringList;
    IdList: TList;
    PInteger: PInteger_type;
    procedure PrintInit;
    function GetComments(id: integer): string;
    procedure BuildCommentsList;
  public
    procedure Initialise;
    function GetFocusedId: integer;
  end;

const
  starpcbs_array: array[0..4] of string[18]
   = ('  --  ','Home made','Glenns separates','Glenns combostar','other');

  controller_array: array[0..4] of string[10]
   = ('  --  ','PicNmix','TrxAVR-A','TrxAVR-B','other');

  encoder_array: array[0..4] of string[10]
   = ('  --  ','G3XJP','Agilent','Oak','other');

  display_array: array[0..7] of string[18]
   = ('  --  ','PicNmix','Char 20x4','Char 40x2','Mono 320X240','Mono 128x64',
      'Colour 480x272','other');

  encoders8_array: array[0..9] of string[18]
   = ('  --  ','1 encoder','2 encoders','3 encoders','4 encoder',
      '5 encoders','6 encoders','7 encoder','8 encoders','not installed'
     );

  bpf_array: array[0..4] of string[18]
   = ('  --  ','Picastar','CDG2000','PA3AKE','other');

var
  frmDatabase: TfrmDatabase;

implementation

uses UfrmDBRtf;



{$R *.dfm}



procedure TfrmDatabase.Initialise;
begin
  ComList := TStringList.Create;
  IdList := TList.Create;
  BuildCommentsList;
  clSelected := Tcolor($00E0ECF0);
  RzURLLabel2.Caption := '';
  RzURLLabel2.URL := '';
  IdFieldIndex := dxDBGrid_projects.ColumnByFieldName('id').Index;
  UsernameFieldIndex := dxDBGrid_projects.ColumnByFieldName('username').Index;
  NameFieldIndex := dxDBGrid_projects.ColumnByFieldName('name').Index;
  CallsignFieldIndex := dxDBGrid_projects.ColumnByFieldName('callsign').Index;
  TitleFieldIndex := dxDBGrid_projects.ColumnByFieldName('title').Index;
  StartdateFieldIndex := dxDBGrid_projects.ColumnByFieldName('startdate').Index;
  QsodateFieldIndex := dxDBGrid_projects.ColumnByFieldName('qsodate').Index;
  ControllerFieldIndex := dxDBGrid_projects.ColumnByFieldName('controller').Index;
  StarpcbsFieldIndex := dxDBGrid_projects.ColumnByFieldName('starpcbs').Index;
  EncoderFieldIndex := dxDBGrid_projects.ColumnByFieldName('encoder').Index;
  DisplayFieldIndex := dxDBGrid_projects.ColumnByFieldName('display').Index;
  TouchpanelFieldIndex := dxDBGrid_projects.ColumnByFieldName('touchpanel').Index;
  Encoders8FieldIndex := dxDBGrid_projects.ColumnByFieldName('encoders8').Index;
  BpfFieldIndex := dxDBGrid_projects.ColumnByFieldName('bpf').Index;
  DescriptionFieldIndex := dxDBGrid_projects.ColumnByFieldName('description').Index;
  CommentsFieldIndex := dxDBGrid_projects.ColumnByFieldName('comments').Index;
  UrlFieldIndex := dxDBGrid_projects.ColumnByFieldName('url').Index;
  with Query_hbusers, SQL do
  begin
    Close;
    Clear;
    Add('select  * from projects,users where users.username = projects.username');
    FetchAll := true;
    FetchRows := 2000;
    Open;
  end;
end;


procedure TfrmDatabase.BuildCommentsList;
var
  s: string;
begin
  ComList.Clear;
  IdList.Clear;
  with Query_Comments do
  begin
    SQL.Text := 'select id, comments from projects';
    FetchAll := true;
    FetchRows := 2000;
    Open;
    while not EOF do
    begin
      s := FieldByName('comments').AsString;
      ComList.Add(s);
      New(PInteger);
      PInteger^ := FieldByName('id').AsInteger;
      IdList.Add(PInteger);
      Next;
    end;
    Close;
  end;

end;



function TfrmDatabase.GetFocusedId: integer;
var
  s: string;
begin
  result := dxDbGrid_Projects.FocusedNode.Values[IdFieldIndex];
end;



function TfrmDatabase.GetComments(id: integer): string;
var
  p,i: integer;
  s: string;
  Pint: PInteger_type;
begin
  p := -1;
  for i := 0 to IdList.Count - 1 do
  begin
    PInt := IdList[i];
    if Pint^ = id then
    begin
      p := i;
      break;
    end
  end;
  if p >= 0 then s := ComList[p] else s := '';
  result := s;
end;

{
function TfrmDatabase.GetComments(id: integer): string;
begin
  with Query_Comments do
  begin
    Close;
    SQL.Text := 'select comments from projects where id = ' + IntToStr(id);
    Open;
    if EOF
    then result := ''
    else result := FieldByName('comments').AsString;
    Close;
  end;
end;
}


procedure TfrmDatabase.dxDBGrid_projectsCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  v: integer;
begin
   if dxDBGrid_Projects.FocusedNode = ANode then
   begin
     AColor := clSelected;
     AFont.Color := clNavy;
   end;
   if AColumn.Index = UsernameFieldIndex then
   begin
     AFont.Style := [fsBold];
     AFont.Color := clMaroon;
   end;
   if AColumn.Index = NameFieldIndex then
   begin
     AFont.Style := [fsBold];
     AFont.Color := clMaroon;
   end;
   if AColumn.Index = CallsignFieldIndex then
   begin
     AFont.Style := [fsBold];
     AFont.Color := clMaroon;
   end;
   if AColumn.Index = TitleFieldIndex then
   begin
     AFont.Style := [fsBold];
     AFont.Color := clBlue;
   end;
   if AColumn.Index = ControllerFieldIndex then
   begin
     v := ANode.Values[ControllerFieldIndex];
     AText := controller_array[v];
   end;
   if AColumn.Index = StarpcbsFieldIndex then
   begin
     v := ANode.Values[StarpcbsFieldIndex];
    AText := starpcbs_array[v];
   end;
   if AColumn.Index = EncoderFieldIndex then
   begin
     v := ANode.Values[EncoderFieldIndex];
     AText := encoder_array[v];
   end;
   if AColumn.Index = DisplayFieldIndex then
   begin
     v := ANode.Values[DisplayFieldIndex];
    AText := display_array[v];
  end; {case}
   if AColumn.Index = Encoders8FieldIndex then
   begin
     v := ANode.Values[Encoders8FieldIndex];
    AText := encoders8_array[v];
  end; {case}
   if AColumn.Index = BpfFieldIndex then
   begin
     v := ANode.Values[BpfFieldIndex];
    AText := bpf_array[v];
  end; {case}
end;


procedure TfrmDatabase.dxDBGrid_projectsGetPreviewText(Sender: TObject;
  Node: TdxTreeListNode; var Text: String);
var
  Description: string;
  Id: integer;
  V: variant;
begin
  Description := Text;
  V := Node.Values[IdFieldIndex];
  if V <> null then id := V else id := 0;
  Comments := GetComments(Id);
  Text := '';
  if Description <> '' then
  begin
   Text := '  DESCRIPTION:' + #10#13 + Description;
   if Comments <> '' then Text := Text + #10#13;
  end;
  if Comments <> '' then
  begin
   Text := Text + '  COMMENTS:' + #10#13 + Comments;
  end;
end;



procedure TfrmDatabase.dxDBGrid_projectsChangeNodeEx(Sender: TObject);
begin
   with dxDBGrid_Projects.FocusedNode do
  begin
    RzURLLabel2.caption := Strings[UrlFieldIndex];
    RzURLLabel2.URL := Strings[UrlFieldIndex];
  end;

end;

procedure TfrmDatabase.dxDBGrid_projectsCustomDrawPreviewCell(
  Sender: TObject; ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  ASelected: Boolean; var AText: String; var AColor, ATextColor: TColor;
  AFont: TFont; var ADone: Boolean);
begin
   if dxDBGrid_Projects.FocusedNode = ANode then
   begin
     AColor := clSelected;
     ATextColor := clNavy;
   end
   else  begin
     AColor := clWhite;
     ATextColor := clBlack;
   end;
end;

procedure TfrmDatabase.RzBitBtn_clodeClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDatabase.PrintInit;
begin
  frmDBrtf := TfrmDBrtf.Create(self);
  frmDBrtf.Initialise;
  frmDBrtf.ShowModal;
end;

procedure TfrmDatabase.RzBitBtn_printSelectedClick(Sender: TObject);
var
  id: integer;
begin
  PrintInit;
end;

procedure TfrmDatabase.RzBitBtn_UpClick(Sender: TObject);
var
  N: TdxTreeListNode;
begin
  if dxDBGrid_Projects.GroupColumnCount > 0 then exit;
  N := dxDBGrid_Projects.FocusedNode.GetPriorNode;
  if N <> nil then N.Focused := true;
end;

procedure TfrmDatabase.RzBitBtn_downClick(Sender: TObject);
var
  N: TdxTreeListNode;
begin
  if dxDBGrid_Projects.GroupColumnCount > 0 then exit;
  N := dxDBGrid_Projects.FocusedNode.GetNextNode;
  if N <> nil then N.Focused := true;
end;

procedure TfrmDatabase.dxDBGrid_projectsReloadGroupList(Sender: TObject);
begin
  if dxDBGrid_Projects.GroupColumnCount > 0 then
  begin
    RzBitBtn_Up.Enabled := false;
    RzBitBtn_Down.Enabled := false;
  end
  else begin
    RzBitBtn_Up.Enabled := true;
    RzBitBtn_Down.Enabled := true;
  end;
end;

procedure TfrmDatabase.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  IdList.Free;
  ComList.Free;
end;

end.




