unit UfrmDDS;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, RzPanel, StdCtrls, RzLabel, Mask, RzEdit, syncobjs,
  RzBorder, RzButton, RzRadGrp, RzSpnEdt, Menus, RzRadChk;

type

  Tvfo = (vfoa, vfob);

  TSlot =
    record
      stFreq: longint;
      stMode: byte;
      stFilterNarrow: byte;
      stIP3: byte;
      stParamColour: byte;
    end;


  TfrmDDS = class(TForm)
    Timer_freq: TTimer;
    Timer_Close: TTimer;
    RzBitBtn_RIT: TRzBitBtn;
    RzBitBtn_XIT: TRzBitBtn;
    RzBitBtn_Split: TRzBitBtn;
    RzPanel1: TRzPanel;
    RzLabel_VFOA: TRzLabel;
    RzPanel2: TRzPanel;
    RzLabel_VFOB: TRzLabel;
    RzLabel_A: TRzLabel;
    RzLabel_B: TRzLabel;
    RzBitBtn_FilterA: TRzBitBtn;
    RzBitBtn_IP3A: TRzBitBtn;
    RzBitBtn_Green_A: TRzBitBtn;
    RzBitBtn_FilterB: TRzBitBtn;
    RzBitBtn_IP3B: TRzBitBtn;
    RzBitBtn_Green_B: TRzBitBtn;
    RzSpin_VFOA: TRzSpinButtons;
    RzSpin_VFOB: TRzSpinButtons;
    RzRG_Step: TRzRadioGroup;
    RzBitBtn_ABswap: TRzBitBtn;
    RzBitBtn_AtoB: TRzBitBtn;
    RzBitBtn_BtoA: TRzBitBtn;
    RzGroupBox1: TRzGroupBox;
    RzLabel_BandA: TRzLabel;
    RzSpinButtons_BandA: TRzSpinButtons;
    RzGroupBox2: TRzGroupBox;
    RzLabel_BandB: TRzLabel;
    RzSpinButtons_BandB: TRzSpinButtons;
    RzGroupBox_ModeA: TRzGroupBox;
    RzChBx_LSB_A: TRzCheckBox;
    RzChBx_USB_A: TRzCheckBox;
    RzChBx_CWL_A: TRzCheckBox;
    RzChBx_CWH_A: TRzCheckBox;
    RzGroupBox_ModeB: TRzGroupBox;
    RzChBx_LSB_B: TRzCheckBox;
    RzChBx_USB_B: TRzCheckBox;
    RzChBx_CWL_B: TRzCheckBox;
    RzChBx_CWH_B: TRzCheckBox;
    RzBitBtn_Yellow_A: TRzBitBtn;
    RzBitBtn_Red_A: TRzBitBtn;
    RzBitBtn_Yellow_B: TRzBitBtn;
    RzBitBtn_Red_B: TRzBitBtn;
    RzBitBtn_Atten: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzPanel_Smeter: TRzPanel;
    RzMeter_Smeter: TRzMeter;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel7: TRzLabel;
    RzLabel8: TRzLabel;
    RzLabel9: TRzLabel;
    RzLabel10: TRzLabel;
    RzLabel11: TRzLabel;
    RzLabel12: TRzLabel;
    RzLabel13: TRzLabel;
    RzLabel14: TRzLabel;
    RzLabel15: TRzLabel;
    RzLabel16: TRzLabel;
    RzLabel17: TRzLabel;
    RzLabel18: TRzLabel;
    RzLabel19: TRzLabel;
    RzLabel20: TRzLabel;
    RzLabel21: TRzLabel;
    RzLabel22: TRzLabel;
    RzLabel23: TRzLabel;
    RzLabel25: TRzLabel;
    RzLabel26: TRzLabel;
    RzLabel27: TRzLabel;
    RzLabel24: TRzLabel;
    RzLabel28: TRzLabel;
    RzLabel29: TRzLabel;
    RzBitBtn_DNR: TRzBitBtn;
    RzBitBtn_TransmitA: TRzBitBtn;
    RzBitBtn_TransmitB: TRzBitBtn;
    RzBitBtn_Mox: TRzBitBtn;
    RzLabel32: TRzLabel;
    RzPanel_SWRmeter: TRzPanel;
    RzPanel_SWR: TRzPanel;
    RzMeter_Fwd: TRzMeter;
    RzLabel30: TRzLabel;
    RzLabel31: TRzLabel;
    RzLabel33: TRzLabel;
    RzLabel34: TRzLabel;
    RzLabel35: TRzLabel;
    RzLabel36: TRzLabel;
    RzLabel37: TRzLabel;
    RzLabel38: TRzLabel;
    RzLabel39: TRzLabel;
    RzLabel40: TRzLabel;
    RzLabel_Fwd1: TRzLabel;
    RzLabel_Fwd2: TRzLabel;
    RzLabel45: TRzLabel;
    RzLabel46: TRzLabel;
    RzLabel47: TRzLabel;
    RzLabel48: TRzLabel;
    RzLabel49: TRzLabel;
    RzLabel50: TRzLabel;
    RzLabel54: TRzLabel;
    RzLabel55: TRzLabel;
    RzLabel_Fwd3: TRzLabel;
    RzPanel4: TRzPanel;
    RzMeter_Ref: TRzMeter;
    RzLabel43: TRzLabel;
    RzLabel51: TRzLabel;
    RzLabel52: TRzLabel;
    RzLabel53: TRzLabel;
    RzLabel56: TRzLabel;
    RzLabel57: TRzLabel;
    RzLabel58: TRzLabel;
    RzLabel59: TRzLabel;
    RzLabel60: TRzLabel;
    RzLabel61: TRzLabel;
    RzLabel_Ref1: TRzLabel;
    RzLabel_Ref2: TRzLabel;
    RzLabel64: TRzLabel;
    RzLabel65: TRzLabel;
    RzLabel66: TRzLabel;
    RzLabel67: TRzLabel;
    RzLabel68: TRzLabel;
    RzLabel69: TRzLabel;
    RzLabel70: TRzLabel;
    RzLabel71: TRzLabel;
    RzLabel_Ref3: TRzLabel;
    RzPanel5: TRzPanel;
    RzMeter_SWR: TRzMeter;
    RzLabel73: TRzLabel;
    RzLabel74: TRzLabel;
    RzLabel75: TRzLabel;
    RzLabel76: TRzLabel;
    RzLabel77: TRzLabel;
    RzLabel78: TRzLabel;
    RzLabel79: TRzLabel;
    RzLabel80: TRzLabel;
    RzLabel81: TRzLabel;
    RzLabel82: TRzLabel;
    RzLabel83: TRzLabel;
    RzLabel84: TRzLabel;
    RzLabel85: TRzLabel;
    RzLabel86: TRzLabel;
    RzLabel87: TRzLabel;
    RzLabel88: TRzLabel;
    RzLabel89: TRzLabel;
    RzLabel90: TRzLabel;
    RzLabel91: TRzLabel;
    RzLabel93: TRzLabel;
    RzLabel92: TRzLabel;
    RzLabel94: TRzLabel;
    RzLabel95: TRzLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer_freqTimer(Sender: TObject);
    procedure Timer_CloseTimer(Sender: TObject);
    procedure RzBitBtn_FilterAClick(Sender: TObject);
    procedure RzBitBtn_FilterBClick(Sender: TObject);
    procedure RzBitBtn_IP3AClick(Sender: TObject);
    procedure RzBitBtn_IP3BClick(Sender: TObject);
    procedure RzBitBtn_Green_AClick(Sender: TObject);
    procedure RzBitBtn_Green_BClick(Sender: TObject);
    procedure RzBitBtn_RITClick(Sender: TObject);
    procedure RzBitBtn_SplitClick(Sender: TObject);
    procedure RzBitBtn_XITClick(Sender: TObject);
    procedure RzBitBtn_ABswapClick(Sender: TObject);
    procedure RzBitBtn_AtoBClick(Sender: TObject);
    procedure RzBitBtn_BtoAClick(Sender: TObject);
    procedure RzSpin_VFOADownLeftClick(Sender: TObject);
    procedure RzSpin_VFOAUpRightClick(Sender: TObject);
    procedure RzSpin_VFOBDownLeftClick(Sender: TObject);
    procedure RzSpin_VFOBUpRightClick(Sender: TObject);
    procedure FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure RzSpinButtons_BandADownLeftClick(Sender: TObject);
    procedure RzSpinButtons_BandAUpRightClick(Sender: TObject);
    procedure RzSpinButtons_BandBDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_BandBUpRightClick(Sender: TObject);
    procedure RzChBx_LSB_AMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_CWH_AMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_USB_AMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_CWL_AMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_LSB_BMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_USB_BMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_CWL_BMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_CWH_BMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzBitBtn_Red_AClick(Sender: TObject);
    procedure RzBitBtn_Yellow_BClick(Sender: TObject);
    procedure RzBitBtn_Red_BClick(Sender: TObject);
    procedure RzBitBtn_Yellow_AClick(Sender: TObject);
    procedure RzBitBtn_DNRClick(Sender: TObject);
    procedure RzBitBtn_AttenClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RzLabel_VFOAMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzLabel_VFOBMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RzBitBtn_MoxClick(Sender: TObject);
  private
   fbuf: array[0..27] of byte;
   VfoSlot: array[vfoa..vfob] of TSlot;
   Vfo: Tvfo;
   Transmit: boolean;
   Mode: byte;
   RIT: boolean;
   XIT: boolean;
   Split: boolean;
   BandA: integer;
   BandB: integer;
   SmeterDb: byte;
   RfAtten: boolean;
   Denoise: boolean;
   DdsDelayEvent: TEvent;
   ButtonId: byte;
   ButtonVfo: byte;
   ButtonData: byte;
   FreqVfo: byte;
   NewFreq: longint;
   ButtonsBlocked: boolean;
   DigitsEntered: byte;
   EntryVfo: Tvfo;
   EntryMode: boolean;
   EntryDigits: array[1..8] of char;
   FwdFsDeciWatts: word;
   RefFsDeciWatts: word;
   FwdDeciwattsDDS: word;
   RefDeciwattsDDS: word;
   SWRx100DDS: word;
   procedure ShowFreq(v: Tvfo);
   procedure ShowActiveVfo(v:Tvfo);
   procedure ImportSlotData;
   procedure UpdateControls;
   function GetStep: integer;
   procedure VFOAmode(index: byte);
   procedure VFOBmode(index: byte);
   procedure ShowSmeter;
   procedure ShowEntryFreq;
   procedure RequestSwrCalFromUSB;
   procedure RequestSwrDataFromUSB;
  public
    procedure Initialise;
    procedure GetSlotsUpdate;
    procedure SendFreq;
    procedure SendButtonChange;
    procedure GetSwrCalFromUSB;
    procedure ReceiveSwrDataFromUSB;
  end;

const BandMetres: array[0..9] of byte
        = (160,80,60,40,30,20,17,15,12,10);


var
  frmDDS: TfrmDDS;

implementation

uses UfrmMain, UGlobals, UUsb, D2XXUnit;

{$R *.dfm}
procedure TfrmDDS.Initialise;
begin
  RzPanel_SWRmeter.Visible := false;
  RzPanel_Smeter.Visible := true;
  RzMeter_Smeter.Value := 0;
  Transmit := false;
  EntryMode := false;
  RzBitBtn_Green_A.Color := clPaleGreen;
  RzBitBtn_Yellow_A.Color := clPaleYellow;
  RzBitBtn_Red_A.Color := clPaleRed;
  RzBitBtn_Green_A.Font.Color := clGray;
  RzBitBtn_Yellow_A.Font.Color := clGray;
  RzBitBtn_Red_A.Font.Color := clGray;
  RzBitBtn_Green_B.Color := clPaleGreen;
  RzBitBtn_Yellow_B.Color := clPaleYellow;
  RzBitBtn_Red_B.Color := clPaleRed;
  RzBitBtn_Green_B.Font.Color := clGray;
  RzBitBtn_Yellow_B.Font.Color := clGray;
  RzBitBtn_Red_B.Font.Color := clGray;
  DdsDelayEvent := TEvent.Create(0, true, false, 'Hobcat DDS delay event');
  RzRG_Step.ItemIndex := 0;   // step = 10Hz
  RequestSwrCalFromUSB;
end;


procedure TfrmDDS.RequestSwrDataFromUSB;
begin
  if TelemMode <> 'U' then exit;
  frmMain.USBstate[ddsswrdata] := 'W';
end;



procedure TfrmDDS.ReceiveSwrDataFromUSB;
var
  i: byte;
  ch: char;
  swrbuf: array[0..5] of byte;
begin
  Application.ProcessMessages;
  with Usb do
  begin
    purge_USB_Device_In;
    usSendString('$$$SWR_S');
    DdsDelayEvent.ResetEvent;
    DdsDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    Usb.usReceiveBlock(@swrbuf[0],6);
  end;
  FwdDeciwattsDDS := swrbuf[0] + 256*swrbuf[1];
  RefDeciwattsDDS := swrbuf[2] + 256*swrbuf[3];
  SWRx100DDS := swrbuf[4] + 256*swrbuf[5];
  RzMeter_Fwd.Value := (30*FwdDeciwattsDDS) DIV FwdFsDeciwatts;
  RzMeter_Ref.Value := (30*RefDeciwattsDDS) DIV RefFsDeciwatts;
  RzMeter_SWR.Value := (30*(SWRx100DDS-100)) DIV 300;
end;



procedure TfrmDDS.RequestSwrCalFromUSB;
begin
  if TelemMode <> 'U' then exit;
  frmMain.USBstate[ddsswrcal] := 'W';
end;

procedure TfrmDDS.GetSwrCalFromUSB;
var
  ReceivedOk: boolean;
  i: byte;
  calbuf: array[0..3] of byte;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$SWR_F');
    DdsDelayEvent.ResetEvent;
    DdsDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    ReceivedOk := Usb.usReceiveBlock(@calbuf[0],4);
    if ReceivedOk then
    begin
      FwdFsDeciWatts := calbuf[0] + 256*calbuf[1];
      RefFsDeciWatts := calbuf[2] + 256*calbuf[3];
    end
    else begin
      FwdFsDeciWatts := 1400;
      RefFsDeciWatts := 200;
    end;
  end;
  i := 4;
  case FwdFsDeciWatts of
     75: i := 0;
    150: i := 1;
    300: i := 2;
    750: i := 3;
   1500: i := 4;
  end;
  RzLabel_Fwd1.Caption := g_PowerLabels[i,1];
  RzLabel_Fwd2.Caption := g_PowerLabels[i,2];
  RzLabel_Fwd3.Caption := g_PowerLabels[i,3];
  i := 4;
  case RefFsDeciWatts of
     75: i := 0;
    150: i := 1;
    300: i := 2;
    750: i := 3;
   1500: i := 4;
  end;
  RzLabel_Ref1.Caption := g_PowerLabels[i,1];
  RzLabel_Ref2.Caption := g_PowerLabels[i,2];
  RzLabel_Ref3.Caption := g_PowerLabels[i,3];
end;


procedure TfrmDDS.Timer_freqTimer(Sender: TObject);
begin
  if not g_UsbReady then exit;
  frmMain.USBstate[getslots] := 'W';
  if transmit then RequestSwrDataFromUSB;
end;


procedure TfrmDDS.ShowFreq(v: Tvfo);
var
  f: longint;
  h,k,m : integer;  // Hz kHz  MHz
  s,sh,sk: string;
begin
  if EntryMode AND (EntryVfo = v) then exit;
  f := VfoSlot[v].stFreq;
  h := f MOD 1000;
  f := f DIV 1000;
  k := f MOD 1000;
  m := f DIV 1000;
  sh := IntToStr(h);
  if h < 100 then sh := '0' + sh;
  if h < 10 then sh := '0' + sh;
  sk := IntToStr(k);
  if k < 100 then sk := '0' + sk;
  if k < 10 then sk := '0' + sk;
  if m < 10 then s := '   ' else s := ' ';
  s := s + IntToStr(m) + '.' + sk + '.' + sh;
  if v = vfoa
  then RzLabel_VFOA.Caption := s
  else RzLabel_VFOB.Caption := s;
end;



procedure TfrmDDS.ShowEntryFreq;
var
  i: byte;
  f: longint;
  h,k,m : integer;  // Hz kHz  MHz
  s,sh,sk: string;
begin
  s := '';
  if DigitsEntered > 0 then
  begin
    for i := 1 to DigitsEntered do
    begin
      s := s + EntryDigits[i];
      if (((i + 1) MOD 3) = 0) AND (i < 6) then s := s + '.';
    end;
  end;
  if DigitsEntered < 8 then s := s + '_';
  if EntryVfo = vfoa then
  begin
//    Rzlabel_VFOA.Alignment = taLeftJustify;
    RzLabel_VFOA.Caption := s;
  end
  else begin
//    Rzlabel_VFOB.Alignment = taLeftJustify;
    RzLabel_VFOB.Caption := s;
  end;
end;









procedure TfrmDDS.ShowActiveVfo(v:Tvfo);
begin
  if(XIT OR RIT) AND Split AND Transmit then
  begin
    if v = vfoa then v := vfob else v := vfoa;
  end;
  if v = vfoa then
  begin
    RzLabel_VFOA.Font.Color := clYellow;
    RzLabel_VFOB.Font.Color := clMoneyGreen;
  end
  else begin
    RzLabel_VFOB.Font.Color := clYellow;
    RzLabel_VFOA.Font.Color := clMoneyGreen;
  end;
end;

procedure TfrmDDS.GetSlotsUpdate;
begin
  ImportSlotData;
  ShowActiveVFO(VFO);
  ShowFreq(vfoa);
  ShowFreq(vfob);
  UpdateControls;
end;


procedure TfrmDDS.UpdateControls;
var
 v: Tvfo;
begin
  RzChBx_LSB_A.checked := false;
  RzChBx_USB_A.checked := false;
  RzChBx_CWL_A.checked := false;
  RzChBx_CWH_A.checked := false;
  case VfoSlot[vfoa].stMode of
    0:   RzChBx_LSB_A.checked := true;
    1:   RzChBx_USB_A.checked := true;
    2:   RzChBx_CWL_A.checked := true;
    3:   RzChBx_CWH_A.checked := true;
  end;
  Application.ProcessMessages;
  RzChBx_LSB_B.checked := false;
  RzChBx_USB_B.checked := false;
  RzChBx_CWL_B.checked := false;
  RzChBx_CWH_B.checked := false;
  case VfoSlot[vfob].stMode of
    0:   RzChBx_LSB_B.checked := true;
    1:   RzChBx_USB_B.checked := true;
    2:   RzChBx_CWL_B.checked := true;
    3:   RzChBx_CWH_B.checked := true;
  end;
  Application.ProcessMessages;
  if VfoSlot[vfoa].stFilterNarrow = 0
  then RzBitBtn_FilterA.Caption := 'Wide'
  else RzBitBtn_FilterA.Caption := 'Narrow';
  if VfoSlot[vfob].stFilterNarrow = 0
  then RzBitBtn_FilterB.Caption := 'Wide'
  else RzBitBtn_FilterB.Caption := 'Narrow';
  if VfoSlot[vfoa].stIP3 = 1
  then RzBitBtn_IP3A.Caption := 'Best IP3'
  else RzBitBtn_IP3A.Caption := 'Best NF';
  if VfoSlot[vfob].stIP3 = 1
  then RzBitBtn_IP3B.Caption := 'Best IP3'
  else RzBitBtn_IP3B.Caption := 'Best NF';

  case VfoSlot[vfoa].stParamColour of
    1:  begin
          RzBitBtn_Green_A.Color := clGreen;
          RzBitBtn_Yellow_A.Color := clPaleYellow;
          RzBitBtn_Red_A.Color := clPaleRed;
          RzBitBtn_Green_A.Font.Color := clWhite;
          RzBitBtn_Yellow_A.Font.Color := clGray;
          RzBitBtn_Red_A.Font.Color := clGray;
        end;
    2:  begin
          RzBitBtn_Green_A.Color := clPaleGreen;
          RzBitBtn_Yellow_A.Color := clYellow;
          RzBitBtn_Red_A.Color := clPaleRed;
          RzBitBtn_Green_A.Font.Color := clGray;
          RzBitBtn_Yellow_A.Font.Color := clBlack;
          RzBitBtn_Red_A.Font.Color := clGray;
        end;
    3:  begin
          RzBitBtn_Green_A.Color := clPaleGreen;
          RzBitBtn_Yellow_A.Color := clPaleYellow;
          RzBitBtn_Red_A.Color := clRed;
          RzBitBtn_Green_A.Font.Color := clGray;
          RzBitBtn_Yellow_A.Font.Color := clGray;
          RzBitBtn_Red_A.Font.Color := clBlack;
        end;
  end;
  case VfoSlot[vfob].stParamColour of
    1:  begin
          RzBitBtn_Green_B.Color := clGreen;
          RzBitBtn_Yellow_B.Color := clPaleYellow;
          RzBitBtn_Red_B.Color := clPaleRed;
          RzBitBtn_Green_B.Font.Color := clWhite;
          RzBitBtn_Yellow_B.Font.Color := clGray;
          RzBitBtn_Red_B.Font.Color := clGray;
        end;
    2:  begin
          RzBitBtn_Green_B.Color := clPaleGreen;
          RzBitBtn_Yellow_B.Color := clYellow;
          RzBitBtn_Red_B.Color := clPaleRed;
          RzBitBtn_Green_B.Font.Color := clGray;
          RzBitBtn_Yellow_B.Font.Color := clBlack;
          RzBitBtn_Red_B.Font.Color := clGray;
        end;
    3:  begin
          RzBitBtn_Green_B.Color := clPaleGreen;
          RzBitBtn_Yellow_B.Color := clPaleYellow;
          RzBitBtn_Red_B.Color := clRed;
          RzBitBtn_Green_B.Font.Color := clGray;
          RzBitBtn_Yellow_B.Font.Color := clGray;
          RzBitBtn_Red_B.Font.Color := clBlack;
        end;
  end;
  if XIT then
  begin
    RzBitBtn_XIT.Caption := 'XIT mode';
    RzBitBtn_XIT.Font.Style := [fsBold];
    RzBitBtn_XIT.Font.Color := clBlue;
  end
  else begin
    RzBitBtn_XIT.Caption := 'XIT off';
    RzBitBtn_XIT.Font.Style := [];
    RzBitBtn_XIT.Font.Color := clNavy;
  end;

  if RIT then
  begin
    RzBitBtn_RIT.Caption := 'RIT mode';
    RzBitBtn_RIT.Font.Style := [fsBold];
    RzBitBtn_RIT.Font.Color := clBlue;
  end
  else begin
    RzBitBtn_RIT.Caption := 'RIT off';
    RzBitBtn_RIT.Font.Style := [];
    RzBitBtn_RIT.Font.Color := clNavy;
  end;
  if XIT OR RIT then
  begin
    RzBitBtn_Split.Font.Style := [fsBold];
//    RzBitBtn_Split.Font.Color := clBlue;
  end
  else begin
    RzBitBtn_Split.Font.Style := [];
    RzBitBtn_Split.Font.Color := clNavy;
  end;
  if Split then
  begin
    RzBitBtn_Split.Caption := 'Split ON';
    RzBitBtn_Split.Color := clAqua;
    RzBitBtn_Split.Font.Color := clBlack;
  end
  else begin
    RzBitBtn_Split.Caption := 'Split off';
    RzBitBtn_Split.Color := clBtnFace;
    RzBitBtn_Split.Font.Color := clNavy;
  end;

  v := VFO;
  if Transmit then
  begin
    RzBitBtn_MOX.Color := clRed;
    if(XIT OR RIT) AND Split then
    begin
      if v = vfoa then v := vfob else v := vfoa;
    end;
    if v = vfoa
    then RzBitBtn_TransmitA.Visible := true
    else RzBitBtn_TransmitB.Visible := true;
  end
  else begin
    RzBitBtn_MOX.Color := clLime;
    RzBitBtn_TransmitA.Visible := false;
    RzBitBtn_TransmitB.Visible := false;
  end;

  if (XIT OR RIT) AND Split then
  begin
    RzLabel_A.Caption := 'R';
    RzLabel_B.Caption := 'T';
  end
  else begin
    RzLabel_A.Caption := 'A';
    RzLabel_B.Caption := 'B';
  end;
  RzLabel_BandA.Caption := IntToStr(BandMetres[BandA]);
  RzLabel_BandB.Caption := intToStr(BandMetres[BandB]);

  if Denoise then
  begin
    RzBitBtn_DNR.Caption := 'NR TK on';
    RzBitBtn_DNR.Color := clSkyBlue;
    RzBitBtn_DNR.Font.Color := clNavy;
    RzBitBtn_DNR.Font.Style := [fsBold];
  end
  else begin
    RzBitBtn_DNR.Caption := 'NR TK off';
    RzBitBtn_DNR.Color := clBtnFace;
    RzBitBtn_DNR.Font.Color := clNavy;
    RzBitBtn_DNR.Font.Style := [];
  end;

  if RfAtten then
  begin
    RzBitBtn_Atten.Caption := 'Atten ON';
    RzBitBtn_Atten.Color := clSkyBlue;
    RzBitBtn_Atten.Font.Color := clNavy;
    RzBitBtn_Atten.Font.Style := [fsBold];
  end
  else begin
    RzBitBtn_Atten.Caption := 'Atten OFF';
    RzBitBtn_Atten.Color := clBtnFace;
    RzBitBtn_DNR.Font.Color := clNAvy;
    RzBitBtn_Atten.Font.Style := [];
  end;
  if Transmit then
  begin
    RzPanel_Smeter.Visible := false;
    RzPanel_SWRmeter.Visible := true;
  //  ShowSWRmeter;
  end
  else begin
    RzPanel_Smeter.Visible := true;
    RzPanel_SWRmeter.Visible := false;
    ShowSmeter;
  end;
end;


procedure TfrmDDS.ShowSmeter;
var
  x,y,s,over: byte;
begin
  if Transmit then
  begin
    RzMeter_Smeter.Value := 0;
    Rzpanel_Smeter.Enabled := false;
  end
  else begin
    Rzpanel_Smeter.Enabled := true;
    x := SmeterDb;
    if x > 54 then x := 54;
    if SmeterDb < 55
    then over := 0
    else over := SmeterDb - 54;
    RzMeter_Smeter.Value := (x DIV 3) + (over DIV 5);
  end;
end;


procedure TfrmDDS.ImportSlotData;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$DDS_S');   // F = get freq info
    DdsDelayEvent.ResetEvent;
    DdsDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    Usb.usReceiveBlock(@fbuf[0],28);
  end;
  Move(fbuf,VfoSlot,16);
  if fbuf[16] = 0 then VFO := vfoa else VFO := vfob;
  Transmit := (fbuf[17]=1);
  Mode := fbuf[18];
  RIT := (fbuf[19]=1);
  XIT := (fbuf[20]=1);
  Split := (fbuf[21]=1);
  BandA := fbuf[22];
  BandB := fbuf[23];
  SmeterdB := fbuf[24];
  RfAtten := (fbuf[25]=1);
  Denoise := (fbuf[26]=1);
end;



procedure TfrmDDS.SendButtonChange;
var
  block: array[0..2] of byte;
  buf: array[0..40] of byte;
  i: byte;
begin
  Application.ProcessMessages;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DDS_B') then exit;
  block[0] := ButtonId;
  block[1] := ButtonVfo;
  block[2] := ButtonData;
  if not Usb.usSendBlock(@block,3) then exit;     //  sent byte count
  DdsDelayEvent.ResetEvent;
  DdsDelayEvent.WaitFor(50);
  GetSlotsUpdate;
  Timer_Freq.Enabled := true;
end;



procedure TfrmDDS.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer_freq.Enabled := false;
  Application.ProcessMessages;
  Action := caNone;
  Timer_Close.Enabled := true
end;


procedure TfrmDDS.Timer_CloseTimer(Sender: TObject);
begin
  DdsDelayEvent.ResetEvent;
  DdsDelayEvent.WaitFor(1200);
  Application.ProcessMessages;
  DdsDelayEvent.Free;
  Free;
  frmDDS := nil;
end;

procedure TfrmDDS.RzBitBtn_FilterAClick(Sender: TObject);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonId := ord('F');     // Filter switch VFO A
  ButtonVfo := 0;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_FilterBClick(Sender: TObject);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonId := ord('F');      // Filter switch VFO B
  ButtonVfo := 1;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_IP3AClick(Sender: TObject);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonId := ord('I');     // IP3/NF   VFO A
  ButtonVfo := 0;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_IP3BClick(Sender: TObject);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonId := ord('I');   // IP3/NF  VFO B
  ButtonVfo := 1;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_Green_AClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO A
  ButtonVfo := 0;
  ButtonData := 1;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_Yellow_AClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO A
  ButtonVfo := 0;
  ButtonData := 2;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_Red_AClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO A
  ButtonVfo := 0;
  ButtonData := 3;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_Green_BClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO B
  ButtonVfo := 1;
  ButtonData := 1;
  frmMain.USBstate[ddsbutton] := 'W';
end;


procedure TfrmDDS.RzBitBtn_Yellow_BClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO B
  ButtonVfo := 1;
  ButtonData := 2;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_Red_BClick(Sender: TObject);
begin
  ButtonId := ord('P');    // ParamColour VFO B
  ButtonVfo := 1;
  ButtonData := 3;
  frmMain.USBstate[ddsbutton] := 'W';
end;



procedure TfrmDDS.RzBitBtn_RITClick(Sender: TObject);
begin
  ButtonData := 0;  // not used
  ButtonId := ord('R');     // RIT on/off
  ButtonVfo := 0;   //  not used
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_SplitClick(Sender: TObject);
begin
  ButtonData := 0; // not used
  ButtonId := ord('S');     // Split on/off
  ButtonVfo := 0;   //  not used
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_XITClick(Sender: TObject);
begin
  ButtonData := 0; // not used
  ButtonId := ord('X');      // XIT on/off
  ButtonVfo := 0;   //  not used
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_ABswapClick(Sender: TObject);
begin
  ButtonId := ord('W');    // Swap A and B
  ButtonVfo := 0;   //  not used
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_AtoBClick(Sender: TObject);
begin
  ButtonId := ord('>');   // Copy A to B
  ButtonVfo := 0;
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_BtoAClick(Sender: TObject);
begin
  ButtonId := ord('<');  // Copy B to A
  ButtonVfo := 1;
  frmMain.USBstate[ddsbutton] := 'W';
end;




procedure TfrmDDS.RzBitBtn_DNRClick(Sender: TObject);
begin
  ButtonId := ord('N');   // Toggle denoiser
  ButtonVfo := 0;   // not used
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzBitBtn_AttenClick(Sender: TObject);
begin
  ButtonId := ord('T');   // toggle RF attenuator
  ButtonVfo := 0;   // not used
  frmMain.USBstate[ddsbutton] := 'W';
end;



function TfrmDDS.GetStep: integer;
begin
  result := 10;
  if RzRG_Step.ItemIndex = 1 then result := 100;
  if RzRG_Step.ItemIndex = 2 then result := 1000;
  if RzRG_Step.ItemIndex = 3 then result := 10000;
end;

procedure TfrmDDS.SendFreq;
var
  block: array[0..4] of byte;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DDS_F') then exit;
  Move(NewFreq,Block[0],4);
  block[4] := FreqVfo;
  if not Usb.usSendBlock(@block,5) then exit;     //  sent byte count
end;


procedure TfrmDDS.RzSpin_VFOADownLeftClick(Sender: TObject);
begin
  NewFreq := VfoSlot[vfoa].stFreq - GetStep;
  VfoSlot[vfoa].stFreq := NewFreq;
  ShowFreq(vfoa);
  FreqVfo := 0;
  frmMain.USBstate[setfreq] := 'W';
end;

procedure TfrmDDS.RzSpin_VFOAUpRightClick(Sender: TObject);
begin
  NewFreq := VfoSlot[vfoa].stFreq + GetStep;
  VfoSlot[vfoa].stFreq := NewFreq;
  ShowFreq(vfoa);
  FreqVfo := 0;
  frmMain.USBstate[setfreq] := 'W';
end;

procedure TfrmDDS.RzSpin_VFOBDownLeftClick(Sender: TObject);
begin
  NewFreq := VfoSlot[vfob].stFreq - GetStep;
  VfoSlot[vfob].stFreq := NewFreq;
  ShowFreq(vfob);
  FreqVfo := 1;
  frmMain.USBstate[setfreq] := 'W';
end;

procedure TfrmDDS.RzSpin_VFOBUpRightClick(Sender: TObject);
begin
  NewFreq := VfoSlot[vfob].stFreq + GetStep;
  VfoSlot[vfob].stFreq := NewFreq;
  ShowFreq(vfob);
  FreqVfo := 1;
  frmMain.USBstate[setfreq] := 'W';
end;



procedure TfrmDDS.FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  NewFreq := VfoSlot[VFO].stFreq - GetStep;
  VfoSlot[VFO].stFreq := NewFreq;
  ShowFreq(VFO);
  if VFO = vfoa then FreqVfo := 0 else FreqVfo := 1;
  frmMain.USBstate[setfreq] := 'W';
  Handled := true;
end;

procedure TfrmDDS.FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  NewFreq := VfoSlot[VFO].stFreq + GetStep;
  VfoSlot[VFO].stFreq := NewFreq;
  ShowFreq(VFO);
  if VFO = vfoa then FreqVfo := 0 else FreqVfo := 1;
  frmMain.USBstate[setfreq] := 'W';
  Handled := true;
end;



procedure TfrmDDS.RzSpinButtons_BandADownLeftClick(Sender: TObject);
begin
  ButtonData := 0;
  ButtonVfo := 0;
  ButtonId := ord('Q');
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzSpinButtons_BandAUpRightClick(Sender: TObject);
begin
  ButtonData := 1;
  ButtonVfo := 0;
  ButtonId := ord('Q');
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzSpinButtons_BandBDownLeftClick(Sender: TObject);
begin
  ButtonData := 0;
  ButtonVfo := 1;
  ButtonId := ord('Q');
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.RzSpinButtons_BandBUpRightClick(Sender: TObject);
begin
  ButtonData := 1;
  ButtonVfo := 01;
  ButtonId := ord('Q');
  frmMain.USBstate[ddsbutton] := 'W';
end;


procedure TfrmDDS.VFOAmode(index: byte);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonData := index;
  ButtonVfo := 0;
  ButtonId := ord('M');   // VFO A mode
  frmMain.USBstate[ddsbutton] := 'W';
end;

procedure TfrmDDS.VFOBmode(index: byte);
begin
  Timer_Freq.Enabled := false;
  frmMain.USBstate[getslots] := 'X';
  ButtonData := index;
  ButtonVfo := 1;
  ButtonId := ord('M');    //  VFO B mode
  frmMain.USBstate[ddsbutton] := 'W';
end;


procedure TfrmDDS.RzChBx_LSB_AMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  VFOAmode(0);
end;

procedure TfrmDDS.RzChBx_USB_AMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  VFOAmode(1);
end;

procedure TfrmDDS.RzChBx_CWL_AMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  VFOAmode(2);
end;

procedure TfrmDDS.RzChBx_CWH_AMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  VFOAmode(3);
end;



procedure TfrmDDS.RzChBx_LSB_BMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RzChBx_LSB_B.Checked := false;
  VFOBmode(0);
end;

procedure TfrmDDS.RzChBx_USB_BMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RzChBx_USB_B.Checked := false;
  VFOBmode(1);
end;

procedure TfrmDDS.RzChBx_CWL_BMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RzChBx_CWL_B.Checked := false;
  VFOBmode(2);
end;

procedure TfrmDDS.RzChBx_CWH_BMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RzChBx_CWH_B.Checked := false;
  VFOBmode(3);
end;



procedure TfrmDDS.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
 s: string;
 i: byte;
begin
  if EntryMode = false then exit;
  if DigitsEntered > 8 then exit;
  if key = VK_ESCAPE then
  begin
    EntryMode := false;
    ShowFreq(EntryVfo);
    exit;
  end;
  if (key = VK_BACK) AND (DigitsEntered > 0)
  then dec(DigitsEntered)
  else begin
    case key of
      VK_NUMPAD0: key := 0;
      VK_NUMPAD1: key := 1;
      VK_NUMPAD2: key := 2;
      VK_NUMPAD3: key := 3;
      VK_NUMPAD4: key := 4;
      VK_NUMPAD5: key := 5;
      VK_NUMPAD6: key := 6;
      VK_NUMPAD7: key := 7;
      VK_NUMPAD8: key := 8;
      VK_NUMPAD9: key := 9;
    end;
    if (key < ord('0')) OR (key > ord('9')) then exit;
    inc(DigitsEntered);
    EntryDigits[DigitsEntered] := char(key);
  end;
  ShowEntryFreq;
  if DigitsEntered = 8 then
  begin
    DdsDelayEvent.ResetEvent;
    DdsDelayEvent.WaitFor(500);
    s := '';
    for i := 1 to 8 do s := s + EntryDigits[i];
    NewFreq := StrToInt(s);
    VfoSlot[EntryVfo].stFreq := NewFreq;
    ShowFreq(EntryVfo);
    if EntryVfo = vfoa then FreqVfo := 0 else FreqVfo := 1;
    frmMain.USBstate[setfreq] := 'W';
    EntryMode := false;
  end;
end;


procedure TfrmDDS.RzLabel_VFOAMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Shift = [ssRight] then
  begin
    EntryVfo := vfoa;
    EntryMode := true;
    DigitsEntered := 0;
    ShowEntryFreq;
  end
  else begin
    ButtonId := ord('A');   // Switch to VFO A
    ButtonVfo := 0;   // not used
    frmMain.USBstate[ddsbutton] := 'W';
  end;
end;

procedure TfrmDDS.RzLabel_VFOBMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Shift = [ssRight] then
  begin
    EntryVfo := vfoB;
    EntryMode := true;
    DigitsEntered := 0;
    ShowEntryFreq;
  end
  else begin
    ButtonId := ord('B');   // Switch to VFO B
    ButtonVfo := 0;   // not used
    frmMain.USBstate[ddsbutton] := 'W';
  end;

end;

procedure TfrmDDS.RzBitBtn_MoxClick(Sender: TObject);
begin
  frmMain.DoPTT;
end;

end.


