unit UUsb;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Controls,
  Dialogs, StdCtrls, ComPort, ComCtrls, Menus, ExtCtrls,
  UIniData, UGlobals, FileCtrl,D2XXUnit, Forms, syncobjs;


type
  Pbyte_type = ^byte;

  TTrxAvr = record
              trIndex: byte;
              trSerialNo: string[20];
              trDescription: string[50];
            end;

  TUsb = class
           usDeviceSerialNo: string;
           usDeviceDescription: string;
           usDeviceIndex: integer;
           usDeviceOpenAndOk: boolean;
           usDeviceFound: boolean;
           usTrxAvrCount: integer;
           usDelayEvent: TEvent;
           usTrxAvr: array[1..6] of TTrxAvr;
           constructor Create;
           function usReadWord(var w: word): boolean;
           function usFindTrxAVR: boolean;
           function usSelectTrxAvr: byte;
           function usGetTrxAVRversion: string;
           function usTestStatus: boolean;
           function usSendBlock(pbuffer: PByteArray; nc: word): boolean;
           function usReceiveBlock(pbuffer: PByteArray; nc: word): boolean;
           function usSendString(s: string): boolean;
           function usCloseConnection: FT_Result;
         end;

var
  Usb: TUsb;


implementation

uses UfrmSelectTrxAVR, UfrmMain;

constructor TUsb.Create;
begin
  inherited Create;
  usDelayEvent := TEvent.Create(0, true, false, 'Hobcat USB delay event');
end;



function TUsb.usReadWord(var w: word): boolean;
var
  btot: word;
begin
  w := 0;
  result := false;
//  repeat until FT_Q_bytes >= 2;
  btot := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  if btot < 2 then exit;
  w := 256* FT_In_Buffer[0] + FT_In_Buffer[1];
  result := true;
end;


function TUsb.usReceiveBlock(pbuffer: PByteArray; nc: word): boolean;
var
  r,p: word;
begin
  result := false;
  r := Read_USB_Device_Buffer(nc);
  if r <> nc then exit;
  for p := 0 to nc-1 do
  begin
    pbuffer[p] := FT_In_Buffer[p];
  end;
  result := true;
end;





function TUsb.usSendBlock(pbuffer: PByteArray; nc: word): boolean;
var
  r,p: word;
begin
  result := true;
//  Purge_USB_Device_Out;
  for p := 0 to nc-1 do
  begin
    FT_Out_Buffer[p] := pbuffer[p]
  end;
  r := Write_USB_Device_Buffer(nc);
  if r <> nc then result := false;
end;


function TUsb.usSendString(s: string): boolean;
var
  r,i,nc: integer;
begin
  result := true;
  nc := Length(s);
  for i := 1 to nc do
  begin
    FT_Out_Buffer[i-1] := ord(s[i]);
  end;
  FT_Out_Buffer[nc] := 0;
  r := Write_USB_Device_Buffer(nc+1);
  if r <> nc+1 then result := false;
end;



function TUsb.usGetTrxAVRversion: string;
var
  cs: array[0..11] of char;
begin
  result := '';
  Purge_USB_Device_In;
  if not usSendString('$$$CFG_Z')
  then exit
  else begin
    usDelayEvent.ResetEvent;
    usDelayEvent.WaitFor(50);
    if not usReceiveBlock(@cs,9) then exit;
    if Length(cs) < 6 then exit;
    if Copy(cs,1,4) <> '$$TA' then exit;
  end;
  result := Copy(cs,5,100);
end;



function TUsb.usFindTrxAVR: boolean;
var
  S : String;
  i : Integer;
  DeviceIndex : DWord;
  LV : TListItem;
  t: byte;
begin
  FT_Enable_Error_Report := false; // Error reporting = on
  usTrxAvrCount := 0;
  result := false;
  GetFTDeviceCount;
  DeviceIndex := 0;
  usDeviceDescription := '';
  if FT_Device_Count > 0 then
  for DeviceIndex := 0 to FT_Device_Count-1 do
  begin
    GetFTDeviceDescription ( DeviceIndex );
    s := UpperCase(FT_Device_String);
    if Pos('TRXAVR',s) > 0 then
    begin
      inc(usTrxAvrCount);
      with usTrxAvr[usTrxAvrCount] do
      begin
        trIndex := DeviceIndex;
        trDescription := FT_Device_String;
        GetFTDeviceSerialNo( DeviceIndex );
        trSerialNo := FT_Device_String;
      end;
    end;
  end;
  if usTrxAvrCount = 0 then exit;
  if usTrxAvrCount = 1 then t := 1 else t := usSelectTrxAvr;
  if t = 0 then exit;
  if (t > 0) and (t <= usTrxAvrCount)  then
  begin
    result := true;
    usDeviceIndex := usTrxAvr[t].trIndex;
    usDeviceDescription := usTrxAvr[t].trDescription;
    usDeviceSerialNo := usTrxAvr[t].trSerialNo;
  end;
end;


function TUsb.usSelectTrxAvr: byte;
var
  i: byte;
begin
  frmSelectTrxAVR := TfrmSelectTrxAVR.Create(frmMain);
//  frmSelectTrxAVR.RzEditListBox_TrxAvr.AddItem('  No TrxAVR selection',frmMain);
  for i := 1 to usTrxAvrCount do
  begin
    frmSelectTrxAVR.RzEditListBox_TrxAvr.AddItem(usTrxAvr[i].trDescription
                                  + '  s/n: ' + usTrxAVR[i].trSerialNo, frmMain);
  end;
  result := frmSelectTrxAVR.ShowModal;
  frmSelectTrxAVR.Free;
end;


function TUsb.usTestStatus;
var
  PortStatus : FT_Result;
  s : string;
  i : Integer;
begin
  result := false;
  if not usDeviceOpenAndOk then
  begin
    if usFindTrxAVR then
    begin
      if Open_USB_Device_By_Serial_Number(usDeviceSerialNo) = FT_OK then
      begin
        usDeviceOpenAndOk := True;
        Reset_USB_Device;     // warning - this will destroy any pending data.
        Set_USB_Device_TimeOuts(20,20); // read and write timeouts = 500mS
        result := true;
      end
      else exit;
    end
    else exit;
  end
  else begin
    PortStatus := Get_USB_Device_QueueStatus;
    if PortStatus = FT_OK then
    begin
      result := true;
      exit;
    end
    else usDeviceOpenAndOk := false;
  end;
end;

function TUsb.usCloseConnection: FT_Result;
begin
  result := Close_USB_Device;
  usDeviceOpenAndOk := false;
end;

end.
