unit UParams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UGlobals, RzButton, SyncObjs, StdCtrls, RzLabel, ExtCtrls;



type


  Tpcol = (pcname,pcuser,pcstar,pcssbg,pcssby,pcssbr,
                 pccwg,pccwy,pccwr,pcmin,pcmax,pcx,pcpage);

  Tss = array[pcname..pcpage] of string;
  Tvv = array[pcuser..pcpage] of byte;

  TParams
  = class
      paBlock:    array[0..104] of byte;
      paName:     array[1..99] of string;
      paUserID:   array[1..99] of byte;
      paPmin:     array[1..99] of byte;
      paPmax:     array[1..99] of byte;
      paValue:    array[1..99,1..3,1..2] of byte;
      paMult:     array[1..99] of byte;
      paPage:     array[1..99] of byte;
      paCalCurve: array[1..46] of byte;
      paSet: byte;
      pamode: byte;                 // QB: SSborCW
      paXparamsDatFile: Text;
      paXparamsDatFileName: string;
      paCalFilename: string;
      paXparamsXjpFileName: string;
      paUser2B2XjpFilename: string;
      paTextFile: Text;
      paFile: file;
      paParsed: Tss;
      paVals: Tvv;
      paPagemax: byte;
      s: string;
      pabuf: array[0..2000] of byte;
      papb: word;
      paParamset: byte;
      paDelayEvent: TEvent;
      ParamsBuf: array[0..10000] of byte;
      parambufpos: integer;
      constructor Create;
      procedure paWidthCentre(pw,pset: byte);
      procedure paSendDspCommand(p,v: byte);
      procedure paParamsToDSP;
      function paParamsFromAVR: boolean;
      function paParamsToAVR: boolean;
      function paParseThirteen(var s: string; out ss: Tss): boolean;
      procedure paAddHashes(n: byte; cr: boolean);
      function paHexToBinary(s: string): byte;
      function paInputParams: boolean;
      procedure paSaveParams(bak: boolean);
      procedure paInputCalCurve;
      procedure paGetParamLine;
      function paProcessParamsText: boolean;
      procedure paWriteParamsToFile(xparams: boolean);
      procedure paSaveXparamsDat;

    end;


const
  passb = 1;
  pacw  = 2;

  panone = 0;
  pagreen  = 1;
  payellow = 2;
  pared    = 3;

const xparamnos: array[1..12] of byte
= (86,79,78,29,28,27,26,19,18,17,16,15);


var
  Params: TParams;

implementation

uses UUsb, UIniData,UfrmMain;


constructor TParams.Create;
var
  path: string;
  nc: byte;
begin
  inherited Create;
  SetLength(s,200);
  DecimalSeparator := '.';
  LoadRegInifile;
  ReadXjpIniData;
  path := g_RegIniData.IniStarFolder;
  nc := Length(path);
  if path[nc] <> '\' then path := Path + '\';
  with g_RegIniData do paCalFilename := path + 'Filters\AD603.dat';
  with g_RegIniData do paXparamsXjpFilename := path + 'Filters\xparams.xjp';
  with g_RegIniData do paXparamsDatFilename := path + 'Filters\xparams.dat';
  with g_RegIniData do paUser2B2XjpFilename := path + g_XJPIniData.IniParams;
  s := paUser2B2XjpFileName;
  paDelayEvent := TEvent.Create(0, true, false, 'DSP params transfer delay event');
end;


procedure TParams.paSendDspCommand(p,v: byte);
begin
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(2);
  frmMain.StarComPort.WriteChar('~');
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(2);
  frmMain.StarComPort.WriteChar(Chr(p));
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(2);
  frmMain.StarComPort.WriteChar(Chr(v));
end;


procedure TParams.paWidthCentre(pw,pset: byte);
var
  w: word;
begin
  w := (75*paValue[pw,pset,passb]) DIV 100;
  paValue[65,pset,passb] := 45 + w;
end;



procedure TParams.paParamsToDSP;
var
  x: byte;
  p: word;
begin
  if not paInputParams then exit;
  frmMain.StarComport.Open;
  paParamset := pagreen; //
  pamode := 1;
  papb := 0;
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(50);
  paSendDSPcommand(108,1);
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(50);
  paValue[6,pagreen,paMode] := 0;   //filter mode to 6.2 == Star 6.3
  paValue[5,pagreen,paMode] := 0;   //manuel notch off
  for x := 1 to 9 do
  begin
    if paValue[x,pagreen,paMode] <> 255
         then paSendDspCommand(x,paValue[x,pagreen,paMode]);
  end;
  paWidthCentre(63,paParamset);
  for x := 10 to 99 do
  begin
    if paValue[x,paParamSet,paMode] < 254
    then paSendDspCommand(x,paValue[x,paParamset,paMode])
    else begin
      if paValue[x,paParamset,paMode] = 254
      then paSendDspCommand(x,paValue[x,pagreen,paMode]);
    end;
  end;
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(50);
  paSendDspCommand(108,0);

  frmMain.StarComPort.Close;
end;


procedure TParams.paAddHashes(n: byte; cr: boolean);
var
  i: byte;
begin
 try
  for i := 1 to n do
  begin
    pabuf[papb] := ord('#');
    inc(papb);
  end;
  if cr then
  begin
    pabuf[papb] := 13;
    inc(papb);
  end;
  except hcerr(13,'','',0,0,0,0); end;
end;


function TParams.paParamsFromAVR: boolean;
var
  pc,m,pn: byte;
  i: word;
  s: string;
begin
  result := false;
  Params.paInputParams;
  paDelayEvent.ResetEvent;
  paDelayEvent.WaitFor(200);
  for m := 1 to 2 do  // ssb to cw
  begin
    for pc := pagreen to pared do
    begin
      Usb.usReceiveBlock(@paBlock[0],100);
      for pn := 0 to 9 do
      begin
       if paBlock[pn] <> ord('#') then exit;
       paBlock[pn] := 0;
      end;
      for pn := 10 to 99 do paValue[pn,pc,m] := paBlock[pn];
    end;
  end;
  result := true;
  paSaveParams(false);
end;



function TParams.paParamsToAVR: boolean;
var
  x: byte;
  i: word;
  bk, remaining, bksz: word;
  done: boolean;
begin
  if not paInputParams then
  begin
    result := false;
    exit;
  end;
  paWidthCentre(63,pagreen);
  paWidthCentre(63,payellow);
  paWidthCentre(63,pared);
  papb := 0;
  paAddHashes(13,true);
 try

  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,pagreen,passb];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,payellow,passb];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,pared,passb];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paPmax[x];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paPmin[x];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,pagreen,pacw];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,payellow,pacw];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paValue[x,pared,pacw];
    inc(papb);
  end;
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paUserId[x] MOD 10;
    inc(papb);
  end;
 except hcerr(14,'','',0,0,0,0); end;
  // Multiplier - extra - not in Picastar - not enought room in EEPROM
  //. - but I store in on-chip EEPROM
  paAddHashes(13,true);
  for x := 10 to 99 do
  begin
    pabuf[papb] := paMult[x];
    inc(papb);
  end;
  // terminating hashes
  paAddHashes(8,false);
  Application.ProcessMessages;
  bk := 0;
  done := false;
  repeat
    remaining := papb - bk;
    if remaining >= 64 then
    begin
     try
      for i := 0 to 63 do paBlock[i] := pabuf[bk+i];
      bk := bk + 64;
      bksz := 64;
      if remaining = 64 then done := true;
     except hcerr(15,'','',0,0,0,0); end;
    end
    else begin
      try for i := 0 to remaining - 1 do paBlock[i] := pabuf[bk+i]; except hcerr(16,'','',0,0,0,0); end;
//      for i := remaining to 63 do paBlock[i]:= 0;
      done := true;
      bksz := remaining;
    end;
    if not Usb.usSendBlock(@paBlock[0],bksz) then
    begin
      result := false;
//      Usb.usbusy := false;
      exit;
    end;
    Application.ProcessMessages;
    // delay  - needed because TrxAVR has do blockwrite buffer of 100 params
    // to eeprom. Some fails if not delay. ok with 1mS  but use 20mS
    paDelayEvent.ResetEvent;
    paDelayEvent.WaitFor(20);
  until done;
  result := true;
end;

//except hcerr(1,'','''0'0'0'0); end;


function TParams.paParseThirteen(var s: string; out ss: Tss): boolean;
var
  p,i: integer;
  pcol: Tpcol;
begin
  result := true;
  for i := 0 to 11 do
  begin
    pcol := Tpcol(i);
    p := Pos(',',s);
    if p = 0 then
    begin
      result := false;
      exit;
    end;
    try ss[pcol] := Trim(Copy(s,1,p-1)); except hcerr(1,'','',0,0,0,0); end;
    s := Copy(s,p+1,255);
  end;
  ss[pcpage] := Trim(s);
end;


procedure Tparams.paSaveXparamsDat;
var
  p,i: byte;
  n: longint;
  s: string;
begin
  AssignFile(paXparamsDatFile,paXParamsDatFileName);
  Rewrite(paXparamsDatFile);
  for i := 1 to 52 do writeln(paXparamsDatFile,'000000');
  for i := 1 to 12 do
  begin
    p := xparamnos[i];
    n := $10000*p +  $100*paValue[p,1,1] + paValue[p,1,2];
    s := IntToHex(n,6);
    writeln(paXparamsDatFile,s);
  end;
  CloseFile(paXparamsDatFile);
end;


procedure TParams.paSaveParams(bak: boolean);
var
  filename: string;
begin
  filename := paUser2B2XjpFileName;
  if bak then filename := ChangeFileExt(filename,'.BAK');
  AssignFile(paTextFile, filename);
  paWriteParamsToFile(false);
  filename := paXparamsXjpFileName;
  if bak then filename := ChangeFileExt(filename,'.BAK');
  AssignFile(paTextFile, filename);
  paWriteParamsToFile(true);
  paSaveXparamsDat;
end;


procedure TParams.paWriteParamsToFile(xparams: boolean);
var
  x,y: byte;
  s: string;
  sep: string;
  mult: single;
  smult: string;
  ok: boolean;
begin
  Rewrite(paTextFile);
  s := 'Parameter name         User#    Star# SSBGREEN SSBYELLOW SSBRED '
     + 'CWGREEN CWYELLOW CWRED  MIN     MAX     x   Page';
  Writeln(paTextFile,s);
  s := '--------------         -----    ----- -------- --------- ------ '
     + '------- -------- -----  ---     ---     -   ----';
  Writeln(paTextFile,s);
  sep := ' ,' + #9 + ' ';
  for x := 1 to 99 do
  begin
    ok := true;
    if x in [15..19,26..29,78,79,86] then
    begin
      if (xparams = false) then ok := false;
    end
    else begin
      if (xparams = true) then ok := false;
    end;
    if ok AND (paName[x] <> '') then
    begin
      s := paName[x] + ', ';
      y := Length(s);
      while(y < 25) do
      begin
        s := s + ' ';
        y := y + 1;
      end;
      if x < 10 then
      begin
        paValue[x,pagreen,passb] := 0;  // save all off and mode = SSB
        paValue[x,pagreen,pacw] := 0;
      end;
      mult := paMult[x]/100;
      smult := FloatToStrF(mult,ffFixed,3,2);
      smult := Copy(smult,2,8);
      if paMult[x] = 100 then smult := '1';
      if paMult[x] = 0 then smult := '0';
      write(paTextFile,s,paUserId[x],sep,x,sep);
      write(paTextFile,paValue[x,pagreen,passb],sep,paValue[x,payellow,passb],sep,paValue[x,pared,passb],sep);
      write(paTextFile,paValue[x,pagreen,pacw],sep,paValue[x,payellow,pacw],sep,paValue[x,pared,pacw],sep);
      write(paTextFile,paPmin[x],sep,paPmax[x],sep,smult,sep,paPage[x]);
      writeln(paTextFile);
    end;
  end;
  writeln(paTextFile,'END FILE');
  CloseFile(paTextFile);
end;


procedure TParams.paGetParamLine;
var
  i: integer;
  b: byte;
begin
  SetLength(s,200);
  i := -1;
  repeat
    inc(i);
    try s[i+1] := char(ParamsBuf[parambufpos+i]); except hcerr(2,'','',0,0,0,0); end;
  until (s[i+1] = #10) OR (s[i+1]=#13);
  SetLength(s,i);
//  s[i+1] := #0;
  parambufpos := parambufpos+i;
  repeat
   inc(parambufpos);
   try b := ParamsBuf[parambufpos]; except hcerr(3,'','',0,0,0,0); end;
  until (b<>10) AND (b<>13);
end;



function TParams.paInputParams: boolean;
var
  i: integer;
begin
  result := true;
  if not FileExists(paUser2B2XjpFilename) then
  begin
    s := 'Cannot find your parameter file:  ' + paUser2B2XjpFilename;
    MessageDlg(s,mtWarning,[mbOk],0);
    result := false;
    exit;
  end;
  if not FileExists(paXparamsXjpFilename) then
  begin
    s := 'Cannot find your parameter file:  ' + paXparamsXjpFilename;
    MessageDlg(s,mtWarning,[mbOk],0);
    result := false;
    exit;
  end;

  paPagemax:= 1;
  try
    fillchar(paValue,SizeOf(paValue),255);      // gerard's fix JUly 2010
    fillchar(paUserId,SizeOf(paUserId),0);
    fillchar(paPmax,SizeOf(paPmax),0);
    fillchar(paPmin,SizeOf(paPmin),0);
    fillchar(paMult,SizeOf(paMult),1);
    fillchar(paPage,SizeOf(papage),0);
  except hcerr(4,'','',0,0,0,0); end;
  for i := 1 to 99 do paName[i] := '';

  AssignFile(paFile, paUSer2B2XjpFilename);
  Reset(paFile,1);
  BlockRead(paFile,ParamsBuf,FileSize(paFile));
  CloseFile(paFile);
  if not paProcessParamsText then
  begin
    result := false;
    exit;
  end;


  AssignFile(paFile, paXparamsXjpFilename);
  Reset(paFile,1);
  BlockRead(paFile,ParamsBuf,FileSize(paFile));
  CloseFile(paFile);
  if not paProcessParamsText then
  begin
    result := false;
    exit;
  end;
end;



function TParams.paProcessParamsText: boolean;
var
  col: Tpcol;
  r: real;
  fsz: integer;
  p,x: byte;
  vv: Tvv;
begin
  parambufpos := 0;
  result := true;
  try
    paGetParamLine;
    paGetParamLine;
   except
     hcerr(5,'','',0,0,0,0);
  end;
  repeat
    try paGetParamLine;  except hcerr(60,'','',0,0,0,0); end;
    if Copy(s,1,8) = 'END FILE' then break;
    if not paParseThirteen(s, paParsed) then
    begin
      result := false;
      break;
    end;
   try
    for col := pcuser to pcpage do
    begin
      if Col = pcx then
      begin
        try r := StrToFloat(paParsed[col]);  except hcerr(6,'paParsed[pcol]','',Ord(col),x,0,0); end;
        try r := r*100;   except hcerr(7,'','',0,0,0,0); end;
        try vv[col] := trunc(r);   except hcerr(8,'','',0,0,0,0); end;
      end
      else try vv[col] := StrToInt(paParsed[col]);   except hcerr(9,'','',0,0,0,0); end;
    end;
   except hcerr(61,'','',0,0,0,0); end;
   try
    x := vv[pcstar];
    paName[x] := paParsed[pcName];
    paUserId[x] := vv[pcuser] ;
    paValue[x,paGreen,passb]  := vv[pcssbg];
    paValue[x,paYellow,passb] := vv[pcssby];
    paValue[x,paRed,passb]     := vv[pcssbr];
    paValue[x,paGreen,pacw]   := vv[pccwg];
    paValue[x,paYellow,pacw]  := vv[pccwy];
    paValue[x,paRed,pacw]    := vv[pccwr];
    paPmin[x] := vv[pcmin];
    paPmax[x] := vv[pcmax];
    paMult[x] := vv[pcx];        //  mult stored x100 as byte
    paPage[x] := vv[pcpage];
   except hcerr(10,'','',0,0,0,0); end;
    if paPage[x] > paPagemax then paPagemax := paPage[x];
  until x >= 99;
//  CloseFile(paTextFile);
  paValue[6,paGreen,passb] := 0;
  paValue[6,paGreen,pacw] := 0;
end;



// assumes two character hex number
function TParams.paHexToBinary(s: string): byte;
var
  a,b: byte;
begin
 try
  a := ord(s[1]);
  if a >64 then a := a-55 else a := a-48;
  b := ord(s[2]);
  if b >64 then b := b-55 else b := b-48;
  result := a*16 + b;
   except hcerr(11,'','',0,0,0,0); end;
end;




procedure TParams.paInputCalCurve;
var
  gain: byte;
begin
 try
  AssignFile(paTextFile,paCalFilename);
  Reset(paTextFile);
  for gain := 0 to 41 do
  begin
    ReadLn(paTextFile,s);
    paCalCurve[gain+1] := paHexToBinary(Copy(s,3,2));
  end;
  CloseFile(paTextFile);
   except hcerr(12,'','',0,0,0,0); end;
end;




end.
