unit UOwdxPrintConfig;

interface

uses  dxPSGlbl, dxPSUtl, dxPSEngn, dxPrnPg, dxBkgnd, dxWrap, dxPrnDev,
      dxPSCompsProvider, dxPSFillPatterns, dxPSEdgePatterns,
      dxPSCore, dxPSRELnk,
      SysUtils, UGlobals, Windows, Dialogs, Classes,
      Controls, variants, graphics;

type

  TOwDxPrintConfig = class
    function TextAlignYApply(s: string): TdxTextAlignY;
    function TextAlignYExtract(ta: TdxTextAlignY): string;
    function MeasurementUnitsExtract(ta: TdxMeasurementUnits): string;
    function MeasurementUnitsApply(s: string): TdxMeasurementUnits;
    function FontStyleExtract(fs: TFontStyles): string;
    function FontStyleApply(s: string): TFontStyles;
    function FontPitchExtract(fp: TFontPitch): string;
    function FontPitchApply(s: string): TFontPitch;
    function PageOrderApply(s: string): TdxPageOrder;
    function PageOrderExtract(po: TdxPageOrder): string;
    function ScaleModeApply(s: string): TdxScaleMode;
    function ScaleModeExtract(sm: TdxScaleMode): string;
    function OrientationApply(s: string): TdxPrinterOrientation;
    function OrientationExtract(po: TdxPrinterOrientation): string;
    function PageNumberFormatApply(s: string): TdxPageNumberFormat;
    function PageNumberFormatExtract(pnf: TdxPageNumberFormat): string;
    procedure ApplyDxPrinterSettings(var CP: TdxComponentPrinter);
    procedure ExtractDxPrinterSettings(var CP: TdxComponentPrinter);
    function TitleModeApply(s: string): TdxReportTitleMode;
    function TitleModeExtract(tm: TdxReportTitleMode): string;
  end;

var
  OwDxPrintConfig: TOwDxPrintConfig;


implementation

uses UIniData;

function TOwDxPrintConfig.TextAlignYApply(s: string): TdxTextAlignY;
begin
  result := taCenterY;
  if s = 'taTop' then result := taTop;
  if s = 'taBottom' then result := taBottom;
end;


function TOwDxPrintConfig.TextAlignYExtract(ta: TdxTextAlignY): string;
begin
  result := 'taCenterY';
  if ta = taTop then result := 'taTop';
  if ta = taBottom then result := 'taBottom';
end;


function TOwDxPrintConfig.MeasurementUnitsApply(s: string): TdxMeasurementUnits;
begin
  result := muDefault;
  if s = 'muInches' then result := muInches;
  if s = 'muMillimeters' then result := muMillimeters;
end;


function TOwDxPrintConfig.MeasurementUnitsExtract(ta: TdxMeasurementUnits): string;
begin
  result := 'muDefault';
  if ta = muInches then result := 'muInches';
  if ta = muMillimeters then result := 'muMillimeters';
end;




function TOwDxPrintConfig.FontStyleApply(s: string): TFontStyles;
begin
  result := [];
  if Pos(s,'U') > 0 then result := result + [fsUnderline];
  if Pos(s,'B') > 0 then result := result + [fsBold];
  if Pos(s,'I') > 0 then result := result + [fsItalic];
  if Pos(s,'S') > 0 then result := result + [fsStrikeout];
end;

function TOwDxPrintConfig.FontStyleExtract(fs: TFontStyles): string;
begin
  result := '';
  if fsBold in fs then result := result + 'B';
  if fsItalic in fs then result := result + 'I';
  if fsUnderline in fs then result := result + 'U';
  if fsStrikeout in fs then result := result + 'S';
end;



function TOwDxPrintConfig.FontPitchApply(s: string): TFontPitch;
begin
  result := fpDefault;
  if s = 'fpFixed' then result := fpFixed;
  if s = 'fpVariable' then result := fpVariable;
end;


function TOwDxPrintConfig.FontPitchExtract(fp: TFontPitch): string;
begin
  result := 'fpDefault';
  if fp = fpFixed then result := 'fpFixed';
  if fp = fpVariable then result := 'fpVariable';
end;




function TOwDxPrintConfig.PageOrderApply(s: string): TdxPageOrder;
begin
  result := poOverThenDown;
  if s = 'poDownThenOver' then result := poDownThenOver;
end;


function TOwDxPrintConfig.PageOrderExtract(po: TdxPageOrder): string;
begin
  result := 'poOverThenDown';
  if po = poDownThenOver then result := 'poDownThenOver';
end;




function TOwDxPrintConfig.ScaleModeApply(s: string): TdxScaleMode;
begin
  result := smAdjust;
  if s = 'smFit' then result := smFit;
end;


function TOwDxPrintConfig.ScaleModeExtract(sm: TdxScaleMode): string;
begin
  result := 'smAdjust';
  if sm = smFit then result := 'smFit';
end;



function TOwDxPrintConfig.TitleModeApply(s: string): TdxReportTitleMode;
begin
  result := tmNone;
  if s = 'tmOnEveryTopPage' then result := tmOnEveryTopPage;
  if s = 'tmOnFirstPage' then result := tmOnFirstPage;
end;


function TOwDxPrintConfig.TitleModeExtract(tm: TdxReportTitleMode): string;
begin
  result := 'tmNone';
  if tm = tmOnEveryTopPage then result := 'tmOnEveryTopPage';
  if tm = tmOnFirstPage then result := 'tmOnFirstPage';
end;





function TOwDxPrintConfig.OrientationApply(s: string): TdxPrinterOrientation;
begin
  result := poPortrait;
  if s = 'poLandscape' then result := poLandscape;
end;


function TOwDxPrintConfig.OrientationExtract(po: TdxPrinterOrientation): string;
begin
  result := 'poPortrait';
  if po = poLandscape then result := 'poLandscape';
end;


function TOwDxPrintConfig.PageNumberFormatApply(s: string): TdxPageNumberFormat;
begin
  result := pnfNumeral;
  if s = 'pnfChars' then result := pnfChars;
  if s = 'pnfUpperChars' then result := pnfUpperChars;
  if s = 'pnfRoman' then result := pnfRoman;
  if s = 'pnfUpperRoman' then result := pnfUpperRoman;
end;


function TOwDxPrintConfig.PageNumberFormatExtract(pnf: TdxPageNumberFormat): string;
begin
  result := 'pnfNumeral';
  if pnf = pnfChars then result := 'pnfChars';
  if pnf = pnfUpperChars then result := 'pnfUpperChars';
  if pnf = pnfRoman then result := 'pnfRoman';
  if pnf = pnfUpperRoman then result := 'pnfUpperRoman';
end;







procedure TOwDxPrintConfig.ApplyDxPrinterSettings(var CP: TdxComponentPrinter);
begin
  with CP.CurrentLink.PrinterPage, g_RegIniData do
  begin
    CenterOnPageH := IniCenterOnPageH;
    CenterOnPageV := IniCenterOnPageV;
    DMPaper := IniDMPaper;
    FitToPagesByTall := IniFitToPagesByTall;
    FitToPagesByWide := IniFitToPagesByWide;
    Footer := IniFooter;
    GrayShading := IniGrayShading;
    Header := IniHeader;
    Margins.Bottom := IniMarginsBottom;
    Margins.Left := IniMarginsLeft;
    Margins.Right := IniMarginsRight;
    Margins.Top := IniMarginsTop;
    MeasurementUnits := MeasurementUnitsApply(IniMeasurementUnits);

    PageFooter.CenterTextAlignY := TextAlignYApply(IniPageFooterCenterTextAlignY);
    PageFooter.LeftTextAlignY := TextAlignYApply(IniPageFooterRightTextAlignY);
    PageFooter.RightTextAlignY := TextAlignYApply(IniPageFooterRightTextAlignY);
    PageFooter.Font.Charset := IniPageFooterFontCharset;
    PageFooter.Font.Color := IniPageFooterFontColor;
    PageFooter.Font.Height := IniPageFooterFontHeight;
    PageFooter.Font.Name := IniPageFooterFontName;
    PageFooter.Font.Pitch := FontPitchAPply(IniPageFooterFontPitch);
    PageFooter.Font.Size := IniPageFooterFontSize;
    PageFooter.Font.Style := FontStyleApply(IniPageFooterFontStyle);

    PageHeader.CenterTextAlignY := TextAlignYApply(IniPageHeaderCenterTextAlignY);
    PageHeader.LeftTextAlignY := TextAlignYApply(IniPageHeaderRightTextAlignY);
    PageHeader.RightTextAlignY := TextAlignYApply(IniPageHeaderRightTextAlignY);
    PageHeader.Font.Charset := IniPageHeaderFontCharset;
    PageHeader.Font.Color := IniPageHeaderFontColor;
    PageHeader.Font.Height := IniPageHeaderFontHeight;
    PageHeader.Font.Name := IniPageHeaderFontName;
    PageHeader.Font.Pitch := FontPitchAPply(IniPageHeaderFontPitch);
    PageHeader.Font.Size := IniPageHeaderFontSize;
    PageHeader.Font.Style := FontStyleApply(IniPageHeaderFontStyle);

    PageOrder := PageOrderApply(IniPageOrder);
    PageSize.X := IniPageSizeX;
    PageSize.Y := IniPageSizeY;
    ReverseTitlesOnEvenPages := IniReverseTitlesOnEvenPages;
    ScaleFactor := IniScaleFactor;
    ScaleMode := ScaleModeApply(IniScaleMode);
    Orientation := OrientationApply(IniOrientation);
  end;
  with CP.CurrentLink, g_RegIniData do
  begin
    ShowPageFooter := IniShowPageFooter;
    ShowPageHeader := IniShowPageHeader;
    ShrinkToPageWidth := IniShrinkToPageWidth;
    PageNumberFormat := PageNumberFormatApply(IniPageNumberFormat);
    ReportTitle.Mode := TitleModeApply(IniReportTitleMode);
  end;
end;


procedure TOwDxPrintConfig.ExtractDxPrinterSettings(var CP: TdxComponentPrinter);
begin
  with CP.CurrentLink.PrinterPage, g_RegIniData do
  begin
    IniCentEROnPageH := CenterOnPageH;
    IniCenterOnPageV := CenterOnPageV;
    IniDMPaper := DMPaper;
    IniFitToPagesByTall := FitToPagesByTall;
    IniFitToPagesByWide := FitToPagesByWide;
    IniFooter := Footer;
    IniGrayShading := GrayShading;
    IniHeader := Header;
    IniMarginsBottom := Margins.Bottom;
    IniMarginsLeft := Margins.Left;
    IniMarginsRight := Margins.Right;
    IniMarginsTop := Margins.Top;
    IniMeasurementUnits := MeasurementUnitsExtract(MeasurementUnits);

    IniPageFooterCenterTextAlignY := TextAlignYExtract(PageFooter.CenterTextAlignY);
    IniPageFooterLeftTextAlignY := TextAlignYExtract(PageFooter.RightTextAlignY);
    IniPageFooterRightTextAlignY := TextAlignYExtract(PageFooter.RightTextAlignY);
    IniPageFooterFontCharset := PageFooter.Font.Charset;
    IniPageFooterFontColor := PageFooter.Font.Color;
    IniPageFooterFontHeight := PageFooter.Font.Height;
    IniPageFooterFontName := PageFooter.Font.Name;
    IniPageFooterFontPitch := FontPitchExtract(PageFooter.Font.Pitch);
    IniPageFooterFontSize := PageFooter.Font.Size;
    IniPageFooterFontStyle := FontStyleExtract(PageFooter.Font.Style);

    IniPageHeaderCenterTextAlignY := TextAlignYExtract(PageHeader.CenterTextAlignY);
    IniPageHeaderLeftTextAlignY := TextAlignYExtract(PageHeader.RightTextAlignY);
    IniPageHeaderRightTextAlignY := TextAlignYExtract(PageHeader.RightTextAlignY);
    IniPageHeaderFontCharset := PageHeader.Font.Charset;
    IniPageHeaderFontColor := PageHeader.Font.Color;
    IniPageHeaderFontHeight := PageHeader.Font.Height;
    IniPageHeaderFontName := PageHeader.Font.Name;
    IniPageHeaderFontPitch := FontPitchExtract(PageHeader.Font.Pitch);
    IniPageHeaderFontSize := PageHeader.Font.Size;
    IniPageHeaderFontStyle := FontStyleExtract(PageHeader.Font.Style);

    IniPageOrder := PageOrderExtract(PageOrder);
    IniPageSizeX := PageSize.X;
    IniPageSizeY := PageSize.Y;
    IniReverseTitlesOnEvenPages := ReverseTitlesOnEvenPages;
    IniScaleFactor := ScaleFactor;
    IniScaleMode := ScaleModeExtract(ScaleMode);
    IniOrientation := OrientationExtract(Orientation);
  end;
  with CP.CurrentLink, g_RegIniData do
  begin
    IniShowPageFooter := ShowPageFooter;
    IniShowPageHeader := ShowPageHeader;
    IniShrinkToPageWidth := ShrinkToPageWidth;
    IniPageNumberFormat := PageNumberFormatExtract(PageNumberFormat);
    IniReportTitleMode := TitleModeExtract(ReportTitle.Mode);
  end;
end;






end.
