unit UGlobals;

interface

uses graphics;
type
  Trgb = (cr,cg,cb);

  Topt = (esc, bok, ToAVR, ToDSP);

  THardwareSettings
   = record                 //96 bytes
       hsDisplay: byte;
       hsKeypad: byte;
       hsTuningEncoder: byte;
       hsTouchPanel: byte;
       hsDDSmultiplierA: byte;
       hsDDSmultiplierB: byte;
       hsHardwareOptionsA: byte;
       hsInternalEepromStart: byte;
       hsCallsign: array[0..10] of byte;
       hsWelcomeText1: array[0..28] of byte;
       hsWelcomeText2: array[0..28] of byte;
       hsMultipleDisplay: byte;
       hsMenuEncoder: byte;
       hsKeyMatrix: byte;
       hsRtcStatus: byte;
       hsTFTAaddress: byte;
       hsSpare: array[0..13] of byte;
     end;


const

   clPaleRed:    Tcolor = $00E0E0FF;
   clPaleBlue:   Tcolor = $00FFE0E0;
   clPaleGreen:  Tcolor = $00E0FFE0;
   clPaleYellow: Tcolor = $00E0FFFF;
   clDeepYellow: Tcolor = $0000E8E8;
   clPaleBrown:  Tcolor = $00E8F0FF;


   cBlack:    string[7] = '\cf0 ';
   cRed:      string[7] = '\cf1 ';
   cGreen:    string[7] = '\cf2 ';
   cBlue:     string[7] = '\cf3 ';
   cTeal:     string[7] = '\cf4 ';
   cBrown:    string[7] = '\cf5 ';
   cMagenta:  string[7] = '\cf6 ';
   cEmerald:  string[7] = '\cf7 ';
   cNavy:     string[7] = '\cf8 ';

   g_ColourDefs: array[1..9,cr..cb] of integer
    =  ( (140,000,000),   // red
         (000,090,000),   // green
         (000,000,130),   // blue
         (000,080,080),   // teal
         (100,050,020),   // brown
         (120,000,90),    // magenta
         (000,100,050),   // emerald
         (000,000,060),   // navy
         (000,000,000) );



const g_PowerLabels: array[0..4,1..3] of string =
   (('2.5', '5.0', '7.5'),
		('5',   '10',  '15'),
		('10',  '20',  '30'),
		('25',  '50',  '75'),
		('50',  '100', '150'));


var
   cHeader:       string[7];
   cHeading1:     string[7];
   cHeading2:     string[7];
   cAdc:          string[7];
   cWatts:        string[7];
   cLedNo:        string[7];


  g_HobcatVersion: string;

  g_TextFile: Text;
  g_TextFilePath: string;
  g_tempPath: string;

  g_UsbReady: boolean;

  HcerrFilename: string;
  HcerrFile: Text;
  TelemMode: char;


procedure hcerr(eno: integer; u,v: string; a,b,c,d: longint);
procedure ErrorLogInit;

implementation

uses UIniData, SysUtils, Dialogs;


procedure ErrorLogInit;
var
  Filename: string;
begin
  Filename := g_RegInidata.IniStarFolder + '\HobcatDebug.txt';
  AssignFile(HcerrFile, Filename);
  if not FileExists(Filename) then Rewrite(HcerrFile);
end;


procedure hcerr(eno: integer; u,v: string; a,b,c,d: longint);
var
  s: string;
begin
  s := 'Hobcat logged error no ';
  s := s + IntToStr(eno) + '     ';
  s := s + 'u=' + u + '    ';
  s := s + 'V=' + V + '    ';
  s := s + 'a=' + IntToStr(a) + '  ';
  s := s + 'b=' + IntToStr(b) + '  ';
  s := s + 'c=' + IntToStr(c) + '  ';
  s := s + 'd=' + IntToStr(d) + '  ';
  MessageDlg(s,mtWarning,[mbOK],0);
  Append(HcerrFile);
  writeln(HcerrFile,DateTimeToStr(now) + '   ' + s);
  Close(HcerrFile);
end;



end.
