/*
 *****    homebrew-radios.net   *****

 *****     Project Encoders8       *****

 en_RS232.c  Provide RS232 interface

*/

#include "encoders8.h"
#include "en_RS232.h"

#define BAUD 38400
#define MYUBRR ((F_CPU/16/BAUD)-1)

// USART transmit ring buffer
uint8_t USART_TX[USART_TX_BUFFER_SIZE];
volatile uint8_t USART_TX_Head;
volatile uint8_t USART_TX_Tail;


void rsInit()
{
	// Configure PORTE for USART0 TxD
	// Pin 1 (USART0 TxD) set as output
	DDRE |= 0x02;
	
	UBRR0 = MYUBRR; // set baud rate to 38400
	UCSR0C = 0x06;  // asynchronous, no parity, 1 stop bit, 8 data bits 
	UCSR0B = 0x08;  // enable transmission

	return;
}


// Return the number of free bytes in the transmitter buffer
uint8_t USART_TXBuffer_Space()
{
	uint8_t ret;

	cli();
	if (USART_TX_Tail > USART_TX_Head) {
		ret = (USART_TX_Tail - USART_TX_Head - (uint8_t)1);
	} else {
		ret =  ((uint8_t)USART_TX_BUFFER_MASK - USART_TX_Head + USART_TX_Tail);
	}
	sei();

	return ret;
}


// Data Register Empty Interrupt Service Routine.
//  Transmits one byte from TX software buffer
//  Disables DRE interrupt if buffer is empty
ISR(USART0_UDRE_vect)
{
	// Check if all data is transmitted
	if (USART_TX_Head == USART_TX_Tail){
		UCSR0B &= 0xdf; // Disable DRE interrupts
	} else {
		UDR0 = USART_TX[USART_TX_Tail++];	// Start transmitting
	}
	sei();

	return;
}

   
